/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class DoubleSingularValueDecompositionDC {
    private double[] Ut;
    private double[] V;
    private double[] s;
    private intW info;
    private int m;
    private int n;
    private int minmn;
    private boolean wantWholeUV;
    private boolean wantUV;

    public DoubleSingularValueDecompositionDC(DoubleMatrix2D doubleMatrix2D, boolean bl, boolean bl2) {
        this.wantUV = bl;
        this.wantWholeUV = bl2;
        this.m = doubleMatrix2D.rows();
        this.n = doubleMatrix2D.columns();
        double[] dArray = (double[])doubleMatrix2D.viewDice().copy().elements();
        this.minmn = Math.min(this.m, this.n);
        int n = Math.max(this.m, this.n);
        this.info = new intW(2);
        int[] nArray = new int[8 * this.minmn];
        this.s = new double[this.minmn];
        bl = true;
        if (true) {
            if (bl2) {
                this.Ut = new double[this.m * this.m];
                this.V = new double[this.n * this.n];
                int n2 = 3 * this.minmn * this.minmn + Math.max(n, 4 * this.minmn * this.minmn + 4 * this.minmn) + n;
                double[] dArray2 = new double[n2];
                LAPACK.getInstance().dgesdd("A", this.m, this.n, dArray, this.m, this.s, this.Ut, this.m, this.V, this.n, dArray2, n2, nArray, this.info);
            } else {
                this.Ut = new double[this.m * this.minmn];
                this.V = new double[this.minmn * this.n];
                int n3 = 3 * this.minmn * this.minmn + Math.max(n, 4 * this.minmn * this.minmn + 4 * this.minmn) + n;
                double[] dArray3 = new double[n3];
                LAPACK.getInstance().dgesdd("S", this.m, this.n, dArray, this.m, this.s, this.Ut, this.m, this.V, this.minmn, dArray3, n3, nArray, this.info);
            }
        } else {
            int n4 = 3 * this.minmn + Math.max(n, 6 * this.minmn) + n;
            double[] dArray4 = new double[n4];
            LAPACK.getInstance().dgesdd("N", this.m, this.n, dArray, this.m, this.s, null, this.m, null, this.n, dArray4, n4, nArray, this.info);
        }
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public DoubleMatrix2D getS() {
        DenseDoubleMatrix2D denseDoubleMatrix2D = !this.wantWholeUV ? new DenseDoubleMatrix2D(this.minmn, this.minmn) : new DenseDoubleMatrix2D(this.m, this.n);
        for (int i = 0; i < this.s.length; ++i) {
            ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(i, i, this.s[i]);
        }
        return denseDoubleMatrix2D;
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public DoubleMatrix2D getU() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix U was not computed");
        }
        if (!this.wantWholeUV) {
            return new DenseDoubleMatrix2D(this.minmn, this.m).assign(this.Ut).viewDice().copy();
        }
        return new DenseDoubleMatrix2D(this.m, this.m).assign(this.Ut).viewDice().copy();
    }

    public DoubleMatrix2D getUt() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix Ut was not computed");
        }
        if (!this.wantWholeUV) {
            return new DenseDoubleMatrix2D(this.m, this.minmn).assign(this.Ut);
        }
        return new DenseDoubleMatrix2D(this.m, this.m).assign(this.Ut);
    }

    public DoubleMatrix2D getVt() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix Vt was not computed");
        }
        if (!this.wantWholeUV) {
            return new DenseDoubleMatrix2D(this.minmn, this.n).assign(this.V).viewDice().copy();
        }
        return new DenseDoubleMatrix2D(this.n, this.n).assign(this.V).viewDice().copy();
    }

    public DoubleMatrix2D getV() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix V was not computed");
        }
        if (!this.wantWholeUV) {
            return new DenseDoubleMatrix2D(this.n, this.minmn).assign(this.V);
        }
        return new DenseDoubleMatrix2D(this.n, this.n).assign(this.V);
    }

    public intW getInfo() {
        return this.info;
    }

    public double norm2() {
        return this.s[0];
    }

    public int rank() {
        double d = Math.pow(2.0, -52.0);
        double d2 = (double)Math.max(this.m, this.n) * this.s[0] * d;
        int n = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > d2)) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("SingularValueDecomposition(A) --> cond(A), rank(A), norm2(A), U, S, V\n");
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("cond = ");
        try {
            stringBuffer.append(String.valueOf(this.cond()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nrank = ");
        try {
            stringBuffer.append(String.valueOf(this.rank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nnorm2 = ");
        try {
            stringBuffer.append(String.valueOf(this.norm2()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nU = ");
        try {
            stringBuffer.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nS = ");
        try {
            stringBuffer.append(String.valueOf(this.getS()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nV = ");
        try {
            stringBuffer.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

