/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleAlgebra;
import cern.colt.matrix.tdouble.algo.decomposition.DoubleSingularValueDecompositionDC;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.HyBRDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.HyBRInnerSolver;
import cern.colt.matrix.tdouble.algo.solver.HyBRRegularizationMethod;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoubleIdentity;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseColDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.stat.tdouble.DoubleDescriptive;
import optimization.DoubleFmin;
import optimization.DoubleFmin_methods;

public class DoubleHyBR
extends AbstractDoubleIterativeSolver {
    private HyBRInnerSolver innerSolver;
    private HyBRRegularizationMethod regMethod;
    private double regPar;
    private double omega;
    private boolean reorth;
    private int begReg;
    private double flatTol;
    private boolean computeRnrm;
    private static final DoubleAlgebra alg = DoubleAlgebra.DEFAULT;
    private static final double FMIN_TOL = 1.0E-4;

    public DoubleHyBR() {
        this(HyBRInnerSolver.TIKHONOV, HyBRRegularizationMethod.ADAPTWGCV, 0.0, 0.0, false, 2, 1.0E-6, false);
    }

    public DoubleHyBR(HyBRInnerSolver hyBRInnerSolver, HyBRRegularizationMethod hyBRRegularizationMethod, double d, double d2, boolean bl, int n, double d3, boolean bl2) {
        this.innerSolver = hyBRInnerSolver;
        this.regMethod = hyBRRegularizationMethod;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("regularizationParameter must be a number between 0 and 1.");
        }
        this.regPar = d;
        if (d2 < 0.0) {
            throw new IllegalArgumentException("omega must be a nonnegative number.");
        }
        this.omega = d2;
        this.reorth = bl;
        if (n < 2) {
            throw new IllegalArgumentException("beginRegularization must be greater or equal 2");
        }
        this.begReg = n;
        if (d3 < 0.0) {
            throw new IllegalArgumentException("flatTolerance must be a nonnegative number.");
        }
        this.flatTol = d3;
        this.computeRnrm = bl2;
        this.iter = new HyBRDoubleIterationMonitor();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        DoubleLBD doubleLBD;
        double d;
        DoubleMatrix1D doubleMatrix1D3;
        if (!(this.iter instanceof HyBRDoubleIterationMonitor)) {
            this.iter = new HyBRDoubleIterationMonitor();
        }
        this.checkSizes(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D2);
        int n = doubleMatrix2D.columns();
        boolean bl = false;
        boolean bl2 = false;
        double d2 = -1.0;
        int n2 = 0;
        HyBRInnerSolver hyBRInnerSolver = HyBRInnerSolver.NONE;
        DoubleMatrix1D doubleMatrix1D4 = null;
        DenseDoubleMatrix1D denseDoubleMatrix1D = null;
        DoubleArrayList doubleArrayList = new DoubleArrayList(new double[this.begReg - 2]);
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(new double[this.begReg - 2]);
        DoubleMatrix2D doubleMatrix2D2 = new DenseDoubleMatrix2D(1, doubleMatrix1D.size());
        DoubleMatrix2D doubleMatrix2D3 = null;
        DoubleMatrix2D doubleMatrix2D4 = null;
        if (this.computeRnrm) {
            doubleMatrix1D3 = doubleMatrix1D.copy();
            doubleMatrix2D.zMult(doubleMatrix1D2, doubleMatrix1D3, -1.0, 1.0, false);
            d2 = alg.norm2(doubleMatrix1D3);
        }
        if (this.M instanceof DoubleIdentity) {
            d = alg.norm2(doubleMatrix1D);
            doubleMatrix2D2.viewRow(0).assign(doubleMatrix1D, DoubleFunctions.multSecond(1.0 / d));
            doubleLBD = new DoubleSimpleLBD(doubleMatrix2D, doubleMatrix2D2, this.reorth);
        } else {
            doubleMatrix1D3 = new DenseDoubleMatrix1D(doubleMatrix1D.size());
            doubleMatrix1D3 = this.M.apply(doubleMatrix1D, doubleMatrix1D3);
            d = alg.norm2(doubleMatrix1D3);
            doubleMatrix2D2.viewRow(0).assign(doubleMatrix1D3, DoubleFunctions.multSecond(1.0 / d));
            doubleLBD = new DoublePLBD(this.M, doubleMatrix2D, doubleMatrix2D2, this.reorth);
        }
        this.iter.setFirst();
        while (!this.iter.converged(d2, doubleMatrix1D2)) {
            doubleLBD.apply();
            doubleMatrix2D2 = doubleLBD.getU();
            doubleMatrix2D3 = doubleLBD.getB();
            doubleMatrix2D4 = doubleLBD.getV();
            DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(doubleMatrix2D2.rows());
            ((DoubleMatrix1D)denseDoubleMatrix1D2).setQuick(0, d);
            int n3 = this.iter.iterations();
            if (n3 >= 1) {
                if (n3 >= this.begReg - 1) {
                    hyBRInnerSolver = this.innerSolver;
                }
                switch (hyBRInnerSolver) {
                    case TIKHONOV: {
                        DoubleSingularValueDecompositionDC doubleSingularValueDecompositionDC = alg.svdDC(doubleMatrix2D3);
                        DoubleMatrix2D doubleMatrix2D5 = doubleSingularValueDecompositionDC.getU();
                        double[] dArray = doubleSingularValueDecompositionDC.getSingularValues();
                        DoubleMatrix2D doubleMatrix2D6 = doubleSingularValueDecompositionDC.getV();
                        if (this.regMethod == HyBRRegularizationMethod.ADAPTWGCV) {
                            doubleMatrix1D3 = new DenseDoubleMatrix1D(doubleMatrix2D5.rows());
                            doubleMatrix2D5.zMult(denseDoubleMatrix1D2, doubleMatrix1D3, 1.0, 0.0, true);
                            doubleArrayList.add(Math.min(1.0, this.findOmega(doubleMatrix1D3, dArray)));
                            this.omega = DoubleDescriptive.mean(doubleArrayList);
                        }
                        doubleMatrix1D4 = new DenseDoubleMatrix1D(doubleMatrix2D6.rows());
                        double d3 = this.tikhonovSolver(doubleMatrix2D5, dArray, doubleMatrix2D6, denseDoubleMatrix1D2, doubleMatrix1D4);
                        doubleArrayList2.add(this.GCVstopfun(d3, doubleMatrix2D5.viewRow(0), dArray, d, n));
                        if (n3 <= 1) break;
                        if (Math.abs(doubleArrayList2.getQuick(n3 - 1) - doubleArrayList2.getQuick(n3 - 2)) / doubleArrayList2.get(this.begReg - 2) < this.flatTol) {
                            doubleMatrix2D4.zMult(doubleMatrix1D4, doubleMatrix1D2);
                            ((HyBRDoubleIterationMonitor)this.iter).setStoppingCondition(HyBRDoubleIterationMonitor.HyBRStoppingCondition.FLAT_GCV_CURVE);
                            if (this.computeRnrm) {
                                doubleMatrix1D3 = doubleMatrix1D.copy();
                                doubleMatrix2D.zMult(doubleMatrix1D2, doubleMatrix1D3, -1.0, 1.0, false);
                                ((HyBRDoubleIterationMonitor)this.iter).residual = alg.norm2(doubleMatrix1D3);
                            }
                            return doubleMatrix1D2;
                        }
                        if (bl2 && doubleArrayList2.size() > n2 + 3) {
                            for (int i = n2; i < doubleArrayList2.size(); ++i) {
                                if (!(doubleArrayList2.getQuick(n2 - 1) > doubleArrayList2.get(i))) continue;
                                bl = true;
                            }
                            if (!bl) {
                                doubleMatrix1D2.assign(denseDoubleMatrix1D);
                                ((HyBRDoubleIterationMonitor)this.iter).setStoppingCondition(HyBRDoubleIterationMonitor.HyBRStoppingCondition.MIN_OF_GCV_CURVE_WITHIN_WINDOW_OF_4_ITERATIONS);
                                ((HyBRDoubleIterationMonitor)this.iter).iter = n2;
                                if (this.computeRnrm) {
                                    doubleMatrix1D3 = doubleMatrix1D.copy();
                                    doubleMatrix2D.zMult(doubleMatrix1D2, doubleMatrix1D3, -1.0, 1.0, false);
                                    ((HyBRDoubleIterationMonitor)this.iter).residual = alg.norm2(doubleMatrix1D3);
                                }
                                return doubleMatrix1D2;
                            }
                            bl = false;
                            bl2 = false;
                            n2 = this.iter.getMaxIterations();
                            break;
                        }
                        if (bl2 || !(doubleArrayList2.get(n3 - 2) < doubleArrayList2.get(n3 - 1))) break;
                        bl2 = true;
                        denseDoubleMatrix1D = new DenseDoubleMatrix1D(doubleMatrix2D4.rows());
                        doubleMatrix2D4.zMult(doubleMatrix1D4, denseDoubleMatrix1D);
                        n2 = n3;
                        break;
                    }
                    case NONE: {
                        doubleMatrix1D4 = alg.solve(doubleMatrix2D3, denseDoubleMatrix1D2);
                    }
                }
                doubleMatrix2D4.zMult(doubleMatrix1D4, doubleMatrix1D2);
                if (this.computeRnrm) {
                    doubleMatrix1D3 = doubleMatrix1D.copy();
                    doubleMatrix2D.zMult(doubleMatrix1D2, doubleMatrix1D3, -1.0, 1.0, false);
                    d2 = alg.norm2(doubleMatrix1D3);
                }
            }
            this.iter.next();
        }
        return doubleMatrix1D2;
    }

    private double findOmega(DoubleMatrix1D doubleMatrix1D, double[] dArray) {
        int n = doubleMatrix1D.size();
        int n2 = dArray.length;
        double d = dArray[n2 - 1];
        double d2 = doubleMatrix1D.viewPart(n2, n - n2).aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(DoubleFunctions.square);
        double d3 = d * d;
        DoubleMatrix1D doubleMatrix1D2 = denseDoubleMatrix1D.copy();
        doubleMatrix1D2.assign(DoubleFunctions.plus(d3));
        doubleMatrix1D2.assign(DoubleFunctions.inv);
        double d4 = ((DoubleMatrix1D)denseDoubleMatrix1D).aggregate(doubleMatrix1D2, DoubleFunctions.plus, DoubleFunctions.mult);
        denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(DoubleFunctions.mult(d));
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(doubleMatrix1D.viewPart(0, n2), DoubleFunctions.mult);
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(DoubleFunctions.square);
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D2.copy();
        doubleMatrix1D3.assign(DoubleFunctions.pow(3.0));
        doubleMatrix1D3.assign(DoubleFunctions.abs);
        double d5 = doubleMatrix1D3.aggregate(denseDoubleMatrix1D, DoubleFunctions.plus, DoubleFunctions.mult);
        doubleMatrix1D3 = new DenseDoubleMatrix1D(dArray);
        doubleMatrix1D3.assign(doubleMatrix1D2, DoubleFunctions.mult);
        double d6 = doubleMatrix1D3.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        doubleMatrix1D3 = doubleMatrix1D2.copy();
        doubleMatrix1D3.assign(doubleMatrix1D.viewPart(0, n2), DoubleFunctions.mult);
        doubleMatrix1D3.assign(DoubleFunctions.mult(d3));
        double d7 = doubleMatrix1D3.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(doubleMatrix1D.viewPart(0, n2), DoubleFunctions.mult);
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(DoubleFunctions.square);
        doubleMatrix1D2.assign(DoubleFunctions.pow(3.0));
        doubleMatrix1D2.assign(DoubleFunctions.abs);
        double d8 = doubleMatrix1D2.aggregate(denseDoubleMatrix1D, DoubleFunctions.plus, DoubleFunctions.mult);
        return (double)n * d3 * d8 / (d4 * d5 + d6 * (d7 + d2));
    }

    private double tikhonovSolver(DoubleMatrix2D doubleMatrix2D, double[] dArray, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        DoubleMatrix1D doubleMatrix1D3 = new DenseDoubleMatrix1D(doubleMatrix2D.rows());
        doubleMatrix2D.zMult(doubleMatrix1D, doubleMatrix1D3, 1.0, 0.0, true);
        double d = 0.0;
        switch (this.regMethod) {
            case GCV: {
                TikFmin_2D tikFmin_2D = new TikFmin_2D(doubleMatrix1D3, dArray, 1.0);
                d = DoubleFmin.fmin(0.0, 1.0, tikFmin_2D, 1.0E-4);
                break;
            }
            case WGCV: {
                TikFmin_2D tikFmin_2D = new TikFmin_2D(doubleMatrix1D3, dArray, this.omega);
                d = DoubleFmin.fmin(0.0, 1.0, tikFmin_2D, 1.0E-4);
                break;
            }
            case ADAPTWGCV: {
                TikFmin_2D tikFmin_2D = new TikFmin_2D(doubleMatrix1D3, dArray, this.omega);
                d = DoubleFmin.fmin(0.0, 1.0, tikFmin_2D, 1.0E-4);
                break;
            }
            case NONE: {
                d = this.regPar;
            }
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(DoubleFunctions.square);
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(DoubleFunctions.plus(d * d));
        doubleMatrix1D3 = doubleMatrix1D3.viewPart(0, dArray.length);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(dArray);
        doubleMatrix1D3.assign(denseDoubleMatrix1D2, DoubleFunctions.mult);
        doubleMatrix1D3.assign(denseDoubleMatrix1D, DoubleFunctions.div);
        doubleMatrix2D2.zMult(doubleMatrix1D3, doubleMatrix1D2);
        return d;
    }

    private double GCVstopfun(double d, DoubleMatrix1D doubleMatrix1D, double[] dArray, double d2, int n) {
        int n2 = dArray.length;
        double d3 = d2 * d2;
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        ((DoubleMatrix1D)denseDoubleMatrix1D).assign(DoubleFunctions.square);
        double d4 = d * d;
        DoubleMatrix1D doubleMatrix1D2 = denseDoubleMatrix1D.copy();
        doubleMatrix1D2.assign(DoubleFunctions.plus(d4));
        doubleMatrix1D2.assign(DoubleFunctions.inv);
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D2.copy();
        doubleMatrix1D3.assign(doubleMatrix1D.viewPart(0, n2), DoubleFunctions.mult);
        doubleMatrix1D3.assign(DoubleFunctions.mult(d4));
        double d5 = d3 * (doubleMatrix1D3.aggregate(DoubleFunctions.plus, DoubleFunctions.square) + Math.pow(Math.abs(doubleMatrix1D.getQuick(n2)), 2.0)) / (double)n;
        double d6 = ((double)n - doubleMatrix1D2.aggregate(denseDoubleMatrix1D, DoubleFunctions.plus, DoubleFunctions.mult)) / (double)n;
        d6 *= d6;
        return d5 / d6;
    }

    private class DoublePLBD
    implements DoubleLBD {
        private final DoubleAlgebra alg = DoubleAlgebra.DEFAULT;
        private final DoubleFactory2D factory = DoubleFactory2D.dense;
        private final DoubleMatrix2D alphaBeta = new DenseDoubleMatrix2D(2, 1);
        private final DoublePreconditioner M;
        private final DoubleMatrix2D A;
        private DoubleMatrix2D B;
        private DoubleMatrix2D U;
        private DoubleMatrix2D V;
        private boolean reorth;

        public DoublePLBD(DoublePreconditioner doublePreconditioner, DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, boolean bl) {
            this.M = doublePreconditioner;
            this.A = doubleMatrix2D;
            this.reorth = bl;
            this.U = doubleMatrix2D2;
            this.V = null;
            this.B = null;
        }

        public void apply() {
            int n = this.U.rows();
            DoubleMatrix1D doubleMatrix1D = null;
            DoubleMatrix1D doubleMatrix1D2 = null;
            DoubleMatrix1D doubleMatrix1D3 = null;
            if (n == 1) {
                doubleMatrix1D3 = this.U.viewRow(n - 1).copy();
                doubleMatrix1D3 = this.M.transApply(doubleMatrix1D3, doubleMatrix1D3);
                doubleMatrix1D2 = this.A.zMult(doubleMatrix1D3, doubleMatrix1D2, 1.0, 0.0, true);
            } else {
                doubleMatrix1D3 = this.U.viewRow(n - 1).copy();
                doubleMatrix1D3 = this.M.transApply(doubleMatrix1D3, doubleMatrix1D3);
                doubleMatrix1D2 = this.A.zMult(doubleMatrix1D3, doubleMatrix1D2, 1.0, 0.0, true);
                doubleMatrix1D3 = this.V.viewColumn(n - 2).copy();
                doubleMatrix1D2.assign(doubleMatrix1D3.assign(DoubleFunctions.mult(this.B.getQuick(n - 1, n - 2))), DoubleFunctions.minus);
                if (this.reorth) {
                    for (int i = 0; i < n - 1; ++i) {
                        doubleMatrix1D3 = this.V.viewColumn(i).copy();
                        doubleMatrix1D2.assign(doubleMatrix1D3.assign(DoubleFunctions.mult(doubleMatrix1D3.zDotProduct(doubleMatrix1D2))), DoubleFunctions.minus);
                    }
                }
            }
            double d = this.alg.norm2(doubleMatrix1D2);
            doubleMatrix1D2.assign(DoubleFunctions.div(d));
            doubleMatrix1D3 = this.A.zMult(doubleMatrix1D2, doubleMatrix1D3);
            doubleMatrix1D = this.M.apply(doubleMatrix1D3, doubleMatrix1D);
            doubleMatrix1D3 = this.U.viewRow(n - 1).copy();
            doubleMatrix1D.assign(doubleMatrix1D3.assign(DoubleFunctions.mult(d)), DoubleFunctions.minus);
            if (this.reorth) {
                for (int i = 0; i < n; ++i) {
                    doubleMatrix1D3 = this.U.viewRow(i).copy();
                    doubleMatrix1D.assign(doubleMatrix1D3.assign(DoubleFunctions.mult(doubleMatrix1D3.zDotProduct(doubleMatrix1D))), DoubleFunctions.minus);
                }
            }
            double d2 = this.alg.norm2(doubleMatrix1D);
            this.alphaBeta.setQuick(0, 0, d);
            this.alphaBeta.setQuick(1, 0, d2);
            doubleMatrix1D.assign(DoubleFunctions.div(d2));
            this.U = this.factory.appendRow(this.U, doubleMatrix1D);
            if (this.V == null) {
                this.V = new DenseColDoubleMatrix2D(doubleMatrix1D2.size(), 1);
                this.V.assign((double[])doubleMatrix1D2.elements());
            } else {
                this.V = this.factory.appendColumn(this.V, doubleMatrix1D2);
            }
            if (this.B == null) {
                this.B = new DenseDoubleMatrix2D(2, 1);
                this.B.assign(this.alphaBeta);
            } else {
                this.B = this.factory.composeBidiagonal(this.B, this.alphaBeta);
            }
        }

        public DoubleMatrix2D getB() {
            return this.B;
        }

        public DoubleMatrix2D getU() {
            return this.U;
        }

        public DoubleMatrix2D getV() {
            return this.V;
        }
    }

    private class DoubleSimpleLBD
    implements DoubleLBD {
        private final DoubleAlgebra alg = DoubleAlgebra.DEFAULT;
        private final DoubleFactory2D factory = DoubleFactory2D.dense;
        private final DoubleMatrix2D alphaBeta = new DenseDoubleMatrix2D(2, 1);
        private final DoubleMatrix2D A;
        private DoubleMatrix2D B;
        private DoubleMatrix2D U;
        private DoubleMatrix2D V;
        private boolean reorth;

        public DoubleSimpleLBD(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, boolean bl) {
            this.A = doubleMatrix2D;
            this.reorth = bl;
            this.U = doubleMatrix2D2;
            this.V = null;
            this.B = null;
        }

        public void apply() {
            int n = this.U.rows();
            DoubleMatrix1D doubleMatrix1D = null;
            DoubleMatrix1D doubleMatrix1D2 = null;
            DoubleMatrix1D doubleMatrix1D3 = null;
            if (n == 1) {
                doubleMatrix1D2 = this.A.zMult(this.U.viewRow(n - 1), doubleMatrix1D2, 1.0, 0.0, true);
            } else {
                doubleMatrix1D2 = this.A.zMult(this.U.viewRow(n - 1), doubleMatrix1D2, 1.0, 0.0, true);
                doubleMatrix1D3 = this.V.viewColumn(n - 2).copy();
                doubleMatrix1D2.assign(doubleMatrix1D3.assign(DoubleFunctions.mult(this.B.getQuick(n - 1, n - 2))), DoubleFunctions.minus);
                if (this.reorth) {
                    for (int i = 0; i < n - 1; ++i) {
                        doubleMatrix1D3 = this.V.viewColumn(i).copy();
                        doubleMatrix1D2.assign(doubleMatrix1D3.assign(DoubleFunctions.mult(doubleMatrix1D3.zDotProduct(doubleMatrix1D2))), DoubleFunctions.minus);
                    }
                }
            }
            double d = this.alg.norm2(doubleMatrix1D2);
            doubleMatrix1D2.assign(DoubleFunctions.div(d));
            doubleMatrix1D = this.A.zMult(doubleMatrix1D2, doubleMatrix1D);
            doubleMatrix1D3 = this.U.viewRow(n - 1).copy();
            doubleMatrix1D.assign(doubleMatrix1D3.assign(DoubleFunctions.mult(d)), DoubleFunctions.minus);
            if (this.reorth) {
                for (int i = 0; i < n; ++i) {
                    doubleMatrix1D3 = this.U.viewRow(i).copy();
                    doubleMatrix1D.assign(doubleMatrix1D3.assign(DoubleFunctions.mult(doubleMatrix1D3.zDotProduct(doubleMatrix1D))), DoubleFunctions.minus);
                }
            }
            double d2 = this.alg.norm2(doubleMatrix1D);
            this.alphaBeta.setQuick(0, 0, d);
            this.alphaBeta.setQuick(1, 0, d2);
            doubleMatrix1D.assign(DoubleFunctions.div(d2));
            this.U = this.factory.appendRow(this.U, doubleMatrix1D);
            if (this.V == null) {
                this.V = new DenseColDoubleMatrix2D(doubleMatrix1D2.size(), 1);
                this.V.assign((double[])doubleMatrix1D2.elements());
            } else {
                this.V = this.factory.appendColumn(this.V, doubleMatrix1D2);
            }
            if (this.B == null) {
                this.B = new DenseDoubleMatrix2D(2, 1);
                this.B.assign(this.alphaBeta);
            } else {
                this.B = this.factory.composeBidiagonal(this.B, this.alphaBeta);
            }
        }

        public DoubleMatrix2D getB() {
            return this.B;
        }

        public DoubleMatrix2D getU() {
            return this.U;
        }

        public DoubleMatrix2D getV() {
            return this.V;
        }
    }

    private static interface DoubleLBD {
        public void apply();

        public DoubleMatrix2D getB();

        public DoubleMatrix2D getU();

        public DoubleMatrix2D getV();
    }

    private static class TikFmin_2D
    implements DoubleFmin_methods {
        DoubleMatrix1D bhat;
        double[] s;
        double omega;

        public TikFmin_2D(DoubleMatrix1D doubleMatrix1D, double[] dArray, double d) {
            this.bhat = doubleMatrix1D;
            this.s = dArray;
            this.omega = d;
        }

        public double f_to_minimize(double d) {
            int n = this.bhat.size();
            int n2 = this.s.length;
            double d2 = this.bhat.viewPart(n2, n - n2).aggregate(DoubleFunctions.plus, DoubleFunctions.square);
            DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.s);
            ((DoubleMatrix1D)denseDoubleMatrix1D).assign(DoubleFunctions.square);
            double d3 = d * d;
            DoubleMatrix1D doubleMatrix1D = denseDoubleMatrix1D.copy();
            doubleMatrix1D.assign(DoubleFunctions.plus(d3));
            doubleMatrix1D.assign(DoubleFunctions.inv);
            DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.copy();
            doubleMatrix1D2.assign(DoubleFunctions.mult(d3));
            DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D2.copy();
            doubleMatrix1D3.assign(this.bhat.viewPart(0, n2), DoubleFunctions.mult);
            DoubleMatrix1D doubleMatrix1D4 = doubleMatrix1D.copy();
            doubleMatrix1D4.assign(denseDoubleMatrix1D, DoubleFunctions.mult);
            doubleMatrix1D4.assign(DoubleFunctions.mult(1.0 - this.omega));
            double d4 = doubleMatrix1D4.aggregate(doubleMatrix1D2, DoubleFunctions.plus, DoubleFunctions.plus) + (double)n - (double)n2;
            return (double)n2 * (doubleMatrix1D3.aggregate(DoubleFunctions.plus, DoubleFunctions.square) + d2) / (d4 * d4);
        }
    }
}

