/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.RCDoubleMatrix2D;

public class DoubleSSOR
implements DoublePreconditioner {
    private double omegaF;
    private double omegaR;
    private final RCDoubleMatrix2D F;
    private final int[] diagind;
    private final double[] xx;
    private final boolean reverse;

    public DoubleSSOR(RCDoubleMatrix2D rCDoubleMatrix2D, boolean bl, double d, double d2) {
        if (rCDoubleMatrix2D.rows() != rCDoubleMatrix2D.columns()) {
            throw new IllegalArgumentException("SSOR only applies to square matrices");
        }
        this.F = rCDoubleMatrix2D;
        this.reverse = bl;
        this.setOmega(d, d2);
        int n = rCDoubleMatrix2D.rows();
        this.diagind = new int[n];
        this.xx = new double[n];
    }

    public DoubleSSOR(RCDoubleMatrix2D rCDoubleMatrix2D) {
        this(rCDoubleMatrix2D, true, 1.0, 1.0);
    }

    public void setOmega(double d, double d2) {
        if (d < 0.0 || d > 2.0) {
            throw new IllegalArgumentException("omegaF must be between 0 and 2");
        }
        if (d2 < 0.0 || d2 > 2.0) {
            throw new IllegalArgumentException("omegaR must be between 0 and 2");
        }
        this.omegaF = d;
        this.omegaR = d2;
    }

    public void setMatrix(DoubleMatrix2D doubleMatrix2D) {
        this.F.assign(doubleMatrix2D);
        int n = this.F.rows();
        int[] nArray = this.F.getRowPointers();
        int[] nArray2 = this.F.getColumnindexes().elements();
        for (int i = 0; i < n; ++i) {
            this.diagind[i] = Sorting.binarySearchFromTo(nArray2, i, nArray[i], nArray[i + 1] - 1);
            if (this.diagind[i] >= 0) continue;
            throw new RuntimeException("Missing diagonal on row " + (i + 1));
        }
    }

    public DoubleMatrix1D apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        int n;
        double d;
        int n2;
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            throw new IllegalArgumentException("b and x must be a DenseDoubleMatrix1D");
        }
        int[] nArray = this.F.getRowPointers();
        int[] nArray2 = this.F.getColumnindexes().elements();
        double[] dArray = this.F.getValues().elements();
        double[] dArray2 = ((DenseDoubleMatrix1D)doubleMatrix1D).elements();
        double[] dArray3 = new double[doubleMatrix1D2.size()];
        int n3 = this.F.rows();
        System.arraycopy(dArray3, 0, this.xx, 0, n3);
        for (n2 = 0; n2 < n3; ++n2) {
            d = 0.0;
            for (n = nArray[n2]; n < this.diagind[n2]; ++n) {
                d += dArray[n] * this.xx[nArray2[n]];
            }
            for (n = this.diagind[n2] + 1; n < nArray[n2 + 1]; ++n) {
                d += dArray[n] * dArray3[nArray2[n]];
            }
            d = (dArray2[n2] - d) / dArray[this.diagind[n2]];
            this.xx[n2] = dArray3[n2] + this.omegaF * (d - dArray3[n2]);
        }
        if (!this.reverse) {
            System.arraycopy(this.xx, 0, dArray3, 0, n3);
            doubleMatrix1D2.assign(dArray3);
            return doubleMatrix1D2;
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            d = 0.0;
            for (n = nArray[n2]; n < this.diagind[n2]; ++n) {
                d += dArray[n] * this.xx[nArray2[n]];
            }
            for (n = this.diagind[n2] + 1; n < nArray[n2 + 1]; ++n) {
                d += dArray[n] * dArray3[nArray2[n]];
            }
            d = (dArray2[n2] - d) / dArray[this.diagind[n2]];
            dArray3[n2] = this.xx[n2] + this.omegaR * (d - this.xx[n2]);
        }
        doubleMatrix1D2.assign(dArray3);
        return doubleMatrix1D2;
    }

    public DoubleMatrix1D transApply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        return this.apply(doubleMatrix1D, doubleMatrix1D2);
    }
}

