/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.Timer;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleFactory3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;

public class BenchmarkFFT {
    private static final int[] sizes2D = new int[]{2000, 2048, 4000, 4096, 8000, 8192};
    private static final int[] sizes3D = new int[]{100, 128, 200, 256, 500, 512};
    private static int niters = 100;

    public static void benchmarkFft2() {
        Timer timer = new Timer();
        double[] dArray = new double[sizes2D.length];
        for (int i = 0; i < sizes2D.length; ++i) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)DoubleFactory2D.dense.random(sizes2D[i], sizes2D[i]);
            DenseDComplexMatrix2D denseDComplexMatrix2D = denseDoubleMatrix2D.getFft2();
            denseDComplexMatrix2D = denseDoubleMatrix2D.getFft2();
            timer.reset().start();
            for (int j = 0; j < niters; ++j) {
                denseDComplexMatrix2D = denseDoubleMatrix2D.getFft2();
            }
            timer.stop();
            dArray[i] = timer.seconds() / (double)niters;
            System.out.println("Average execution time for getFft2() of size " + sizes2D[i] + " x " + sizes2D[i] + " : " + dArray[i]);
        }
    }

    public static void benchmarkFft3() {
        Timer timer = new Timer();
        double[] dArray = new double[sizes3D.length];
        for (int i = 0; i < sizes3D.length; ++i) {
            DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)DoubleFactory3D.dense.random(sizes3D[i], sizes3D[i], sizes3D[i]);
            DenseDComplexMatrix3D denseDComplexMatrix3D = denseDoubleMatrix3D.getFft3();
            denseDComplexMatrix3D = denseDoubleMatrix3D.getFft3();
            timer.reset().start();
            for (int j = 0; j < niters; ++j) {
                denseDComplexMatrix3D = denseDoubleMatrix3D.getFft3();
            }
            timer.stop();
            dArray[i] = timer.seconds() / (double)niters;
            System.out.println("Average execution time for getFft3() of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + " : " + dArray[i]);
        }
    }

    public static void main(String[] stringArray) {
        BenchmarkFFT.benchmarkFft2();
        BenchmarkFFT.benchmarkFft3();
    }
}

