/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;

public class CCMDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private SparseDoubleMatrix1D[] elements;

    public CCMDoubleMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseDoubleMatrix1D[n2];
        for (int i = 0; i < n2; ++i) {
            this.elements[i] = new SparseDoubleMatrix1D(n);
        }
    }

    public SparseDoubleMatrix1D[] elements() {
        return this.elements;
    }

    public double getQuick(int n, int n2) {
        return this.elements[n2].getQuick(n);
    }

    public void setQuick(int n, int n2, double d) {
        this.elements[n2].setQuick(n, d);
    }

    public void trimToSize() {
        for (int i = 0; i < this.columns; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseDoubleMatrix1D viewColumn(int n) {
        return this.elements[n];
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new CCMDoubleMatrix2D(n, n2);
    }
}

