/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.Double27Function;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SelectedDenseDoubleMatrix3D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_3D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_3D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_3D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseDoubleMatrix3D
extends DoubleMatrix3D {
    private static final long serialVersionUID = 5711401505315728697L;
    private DoubleFFT_3D fft3;
    private DoubleDCT_3D dct3;
    private DoubleDST_3D dst3;
    private DoubleDHT_3D dht3;
    protected double[] elements;

    public DenseDoubleMatrix3D(double[][][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length, dArray.length == 0 ? 0 : (dArray[0].length == 0 ? 0 : dArray[0][0].length));
        this.assign(dArray);
    }

    public DenseDoubleMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new double[n * n2 * n3];
    }

    public DenseDoubleMatrix3D(int n, int n2, int n3, double[] dArray, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = dArray;
        this.isNoView = !bl;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            Double[] doubleArray = new Double[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DenseDoubleMatrix3D.this.elements[n + n4 * DenseDoubleMatrix3D.this.sliceStride]);
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    d = doubleDoubleFunction.apply(d, doubleFunction.apply(DenseDoubleMatrix3D.this.elements[n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride + k * DenseDoubleMatrix3D.this.columnStride]));
                                }
                                n2 = 0;
                            }
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.elements[n]);
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride]));
                    }
                    n6 = 0;
                }
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, final DoubleProcedure doubleProcedure) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            Double[] doubleArray = new Double[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = DenseDoubleMatrix3D.this.elements[n + n4 * DenseDoubleMatrix3D.this.sliceStride];
                        double d2 = 0.0;
                        if (doubleProcedure.apply(d)) {
                            d2 = doubleDoubleFunction.apply(d2, doubleFunction.apply(d));
                        }
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    d = DenseDoubleMatrix3D.this.elements[n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride + k * DenseDoubleMatrix3D.this.columnStride];
                                    if (doubleProcedure.apply(d)) {
                                        d2 = doubleDoubleFunction.apply(d2, doubleFunction.apply(d));
                                    }
                                    n2 = 0;
                                }
                            }
                        }
                        return d2;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            double d2 = this.elements[n];
            if (doubleProcedure.apply(d2)) {
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
            }
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        d2 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (doubleProcedure.apply(d2)) {
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                        }
                        n6 = 0;
                    }
                }
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (intArrayList.size() == 0 || intArrayList2.size() == 0 || intArrayList3.size() == 0) {
            return Double.NaN;
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        final int n2 = (int)this.index(0, 0, 0);
        double d = 0.0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n3];
            Double[] doubleArray = new Double[n3];
            int n4 = n / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DenseDoubleMatrix3D.this.elements[n2 + nArray[n5] * DenseDoubleMatrix3D.this.sliceStride + nArray2[n5] * DenseDoubleMatrix3D.this.rowStride + nArray3[n5] * DenseDoubleMatrix3D.this.columnStride]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            double d2 = DenseDoubleMatrix3D.this.elements[n2 + nArray[i] * DenseDoubleMatrix3D.this.sliceStride + nArray2[i] * DenseDoubleMatrix3D.this.rowStride + nArray3[i] * DenseDoubleMatrix3D.this.columnStride];
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.elements[n2 + nArray[0] * this.sliceStride + nArray2[0] * this.rowStride + nArray3[0] * this.columnStride]);
            for (int i = 1; i < n; ++i) {
                double d2 = this.elements[n2 + nArray[i] * this.sliceStride + nArray2[i] * this.rowStride + nArray3[i] * this.columnStride];
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
            }
        }
        return d;
    }

    public double aggregate(DoubleMatrix3D doubleMatrix3D, final DoubleDoubleFunction doubleDoubleFunction, final DoubleDoubleFunction doubleDoubleFunction2) {
        if (!(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            return super.aggregate(doubleMatrix3D, doubleDoubleFunction, doubleDoubleFunction2);
        }
        this.checkShape(doubleMatrix3D);
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)doubleMatrix3D.index(0, 0, 0);
        final int n3 = doubleMatrix3D.sliceStride();
        final int n4 = doubleMatrix3D.rowStride();
        final int n5 = doubleMatrix3D.columnStride();
        final double[] dArray = (double[])doubleMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            Double[] doubleArray = new Double[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        int n6 = n + n8 * DenseDoubleMatrix3D.this.sliceStride;
                        int n22 = n2 + n8 * n3;
                        double d = doubleDoubleFunction2.apply(DenseDoubleMatrix3D.this.elements[n6], dArray[n22]);
                        int n32 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                for (int k = n32; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    n6 = n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride + k * DenseDoubleMatrix3D.this.columnStride;
                                    n22 = n2 + i * n3 + j * n4 + k * n5;
                                    d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(DenseDoubleMatrix3D.this.elements[n6], dArray[n22]));
                                }
                                n32 = 0;
                            }
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleDoubleFunction2.apply(this.getQuick(0, 0, 0), doubleMatrix3D.getQuick(0, 0, 0));
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        int n11 = n + i * this.sliceStride + j * this.rowStride + k * this.columnStride;
                        int n12 = n2 + i * n3 + j * n4 + k * n5;
                        d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(this.elements[n11], dArray[n12]));
                    }
                    n10 = 0;
                }
            }
        }
        return d;
    }

    public DoubleMatrix3D assign(final DoubleFunction doubleFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    DenseDoubleMatrix3D.this.elements[n2] = doubleFunction.apply(DenseDoubleMatrix3D.this.elements[n2]);
                                    n2 += DenseDoubleMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = doubleFunction.apply(this.elements[n6]);
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final double d) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    DenseDoubleMatrix3D.this.elements[n2] = d;
                                    n2 += DenseDoubleMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n6] = d;
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final double[] dArray) {
        if (dArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n2;
                Future[] futureArray = new Future[n];
                int n3 = this.size() / n;
                for (n2 = 0; n2 < n; ++n2) {
                    final int n4 = n2 * n3;
                    final int n5 = n2 == n - 1 ? this.size() - n4 : n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            System.arraycopy(dArray, n4, DenseDoubleMatrix3D.this.elements, n4, n5);
                        }
                    });
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        futureArray[n2].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                System.arraycopy(dArray, 0, this.elements, 0, dArray.length);
            }
        } else {
            final int n6 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n7;
                Future[] futureArray = new Future[n];
                int n8 = this.slices / n;
                for (n7 = 0; n7 < n; ++n7) {
                    final int n9 = n7 * n8;
                    final int n10 = n7 * n8 * this.rows * this.columns;
                    final int n11 = n7 == n - 1 ? this.slices : n9 + n8;
                    futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n10;
                            for (int i = n9; i < n11; ++i) {
                                for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                    int n2 = n6 + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                    for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                        DenseDoubleMatrix3D.this.elements[n2] = dArray[n++];
                                        n2 += DenseDoubleMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    for (n7 = 0; n7 < n; ++n7) {
                        futureArray[n7].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                int n12 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        int n13 = n6 + i * this.sliceStride + j * this.rowStride;
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n13] = dArray[n12++];
                            n13 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final double[][][] dArray) {
        if (dArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + dArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n2;
                Future[] futureArray = new Future[n];
                int n3 = this.slices / n;
                for (n2 = 0; n2 < n; ++n2) {
                    final int n4 = n2 * n3;
                    final int n5 = n2 == n - 1 ? this.slices : n4 + n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseDoubleMatrix3D.this.sliceStride;
                            for (int i = n4; i < n5; ++i) {
                                double[][] dArray3 = dArray[i];
                                if (dArray3.length != DenseDoubleMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray3.length + "rows()=" + DenseDoubleMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                    double[] dArray2 = dArray3[j];
                                    if (dArray2.length != DenseDoubleMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "columns()=" + DenseDoubleMatrix3D.this.columns());
                                    }
                                    System.arraycopy(dArray2, 0, DenseDoubleMatrix3D.this.elements, n, DenseDoubleMatrix3D.this.columns);
                                    n += DenseDoubleMatrix3D.this.columns;
                                }
                            }
                        }
                    });
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        futureArray[n2].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                int n6 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    double[][] dArray2 = dArray[i];
                    if (dArray2.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray2.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        double[] dArray3 = dArray2[j];
                        if (dArray3.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray3.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(dArray3, 0, this.elements, n6, this.columns);
                        n6 += this.columns;
                    }
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n8;
                Future[] futureArray = new Future[n];
                int n9 = this.slices / n;
                for (n8 = 0; n8 < n; ++n8) {
                    final int n10 = n8 * n9;
                    final int n11 = n8 == n - 1 ? this.slices : n10 + n9;
                    futureArray[n8] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n10; i < n11; ++i) {
                                double[][] dArray3 = dArray[i];
                                if (dArray3.length != DenseDoubleMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray3.length + "rows()=" + DenseDoubleMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                    int n = n7 + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                    double[] dArray2 = dArray3[j];
                                    if (dArray2.length != DenseDoubleMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "columns()=" + DenseDoubleMatrix3D.this.columns());
                                    }
                                    for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                        DenseDoubleMatrix3D.this.elements[n] = dArray2[k];
                                        n += DenseDoubleMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    for (n8 = 0; n8 < n; ++n8) {
                        futureArray[n8].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                for (int i = 0; i < this.slices; ++i) {
                    double[][] dArray4 = dArray[i];
                    if (dArray4.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray4.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        int n12 = n7 + i * this.sliceStride + j * this.rowStride;
                        double[] dArray5 = dArray4[j];
                        if (dArray5.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray5.length + "columns()=" + this.columns());
                        }
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n12] = dArray5[k];
                            n12 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final DoubleProcedure doubleProcedure, final DoubleFunction doubleFunction) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    double d = DenseDoubleMatrix3D.this.elements[n2];
                                    if (doubleProcedure.apply(d)) {
                                        DenseDoubleMatrix3D.this.elements[n2] = doubleFunction.apply(d);
                                    }
                                    n2 += DenseDoubleMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        double d = this.elements[n6];
                        if (doubleProcedure.apply(d)) {
                            this.elements[n6] = doubleFunction.apply(d);
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final DoubleProcedure doubleProcedure, final double d) {
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    double d2 = DenseDoubleMatrix3D.this.elements[n2];
                                    if (doubleProcedure.apply(d2)) {
                                        DenseDoubleMatrix3D.this.elements[n2] = d;
                                    }
                                    n2 += DenseDoubleMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        double d2 = this.elements[n6];
                        if (doubleProcedure.apply(d2)) {
                            this.elements[n6] = d;
                        }
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleMatrix3D doubleMatrix3D) {
        DoubleMatrix3D doubleMatrix3D2;
        if (!(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            super.assign(doubleMatrix3D);
            return this;
        }
        DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D;
        if (denseDoubleMatrix3D == this) {
            return this;
        }
        this.checkShape(denseDoubleMatrix3D);
        if (this.haveSharedCells(denseDoubleMatrix3D)) {
            doubleMatrix3D2 = denseDoubleMatrix3D.copy();
            if (!(doubleMatrix3D2 instanceof DenseDoubleMatrix3D)) {
                super.assign(doubleMatrix3D);
                return this;
            }
            denseDoubleMatrix3D = doubleMatrix3D2;
        }
        doubleMatrix3D2 = denseDoubleMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseDoubleMatrix3D.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n2;
                Future[] futureArray = new Future[n];
                int n3 = this.size() / n;
                for (n2 = 0; n2 < n; ++n2) {
                    int n4 = n2 * n3;
                    int n5 = n2 == n - 1 ? this.size() - n4 : n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable((DenseDoubleMatrix3D)doubleMatrix3D2, n4, n5){
                        final /* synthetic */ DenseDoubleMatrix3D val$other_final;
                        final /* synthetic */ int val$startidx;
                        final /* synthetic */ int val$length;
                        {
                            this.val$other_final = denseDoubleMatrix3D2;
                            this.val$startidx = n;
                            this.val$length = n2;
                        }

                        public void run() {
                            System.arraycopy(this.val$other_final.elements, this.val$startidx, DenseDoubleMatrix3D.this.elements, this.val$startidx, this.val$length);
                        }
                    });
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        futureArray[n2].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                System.arraycopy(((DenseDoubleMatrix3D)doubleMatrix3D2).elements, 0, this.elements, 0, this.elements.length);
            }
            return this;
        }
        final int n6 = (int)this.index(0, 0, 0);
        final int n7 = (int)((DenseDoubleMatrix3D)doubleMatrix3D2).index(0, 0, 0);
        final int n8 = ((DenseDoubleMatrix3D)doubleMatrix3D2).sliceStride;
        final int n9 = ((DenseDoubleMatrix3D)doubleMatrix3D2).rowStride;
        final int n10 = ((DenseDoubleMatrix3D)doubleMatrix3D2).columnStride;
        final double[] dArray = ((DenseDoubleMatrix3D)doubleMatrix3D2).elements;
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n11;
            Future[] futureArray = new Future[n];
            int n12 = this.slices / n;
            for (n11 = 0; n11 < n; ++n11) {
                final int n13 = n11 * n12;
                final int n14 = n11 == n - 1 ? this.slices : n13 + n12;
                futureArray[n11] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n13; i < n14; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n = n6 + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                int n2 = n7 + i * n8 + j * n9;
                                for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    DenseDoubleMatrix3D.this.elements[n] = dArray[n2];
                                    n += DenseDoubleMatrix3D.this.columnStride;
                                    n2 += n10;
                                }
                            }
                        }
                    }
                });
            }
            try {
                for (n11 = 0; n11 < n; ++n11) {
                    futureArray[n11].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n15 = n6 + i * this.sliceStride + j * this.rowStride;
                    int n16 = n7 + i * n8 + j * n9;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n15] = dArray[n16];
                        n15 += this.columnStride;
                        n16 += n10;
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleMatrix3D doubleMatrix3D, final DoubleDoubleFunction doubleDoubleFunction) {
        if (!(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            super.assign(doubleMatrix3D, doubleDoubleFunction);
            return this;
        }
        this.checkShape(doubleMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)doubleMatrix3D.index(0, 0, 0);
        final int n3 = doubleMatrix3D.sliceStride();
        final int n4 = doubleMatrix3D.rowStride();
        final int n5 = doubleMatrix3D.columnStride();
        final double[] dArray = (double[])doubleMatrix3D.elements();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n6];
            int n7 = this.slices / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.slices : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n6 = n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                int n22 = n2 + i * n3 + j * n4;
                                for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    DenseDoubleMatrix3D.this.elements[n6] = doubleDoubleFunction.apply(DenseDoubleMatrix3D.this.elements[n6], dArray[n22]);
                                    n6 += DenseDoubleMatrix3D.this.columnStride;
                                    n22 += n5;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n10 = n + i * this.sliceStride + j * this.rowStride;
                    int n11 = n2 + i * n3 + j * n4;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n10] = doubleDoubleFunction.apply(this.elements[n10], dArray[n11]);
                        n10 += this.columnStride;
                        n11 += n5;
                    }
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleMatrix3D doubleMatrix3D, final DoubleDoubleFunction doubleDoubleFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (!(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            super.assign(doubleMatrix3D, doubleDoubleFunction);
            return this;
        }
        this.checkShape(doubleMatrix3D);
        final int n = (int)this.index(0, 0, 0);
        final int n2 = (int)doubleMatrix3D.index(0, 0, 0);
        final int n3 = doubleMatrix3D.sliceStride();
        final int n4 = doubleMatrix3D.rowStride();
        final int n5 = doubleMatrix3D.columnStride();
        final double[] dArray = (double[])doubleMatrix3D.elements();
        int n6 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && n6 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n7];
            int n8 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                final int n9 = i * n8;
                final int n10 = i == n7 - 1 ? n6 : n9 + n8;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n10; ++i) {
                            int n6 = n + nArray[i] * DenseDoubleMatrix3D.this.sliceStride + nArray2[i] * DenseDoubleMatrix3D.this.rowStride + nArray3[i] * DenseDoubleMatrix3D.this.columnStride;
                            int n22 = n2 + nArray[i] * n3 + nArray2[i] * n4 + nArray3[i] * n5;
                            DenseDoubleMatrix3D.this.elements[n6] = doubleDoubleFunction.apply(DenseDoubleMatrix3D.this.elements[n6], dArray[n22]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n6; ++i) {
                int n11 = n + nArray[i] * this.sliceStride + nArray2[i] * this.rowStride + nArray3[i] * this.columnStride;
                int n12 = n2 + nArray[i] * n3 + nArray2[i] * n4 + nArray3[i] * n5;
                this.elements[n11] = doubleDoubleFunction.apply(this.elements[n11], dArray[n12]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        final int n2 = (int)this.index(0, 0, 0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n5 = this.slices / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.slices : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n22 = n2 + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    if (DenseDoubleMatrix3D.this.elements[n22] != 0.0) {
                                        ++n;
                                    }
                                    n22 += DenseDoubleMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = n2 + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        if (this.elements[n8] != 0.0) {
                            ++n;
                        }
                        n8 += this.columnStride;
                    }
                }
            }
        }
        return n;
    }

    public void dct2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(i)).dct2(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseDoubleMatrix2D)this.viewSlice(i)).dct2(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht3 == null) {
            this.dht3 = new DoubleDHT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht3.forward(this.elements);
        } else {
            DoubleMatrix3D doubleMatrix3D = this.copy();
            this.dht3.forward((double[])doubleMatrix3D.elements());
            this.assign((double[])doubleMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht2Slices() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(i)).dht2();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseDoubleMatrix2D)this.viewSlice(i)).dht2();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dct3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct3 == null) {
            this.dct3 = new DoubleDCT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct3.forward(this.elements, bl);
        } else {
            DoubleMatrix3D doubleMatrix3D = this.copy();
            this.dct3.forward((double[])doubleMatrix3D.elements(), bl);
            this.assign((double[])doubleMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(i)).dst2(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseDoubleMatrix2D)this.viewSlice(i)).dst2(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst3 == null) {
            this.dst3 = new DoubleDST_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst3.forward(this.elements, bl);
        } else {
            DoubleMatrix3D doubleMatrix3D = this.copy();
            this.dst3.forward((double[])doubleMatrix3D.elements(), bl);
            this.assign((double[])doubleMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public double[] elements() {
        return this.elements;
    }

    public void fft3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.realForward(this.elements);
        } else {
            DoubleMatrix3D doubleMatrix3D = this.copy();
            this.fft3.realForward((double[])doubleMatrix3D.elements());
            this.assign((double[])doubleMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public DenseDComplexMatrix3D getFft2Slices() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(this.slices, this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseDComplexMatrix3D.viewSlice(i).assign(((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(i)).getFft2());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                denseDComplexMatrix3D.viewSlice(i).assign(((DenseDoubleMatrix2D)this.viewSlice(i)).getFft2());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix3D;
    }

    public DenseDComplexMatrix3D getFft3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(this.slices, this.rows, this.columns);
        final int n2 = this.rows * this.columns;
        final int n3 = this.columns;
        final double[] dArray = this.isNoView ? this.elements : (double[])this.copy().elements();
        final double[] dArray2 = denseDComplexMatrix3D.elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n4];
            int n5 = this.slices / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? this.slices : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n = i * n2 + j * n3;
                                System.arraycopy(dArray, n, dArray2, n, DenseDoubleMatrix3D.this.columns);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = i * n2 + j * n3;
                    System.arraycopy(dArray, n8, dArray2, n8, this.columns);
                }
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realForwardFull(dArray2);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix3D;
    }

    public DenseDComplexMatrix3D getIfft2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(this.slices, this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseDComplexMatrix3D.viewSlice(i).assign(((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(i)).getIfft2(bl));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                denseDComplexMatrix3D.viewSlice(i).assign(((DenseDoubleMatrix2D)this.viewSlice(i)).getIfft2(bl));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix3D;
    }

    public DenseDComplexMatrix3D getIfft3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(this.slices, this.rows, this.columns);
        final int n2 = this.rows * this.columns;
        final int n3 = this.columns;
        final double[] dArray = denseDComplexMatrix3D.elements();
        final double[] dArray2 = this.isNoView ? this.elements : (double[])this.copy().elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n4];
            int n5 = this.slices / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? this.slices : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n = i * n2 + j * n3;
                                System.arraycopy(dArray2, n, dArray, n, DenseDoubleMatrix3D.this.columns);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n8 = i * n2 + j * n3;
                    System.arraycopy(dArray2, n8, dArray, n8, this.columns);
                }
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realInverseFull(dArray, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseDComplexMatrix3D;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        doubleArrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    double d = this.elements[n2];
                    if (d < 0.0) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        doubleArrayList.add(d);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        doubleArrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    double d = this.elements[n2];
                    if (d != 0.0) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        doubleArrayList.add(d);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        doubleArrayList.clear();
        int n = (int)this.index(0, 0, 0);
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = n + i * this.sliceStride + j * this.rowStride;
                for (int k = 0; k < this.columns; ++k) {
                    double d = this.elements[n2];
                    if (d > 0.0) {
                        intArrayList.add(i);
                        intArrayList2.add(j);
                        intArrayList3.add(k);
                        doubleArrayList.add(d);
                    }
                    n2 += this.columnStride;
                }
            }
        }
    }

    public double getQuick(int n, int n2, int n3) {
        return this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride];
    }

    public void idct2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(i)).idct2(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseDoubleMatrix2D)this.viewSlice(i)).idct2(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht3 == null) {
            this.dht3 = new DoubleDHT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht3.inverse(this.elements, bl);
        } else {
            DoubleMatrix3D doubleMatrix3D = this.copy();
            this.dht3.inverse((double[])doubleMatrix3D.elements(), bl);
            this.assign((double[])doubleMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(i)).idht2(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseDoubleMatrix2D)this.viewSlice(i)).idht2(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idct3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct3 == null) {
            this.dct3 = new DoubleDCT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct3.inverse(this.elements, bl);
        } else {
            DoubleMatrix3D doubleMatrix3D = this.copy();
            this.dct3.inverse((double[])doubleMatrix3D.elements(), bl);
            this.assign((double[])doubleMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst2Slices(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(i)).idst2(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                ((DenseDoubleMatrix2D)this.viewSlice(i)).idst2(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst3 == null) {
            this.dst3 = new DoubleDST_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst3.inverse(this.elements, bl);
        } else {
            DoubleMatrix3D doubleMatrix3D = this.copy();
            this.dst3.inverse((double[])doubleMatrix3D.elements(), bl);
            this.assign((double[])doubleMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.realInverse(this.elements, bl);
        } else {
            DoubleMatrix3D doubleMatrix3D = this.copy();
            this.fft3.realInverse((double[])doubleMatrix3D.elements(), bl);
            this.assign((double[])doubleMatrix3D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public long index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    public DoubleMatrix3D like(int n, int n2, int n3) {
        return new DenseDoubleMatrix3D(n, n2, n3);
    }

    public double[] getMaxLocation() {
        final int n = (int)this.index(0, 0, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n6;
            Future[] futureArray = new Future[n5];
            double[][] dArray = new double[n5][2];
            int n7 = this.slices / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.slices : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n5 = n8;
                        int n2 = 0;
                        int n3 = 0;
                        double d = DenseDoubleMatrix3D.this.elements[n + n8 * DenseDoubleMatrix3D.this.sliceStride];
                        int n4 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    double d2 = DenseDoubleMatrix3D.this.elements[n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride + k * DenseDoubleMatrix3D.this.columnStride];
                                    if (!(d < d2)) continue;
                                    d = d2;
                                    n5 = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new double[]{d, n5, n2, n3};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    dArray[n6] = (double[])futureArray[n6].get();
                }
                d = dArray[0][0];
                n2 = (int)dArray[0][1];
                n3 = (int)dArray[0][2];
                n4 = (int)dArray[0][3];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (!(d < dArray[n6][0])) continue;
                    d = dArray[n6][0];
                    n2 = (int)dArray[n6][1];
                    n3 = (int)dArray[n6][2];
                    n4 = (int)dArray[n6][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.elements[n];
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        double d2 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (!(d < d2)) continue;
                        d = d2;
                        n2 = i;
                        n3 = j;
                        n4 = k;
                    }
                    n10 = 0;
                }
            }
        }
        return new double[]{d, n2, n3, n4};
    }

    public double[] getMinLocation() {
        final int n = (int)this.index(0, 0, 0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n6;
            Future[] futureArray = new Future[n5];
            double[][] dArray = new double[n5][2];
            int n7 = this.slices / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.slices : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n5 = n8;
                        int n2 = 0;
                        int n3 = 0;
                        double d = DenseDoubleMatrix3D.this.elements[n + n5 * DenseDoubleMatrix3D.this.sliceStride];
                        int n4 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                for (int k = n4; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    double d2 = DenseDoubleMatrix3D.this.elements[n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride + k * DenseDoubleMatrix3D.this.columnStride];
                                    if (!(d > d2)) continue;
                                    d = d2;
                                    n5 = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n4 = 0;
                            }
                        }
                        return new double[]{d, n5, n2, n3};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    dArray[n6] = (double[])futureArray[n6].get();
                }
                d = dArray[0][0];
                n2 = (int)dArray[0][1];
                n3 = (int)dArray[0][2];
                n4 = (int)dArray[0][3];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (!(d > dArray[n6][0])) continue;
                    d = dArray[n6][0];
                    n2 = (int)dArray[n6][1];
                    n3 = (int)dArray[n6][2];
                    n4 = (int)dArray[n6][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.elements[n];
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        double d2 = this.elements[n + i * this.sliceStride + j * this.rowStride + k * this.columnStride];
                        if (!(d > d2)) continue;
                        d = d2;
                        n2 = i;
                        n3 = j;
                        n4 = k;
                    }
                    n10 = 0;
                }
            }
        }
        return new double[]{d, n2, n3, n4};
    }

    public void setQuick(int n, int n2, int n3, double d) {
        this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride] = d;
    }

    public double[][][] toArray() {
        final double[][][] dArray = new double[this.slices][this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0, 0);
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            Future[] futureArray = new Future[n];
            int n3 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            double[][] dArray3 = dArray[i];
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n = n2 + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                double[] dArray2 = dArray3[j];
                                for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    dArray2[k] = DenseDoubleMatrix3D.this.elements[n];
                                    n += DenseDoubleMatrix3D.this.columnStride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                double[][] dArray2 = dArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    int n6 = n2 + i * this.sliceStride + j * this.rowStride;
                    double[] dArray3 = dArray2[j];
                    for (int k = 0; k < this.columns; ++k) {
                        dArray3[k] = this.elements[n6];
                        n6 += this.columnStride;
                    }
                }
            }
        }
        return dArray;
    }

    public DoubleMatrix1D vectorize() {
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseDoubleMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseDoubleMatrix1D;
    }

    public void zAssign27Neighbors(DoubleMatrix3D doubleMatrix3D, Double27Function double27Function) {
        if (!(doubleMatrix3D instanceof DenseDoubleMatrix3D)) {
            super.zAssign27Neighbors(doubleMatrix3D, double27Function);
            return;
        }
        if (double27Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(doubleMatrix3D);
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D;
        int n3 = this.sliceStride;
        int n4 = this.rowStride;
        int n5 = denseDoubleMatrix3D.rowStride;
        int n6 = this.columnStride;
        int n7 = denseDoubleMatrix3D.columnStride;
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix3D.elements;
        if (dArray == null || dArray2 == null) {
            throw new InternalError();
        }
        for (int i = 1; i < this.slices - 1; ++i) {
            int n8 = (int)this.index(i, 1, 1);
            int n9 = (int)denseDoubleMatrix3D.index(i, 1, 1);
            for (int j = 1; j < n; ++j) {
                int n10 = n8 - n3 - n4 - n6;
                int n11 = n10 + n4;
                int n12 = n11 + n4;
                int n13 = n10 + n3;
                int n14 = n13 + n4;
                int n15 = n14 + n4;
                int n16 = n13 + n3;
                int n17 = n16 + n4;
                int n18 = n17 + n4;
                double d = dArray[n10];
                double d2 = dArray[n10 += n6];
                double d3 = dArray[n11];
                double d4 = dArray[n11 += n6];
                double d5 = dArray[n12];
                double d6 = dArray[n12 += n6];
                double d7 = dArray[n13];
                double d8 = dArray[n13 += n6];
                double d9 = dArray[n14];
                double d10 = dArray[n14 += n6];
                double d11 = dArray[n15];
                double d12 = dArray[n15 += n6];
                double d13 = dArray[n16];
                double d14 = dArray[n16 += n6];
                double d15 = dArray[n17];
                double d16 = dArray[n17 += n6];
                double d17 = dArray[n18];
                double d18 = dArray[n18 += n6];
                int n19 = n9;
                for (int k = 1; k < n2; ++k) {
                    double d19 = dArray[n10 += n6];
                    double d20 = dArray[n11 += n6];
                    double d21 = dArray[n12 += n6];
                    double d22 = dArray[n13 += n6];
                    double d23 = dArray[n14 += n6];
                    double d24 = dArray[n15 += n6];
                    double d25 = dArray[n16 += n6];
                    double d26 = dArray[n17 += n6];
                    double d27 = dArray[n18 += n6];
                    dArray2[n19] = double27Function.apply(d, d2, d19, d3, d4, d20, d5, d6, d21, d7, d8, d22, d9, d10, d23, d11, d12, d24, d13, d14, d25, d15, d16, d26, d17, d18, d27);
                    n19 += n7;
                    d = d2;
                    d2 = d19;
                    d3 = d4;
                    d4 = d20;
                    d5 = d6;
                    d6 = d21;
                    d7 = d8;
                    d8 = d22;
                    d9 = d10;
                    d10 = d23;
                    d11 = d12;
                    d12 = d24;
                    d13 = d14;
                    d14 = d25;
                    d15 = d16;
                    d16 = d26;
                    d17 = d18;
                    d18 = d27;
                }
                n8 += n4;
                n9 += n5;
            }
        }
    }

    public double zSum() {
        double d = 0.0;
        final int n = (int)this.index(0, 0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            int n4 = this.slices / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.slices : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = 0.0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DenseDoubleMatrix3D.this.rows; ++j) {
                                int n2 = n + i * DenseDoubleMatrix3D.this.sliceStride + j * DenseDoubleMatrix3D.this.rowStride;
                                for (int k = 0; k < DenseDoubleMatrix3D.this.columns; ++k) {
                                    d += DenseDoubleMatrix3D.this.elements[n2];
                                    n2 += DenseDoubleMatrix3D.this.columnStride;
                                }
                            }
                        }
                        return d;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    d += ((Double)futureArray[n3].get()).doubleValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n7 = n + i * this.sliceStride + j * this.rowStride;
                    for (int k = 0; k < this.columns; ++k) {
                        d += this.elements[n7];
                        n7 += this.columnStride;
                    }
                }
            }
        }
        return d;
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D instanceof SelectedDenseDoubleMatrix3D) {
            SelectedDenseDoubleMatrix3D selectedDenseDoubleMatrix3D = (SelectedDenseDoubleMatrix3D)doubleMatrix3D;
            return this.elements == selectedDenseDoubleMatrix3D.elements;
        }
        if (doubleMatrix3D instanceof DenseDoubleMatrix3D) {
            DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)doubleMatrix3D;
            return this.elements == denseDoubleMatrix3D.elements;
        }
        return false;
    }

    protected DoubleMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseDoubleMatrix2D(n, n2, this.elements, n3, n4, n5, n6, true);
    }

    protected DoubleMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseDoubleMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

