/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1DProcedure;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2DTest;
import cern.colt.matrix.tdouble.impl.DiagonalDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;

public class DiagonalDoubleMatrix2DTest
extends DoubleMatrix2DTest {
    protected int DLENGTH;
    protected int DINDEX;

    public DiagonalDoubleMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.DINDEX = 3;
        this.A = new DiagonalDoubleMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.B = new DiagonalDoubleMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.Bt = new DiagonalDoubleMatrix2D(this.NCOLUMNS, this.NROWS, -this.DINDEX);
        this.DLENGTH = ((DiagonalDoubleMatrix2D)this.A).dlength();
    }

    protected void populateMatrices() {
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        if (this.DINDEX >= 0) {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n, n + this.DINDEX, Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n, n + this.DINDEX, Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n - this.DINDEX, n, Math.random());
            }
        } else {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n - this.DINDEX, n, Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n - this.DINDEX, n, Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n, n + this.DINDEX, Math.random());
            }
        }
    }

    public void testAssignDouble() {
        double d = Math.random();
        this.A.assign(d);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)d, (double)this.A.getQuick(i, i + this.DINDEX), (double)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)d, (double)this.A.getQuick(i - this.DINDEX, i), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleArrayArray() {
        int n;
        double[][] dArray = new double[this.NROWS][this.NCOLUMNS];
        for (n = 0; n < this.NROWS; ++n) {
            for (int i = 0; i < this.NCOLUMNS; ++i) {
                dArray[n][i] = Math.random();
            }
        }
        this.A.assign(dArray);
        if (this.DINDEX >= 0) {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[n][n + this.DINDEX], (double)this.A.getQuick(n, n + this.DINDEX), (double)this.TOL);
            }
        } else {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[n - this.DINDEX][n], (double)this.A.getQuick(n - this.DINDEX, n), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleFunction() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        this.A.assign(DoubleFunctions.acos);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                double d = Math.acos(doubleMatrix2D.getQuick(i, i + this.DINDEX));
                DiagonalDoubleMatrix2DTest.assertEquals((double)d, (double)this.A.getQuick(i, i + this.DINDEX), (double)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                double d = Math.acos(doubleMatrix2D.getQuick(i - this.DINDEX, i));
                DiagonalDoubleMatrix2DTest.assertEquals((double)d, (double)this.A.getQuick(i - this.DINDEX, i), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleMatrix2DDoubleDoubleFunction() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        this.A.assign(this.B, DoubleFunctions.div);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)(doubleMatrix2D.getQuick(i, i + this.DINDEX) / this.B.getQuick(i, i + this.DINDEX)), (double)this.A.getQuick(i, i + this.DINDEX), (double)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)(doubleMatrix2D.getQuick(i - this.DINDEX, i) / this.B.getQuick(i - this.DINDEX, i)), (double)this.A.getQuick(i - this.DINDEX, i), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleMatrix2DDoubleDoubleFunctionIntArrayListIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i);
                intArrayList2.add(i + this.DINDEX);
            }
            DoubleMatrix2D doubleMatrix2D = this.A.copy();
            this.A.assign(this.B, DoubleFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)(doubleMatrix2D.getQuick(i, i + this.DINDEX) / this.B.getQuick(i, i + this.DINDEX)), (double)this.A.getQuick(i, i + this.DINDEX), (double)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i - this.DINDEX);
                intArrayList2.add(i);
            }
            DoubleMatrix2D doubleMatrix2D = this.A.copy();
            this.A.assign(this.B, DoubleFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)(doubleMatrix2D.getQuick(i - this.DINDEX, i) / this.B.getQuick(i - this.DINDEX, i)), (double)this.A.getQuick(i - this.DINDEX, i), (double)this.TOL);
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DiagonalDoubleMatrix2DTest.assertEquals((int)this.DLENGTH, (int)n);
    }

    public void testMaxLocation() {
        this.A.assign(0.0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 0.7);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 0.1);
            double[] dArray = this.A.getMaxLocation();
            DiagonalDoubleMatrix2DTest.assertEquals((double)0.7, (double)dArray[0], (double)this.TOL);
            DiagonalDoubleMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)dArray[1]));
            DiagonalDoubleMatrix2DTest.assertEquals((int)(this.NROWS / 3 + this.DINDEX), (int)((int)dArray[2]));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 0.7);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 0.1);
            double[] dArray = this.A.getMaxLocation();
            DiagonalDoubleMatrix2DTest.assertEquals((double)0.7, (double)dArray[0], (double)this.TOL);
            DiagonalDoubleMatrix2DTest.assertEquals((int)(this.NROWS / 3 - this.DINDEX), (int)((int)dArray[1]));
            DiagonalDoubleMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)dArray[2]));
        }
    }

    public void testMinLocation() {
        this.A.assign(0.0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, -0.7);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, -0.1);
            double[] dArray = this.A.getMinLocation();
            DiagonalDoubleMatrix2DTest.assertEquals((double)-0.7, (double)dArray[0], (double)this.TOL);
            DiagonalDoubleMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)dArray[1]));
            DiagonalDoubleMatrix2DTest.assertEquals((int)(this.NROWS / 3 + this.DINDEX), (int)((int)dArray[2]));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, -0.7);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, -0.1);
            double[] dArray = this.A.getMinLocation();
            DiagonalDoubleMatrix2DTest.assertEquals((double)-0.7, (double)dArray[0], (double)this.TOL);
            DiagonalDoubleMatrix2DTest.assertEquals((int)(this.NROWS / 3 - this.DINDEX), (int)((int)dArray[1]));
            DiagonalDoubleMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)dArray[2]));
        }
    }

    public void testGetNegativeValues() {
        this.A.assign(0.0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, -0.7);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, -0.1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            this.A.getNegativeValues(intArrayList, intArrayList2, doubleArrayList);
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)doubleArrayList.size());
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(-0.7));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(-0.1));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, -0.7);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, -0.1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            this.A.getNegativeValues(intArrayList, intArrayList3, doubleArrayList);
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)doubleArrayList.size());
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(-0.7));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(-0.1));
        }
    }

    public void testGetNonZeros() {
        this.A.assign(0.0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 0.7);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 0.1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            this.A.getNonZeros(intArrayList, intArrayList2, doubleArrayList);
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)doubleArrayList.size());
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.7));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.1));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 0.7);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 0.1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            this.A.getNonZeros(intArrayList, intArrayList3, doubleArrayList);
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)doubleArrayList.size());
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.7));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.1));
        }
    }

    public void testGetPositiveValues() {
        this.A.assign(0.0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 0.7);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 0.1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            this.A.getPositiveValues(intArrayList, intArrayList2, doubleArrayList);
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)doubleArrayList.size());
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.7));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.1));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 0.7);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 0.1);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            this.A.getPositiveValues(intArrayList, intArrayList3, doubleArrayList);
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalDoubleMatrix2DTest.assertEquals((int)2, (int)doubleArrayList.size());
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.7));
            DiagonalDoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.1));
        }
    }

    public void testToArray() {
        double[][] dArray = this.A.toArray();
        DiagonalDoubleMatrix2DTest.assertTrue((this.NROWS == dArray.length ? 1 : 0) != 0);
        for (int i = 0; i < this.NROWS; ++i) {
            DiagonalDoubleMatrix2DTest.assertTrue((this.NCOLUMNS == dArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[i][j], (double)this.A.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testVectorize() {
        DoubleMatrix1D doubleMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(j, i), (double)doubleMatrix1D.getQuick(n++), (double)this.TOL);
            }
        }
    }

    public void testViewColumn() {
        DoubleMatrix1D doubleMatrix1D = this.A.viewColumn(this.NCOLUMNS / 2);
        DiagonalDoubleMatrix2DTest.assertEquals((int)this.NROWS, (int)doubleMatrix1D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(i, this.NCOLUMNS / 2), (double)doubleMatrix1D.getQuick(i), (double)this.TOL);
        }
    }

    public void testViewColumnFlip() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewColumnFlip();
        DiagonalDoubleMatrix2DTest.assertEquals((int)this.A.size(), (int)doubleMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(i, this.NCOLUMNS - 1 - j), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewDice() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewDice();
        DiagonalDoubleMatrix2DTest.assertEquals((int)this.NROWS, (int)doubleMatrix2D.columns());
        DiagonalDoubleMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)doubleMatrix2D.rows());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(i, j), (double)doubleMatrix2D.getQuick(j, i), (double)this.TOL);
            }
        }
    }

    public void testViewPart() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewPart(this.NROWS / 2, this.NCOLUMNS / 2, this.NROWS / 3, this.NCOLUMNS / 3);
        DiagonalDoubleMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)doubleMatrix2D.rows());
        DiagonalDoubleMatrix2DTest.assertEquals((int)(this.NCOLUMNS / 3), (int)doubleMatrix2D.columns());
        for (int i = 0; i < this.NROWS / 3; ++i) {
            for (int j = 0; j < this.NCOLUMNS / 3; ++j) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(this.NROWS / 2 + i, this.NCOLUMNS / 2 + j), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewRow() {
        DoubleMatrix1D doubleMatrix1D = this.A.viewRow(this.NROWS / 2);
        DiagonalDoubleMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)doubleMatrix1D.size());
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(this.NROWS / 2, i), (double)doubleMatrix1D.getQuick(i), (double)this.TOL);
        }
    }

    public void testViewRowFlip() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewRowFlip();
        DiagonalDoubleMatrix2DTest.assertEquals((int)this.A.size(), (int)doubleMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(this.NROWS - 1 - i, j), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewSelectionDoubleMatrix1DProcedure() {
        this.A.assign(0.0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX, 2.0);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 2.0);
            DoubleMatrix2D doubleMatrix2D = this.A.viewSelection(new DoubleMatrix1DProcedure(){

                public boolean apply(DoubleMatrix1D doubleMatrix1D) {
                    return Math.abs(doubleMatrix1D.getQuick(DiagonalDoubleMatrix2DTest.this.NROWS / 4 + DiagonalDoubleMatrix2DTest.this.DINDEX) - 2.0) < DiagonalDoubleMatrix2DTest.this.TOL;
                }
            });
            DiagonalDoubleMatrix2DTest.assertEquals((int)1, (int)doubleMatrix2D.rows());
            DiagonalDoubleMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)doubleMatrix2D.columns());
            DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX), (double)doubleMatrix2D.getQuick(0, this.NROWS / 4 + this.DINDEX), (double)this.TOL);
        } else {
            this.A.setQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4, 2.0);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 2.0);
            DoubleMatrix2D doubleMatrix2D = this.A.viewSelection(new DoubleMatrix1DProcedure(){

                public boolean apply(DoubleMatrix1D doubleMatrix1D) {
                    return Math.abs(doubleMatrix1D.getQuick(DiagonalDoubleMatrix2DTest.this.NROWS / 4) - 2.0) < DiagonalDoubleMatrix2DTest.this.TOL;
                }
            });
            DiagonalDoubleMatrix2DTest.assertEquals((int)1, (int)doubleMatrix2D.rows());
            DiagonalDoubleMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)doubleMatrix2D.columns());
            DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4), (double)doubleMatrix2D.getQuick(0, this.NROWS / 4), (double)this.TOL);
        }
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2};
        int[] nArray2 = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2, this.NROWS - 1};
        DoubleMatrix2D doubleMatrix2D = this.A.viewSelection(nArray, nArray2);
        DiagonalDoubleMatrix2DTest.assertEquals((int)nArray.length, (int)doubleMatrix2D.rows());
        DiagonalDoubleMatrix2DTest.assertEquals((int)nArray2.length, (int)doubleMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(nArray[i], nArray2[j]), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewSorted() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewSorted(1);
        for (int i = 0; i < this.NROWS - 1; ++i) {
            DiagonalDoubleMatrix2DTest.assertTrue((doubleMatrix2D.getQuick(i + 1, 1) >= doubleMatrix2D.getQuick(i, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        DoubleMatrix2D doubleMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < doubleMatrix2D.rows(); ++i) {
            for (int j = 0; j < doubleMatrix2D.columns(); ++j) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)this.A.getQuick(i * n, j * n2), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testZMultDoubleMatrix2DDoubleMatrix2DDoubleDoubleBooleanBoolean() {
        int n;
        double d;
        int n2;
        int n3;
        double d2 = 3.0;
        double d3 = 5.0;
        DoubleMatrix2D doubleMatrix2D = new DiagonalDoubleMatrix2D(this.NROWS, this.NROWS, 0);
        for (int i = 0; i < this.DLENGTH; ++i) {
            doubleMatrix2D.setQuick(i, i, Math.random());
        }
        double[][] dArray = doubleMatrix2D.toArray();
        doubleMatrix2D = this.A.zMult(this.Bt, doubleMatrix2D, d2, d3, false, false);
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                d = 0.0;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    d += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                dArray[n2][n3] = d * d2 + dArray[n2][n3] * d3;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = null;
        doubleMatrix2D = this.A.zMult(this.Bt, doubleMatrix2D, d2, d3, false, false);
        dArray = new double[this.NROWS][this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                d = 0.0;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    d += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                dArray[n2][n3] = d * d2;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = new DiagonalDoubleMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            doubleMatrix2D.setQuick(n3, n3, Math.random());
        }
        dArray = doubleMatrix2D.toArray();
        doubleMatrix2D = this.A.zMult(this.B, doubleMatrix2D, d2, d3, true, false);
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                d = 0.0;
                for (n = 0; n < this.NROWS; ++n) {
                    d += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                dArray[n2][n3] = d * d2 + dArray[n2][n3] * d3;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = null;
        doubleMatrix2D = this.A.zMult(this.B, doubleMatrix2D, d2, d3, true, false);
        dArray = new double[this.NCOLUMNS][this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                d = 0.0;
                for (n = 0; n < this.NROWS; ++n) {
                    d += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                dArray[n2][n3] = d * d2;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = new DiagonalDoubleMatrix2D(this.NROWS, this.NROWS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            doubleMatrix2D.setQuick(n3, n3, Math.random());
        }
        dArray = doubleMatrix2D.toArray();
        doubleMatrix2D = this.A.zMult(this.B, doubleMatrix2D, d2, d3, false, true);
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                d = 0.0;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    d += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                dArray[n2][n3] = d * d2 + dArray[n2][n3] * d3;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = null;
        doubleMatrix2D = this.A.zMult(this.B, doubleMatrix2D, d2, d3, false, true);
        dArray = new double[this.NROWS][this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                d = 0.0;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    d += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                dArray[n2][n3] = d * d2;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = new DiagonalDoubleMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            doubleMatrix2D.setQuick(n3, n3, Math.random());
        }
        dArray = doubleMatrix2D.toArray();
        doubleMatrix2D = this.A.zMult(this.Bt, doubleMatrix2D, d2, d3, true, true);
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                d = 0.0;
                for (n = 0; n < this.NROWS; ++n) {
                    d += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                dArray[n2][n3] = d * d2 + dArray[n2][n3] * d3;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = null;
        doubleMatrix2D = this.A.zMult(this.Bt, doubleMatrix2D, d2, d3, true, true);
        dArray = new double[this.NCOLUMNS][this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                d = 0.0;
                for (n = 0; n < this.NROWS; ++n) {
                    d += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                dArray[n2][n3] = d * d2;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalDoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
    }
}

