/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.map.tdouble.AbstractLongDoubleMap;
import cern.colt.map.tdouble.OpenLongDoubleHashMap;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SelectedSparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix3D;

public class SparseDoubleMatrix1D
extends DoubleMatrix1D {
    protected AbstractLongDoubleMap elements;

    public SparseDoubleMatrix1D(double[] dArray) {
        this(dArray.length);
        this.assign(dArray);
    }

    public SparseDoubleMatrix1D(int n) {
        this(n, n / 1000, 0.2, 0.5);
    }

    public SparseDoubleMatrix1D(int n, int n2, double d, double d2) {
        this.setUp(n);
        this.elements = new OpenLongDoubleHashMap(n2, d, d2);
    }

    protected SparseDoubleMatrix1D(int n, AbstractLongDoubleMap abstractLongDoubleMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = abstractLongDoubleMap;
        this.isNoView = false;
    }

    public DoubleMatrix1D assign(double d) {
        if (this.isNoView && d == 0.0) {
            this.elements.clear();
        } else {
            super.assign(d);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongDoubleMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public double getQuick(int n) {
        return this.elements.get(this.zero + n * this.stride);
    }

    public long index(int n) {
        return this.zero + n * this.stride;
    }

    public DoubleMatrix1D like(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        return new SparseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*cols != size");
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d;
                if ((d = this.getQuick(n3++)) == 0.0) continue;
                ((DoubleMatrix2D)sparseDoubleMatrix2D).setQuick(j, i, d);
            }
        }
        return sparseDoubleMatrix2D;
    }

    public DoubleMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*cols != size");
        }
        SparseDoubleMatrix3D sparseDoubleMatrix3D = new SparseDoubleMatrix3D(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    double d;
                    if ((d = this.getQuick(n4++)) == 0.0) continue;
                    ((DoubleMatrix3D)sparseDoubleMatrix3D).setQuick(i, k, j, d);
                }
            }
        }
        return sparseDoubleMatrix3D;
    }

    public synchronized void setQuick(int n, double d) {
        int n2 = this.zero + n * this.stride;
        if (d == 0.0) {
            this.elements.removeKey(n2);
        } else {
            this.elements.put(n2, d);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D instanceof SelectedSparseDoubleMatrix1D) {
            SelectedSparseDoubleMatrix1D selectedSparseDoubleMatrix1D = (SelectedSparseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == selectedSparseDoubleMatrix1D.elements;
        }
        if (doubleMatrix1D instanceof SparseDoubleMatrix1D) {
            SparseDoubleMatrix1D sparseDoubleMatrix1D = (SparseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == sparseDoubleMatrix1D.elements;
        }
        return false;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseDoubleMatrix1D(this.elements, nArray);
    }
}

