/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2DTest;
import cern.colt.matrix.tdouble.impl.CCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.CCMDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.RCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.RCMDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;

public class SparseDoubleMatrix2DTest
extends DoubleMatrix2DTest {
    public SparseDoubleMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new SparseDoubleMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new SparseDoubleMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new SparseDoubleMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testConvertToRCDoubleMatrix2D() {
        int n = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(Math.random() * (double)this.NROWS);
            nArray2[i] = (int)(Math.random() * (double)this.NCOLUMNS);
            dArray[i] = Math.random();
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, dArray);
        RCDoubleMatrix2D rCDoubleMatrix2D = sparseDoubleMatrix2D.convertToRCDoubleMatrix2D();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                SparseDoubleMatrix2DTest.assertEquals((Object)sparseDoubleMatrix2D.getQuick(i, j), (Object)rCDoubleMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testConvertToRCMDoubleMatrix2D() {
        int n = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(Math.random() * (double)this.NROWS);
            nArray2[i] = (int)(Math.random() * (double)this.NCOLUMNS);
            dArray[i] = Math.random();
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, dArray);
        RCMDoubleMatrix2D rCMDoubleMatrix2D = sparseDoubleMatrix2D.convertToRCMDoubleMatrix2D();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                SparseDoubleMatrix2DTest.assertEquals((Object)sparseDoubleMatrix2D.getQuick(i, j), (Object)rCMDoubleMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testConvertToCCDoubleMatrix2D() {
        int n = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(Math.random() * (double)this.NROWS);
            nArray2[i] = (int)(Math.random() * (double)this.NCOLUMNS);
            dArray[i] = Math.random();
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, dArray);
        CCDoubleMatrix2D cCDoubleMatrix2D = sparseDoubleMatrix2D.convertToCCDoubleMatrix2D();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                SparseDoubleMatrix2DTest.assertEquals((Object)sparseDoubleMatrix2D.getQuick(i, j), (Object)cCDoubleMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testConvertToCCMDoubleMatrix2D() {
        int n = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(Math.random() * (double)this.NROWS);
            nArray2[i] = (int)(Math.random() * (double)this.NCOLUMNS);
            dArray[i] = Math.random();
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, dArray);
        CCMDoubleMatrix2D cCMDoubleMatrix2D = sparseDoubleMatrix2D.convertToCCMDoubleMatrix2D();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                SparseDoubleMatrix2DTest.assertEquals((Object)sparseDoubleMatrix2D.getQuick(i, j), (Object)cCMDoubleMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testAssignIntArrayIntArrayDoubleArrayDoubleDoubleFunction() {
        int n = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.NROWS, this.NCOLUMNS);
        for (int i = 0; i < n; ++i) {
            nArray[i] = i % this.NROWS;
            nArray2[i] = i % this.NCOLUMNS;
            dArray[i] = Math.random();
            ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(nArray[i], nArray2[i], dArray[i]);
        }
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, dArray);
        sparseDoubleMatrix2D.assign(nArray, nArray2, dArray, DoubleFunctions.plus);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                SparseDoubleMatrix2DTest.assertEquals((Object)(2.0 * ((DoubleMatrix2D)denseDoubleMatrix2D).getQuick(i, j)), (Object)sparseDoubleMatrix2D.getQuick(i, j));
            }
        }
    }
}

