/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.RCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultSecond;

public class TridiagonalDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    protected double[] values;
    protected int[] dims;
    protected static final int NONZERO = 4;

    public TridiagonalDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public TridiagonalDoubleMatrix2D(int n, int n2) {
        super(null);
        this.setUp(n, n2);
        int n3 = Math.min(n, n2);
        int n4 = n3 - 1;
        int n5 = n3 - 1;
        if (n > n2) {
            ++n5;
        }
        if (n < n2) {
            ++n4;
        }
        this.values = new double[n5 + n3 + n4];
        int[] nArray = new int[]{0, n5, n5 + n3, n5 + n3 + n4, 0, 0, 0};
        this.dims = nArray;
    }

    public DoubleMatrix2D assign(double d) {
        if (d == 0.0) {
            int n = this.values.length;
            while (--n >= 0) {
                this.values[n] = 0.0;
            }
            n = this.dims.length;
            while (--n >= 4) {
                this.dims[n] = 0;
            }
        } else {
            super.assign(d);
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleFunction doubleFunction) {
        if (doubleFunction instanceof DoubleMult) {
            double d = ((DoubleMult)doubleFunction).multiplicator;
            if (d == 1.0) {
                return this;
            }
            if (d == 0.0) {
                return this.assign(0.0);
            }
            if (d != d) {
                return this.assign(d);
            }
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    return doubleFunction.apply(d);
                }
            });
        } else {
            super.assign(doubleFunction);
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == this) {
            return this;
        }
        this.checkShape(doubleMatrix2D);
        if (doubleMatrix2D instanceof TridiagonalDoubleMatrix2D) {
            TridiagonalDoubleMatrix2D tridiagonalDoubleMatrix2D = (TridiagonalDoubleMatrix2D)doubleMatrix2D;
            System.arraycopy(tridiagonalDoubleMatrix2D.values, 0, this.values, 0, this.values.length);
            System.arraycopy(tridiagonalDoubleMatrix2D.dims, 0, this.dims, 0, this.dims.length);
            return this;
        }
        if (doubleMatrix2D instanceof RCDoubleMatrix2D || doubleMatrix2D instanceof SparseDoubleMatrix2D) {
            this.assign(0.0);
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    TridiagonalDoubleMatrix2D.this.setQuick(n, n2, d);
                    return d;
                }
            });
            return this;
        }
        return super.assign(doubleMatrix2D);
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix2D);
        if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
            final double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    TridiagonalDoubleMatrix2D.this.setQuick(n, n2, TridiagonalDoubleMatrix2D.this.getQuick(n, n2) + d * d2);
                    return d2;
                }
            });
            return this;
        }
        if (doubleDoubleFunction == DoubleFunctions.mult) {
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    TridiagonalDoubleMatrix2D.this.setQuick(n, n2, TridiagonalDoubleMatrix2D.this.getQuick(n, n2) * doubleMatrix2D.getQuick(n, n2));
                    return d;
                }
            });
            return this;
        }
        if (doubleDoubleFunction == DoubleFunctions.div) {
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    TridiagonalDoubleMatrix2D.this.setQuick(n, n2, TridiagonalDoubleMatrix2D.this.getQuick(n, n2) / doubleMatrix2D.getQuick(n, n2));
                    return d;
                }
            });
            return this;
        }
        return super.assign(doubleMatrix2D, doubleDoubleFunction);
    }

    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction intIntDoubleFunction) {
        for (int i = 0; i <= 2; ++i) {
            int n = 0;
            int n2 = 0;
            switch (i) {
                case 0: {
                    n = 1;
                }
                case 2: {
                    n2 = 1;
                }
            }
            int n3 = this.dims[i];
            int n4 = this.dims[i + 1];
            int n5 = n3;
            while (n5 < n4) {
                double d;
                double d2 = this.values[n5];
                if (d2 != 0.0 && (d = intIntDoubleFunction.apply(n, n2, d2)) != d2) {
                    if (d == 0.0) {
                        int n6 = i + 4;
                        this.dims[n6] = this.dims[n6] + 1;
                    }
                    this.values[n5] = d;
                }
                ++n5;
                ++n;
                ++n2;
            }
        }
        return this;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public double getQuick(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = n4 - n3 + 1;
        int n6 = n3;
        if (n5 == 0) {
            n6 = n4;
        }
        if (n5 >= 0 && n5 <= 2) {
            return this.values[this.dims[n5] + n6];
        }
        return 0.0;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new TridiagonalDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    public void setQuick(int n, int n2, double d) {
        int n3 = n;
        int n4 = n2;
        boolean bl = d == 0.0;
        int n5 = n4 - n3 + 1;
        int n6 = n3;
        if (n5 == 0) {
            n6 = n4;
        }
        if (n5 >= 0 && n5 <= 2) {
            int n7 = this.dims[n5] + n6;
            if (this.values[n7] != 0.0) {
                if (bl) {
                    int n8 = n5 + 4;
                    this.dims[n8] = this.dims[n8] - 1;
                }
            } else if (!bl) {
                int n9 = n5 + 4;
                this.dims[n9] = this.dims[n9] + 1;
            }
            this.values[n7] = d;
            return;
        }
        if (!bl) {
            throw new IllegalArgumentException("Can't store non-zero value to non-tridiagonal coordinate: row=" + n + ", column=" + n2 + ", value=" + d);
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d, double d2, final boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = doubleMatrix1D2 == null;
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(n);
        }
        if (!(this.isNoView && doubleMatrix1D instanceof DenseDoubleMatrix1D && doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
        }
        if (n2 != doubleMatrix1D.size() || n > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        if (!bl2) {
            doubleMatrix1D2.assign(DoubleFunctions.mult(d2 / d));
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D2;
        final double[] dArray = denseDoubleMatrix1D.elements;
        final int n3 = denseDoubleMatrix1D.stride();
        final int n4 = (int)doubleMatrix1D2.index(0);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = (DenseDoubleMatrix1D)doubleMatrix1D;
        final double[] dArray2 = denseDoubleMatrix1D2.elements;
        final int n5 = denseDoubleMatrix1D2.stride();
        final int n6 = (int)doubleMatrix1D.index(0);
        if (dArray2 == null || dArray == null) {
            throw new InternalError();
        }
        this.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int n, int n2, double d) {
                if (bl) {
                    int n32 = n;
                    n = n2;
                    n2 = n32;
                }
                int n42 = n4 + n3 * n;
                dArray[n42] = dArray[n42] + d * dArray2[n6 + n5 * n2];
                return d;
            }
        });
        if (d != 1.0) {
            doubleMatrix1D2.assign(DoubleFunctions.mult(d));
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, final double d, double d2, final boolean bl, boolean bl2) {
        boolean bl3;
        if (bl2) {
            doubleMatrix2D = doubleMatrix2D.viewDice();
        }
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = doubleMatrix2D.columns();
        boolean bl4 = bl3 = doubleMatrix2D2 == null;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n, n3);
        }
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort());
        }
        if (doubleMatrix2D2.rows() != n || doubleMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            doubleMatrix2D2.assign(DoubleFunctions.mult(d2));
        }
        final DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            doubleMatrix1DArray[n4] = doubleMatrix2D.viewRow(n4);
        }
        final DoubleMatrix1D[] doubleMatrix1DArray2 = new DoubleMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            doubleMatrix1DArray2[n5] = doubleMatrix2D2.viewRow(n5);
        }
        final DoublePlusMultSecond doublePlusMultSecond = DoublePlusMultSecond.plusMult(0.0);
        this.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int n, int n2, double d2) {
                doublePlusMultSecond.multiplicator = d2 * d;
                if (!bl) {
                    doubleMatrix1DArray2[n].assign(doubleMatrix1DArray[n2], doublePlusMultSecond);
                } else {
                    doubleMatrix1DArray2[n2].assign(doubleMatrix1DArray[n], doublePlusMultSecond);
                }
                return d2;
            }
        });
        return doubleMatrix2D2;
    }
}

