/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DelegateDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DiagonalDoubleMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperDoubleMatrix2D
extends DoubleMatrix2D {
    protected DoubleMatrix2D content;

    public WrapperDoubleMatrix2D(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D != null) {
            this.setUp(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        }
        this.content = doubleMatrix2D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public double getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    public boolean equals(double d) {
        if (this.content instanceof DiagonalDoubleMatrix2D) {
            double d2 = DoubleProperty.DEFAULT.tolerance();
            double[] dArray = (double[])this.content.elements();
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = dArray[i];
                double d4 = Math.abs(d - d3);
                if (d4 != d4 && (d != d && d3 != d3 || d == d3)) {
                    d4 = 0.0;
                }
                if (d4 <= d2) continue;
                return false;
            }
            return true;
        }
        return super.equals(d);
    }

    public boolean equals(Object object) {
        if (this.content instanceof DiagonalDoubleMatrix2D && object instanceof DiagonalDoubleMatrix2D) {
            double d = DoubleProperty.DEFAULT.tolerance();
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            DiagonalDoubleMatrix2D diagonalDoubleMatrix2D = (DiagonalDoubleMatrix2D)this.content;
            DiagonalDoubleMatrix2D diagonalDoubleMatrix2D2 = (DiagonalDoubleMatrix2D)object;
            if (diagonalDoubleMatrix2D.columns() != diagonalDoubleMatrix2D2.columns() || diagonalDoubleMatrix2D.rows() != diagonalDoubleMatrix2D2.rows() || diagonalDoubleMatrix2D.dindex() != diagonalDoubleMatrix2D2.dindex() || diagonalDoubleMatrix2D.dlength() != diagonalDoubleMatrix2D2.dlength()) {
                return false;
            }
            double[] dArray = diagonalDoubleMatrix2D.elements();
            double[] dArray2 = diagonalDoubleMatrix2D2.elements();
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = dArray2[i];
                double d3 = dArray[i];
                double d4 = Math.abs(d2 - d3);
                if (d4 != d4 && (d2 != d2 && d3 != d3 || d2 == d3)) {
                    d4 = 0.0;
                }
                if (d4 <= d) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public DoubleMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    public void setQuick(int n, int n2, double d) {
        this.content.setQuick(n, n2, d);
    }

    public DoubleMatrix1D vectorize() {
        final DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i * n2 * this.rows;
                final int n5 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        for (int i = n3; i < n5; ++i) {
                            for (int j = 0; j < WrapperDoubleMatrix2D.this.rows; ++j) {
                                denseDoubleMatrix1D.setQuick(n++, WrapperDoubleMatrix2D.this.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    denseDoubleMatrix1D.setQuick(n6++, this.getQuick(j, i));
                }
            }
        }
        return denseDoubleMatrix1D;
    }

    public DoubleMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    public DoubleMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            public double getQuick(int n, int n2) {
                return this.content.getQuick(n, this.columns - 1 - n2);
            }

            public void setQuick(int n, int n2, double d) {
                this.content.setQuick(n, this.columns - 1 - n2, d);
            }

            public double get(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            public void set(int n, int n2, double d) {
                this.content.set(n, this.columns - 1 - n2, d);
            }
        };
        return wrapperDoubleMatrix2D;
    }

    public DoubleMatrix2D viewDice() {
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            public double getQuick(int n, int n2) {
                return this.content.getQuick(n2, n);
            }

            public void setQuick(int n, int n2, double d) {
                this.content.setQuick(n2, n, d);
            }

            public double get(int n, int n2) {
                return this.content.get(n2, n);
            }

            public void set(int n, int n2, double d) {
                this.content.set(n2, n, d);
            }
        };
        wrapperDoubleMatrix2D.setNrows(this.columns);
        wrapperDoubleMatrix2D.setNcolumns(this.rows);
        return wrapperDoubleMatrix2D;
    }

    public void setNcolumns(int n) {
        this.columns = n;
    }

    public void setNrows(int n) {
        this.rows = n;
    }

    public DoubleMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            public double getQuick(int n3, int n22) {
                return this.content.getQuick(n + n3, n2 + n22);
            }

            public void setQuick(int n3, int n22, double d) {
                this.content.setQuick(n + n3, n2 + n22, d);
            }

            public double get(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            public void set(int n3, int n22, double d) {
                this.content.set(n + n3, n2 + n22, d);
            }
        };
        wrapperDoubleMatrix2D.setNrows(n3);
        wrapperDoubleMatrix2D.setNcolumns(n4);
        return wrapperDoubleMatrix2D;
    }

    public DoubleMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateDoubleMatrix1D(this, n);
    }

    public DoubleMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            public double getQuick(int n, int n2) {
                return this.content.getQuick(this.rows - 1 - n, n2);
            }

            public void setQuick(int n, int n2, double d) {
                this.content.setQuick(this.rows - 1 - n, n2, d);
            }

            public double get(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            public void set(int n, int n2, double d) {
                this.content.set(this.rows - 1 - n, n2, d);
            }
        };
        return wrapperDoubleMatrix2D;
    }

    public DoubleMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            public double getQuick(int n, int n2) {
                return this.content.getQuick(nArray3[n], nArray4[n2]);
            }

            public void setQuick(int n, int n2, double d) {
                this.content.setQuick(nArray3[n], nArray4[n2], d);
            }

            public double get(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            public void set(int n, int n2, double d) {
                this.content.set(nArray3[n], nArray4[n2], d);
            }
        };
        wrapperDoubleMatrix2D.setNrows(nArray.length);
        wrapperDoubleMatrix2D.setNcolumns(nArray2.length);
        return wrapperDoubleMatrix2D;
    }

    public DoubleMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            public double getQuick(int n3, int n22) {
                return this.content.getQuick(n * n3, n2 * n22);
            }

            public void setQuick(int n3, int n22, double d) {
                this.content.setQuick(n * n3, n2 * n22, d);
            }

            public double get(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            public void set(int n3, int n22, double d) {
                this.content.set(n * n3, n2 * n22, d);
            }
        };
        wrapperDoubleMatrix2D.setNrows(this.rows);
        wrapperDoubleMatrix2D.setNcolumns(this.columns);
        if (this.rows != 0) {
            wrapperDoubleMatrix2D.setNrows((this.rows - 1) / n + 1);
        }
        if (this.columns != 0) {
            wrapperDoubleMatrix2D.setNcolumns((this.columns - 1) / n2 + 1);
        }
        return wrapperDoubleMatrix2D;
    }

    protected DoubleMatrix2D getContent() {
        return this.content;
    }

    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }
}

