/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1DProcedure;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FComplexMatrix2D
extends AbstractMatrix2D {
    protected FComplexMatrix2D() {
    }

    public float[] aggregate(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFunction fComplexFComplexFunction) {
        float[] fArray = new float[2];
        if (this.size() == 0) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        float[] fArray2 = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            float[][] fArray3 = new float[n][2];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = fComplexFComplexFunction.apply(FComplexMatrix2D.this.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < FComplexMatrix2D.this.columns; ++j) {
                                fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFunction.apply(FComplexMatrix2D.this.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return fArray;
                    }
                });
            }
            fArray2 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray2 = fComplexFComplexFunction.apply(this.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFunction.apply(this.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return fArray2;
    }

    public float[] aggregate(final FComplexMatrix2D fComplexMatrix2D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction2) {
        this.checkShape(fComplexMatrix2D);
        float[] fArray = new float[2];
        if (this.size() == 0) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        float[] fArray2 = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            float[][] fArray3 = new float[n][2];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = fComplexFComplexFComplexFunction2.apply(FComplexMatrix2D.this.getQuick(n3, 0), fComplexMatrix2D.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < FComplexMatrix2D.this.columns; ++j) {
                                fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFComplexFunction2.apply(FComplexMatrix2D.this.getQuick(i, j), fComplexMatrix2D.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return fArray;
                    }
                });
            }
            fArray2 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray2 = fComplexFComplexFComplexFunction2.apply(this.getQuick(0, 0), fComplexMatrix2D.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFComplexFunction2.apply(this.getQuick(i, j), fComplexMatrix2D.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return fArray2;
    }

    public FComplexMatrix2D assign(final FComplexFComplexFunction fComplexFComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                FComplexMatrix2D.this.setQuick(i, j, fComplexFComplexFunction.apply(FComplexMatrix2D.this.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, fComplexFComplexFunction.apply(this.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final FComplexProcedure fComplexProcedure, final FComplexFComplexFunction fComplexFComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                float[] fArray = FComplexMatrix2D.this.getQuick(i, j);
                                if (!fComplexProcedure.apply(fArray)) continue;
                                FComplexMatrix2D.this.setQuick(i, j, fComplexFComplexFunction.apply(fArray));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float[] fArray = this.getQuick(i, j);
                    if (!fComplexProcedure.apply(fArray)) continue;
                    this.setQuick(i, j, fComplexFComplexFunction.apply(fArray));
                }
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final FComplexProcedure fComplexProcedure, final float[] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                float[] fArray2 = FComplexMatrix2D.this.getQuick(i, j);
                                if (!fComplexProcedure.apply(fArray2)) continue;
                                FComplexMatrix2D.this.setQuick(i, j, fArray);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float[] fArray2 = this.getQuick(i, j);
                    if (!fComplexProcedure.apply(fArray2)) continue;
                    this.setQuick(i, j, fArray);
                }
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final FComplexRealFunction fComplexRealFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                float f = fComplexRealFunction.apply(FComplexMatrix2D.this.getQuick(i, j));
                                FComplexMatrix2D.this.setQuick(i, j, f, 0.0f);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float f = fComplexRealFunction.apply(this.getQuick(i, j));
                    this.setQuick(i, j, f, 0.0f);
                }
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(fComplexMatrix2D);
        final FComplexMatrix2D fComplexMatrix2D2 = this.haveSharedCells(fComplexMatrix2D) ? fComplexMatrix2D.copy() : fComplexMatrix2D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                FComplexMatrix2D.this.setQuick(i, j, fComplexMatrix2D2.getQuick(i, j));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, fComplexMatrix2D2.getQuick(i, j));
                }
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final FComplexMatrix2D fComplexMatrix2D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        this.checkShape(fComplexMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                FComplexMatrix2D.this.setQuick(i, j, fComplexFComplexFComplexFunction.apply(FComplexMatrix2D.this.getQuick(i, j), fComplexMatrix2D.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, fComplexFComplexFComplexFunction.apply(this.getQuick(i, j), fComplexMatrix2D.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final float f, final float f2) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                FComplexMatrix2D.this.setQuick(i, j, f, f2);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, f, f2);
                }
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final float[] fArray) {
        if (fArray.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i * n2 * 2 * this.columns;
                final int n5 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        for (int i = n3; i < n5; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                FComplexMatrix2D.this.setQuick(i, j, fArray[n], fArray[n + 1]);
                                n += 2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, fArray[n6], fArray[n6 + 1]);
                    n6 += 2;
                }
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(final float[][] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (fArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + fArray.length + "rows()=" + this.rows());
        }
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            float[] fArray2 = fArray[i];
                            if (fArray2.length != 2 * FComplexMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "2*columns()=" + 2 * FComplexMatrix2D.this.columns());
                            }
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                FComplexMatrix2D.this.setQuick(i, j, fArray2[2 * j], fArray2[2 * j + 1]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                float[] fArray2 = fArray[i];
                if (fArray2.length != 2 * this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "2*columns()=" + 2 * this.columns());
                }
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, fArray2[2 * j], fArray2[2 * j + 1]);
                }
            }
        }
        return this;
    }

    public FComplexMatrix2D assignImaginary(final FloatMatrix2D floatMatrix2D) {
        this.checkShape(floatMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                float f = FComplexMatrix2D.this.getQuick(i, j)[0];
                                float f2 = floatMatrix2D.getQuick(i, j);
                                FComplexMatrix2D.this.setQuick(i, j, f, f2);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float f = this.getQuick(i, j)[0];
                    float f2 = floatMatrix2D.getQuick(i, j);
                    this.setQuick(i, j, f, f2);
                }
            }
        }
        return this;
    }

    public FComplexMatrix2D assignReal(final FloatMatrix2D floatMatrix2D) {
        this.checkShape(floatMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                float f = floatMatrix2D.getQuick(i, j);
                                float f2 = FComplexMatrix2D.this.getQuick(i, j)[1];
                                FComplexMatrix2D.this.setQuick(i, j, f, f2);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float f = floatMatrix2D.getQuick(i, j);
                    float f2 = this.getQuick(i, j)[1];
                    this.setQuick(i, j, f, f2);
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.rows / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.rows : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        float[] fArray = new float[2];
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                fArray = FComplexMatrix2D.this.getQuick(i, j);
                                if ((double)fArray[0] == 0.0 && (double)fArray[1] == 0.0) continue;
                                ++n;
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            float[] fArray = new float[2];
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    fArray = this.getQuick(i, j);
                    if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public FComplexMatrix2D copy() {
        return this.like().assign(this);
    }

    public boolean equals(float[] fArray) {
        return FloatProperty.DEFAULT.equals(this, fArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FComplexMatrix2D)) {
            return false;
        }
        return FloatProperty.DEFAULT.equals(this, (FComplexMatrix2D)object);
    }

    public FComplexMatrix2D forEachNonZero(final IntIntFComplexFunction intIntFComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                float[] fArray = FComplexMatrix2D.this.getQuick(i, j);
                                if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
                                float[] fArray2 = intIntFComplexFunction.apply(i, j, fArray);
                                FComplexMatrix2D.this.setQuick(i, j, fArray2);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float[] fArray = this.getQuick(i, j);
                    if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
                    float[] fArray2 = intIntFComplexFunction.apply(i, j, fArray);
                    this.setQuick(i, j, fArray2);
                }
            }
        }
        return this;
    }

    public float[] get(int n, int n2) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        return this.getQuick(n, n2);
    }

    public FComplexMatrix2D getConjugateTranspose() {
        final FComplexMatrix2D fComplexMatrix2D = this.viewDice().copy();
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray = new float[2];
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.rows; ++j) {
                                fArray = fComplexMatrix2D.getQuick(i, j);
                                fArray[1] = -fArray[1];
                                fComplexMatrix2D.setQuick(i, j, fArray);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray = new float[2];
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    fArray = fComplexMatrix2D.getQuick(i, j);
                    fArray[1] = -fArray[1];
                    fComplexMatrix2D.setQuick(i, j, fArray);
                }
            }
        }
        return fComplexMatrix2D;
    }

    public abstract Object elements();

    public abstract FloatMatrix2D getImaginaryPart();

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, ArrayList<float[]> arrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        arrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                float[] fArray = this.getQuick(i, j);
                if (fArray[0] == 0.0f && fArray[1] == 0.0f) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                arrayList.add(fArray);
            }
        }
    }

    public abstract float[] getQuick(int var1, int var2);

    public abstract FloatMatrix2D getRealPart();

    public FComplexMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract FComplexMatrix2D like(int var1, int var2);

    public abstract FComplexMatrix1D like1D(int var1);

    public void set(int n, int n2, float[] fArray) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        this.setQuick(n, n2, fArray);
    }

    public abstract void setQuick(int var1, int var2, float var3, float var4);

    public abstract void setQuick(int var1, int var2, float[] var3);

    public float[][] toArray() {
        final float[][] fArray = new float[this.rows][2 * this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2];
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                fArray2 = FComplexMatrix2D.this.getQuick(i, j);
                                fArray[i][2 * j] = fArray2[0];
                                fArray[i][2 * j + 1] = fArray2[1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray2 = new float[2];
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    fArray2 = this.getQuick(i, j);
                    fArray[i][2 * j] = fArray2[0];
                    fArray[i][2 * j + 1] = fArray2[1];
                }
            }
        }
        return fArray;
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(String.format("ComplexMatrix2D: %d rows, %d columns\n\n", this.rows, this.columns));
        float[] fArray = new float[2];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                fArray = this.getQuick(i, j);
                if (fArray[1] == 0.0f) {
                    stringBuffer.append(String.format(string + "\t", Float.valueOf(fArray[0])));
                    continue;
                }
                if (fArray[0] == 0.0f) {
                    stringBuffer.append(String.format(string + "i\t", Float.valueOf(fArray[1])));
                    continue;
                }
                if (fArray[1] < 0.0f) {
                    stringBuffer.append(String.format(string + " - " + string + "i\t", Float.valueOf(fArray[0]), Float.valueOf(-fArray[1])));
                    continue;
                }
                stringBuffer.append(String.format(string + " + " + string + "i\t", Float.valueOf(fArray[0]), Float.valueOf(fArray[1])));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public abstract FComplexMatrix1D vectorize();

    public FComplexMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = (int)this.index(0, n);
        int n4 = this.rowStride;
        return this.like1D(n2, n3, n4);
    }

    public FComplexMatrix2D viewColumnFlip() {
        return (FComplexMatrix2D)this.view().vColumnFlip();
    }

    public FComplexMatrix2D viewDice() {
        return (FComplexMatrix2D)this.view().vDice();
    }

    public FComplexMatrix2D viewPart(int n, int n2, int n3, int n4) {
        return (FComplexMatrix2D)this.view().vPart(n, n2, n3, n4);
    }

    public FComplexMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = (int)this.index(n, 0);
        int n4 = this.columnStride;
        return this.like1D(n2, n3, n4);
    }

    public FComplexMatrix2D viewRowFlip() {
        return (FComplexMatrix2D)this.view().vRowFlip();
    }

    public FComplexMatrix2D viewSelection(FComplexMatrix1DProcedure fComplexMatrix1DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!fComplexMatrix1DProcedure.apply(this.viewRow(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null);
    }

    public FComplexMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.rows];
            for (n2 = 0; n2 < this.rows; ++n2) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            for (n2 = 0; n2 < this.columns; ++n2) {
                nArray2[n2] = n2;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = this._rowOffset(this._rowRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray4[n] = this._columnOffset(this._columnRank(nArray2[n]));
        }
        return this.viewSelectionLike(nArray3, nArray4);
    }

    public FComplexMatrix2D viewStrides(int n, int n2) {
        return (FComplexMatrix2D)this.view().vStrides(n, n2);
    }

    public FComplexMatrix1D zMult(FComplexMatrix1D fComplexMatrix1D, FComplexMatrix1D fComplexMatrix1D2) {
        float[] fArray;
        float[] fArray2 = new float[]{1.0f, 0.0f};
        if (fComplexMatrix1D2 == null) {
            float[] fArray3 = new float[2];
            fArray3[0] = 1.0f;
            fArray = fArray3;
            fArray3[1] = 0.0f;
        } else {
            float[] fArray4 = new float[2];
            fArray4[0] = 0.0f;
            fArray = fArray4;
            fArray4[1] = 0.0f;
        }
        return this.zMult(fComplexMatrix1D, fComplexMatrix1D2, fArray2, fArray, false);
    }

    public FComplexMatrix1D zMult(final FComplexMatrix1D fComplexMatrix1D, FComplexMatrix1D fComplexMatrix1D2, final float[] fArray, final float[] fArray2, boolean bl) {
        if (bl) {
            return this.getConjugateTranspose().zMult(fComplexMatrix1D, fComplexMatrix1D2, fArray, fArray2, false);
        }
        final FComplexMatrix1D fComplexMatrix1D3 = fComplexMatrix1D2 == null ? new DenseFComplexMatrix1D(this.rows) : fComplexMatrix1D2;
        if (this.columns != fComplexMatrix1D.size() || this.rows > fComplexMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + fComplexMatrix1D.toStringShort() + ", " + fComplexMatrix1D3.toStringShort());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    float[] s = new float[2];

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            this.s[0] = 0.0f;
                            this.s[1] = 0.0f;
                            for (int j = 0; j < FComplexMatrix2D.this.columns; ++j) {
                                this.s = FComplex.plus(this.s, FComplex.mult(FComplexMatrix2D.this.getQuick(i, j), fComplexMatrix1D.getQuick(j)));
                            }
                            fComplexMatrix1D3.setQuick(i, FComplex.plus(FComplex.mult(this.s, fArray), FComplex.mult(fComplexMatrix1D3.getQuick(i), fArray2)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray3 = new float[2];
            for (int i = 0; i < this.rows; ++i) {
                fArray3[0] = 0.0f;
                fArray3[1] = 0.0f;
                for (int j = 0; j < this.columns; ++j) {
                    fArray3 = FComplex.plus(fArray3, FComplex.mult(this.getQuick(i, j), fComplexMatrix1D.getQuick(j)));
                }
                fComplexMatrix1D3.setQuick(i, FComplex.plus(FComplex.mult(fArray3, fArray), FComplex.mult(fComplexMatrix1D3.getQuick(i), fArray2)));
            }
        }
        fComplexMatrix1D2 = fComplexMatrix1D3;
        return fComplexMatrix1D2;
    }

    public FComplexMatrix2D zMult(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2) {
        float[] fArray;
        float[] fArray2 = new float[]{1.0f, 0.0f};
        if (fComplexMatrix2D2 == null) {
            float[] fArray3 = new float[2];
            fArray3[0] = 1.0f;
            fArray = fArray3;
            fArray3[1] = 0.0f;
        } else {
            float[] fArray4 = new float[2];
            fArray4[0] = 0.0f;
            fArray = fArray4;
            fArray4[1] = 0.0f;
        }
        return this.zMult(fComplexMatrix2D, fComplexMatrix2D2, fArray2, fArray, false, false);
    }

    public FComplexMatrix2D zMult(final FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2, final float[] fArray, final float[] fArray2, boolean bl, boolean bl2) {
        if (bl) {
            return this.getConjugateTranspose().zMult(fComplexMatrix2D, fComplexMatrix2D2, fArray, fArray2, false, bl2);
        }
        if (bl2) {
            return this.zMult(fComplexMatrix2D.getConjugateTranspose(), fComplexMatrix2D2, fArray, fArray2, bl, false);
        }
        final int n = this.rows;
        final int n2 = this.columns;
        int n3 = fComplexMatrix2D.columns;
        final FComplexMatrix2D fComplexMatrix2D3 = fComplexMatrix2D2 == null ? new DenseFComplexMatrix2D(n, n3) : fComplexMatrix2D2;
        if (fComplexMatrix2D.rows != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + fComplexMatrix2D.toStringShort());
        }
        if (fComplexMatrix2D3.rows != n || fComplexMatrix2D3.columns != n3) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + fComplexMatrix2D.toStringShort() + ", " + fComplexMatrix2D3.toStringShort());
        }
        if (this == fComplexMatrix2D3 || fComplexMatrix2D == fComplexMatrix2D3) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n4];
            int n5 = n3 / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? n3 : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    float[] s = new float[2];

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n; ++j) {
                                this.s[0] = 0.0f;
                                this.s[1] = 0.0f;
                                for (int k = 0; k < n2; ++k) {
                                    this.s = FComplex.plus(this.s, FComplex.mult(FComplexMatrix2D.this.getQuick(j, k), fComplexMatrix2D.getQuick(k, i)));
                                }
                                fComplexMatrix2D3.setQuick(j, i, FComplex.plus(FComplex.mult(this.s, fArray), FComplex.mult(fComplexMatrix2D3.getQuick(j, i), fArray2)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray3 = new float[2];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    fArray3[0] = 0.0f;
                    fArray3[1] = 0.0f;
                    for (int k = 0; k < n2; ++k) {
                        fArray3 = FComplex.plus(fArray3, FComplex.mult(this.getQuick(j, k), fComplexMatrix2D.getQuick(k, i)));
                    }
                    fComplexMatrix2D3.setQuick(j, i, FComplex.plus(FComplex.mult(fArray3, fArray), FComplex.mult(fComplexMatrix2D3.getQuick(j, i), fArray2)));
                }
            }
        }
        fComplexMatrix2D2 = fComplexMatrix2D3;
        return fComplexMatrix2D2;
    }

    public float[] zSum() {
        if (this.size() == 0) {
            return new float[]{0.0f, 0.0f};
        }
        return this.aggregate(FComplexFunctions.plus, FComplexFunctions.identity);
    }

    protected FComplexMatrix2D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D == null) {
            return false;
        }
        if (this == fComplexMatrix2D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(fComplexMatrix2D.getContent());
    }

    protected boolean haveSharedCellsRaw(FComplexMatrix2D fComplexMatrix2D) {
        return false;
    }

    protected abstract FComplexMatrix1D like1D(int var1, int var2, int var3);

    protected FComplexMatrix2D view() {
        return (FComplexMatrix2D)this.clone();
    }

    protected abstract FComplexMatrix2D viewSelectionLike(int[] var1, int[] var2);
}

