/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.Timer;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseFComplexMatrix1D {
    private static final Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseFComplexMatrix1D.txt";
    private static double[] noViewTimes;
    private static double[] viewTimes;
    private static float[] a;
    private static float[] b;

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tfcomplex.impl.BenchmarkDenseFComplexMatrix1D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int n;
        BenchmarkMatrixKernel.readSettings1D();
        Random random = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        a = new float[2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D];
        for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D; ++n) {
            BenchmarkDenseFComplexMatrix1D.a[n] = random.nextFloat();
        }
        b = new float[2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D];
        for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_1D; ++n) {
            BenchmarkDenseFComplexMatrix1D.b[n] = random.nextFloat();
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, new int[]{BenchmarkMatrixKernel.MATRIX_SIZE_1D});
        BenchmarkMatrixKernel.displayProperties(new int[]{BenchmarkMatrixKernel.MATRIX_SIZE_1D});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a = null;
        b = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateFComplexFComplexFComplexFunctionFComplexFComplexFunction() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = ((FComplexMatrix1D)denseFComplexMatrix1D).aggregate(FComplexFunctions.plus, FComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((FComplexMatrix1D)denseFComplexMatrix1D).aggregate(FComplexFunctions.plus, FComplexFunctions.square);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = fComplexMatrix1D.aggregate(FComplexFunctions.plus, FComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix1D.aggregate(FComplexFunctions.plus, FComplexFunctions.square);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FComplexFComplexFComplexFunction, FComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateFComplexMatrix1DFComplexFComplexFComplexFunctionFComplexFComplexFComplexFunction() {
        int n;
        Object object;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        DenseFComplexMatrix1D denseFComplexMatrix1D2 = new DenseFComplexMatrix1D(b);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            object = ((FComplexMatrix1D)denseFComplexMatrix1D).aggregate(denseFComplexMatrix1D2, FComplexFunctions.plus, FComplexFunctions.mult);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                object = ((FComplexMatrix1D)denseFComplexMatrix1D).aggregate(denseFComplexMatrix1D2, FComplexFunctions.plus, FComplexFunctions.mult);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        object = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(b);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = fComplexMatrix1D.aggregate((FComplexMatrix1D)object, FComplexFunctions.plus, FComplexFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix1D.aggregate((FComplexMatrix1D)object, FComplexFunctions.plus, FComplexFunctions.mult);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FComplexMatrix1D, FComplexFComplexFComplexFunction, FComplexFComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatFloat() {
        int n;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        float f = (float)Math.random();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix1D)denseFComplexMatrix1D).assign(f, f);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(f, f);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix1D.assign(f, f);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix1D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix1D.assign(f, f);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float, float)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArray() {
        int n;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix1D)denseFComplexMatrix1D).assign(a);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(a);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix1D.assign(a);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix1D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix1D.assign(a);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexFComplexFunction() {
        int n;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix1D)denseFComplexMatrix1D).assign(FComplexFunctions.acos);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(a);
                t.reset().start();
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(FComplexFunctions.acos);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix1D.assign(FComplexFunctions.acos);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix1D.assign(a);
                t.reset().start();
                fComplexMatrix1D.assign(FComplexFunctions.acos);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexMatrix1D() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        DenseFComplexMatrix1D denseFComplexMatrix1D2 = new DenseFComplexMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FComplexMatrix1D)denseFComplexMatrix1D).assign(denseFComplexMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(denseFComplexMatrix1D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D);
        FComplexMatrix1D fComplexMatrix1D = denseFComplexMatrix1D.viewFlip();
        denseFComplexMatrix1D2 = new DenseFComplexMatrix1D(a);
        FComplexMatrix1D fComplexMatrix1D2 = denseFComplexMatrix1D2.viewFlip();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            fComplexMatrix1D.assign(fComplexMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix1D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix1D.assign(fComplexMatrix1D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexMatrix1D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexMatrix1DFComplexFComplexFComplexFunction() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        DenseFComplexMatrix1D denseFComplexMatrix1D2 = new DenseFComplexMatrix1D(b);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FComplexMatrix1D)denseFComplexMatrix1D).assign(denseFComplexMatrix1D2, FComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(a);
                t.reset().start();
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(denseFComplexMatrix1D2, FComplexFunctions.div);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        FComplexMatrix1D fComplexMatrix1D2 = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(b);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            fComplexMatrix1D.assign(fComplexMatrix1D2, FComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix1D.assign(a);
                t.reset().start();
                fComplexMatrix1D.assign(fComplexMatrix1D2, FComplexFunctions.div);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexMatrix1D, FComplexFComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexProcedureFloatArray() {
        int n;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        float[] fArray = new float[]{-1.0f, -2.0f};
        FComplexProcedure fComplexProcedure = new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return (double)FComplex.abs(fArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix1D)denseFComplexMatrix1D).assign(fComplexProcedure, fArray);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(a);
                t.reset().start();
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(fComplexProcedure, fArray);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix1D.assign(fComplexProcedure, fArray);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix1D.assign(a);
                t.reset().start();
                fComplexMatrix1D.assign(fComplexProcedure, fArray);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexProcedure, float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexProcedureFComplexFComplexFunction() {
        int n;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        FComplexProcedure fComplexProcedure = new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return (double)FComplex.abs(fArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix1D)denseFComplexMatrix1D).assign(fComplexProcedure, FComplexFunctions.tan);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(a);
                t.reset().start();
                ((FComplexMatrix1D)denseFComplexMatrix1D).assign(fComplexProcedure, FComplexFunctions.tan);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix1D.assign(fComplexProcedure, FComplexFunctions.tan);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix1D.assign(a);
                t.reset().start();
                fComplexMatrix1D.assign(fComplexProcedure, FComplexFunctions.tan);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexProcedure, FComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        int n;
        int n2;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            n2 = denseFComplexMatrix1D.cardinality();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                n2 = denseFComplexMatrix1D.cardinality();
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        FComplexMatrix1D fComplexMatrix1D = denseFComplexMatrix1D.viewFlip();
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            n = fComplexMatrix1D.cardinality();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                n = fComplexMatrix1D.cardinality();
                t.stop();
                int n6 = n2;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n2++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetImaginaryPart() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int n2 = 16;
        int n3 = 4;
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FloatMatrix1D floatMatrix1D = ((FComplexMatrix1D)denseFComplexMatrix1D).getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix1D = ((FComplexMatrix1D)denseFComplexMatrix1D).getImaginaryPart();
                t.stop();
                int n5 = n4;
                noViewTimes[n5] = noViewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            noViewTimes[n6] = noViewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        FComplexMatrix1D fComplexMatrix1D = denseFComplexMatrix1D.viewFlip();
        int n7 = 0;
        while (n7 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n7]);
            FloatMatrix1D floatMatrix1D = fComplexMatrix1D.getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix1D = fComplexMatrix1D.getImaginaryPart();
                t.stop();
                int n8 = n7;
                viewTimes[n8] = viewTimes[n8] + t.millis();
            }
            int n9 = n7++;
            viewTimes[n9] = viewTimes[n9] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getImaginaryPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetRealPart() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int n2 = 16;
        int n3 = 4;
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FloatMatrix1D floatMatrix1D = ((FComplexMatrix1D)denseFComplexMatrix1D).getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix1D = ((FComplexMatrix1D)denseFComplexMatrix1D).getRealPart();
                t.stop();
                int n5 = n4;
                noViewTimes[n5] = noViewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            noViewTimes[n6] = noViewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        FComplexMatrix1D fComplexMatrix1D = denseFComplexMatrix1D.viewFlip();
        int n7 = 0;
        while (n7 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n7]);
            FloatMatrix1D floatMatrix1D = fComplexMatrix1D.getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix1D = fComplexMatrix1D.getRealPart();
                t.stop();
                int n8 = n7;
                viewTimes[n8] = viewTimes[n8] + t.millis();
            }
            int n9 = n7++;
            viewTimes[n9] = viewTimes[n9] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getRealPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft() {
        int n;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFComplexMatrix1D.fft();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix1D.assign(a);
                t.reset().start();
                denseFComplexMatrix1D.fft();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseFComplexMatrix1D)fComplexMatrix1D).fft();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix1D.assign(a);
                t.reset().start();
                ((DenseFComplexMatrix1D)fComplexMatrix1D).fft();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft() {
        int n;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n2]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            denseFComplexMatrix1D.ifft(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix1D.assign(a);
                t.reset().start();
                denseFComplexMatrix1D.ifft(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ConcurrencyUtils.setThreadsBeginN_1D(1);
            switch (BenchmarkMatrixKernel.NTHREADS[n]) {
                case 1: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                case 2: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
                    break;
                }
                default: {
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(1);
                    ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(1);
                }
            }
            ((DenseFComplexMatrix1D)fComplexMatrix1D).ifft(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix1D.assign(a);
                t.reset().start();
                ((DenseFComplexMatrix1D)fComplexMatrix1D).ifft(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testReshapeIntInt() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int n2 = 64;
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            FComplexMatrix2D fComplexMatrix2D = ((FComplexMatrix1D)denseFComplexMatrix1D).reshape(n, n2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix2D = ((FComplexMatrix1D)denseFComplexMatrix1D).reshape(n, n2);
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        FComplexMatrix1D fComplexMatrix1D = denseFComplexMatrix1D.viewFlip();
        int n6 = 0;
        while (n6 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n6]);
            FComplexMatrix2D fComplexMatrix2D = fComplexMatrix1D.reshape(n, n2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix2D = fComplexMatrix1D.reshape(n, n2);
                t.stop();
                int n7 = n6;
                viewTimes[n7] = viewTimes[n7] + t.millis();
            }
            int n8 = n6++;
            viewTimes[n8] = viewTimes[n8] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "reshape(int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testReshapeIntIntInt() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n = BenchmarkMatrixKernel.MATRIX_SIZE_1D / 64;
        int n2 = 16;
        int n3 = 4;
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FComplexMatrix3D fComplexMatrix3D = ((FComplexMatrix1D)denseFComplexMatrix1D).reshape(n, n2, n3);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix3D = ((FComplexMatrix1D)denseFComplexMatrix1D).reshape(n, n2, n3);
                t.stop();
                int n5 = n4;
                noViewTimes[n5] = noViewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            noViewTimes[n6] = noViewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        FComplexMatrix1D fComplexMatrix1D = denseFComplexMatrix1D.viewFlip();
        int n7 = 0;
        while (n7 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n7]);
            FComplexMatrix3D fComplexMatrix3D = fComplexMatrix1D.reshape(n, n2, n3);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix3D = fComplexMatrix1D.reshape(n, n2, n3);
                t.stop();
                int n8 = n7;
                viewTimes[n8] = viewTimes[n8] + t.millis();
            }
            int n9 = n7++;
            viewTimes[n9] = viewTimes[n9] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "reshape(int, int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSwapFComplexMatrix1D() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        DenseFComplexMatrix1D denseFComplexMatrix1D2 = new DenseFComplexMatrix1D(b);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FComplexMatrix1D)denseFComplexMatrix1D).swap(denseFComplexMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                ((FComplexMatrix1D)denseFComplexMatrix1D).swap(denseFComplexMatrix1D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        FComplexMatrix1D fComplexMatrix1D = denseFComplexMatrix1D.viewFlip();
        denseFComplexMatrix1D2 = new DenseFComplexMatrix1D(b);
        FComplexMatrix1D fComplexMatrix1D2 = denseFComplexMatrix1D2.viewFlip();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            fComplexMatrix1D.swap(fComplexMatrix1D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix1D.swap(fComplexMatrix1D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "swap(FComplexMatrix1D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArrayFloatArray() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = denseFComplexMatrix1D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = denseFComplexMatrix1D.toArray();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = fComplexMatrix1D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix1D.toArray();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZDotProductFComplexMatrix1DIntInt() {
        int n;
        Object object;
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        DenseFComplexMatrix1D denseFComplexMatrix1D2 = new DenseFComplexMatrix1D(b);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            object = denseFComplexMatrix1D.zDotProduct(denseFComplexMatrix1D2, 5, denseFComplexMatrix1D2.size() - 10);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                object = denseFComplexMatrix1D.zDotProduct(denseFComplexMatrix1D2, 5, denseFComplexMatrix1D2.size() - 10);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        FComplexMatrix1D fComplexMatrix1D = denseFComplexMatrix1D.viewFlip();
        denseFComplexMatrix1D2 = new DenseFComplexMatrix1D(b);
        object = denseFComplexMatrix1D2.viewFlip();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = fComplexMatrix1D.zDotProduct((FComplexMatrix1D)object, 5, ((AbstractMatrix1D)object).size() - 10);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix1D.zDotProduct((FComplexMatrix1D)object, 5, ((AbstractMatrix1D)object).size() - 10);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zDotProduct(FComplexMatrix1D, int, int)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZSum() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(a);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = ((FComplexMatrix1D)denseFComplexMatrix1D).zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((FComplexMatrix1D)denseFComplexMatrix1D).zSum();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix1D fComplexMatrix1D = new DenseFComplexMatrix1D(BenchmarkMatrixKernel.MATRIX_SIZE_1D).viewFlip().assign(a);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = fComplexMatrix1D.zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix1D.zSum();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }
}

