/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.Timer;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseFComplexMatrix2D {
    private static Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseFComplexMatrix2D.txt";
    private static float[][] a_2d;
    private static float[][] b_2d;
    private static float[] a_1d;
    private static float[] b_1d;
    private static double[] noViewTimes;
    private static double[] viewTimes;

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tfcomplex.impl.BenchmarkDenseFComplexMatrix2D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int n;
        int n2;
        BenchmarkMatrixKernel.readSettings2D();
        Random random = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        a_1d = new float[2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        a_2d = new float[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        int n3 = 0;
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n2) {
            for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n) {
                BenchmarkDenseFComplexMatrix2D.a_2d[n2][n] = random.nextFloat();
                BenchmarkDenseFComplexMatrix2D.a_1d[n3++] = a_2d[n2][n];
            }
        }
        b_1d = new float[2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        b_2d = new float[BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]];
        n3 = 0;
        for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]; ++n2) {
            for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]; ++n) {
                BenchmarkDenseFComplexMatrix2D.b_2d[n2][n] = random.nextFloat();
                BenchmarkDenseFComplexMatrix2D.b_1d[n3++] = b_2d[n2][n];
            }
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, BenchmarkMatrixKernel.MATRIX_SIZE_2D);
        BenchmarkMatrixKernel.displayProperties(BenchmarkMatrixKernel.MATRIX_SIZE_2D);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a_1d = null;
        a_2d = null;
        b_1d = null;
        b_2d = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateFComplexFComplexFComplexFunctionFComplexFComplexFunction() {
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = ((FComplexMatrix2D)denseFComplexMatrix2D).aggregate(FComplexFunctions.plus, FComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((FComplexMatrix2D)denseFComplexMatrix2D).aggregate(FComplexFunctions.plus, FComplexFunctions.square);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = fComplexMatrix2D.aggregate(FComplexFunctions.plus, FComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix2D.aggregate(FComplexFunctions.plus, FComplexFunctions.square);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FComplexFComplexFComplexFunction, FComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateFComplexMatrix2DFComplexFComplexFComplexFunctionFComplexFComplexFComplexFunction() {
        int n;
        Object object;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        DenseFComplexMatrix2D denseFComplexMatrix2D2 = new DenseFComplexMatrix2D(b_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            object = ((FComplexMatrix2D)denseFComplexMatrix2D).aggregate(denseFComplexMatrix2D2, FComplexFunctions.plus, FComplexFunctions.mult);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                object = ((FComplexMatrix2D)denseFComplexMatrix2D).aggregate(denseFComplexMatrix2D2, FComplexFunctions.plus, FComplexFunctions.mult);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        object = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = fComplexMatrix2D.aggregate((FComplexMatrix2D)object, FComplexFunctions.plus, FComplexFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix2D.aggregate((FComplexMatrix2D)object, FComplexFunctions.plus, FComplexFunctions.mult);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(FComplexMatrix2D, FComplexFComplexFComplexFunction, FComplexFComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatFloat() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        float f = (float)Math.random();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).assign(f, f);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(f, f);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix2D.assign(f, f);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix2D.assign(f, f);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float, float)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArray() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).assign(a_1d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(a_1d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix2D.assign(a_1d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix2D.assign(a_1d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFloatArrayArray() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).assign(a_2d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(a_2d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix2D.assign(a_2d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix2D.assign(a_2d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(float[][])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexFComplexFunction() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).assign(FComplexFunctions.acos);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(a_2d);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(FComplexFunctions.acos);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix2D.assign(FComplexFunctions.acos);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                fComplexMatrix2D.assign(FComplexFunctions.acos);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexMatrix2D() {
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        DenseFComplexMatrix2D denseFComplexMatrix2D2 = new DenseFComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).assign(denseFComplexMatrix2D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(denseFComplexMatrix2D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        FComplexMatrix2D fComplexMatrix2D = denseFComplexMatrix2D.viewDice();
        denseFComplexMatrix2D2 = new DenseFComplexMatrix2D(a_2d);
        FComplexMatrix2D fComplexMatrix2D2 = denseFComplexMatrix2D2.viewDice();
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            fComplexMatrix2D.assign(fComplexMatrix2D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix2D.assign(fComplexMatrix2D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexMatrix2D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexMatrix2DFComplexFComplexFComplexFunction() {
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        DenseFComplexMatrix2D denseFComplexMatrix2D2 = new DenseFComplexMatrix2D(b_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).assign(denseFComplexMatrix2D2, FComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(a_2d);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(denseFComplexMatrix2D2, FComplexFunctions.div);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        FComplexMatrix2D fComplexMatrix2D2 = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(b_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            fComplexMatrix2D.assign(fComplexMatrix2D2, FComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                fComplexMatrix2D.assign(fComplexMatrix2D2, FComplexFunctions.div);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexMatrix2D, FComplexFComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexProcedureFloatArray() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        float[] fArray = new float[]{-1.0f, -2.0f};
        FComplexProcedure fComplexProcedure = new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return (double)FComplex.abs(fArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).assign(fComplexProcedure, fArray);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(a_2d);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(fComplexProcedure, fArray);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix2D.assign(fComplexProcedure, fArray);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                fComplexMatrix2D.assign(fComplexProcedure, fArray);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexProcedure, float[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignFComplexProcedureFComplexFComplexFunction() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        FComplexProcedure fComplexProcedure = new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return (double)FComplex.abs(fArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).assign(fComplexProcedure, FComplexFunctions.tan);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(a_2d);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(fComplexProcedure, FComplexFunctions.tan);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix2D.assign(fComplexProcedure, FComplexFunctions.tan);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                fComplexMatrix2D.assign(fComplexProcedure, FComplexFunctions.tan);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(FComplexProcedure, FComplexFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        int n;
        int n2;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            n2 = ((FComplexMatrix2D)denseFComplexMatrix2D).cardinality();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                n2 = ((FComplexMatrix2D)denseFComplexMatrix2D).cardinality();
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        FComplexMatrix2D fComplexMatrix2D = denseFComplexMatrix2D.viewDice();
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            n = fComplexMatrix2D.cardinality();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                n = fComplexMatrix2D.cardinality();
                t.stop();
                int n6 = n2;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n2++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft2() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D.fft2();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D.fft2();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFComplexMatrix2D)fComplexMatrix2D).fft2();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseFComplexMatrix2D)fComplexMatrix2D).fft2();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft2()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFftColumns() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D.fftColumns();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D.fftColumns();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFComplexMatrix2D)fComplexMatrix2D).fftColumns();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseFComplexMatrix2D)fComplexMatrix2D).fftColumns();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fftColumns()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFftRows() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D.fftRows();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D.fftRows();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFComplexMatrix2D)fComplexMatrix2D).fftRows();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseFComplexMatrix2D)fComplexMatrix2D).fftRows();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fftRows()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testForEachNonZero() {
        int n;
        IntIntFComplexFunction intIntFComplexFunction = new IntIntFComplexFunction(){

            public float[] apply(int n, int n2, float[] fArray) {
                return FComplex.sqrt(fArray);
            }
        };
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).forEachNonZero(intIntFComplexFunction);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix2D)denseFComplexMatrix2D).assign(a_2d);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).forEachNonZero(intIntFComplexFunction);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(a_2d).viewDice();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix2D.forEachNonZero(intIntFComplexFunction);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                fComplexMatrix2D.forEachNonZero(intIntFComplexFunction);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "forEachNonZero(IntIntFComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetConjugateTranspose() {
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            FComplexMatrix2D fComplexMatrix2D = ((FComplexMatrix2D)denseFComplexMatrix2D).getConjugateTranspose();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix2D = ((FComplexMatrix2D)denseFComplexMatrix2D).getConjugateTranspose();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FComplexMatrix2D fComplexMatrix2D2 = fComplexMatrix2D.getConjugateTranspose();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix2D2 = fComplexMatrix2D.getConjugateTranspose();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getConjugateTranspose()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetRealPart() {
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            FloatMatrix2D floatMatrix2D = ((FComplexMatrix2D)denseFComplexMatrix2D).getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix2D = ((FComplexMatrix2D)denseFComplexMatrix2D).getRealPart();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FloatMatrix2D floatMatrix2D = fComplexMatrix2D.getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix2D = fComplexMatrix2D.getRealPart();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getRealPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetImaginaryPart() {
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            FloatMatrix2D floatMatrix2D = ((FComplexMatrix2D)denseFComplexMatrix2D).getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix2D = ((FComplexMatrix2D)denseFComplexMatrix2D).getImaginaryPart();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FloatMatrix2D floatMatrix2D = fComplexMatrix2D.getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                floatMatrix2D = fComplexMatrix2D.getImaginaryPart();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getImaginaryPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNonZerosIntArrayListIntArrayListArrayList() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).getNonZeros(intArrayList, intArrayList2, arrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                arrayList.clear();
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).getNonZeros(intArrayList, intArrayList2, arrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(a_2d).viewDice();
        intArrayList.clear();
        intArrayList2.clear();
        arrayList.clear();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix2D.getNonZeros(intArrayList, intArrayList2, arrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                arrayList.clear();
                t.reset().start();
                fComplexMatrix2D.getNonZeros(intArrayList, intArrayList2, arrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNonZeros(IntArrayList, IntArrayList, ArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft2() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D.ifft2(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D.ifft2(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFComplexMatrix2D)fComplexMatrix2D).ifft2(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseFComplexMatrix2D)fComplexMatrix2D).ifft2(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft2(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfftColumns() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D.ifftColumns(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D.ifftColumns(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFComplexMatrix2D)fComplexMatrix2D).ifftColumns(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseFComplexMatrix2D)fComplexMatrix2D).ifftColumns(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifftColumns(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfftRows() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseFComplexMatrix2D.ifftRows(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseFComplexMatrix2D.assign(a_2d);
                t.reset().start();
                denseFComplexMatrix2D.ifftRows(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseFComplexMatrix2D)fComplexMatrix2D).ifftRows(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D.assign(a_2d);
                t.reset().start();
                ((DenseFComplexMatrix2D)fComplexMatrix2D).ifftRows(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifftRows(true)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSum() {
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[] fArray = ((FComplexMatrix2D)denseFComplexMatrix2D).zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((FComplexMatrix2D)denseFComplexMatrix2D).zSum();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[] fArray = fComplexMatrix2D.zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix2D.zSum();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArray() {
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            float[][] fArray = ((FComplexMatrix2D)denseFComplexMatrix2D).toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = ((FComplexMatrix2D)denseFComplexMatrix2D).toArray();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            float[][] fArray = fComplexMatrix2D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fArray = fComplexMatrix2D.toArray();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testVectorize() {
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            FComplexMatrix1D fComplexMatrix1D = ((FComplexMatrix2D)denseFComplexMatrix2D).vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix1D = ((FComplexMatrix2D)denseFComplexMatrix2D).vectorize();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            FComplexMatrix1D fComplexMatrix1D = fComplexMatrix2D.vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                fComplexMatrix1D = fComplexMatrix2D.vectorize();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "vectorize()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZMultFComplexMatrix1DFComplexMatrix1DFloatArrayFloatArrayBoolean() {
        int n;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(denseFComplexMatrix2D.columns());
        float[] fArray = new float[]{3.0f, 4.0f};
        float[] fArray2 = new float[]{5.0f, 6.0f};
        for (int i = 0; i < denseFComplexMatrix1D.size(); ++i) {
            denseFComplexMatrix1D.set(i, new float[]{(float)Math.random(), (float)Math.random()});
        }
        DenseFComplexMatrix1D denseFComplexMatrix1D2 = new DenseFComplexMatrix1D(denseFComplexMatrix2D.rows());
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).zMult(denseFComplexMatrix1D, denseFComplexMatrix1D2, fArray, fArray2, false);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((FComplexMatrix1D)denseFComplexMatrix1D2).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).zMult(denseFComplexMatrix1D, denseFComplexMatrix1D2, fArray, fArray2, false);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]).viewDice().assign(a_2d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            fComplexMatrix2D.zMult(denseFComplexMatrix1D, denseFComplexMatrix1D2, fArray, fArray2, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FComplexMatrix1D)denseFComplexMatrix1D2).assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix2D.zMult(denseFComplexMatrix1D, denseFComplexMatrix1D2, fArray, fArray2, false);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(FComplexMatrix1D, FComplexMatrix1D, float[], float[], boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testZMultFComplexMatrix2DFComplexMatrix2DFloatArrayFloatArrayBooleanBoolean() {
        int n = BenchmarkMatrixKernel.NITERS;
        BenchmarkMatrixKernel.NITERS = 10;
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        FComplexMatrix2D fComplexMatrix2D = new DenseFComplexMatrix2D(b_2d);
        fComplexMatrix2D = fComplexMatrix2D.viewDice().copy();
        DenseFComplexMatrix2D denseFComplexMatrix2D2 = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[0], BenchmarkMatrixKernel.MATRIX_SIZE_2D[0]);
        float[] fArray = new float[]{3.0f, 4.0f};
        float[] fArray2 = new float[]{5.0f, 6.0f};
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((FComplexMatrix2D)denseFComplexMatrix2D).zMult(fComplexMatrix2D, denseFComplexMatrix2D2, fArray, fArray2, false, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((FComplexMatrix2D)denseFComplexMatrix2D2).assign(0.0f, 0.0f);
                t.reset().start();
                ((FComplexMatrix2D)denseFComplexMatrix2D).zMult(fComplexMatrix2D, denseFComplexMatrix2D2, fArray, fArray2, false, false);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseFComplexMatrix2D = new DenseFComplexMatrix2D(a_2d);
        FComplexMatrix2D fComplexMatrix2D2 = denseFComplexMatrix2D.viewDice();
        fComplexMatrix2D = new DenseFComplexMatrix2D(b_2d);
        fComplexMatrix2D = fComplexMatrix2D.viewDice().copy();
        FComplexMatrix2D fComplexMatrix2D3 = fComplexMatrix2D.viewDice();
        denseFComplexMatrix2D2 = new DenseFComplexMatrix2D(BenchmarkMatrixKernel.MATRIX_SIZE_2D[1], BenchmarkMatrixKernel.MATRIX_SIZE_2D[1]);
        FComplexMatrix2D fComplexMatrix2D4 = denseFComplexMatrix2D2.viewDice();
        int n5 = 0;
        while (n5 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n5]);
            fComplexMatrix2D2.zMult(fComplexMatrix2D3, fComplexMatrix2D4, fArray, fArray2, false, false);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                fComplexMatrix2D4.assign(0.0f, 0.0f);
                t.reset().start();
                fComplexMatrix2D2.zMult(fComplexMatrix2D3, fComplexMatrix2D4, fArray, fArray2, false, false);
                t.stop();
                int n6 = n5;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n5++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zMult(FComplexMatrix2D, FComplexMatrix2D, float[], float[], boolean, boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.NITERS = n;
    }
}

