/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SelectedDenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.jet.math.tfcomplex.FComplexMult;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 7295427570770814934L;
    private FloatFFT_1D fft;
    protected float[] elements;

    public DenseFComplexMatrix1D(float[] fArray) {
        this(fArray.length / 2);
        this.assign(fArray);
    }

    public DenseFComplexMatrix1D(FloatMatrix1D floatMatrix1D) {
        this(floatMatrix1D.size());
        this.assignReal(floatMatrix1D);
    }

    public DenseFComplexMatrix1D(int n) {
        this.setUp(n, 0, 2);
        this.isNoView = true;
        this.elements = new float[2 * n];
    }

    public DenseFComplexMatrix1D(int n, float[] fArray, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = fArray;
        this.isNoView = false;
    }

    @Override
    public float[] aggregate(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFunction fComplexFComplexFunction) {
        float[] fArray = new float[2];
        if (this.size == 0) {
            fArray[0] = Float.NaN;
            fArray[1] = Float.NaN;
            return fArray;
        }
        float[] fArray2 = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            float[][] fArray3 = new float[n][2];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = DenseFComplexMatrix1D.this.zero + n3 * DenseFComplexMatrix1D.this.stride;
                        float[] fArray = fComplexFComplexFunction.apply(new float[]{DenseFComplexMatrix1D.this.elements[n], DenseFComplexMatrix1D.this.elements[n + 1]});
                        for (int i = n3 + 1; i < n4; ++i) {
                            fArray = fComplexFComplexFComplexFunction.apply(fArray, fComplexFComplexFunction.apply(new float[]{DenseFComplexMatrix1D.this.elements[n += DenseFComplexMatrix1D.this.stride], DenseFComplexMatrix1D.this.elements[n + 1]}));
                        }
                        return fArray;
                    }
                });
            }
            fArray2 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            fArray2 = fComplexFComplexFunction.apply(new float[]{this.elements[this.zero], this.elements[this.zero + 1]});
            int n5 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFunction.apply(new float[]{this.elements[n5 += this.stride], this.elements[n5 + 1]}));
            }
        }
        return fArray2;
    }

    @Override
    public float[] aggregate(FComplexMatrix1D fComplexMatrix1D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction2) {
        if (!(fComplexMatrix1D instanceof DenseFComplexMatrix1D)) {
            return super.aggregate(fComplexMatrix1D, fComplexFComplexFComplexFunction, fComplexFComplexFComplexFunction2);
        }
        this.checkSize(fComplexMatrix1D);
        if (this.size == 0) {
            float[] fArray = new float[]{Float.NaN, Float.NaN};
            return fArray;
        }
        final int n = (int)fComplexMatrix1D.index(0);
        final int n2 = fComplexMatrix1D.stride();
        final float[] fArray = (float[])fComplexMatrix1D.elements();
        float[] fArray2 = null;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            float[][] fArray3 = new float[n3][2];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n3 = DenseFComplexMatrix1D.this.zero + n5 * DenseFComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        float[] fArray2 = fComplexFComplexFComplexFunction2.apply(new float[]{DenseFComplexMatrix1D.this.elements[n3], DenseFComplexMatrix1D.this.elements[n3 + 1]}, new float[]{fArray[n22], fArray[n22 + 1]});
                        for (int i = n5 + 1; i < n6; ++i) {
                            fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFComplexFunction2.apply(new float[]{DenseFComplexMatrix1D.this.elements[n3 += DenseFComplexMatrix1D.this.stride], DenseFComplexMatrix1D.this.elements[n3 + 1]}, new float[]{fArray[n22 += n2], fArray[n22 + 1]}));
                        }
                        return fArray2;
                    }
                });
            }
            fArray2 = ConcurrencyUtils.waitForCompletion(futureArray, fComplexFComplexFComplexFunction);
        } else {
            int n7 = this.zero;
            int n8 = n;
            fArray2 = fComplexFComplexFComplexFunction2.apply(new float[]{this.elements[this.zero], this.elements[this.zero + 1]}, new float[]{fArray[n], fArray[n + 1]});
            for (int i = 1; i < this.size; ++i) {
                fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fComplexFComplexFComplexFunction2.apply(new float[]{this.elements[n7 += this.stride], this.elements[n7 + 1]}, new float[]{fArray[n8 += n2], fArray[n8 + 1]}));
            }
        }
        return fArray2;
    }

    @Override
    public FComplexMatrix1D assign(final FComplexFComplexFunction fComplexFComplexFunction) {
        if (this.elements == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Object[] objectArray;
            if (fComplexFComplexFunction instanceof FComplexMult && (objectArray = (Object[])((FComplexMult)fComplexFComplexFunction).multiplicator)[0] == 1.0f && objectArray[1] == 0.0f) {
                return this;
            }
            objectArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                objectArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray = new float[2];
                        int n = DenseFComplexMatrix1D.this.zero + n3 * DenseFComplexMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            fArray[0] = DenseFComplexMatrix1D.this.elements[n];
                            fArray[1] = DenseFComplexMatrix1D.this.elements[n + 1];
                            fArray = fComplexFComplexFunction.apply(fArray);
                            DenseFComplexMatrix1D.this.elements[n] = fArray[0];
                            DenseFComplexMatrix1D.this.elements[n + 1] = fArray[1];
                            n += DenseFComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(objectArray);
        } else {
            float[] fArray = new float[2];
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                fArray[0] = this.elements[n5];
                fArray[1] = this.elements[n5 + 1];
                fArray = fComplexFComplexFunction.apply(fArray);
                this.elements[n5] = fArray[0];
                this.elements[n5 + 1] = fArray[1];
                n5 += this.stride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(final FComplexProcedure fComplexProcedure, final FComplexFComplexFunction fComplexFComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray = new float[2];
                        int n = DenseFComplexMatrix1D.this.zero + n3 * DenseFComplexMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            fArray[0] = DenseFComplexMatrix1D.this.elements[n];
                            fArray[1] = DenseFComplexMatrix1D.this.elements[n + 1];
                            if (fComplexProcedure.apply(fArray)) {
                                fArray = fComplexFComplexFunction.apply(fArray);
                                DenseFComplexMatrix1D.this.elements[n] = fArray[0];
                                DenseFComplexMatrix1D.this.elements[n + 1] = fArray[1];
                            }
                            n += DenseFComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray = new float[2];
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                fArray[0] = this.elements[n5];
                fArray[1] = this.elements[n5 + 1];
                if (fComplexProcedure.apply(fArray)) {
                    fArray = fComplexFComplexFunction.apply(fArray);
                    this.elements[n5] = fArray[0];
                    this.elements[n5 + 1] = fArray[1];
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(final FComplexProcedure fComplexProcedure, final float[] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray2 = new float[2];
                        int n = DenseFComplexMatrix1D.this.zero + n3 * DenseFComplexMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            fArray2[0] = DenseFComplexMatrix1D.this.elements[n];
                            fArray2[1] = DenseFComplexMatrix1D.this.elements[n + 1];
                            if (fComplexProcedure.apply(fArray2)) {
                                DenseFComplexMatrix1D.this.elements[n] = fArray[0];
                                DenseFComplexMatrix1D.this.elements[n + 1] = fArray[1];
                            }
                            n += DenseFComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray2 = new float[2];
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                fArray2[0] = this.elements[n5];
                fArray2[1] = this.elements[n5 + 1];
                if (fComplexProcedure.apply(fArray2)) {
                    this.elements[n5] = fArray[0];
                    this.elements[n5 + 1] = fArray[1];
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(final FComplexRealFunction fComplexRealFunction) {
        if (this.elements == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray = new float[2];
                        int n = DenseFComplexMatrix1D.this.zero + n3 * DenseFComplexMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            fArray[0] = DenseFComplexMatrix1D.this.elements[n];
                            fArray[1] = DenseFComplexMatrix1D.this.elements[n + 1];
                            fArray[0] = fComplexRealFunction.apply(fArray);
                            DenseFComplexMatrix1D.this.elements[n] = fArray[0];
                            DenseFComplexMatrix1D.this.elements[n + 1] = 0.0f;
                            n += DenseFComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray = new float[2];
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                fArray[0] = this.elements[n5];
                fArray[1] = this.elements[n5 + 1];
                fArray[0] = fComplexRealFunction.apply(fArray);
                this.elements[n5] = fArray[0];
                this.elements[n5 + 1] = 0.0f;
                n5 += this.stride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(FComplexMatrix1D fComplexMatrix1D) {
        Object object;
        if (!(fComplexMatrix1D instanceof DenseFComplexMatrix1D)) {
            return super.assign(fComplexMatrix1D);
        }
        DenseFComplexMatrix1D denseFComplexMatrix1D = (DenseFComplexMatrix1D)fComplexMatrix1D;
        if (denseFComplexMatrix1D == this) {
            return this;
        }
        this.checkSize(denseFComplexMatrix1D);
        if (this.isNoView && denseFComplexMatrix1D.isNoView) {
            System.arraycopy(denseFComplexMatrix1D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseFComplexMatrix1D)) {
            object = denseFComplexMatrix1D.copy();
            if (!(object instanceof DenseFComplexMatrix1D)) {
                return super.assign(fComplexMatrix1D);
            }
            denseFComplexMatrix1D = (DenseFComplexMatrix1D)object;
        }
        object = denseFComplexMatrix1D.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n = denseFComplexMatrix1D.stride;
        final int n2 = (int)denseFComplexMatrix1D.index(0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((float[])object){
                    final /* synthetic */ float[] val$elemsOther;
                    {
                        this.val$elemsOther = fArray;
                    }

                    public void run() {
                        int n3 = DenseFComplexMatrix1D.this.zero + n5 * DenseFComplexMatrix1D.this.stride;
                        int n22 = n2 + n5 * n;
                        for (int i = n5; i < n6; ++i) {
                            DenseFComplexMatrix1D.this.elements[n3] = this.val$elemsOther[n22];
                            DenseFComplexMatrix1D.this.elements[n3 + 1] = this.val$elemsOther[n22 + 1];
                            n3 += DenseFComplexMatrix1D.this.stride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n2;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = (float)object[n8];
                this.elements[n7 + 1] = (float)object[n8 + 1];
                n7 += this.stride;
                n8 += n;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(FComplexMatrix1D fComplexMatrix1D, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        if (!(fComplexMatrix1D instanceof DenseFComplexMatrix1D)) {
            return super.assign(fComplexMatrix1D, fComplexFComplexFComplexFunction);
        }
        this.checkSize(fComplexMatrix1D);
        final float[] fArray = (float[])fComplexMatrix1D.elements();
        final int n = (int)fComplexMatrix1D.index(0);
        final int n2 = fComplexMatrix1D.stride();
        if (this.elements == null || fArray == null) {
            throw new InternalError();
        }
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] fArray3 = new float[2];
                        float[] fArray2 = new float[2];
                        int n3 = DenseFComplexMatrix1D.this.zero + n5 * DenseFComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            fArray3[0] = DenseFComplexMatrix1D.this.elements[n3];
                            fArray3[1] = DenseFComplexMatrix1D.this.elements[n3 + 1];
                            fArray2[0] = fArray[n22];
                            fArray2[1] = fArray[n22 + 1];
                            fArray3 = fComplexFComplexFComplexFunction.apply(fArray3, fArray2);
                            DenseFComplexMatrix1D.this.elements[n3] = fArray3[0];
                            DenseFComplexMatrix1D.this.elements[n3 + 1] = fArray3[1];
                            n3 += DenseFComplexMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray2 = new float[2];
            float[] fArray3 = new float[2];
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                fArray2[0] = this.elements[n7];
                fArray2[1] = this.elements[n7 + 1];
                fArray3[0] = fArray[n8];
                fArray3[1] = fArray[n8 + 1];
                fArray2 = fComplexFComplexFComplexFunction.apply(fArray2, fArray3);
                this.elements[n7] = fArray2[0];
                this.elements[n7 + 1] = fArray2[1];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(final float f, final float f2) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseFComplexMatrix1D.this.zero + n3 * DenseFComplexMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            DenseFComplexMatrix1D.this.elements[n] = f;
                            DenseFComplexMatrix1D.this.elements[n + 1] = f2;
                            n += DenseFComplexMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n5] = f;
                this.elements[n5 + 1] = f2;
                n5 += this.stride;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(float[] fArray) {
        if (this.isNoView) {
            if (fArray.length != 2 * this.size) {
                throw new IllegalArgumentException("The length of values[] must be equal to 2*size()=" + 2 * this.size());
            }
            System.arraycopy(fArray, 0, this.elements, 0, fArray.length);
        } else {
            super.assign(fArray);
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assignImaginary(FloatMatrix1D floatMatrix1D) {
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D)) {
            return super.assignImaginary(floatMatrix1D);
        }
        this.checkSize(floatMatrix1D);
        final int n = (int)floatMatrix1D.index(0);
        final int n2 = floatMatrix1D.stride();
        final float[] fArray = (float[])floatMatrix1D.elements();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseFComplexMatrix1D.this.zero + n5 * DenseFComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseFComplexMatrix1D.this.elements[n3 + 1] = fArray[n22];
                            n3 += DenseFComplexMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7 + 1] = fArray[n8];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assignReal(FloatMatrix1D floatMatrix1D) {
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D)) {
            return super.assignReal(floatMatrix1D);
        }
        this.checkSize(floatMatrix1D);
        final int n = (int)floatMatrix1D.index(0);
        final int n2 = floatMatrix1D.stride();
        final float[] fArray = (float[])floatMatrix1D.elements();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseFComplexMatrix1D.this.zero + n5 * DenseFComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseFComplexMatrix1D.this.elements[n3] = fArray[n22];
                            n3 += DenseFComplexMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = fArray[n8];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    public void fft() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.complexForward(this.elements);
        } else {
            FComplexMatrix1D fComplexMatrix1D = this.copy();
            this.fft.complexForward((float[])fComplexMatrix1D.elements());
            this.assign((float[])fComplexMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public float[] elements() {
        return this.elements;
    }

    @Override
    public FloatMatrix1D getImaginaryPart() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(this.size);
        final float[] fArray = denseFloatMatrix1D.elements();
        final int n = (int)denseFloatMatrix1D.index(0);
        final int n2 = denseFloatMatrix1D.stride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseFComplexMatrix1D.this.zero + n5 * DenseFComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            fArray[n22] = DenseFComplexMatrix1D.this.elements[n3 + 1];
                            n3 += DenseFComplexMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                fArray[n8] = this.elements[n7 + 1];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return denseFloatMatrix1D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getNonZeros(IntArrayList intArrayList, ArrayList<float[]> arrayList) {
        intArrayList.clear();
        arrayList.clear();
        int n = this.size();
        int n2 = this.zero;
        for (int i = 0; i < n; ++i) {
            float[] fArray = new float[]{this.elements[n2], this.elements[n2 + 1]};
            if (fArray[0] != 0.0f || fArray[1] != 0.0f) {
                IntArrayList intArrayList2 = intArrayList;
                synchronized (intArrayList2) {
                    intArrayList.add(i);
                    arrayList.add(fArray);
                }
            }
            n2 += this.stride;
        }
    }

    @Override
    public float[] getQuick(int n) {
        int n2 = this.zero + n * this.stride;
        return new float[]{this.elements[n2], this.elements[n2 + 1]};
    }

    @Override
    public FloatMatrix1D getRealPart() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(this.size);
        final float[] fArray = denseFloatMatrix1D.elements();
        final int n = (int)denseFloatMatrix1D.index(0);
        final int n2 = denseFloatMatrix1D.stride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseFComplexMatrix1D.this.zero + n5 * DenseFComplexMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            fArray[n22] = DenseFComplexMatrix1D.this.elements[n3];
                            n3 += DenseFComplexMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                fArray[n8] = this.elements[n7];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return denseFloatMatrix1D;
    }

    public void ifft(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.complexInverse(this.elements, bl);
        } else {
            FComplexMatrix1D fComplexMatrix1D = this.copy();
            this.fft.complexInverse((float[])fComplexMatrix1D.elements(), bl);
            this.assign((float[])fComplexMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    @Override
    public FComplexMatrix1D like(int n) {
        return new DenseFComplexMatrix1D(n);
    }

    @Override
    public FComplexMatrix2D like2D(int n, int n2) {
        return new DenseFComplexMatrix2D(n, n2);
    }

    @Override
    public FComplexMatrix2D reshape(final int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*cols != size");
        }
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(n, n2);
        final float[] fArray = (float[])((FComplexMatrix2D)denseFComplexMatrix2D).elements();
        final int n3 = (int)((AbstractMatrix2D)denseFComplexMatrix2D).index(0, 0);
        final int n4 = denseFComplexMatrix2D.rowStride();
        final int n5 = denseFComplexMatrix2D.columnStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n6];
            int n7 = n2 / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n2 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n6 = n3 + i * n5;
                            int n2 = DenseFComplexMatrix1D.this.zero + i * n * DenseFComplexMatrix1D.this.stride;
                            for (int j = 0; j < n; ++j) {
                                fArray[n6] = DenseFComplexMatrix1D.this.elements[n2];
                                fArray[n6 + 1] = DenseFComplexMatrix1D.this.elements[n2 + 1];
                                n6 += n4;
                                n2 += DenseFComplexMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = this.zero;
            for (int i = 0; i < n2; ++i) {
                int n11 = n3 + i * n5;
                for (int j = 0; j < n; ++j) {
                    fArray[n11] = this.elements[n10];
                    fArray[n11 + 1] = this.elements[n10 + 1];
                    n11 += n4;
                    n10 += this.stride;
                }
            }
        }
        return denseFComplexMatrix2D;
    }

    @Override
    public FComplexMatrix3D reshape(int n, final int n2, final int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*cols != size");
        }
        DenseFComplexMatrix3D denseFComplexMatrix3D = new DenseFComplexMatrix3D(n, n2, n3);
        final float[] fArray = (float[])((FComplexMatrix3D)denseFComplexMatrix3D).elements();
        final int n4 = (int)((AbstractMatrix3D)denseFComplexMatrix3D).index(0, 0, 0);
        final int n5 = denseFComplexMatrix3D.sliceStride();
        final int n6 = denseFComplexMatrix3D.rowStride();
        final int n7 = denseFComplexMatrix3D.columnStride();
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n8];
            int n9 = n / n8;
            for (int i = 0; i < n8; ++i) {
                final int n10 = i * n9;
                final int n11 = i == n8 - 1 ? n : n10 + n9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n10; i < n11; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n = n4 + i * n5 + j * n7;
                                int n22 = DenseFComplexMatrix1D.this.zero + (i * n2 * n3 + j * n2) * DenseFComplexMatrix1D.this.stride;
                                for (int k = 0; k < n2; ++k) {
                                    fArray[n] = DenseFComplexMatrix1D.this.elements[n22];
                                    fArray[n + 1] = DenseFComplexMatrix1D.this.elements[n22 + 1];
                                    n += n6;
                                    n22 += DenseFComplexMatrix1D.this.stride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12 = this.zero;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n13 = n4 + i * n5 + j * n7;
                    for (int k = 0; k < n2; ++k) {
                        fArray[n13] = this.elements[n12];
                        fArray[n13 + 1] = this.elements[n12 + 1];
                        n13 += n6;
                        n12 += this.stride;
                    }
                }
            }
        }
        return denseFComplexMatrix3D;
    }

    @Override
    public void setQuick(int n, float f, float f2) {
        int n2 = this.zero + n * this.stride;
        this.elements[n2] = f;
        this.elements[n2 + 1] = f2;
    }

    @Override
    public void setQuick(int n, float[] fArray) {
        int n2 = this.zero + n * this.stride;
        this.elements[n2] = fArray[0];
        this.elements[n2 + 1] = fArray[1];
    }

    @Override
    public void swap(FComplexMatrix1D fComplexMatrix1D) {
        DenseFComplexMatrix1D denseFComplexMatrix1D;
        if (!(fComplexMatrix1D instanceof DenseFComplexMatrix1D)) {
            super.swap(fComplexMatrix1D);
        }
        if ((denseFComplexMatrix1D = (DenseFComplexMatrix1D)fComplexMatrix1D) == this) {
            return;
        }
        this.checkSize(denseFComplexMatrix1D);
        final float[] fArray = denseFComplexMatrix1D.elements;
        if (this.elements == null || fArray == null) {
            throw new InternalError();
        }
        final int n = denseFComplexMatrix1D.stride;
        final int n2 = (int)denseFComplexMatrix1D.index(0);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseFComplexMatrix1D.this.zero + n5 * DenseFComplexMatrix1D.this.stride;
                        int n22 = n2 + n5 * n;
                        for (int i = n5; i < n6; ++i) {
                            float f = DenseFComplexMatrix1D.this.elements[n3];
                            DenseFComplexMatrix1D.this.elements[n3] = fArray[n22];
                            fArray[n22] = f;
                            f = DenseFComplexMatrix1D.this.elements[n3 + 1];
                            DenseFComplexMatrix1D.this.elements[n3 + 1] = fArray[n22 + 1];
                            fArray[n22 + 1] = f;
                            n3 += DenseFComplexMatrix1D.this.stride;
                            n22 += n;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n2;
            for (int i = 0; i < this.size; ++i) {
                float f = this.elements[n7];
                this.elements[n7] = fArray[n8];
                fArray[n8] = f;
                f = this.elements[n7 + 1];
                this.elements[n7 + 1] = fArray[n8 + 1];
                fArray[n8 + 1] = f;
                n7 += this.stride;
                n8 += n;
            }
        }
    }

    @Override
    public void toArray(float[] fArray) {
        if (fArray.length < 2 * this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, fArray, 0, this.elements.length);
        } else {
            super.toArray(fArray);
        }
    }

    @Override
    public float[] zSum() {
        float[] fArray = new float[2];
        if (this.elements == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n2;
            Future[] futureArray = new Future[n];
            float[][] fArray2 = new float[n][2];
            int n3 = this.size / n;
            for (n2 = 0; n2 < n; ++n2) {
                final int n4 = n2 * n3;
                final int n5 = n2 == n - 1 ? this.size : n4 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] fArray = new float[2];
                        int n = DenseFComplexMatrix1D.this.zero + n4 * DenseFComplexMatrix1D.this.stride;
                        for (int i = n4; i < n5; ++i) {
                            fArray[0] = fArray[0] + DenseFComplexMatrix1D.this.elements[n];
                            fArray[1] = fArray[1] + DenseFComplexMatrix1D.this.elements[n + 1];
                            n += DenseFComplexMatrix1D.this.stride;
                        }
                        return fArray;
                    }
                });
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray2[n2] = (float[])futureArray[n2].get();
                }
                fArray = fArray2[0];
                for (n2 = 1; n2 < n; ++n2) {
                    fArray[0] = fArray[0] + fArray2[n2][0];
                    fArray[1] = fArray[1] + fArray2[n2][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n6 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                fArray[0] = fArray[0] + this.elements[n6];
                fArray[1] = fArray[1] + this.elements[n6 + 1];
                n6 += this.stride;
            }
        }
        return fArray;
    }

    @Override
    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.zero;
        for (int i = 0; i < this.size && n2 < n; ++i) {
            if (this.elements[n3] != 0.0f || this.elements[n3 + 1] != 0.0f) {
                ++n2;
            }
            n3 += this.stride;
        }
        return n2;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix1D fComplexMatrix1D) {
        if (fComplexMatrix1D instanceof SelectedDenseFComplexMatrix1D) {
            SelectedDenseFComplexMatrix1D selectedDenseFComplexMatrix1D = (SelectedDenseFComplexMatrix1D)fComplexMatrix1D;
            return this.elements == selectedDenseFComplexMatrix1D.elements;
        }
        if (fComplexMatrix1D instanceof DenseFComplexMatrix1D) {
            DenseFComplexMatrix1D denseFComplexMatrix1D = (DenseFComplexMatrix1D)fComplexMatrix1D;
            return this.elements == denseFComplexMatrix1D.elements;
        }
        return false;
    }

    @Override
    public long index(int n) {
        return this.zero + n * this.stride;
    }

    @Override
    protected FComplexMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseFComplexMatrix1D(this.elements, nArray);
    }
}

