/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

class SelectedDenseFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1358904244890406059L;
    protected float[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseFComplexMatrix1D(float[] fArray, int[] nArray) {
        this(nArray.length, fArray, 0, 1, nArray, 0);
    }

    protected SelectedDenseFComplexMatrix1D(int n, float[] fArray, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = fArray;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    public float[] getQuick(int n) {
        int n2 = this.zero + n * this.stride;
        return new float[]{this.elements[this.offset + this.offsets[n2]], this.elements[this.offset + this.offsets[n2] + 1]};
    }

    public FloatMatrix1D getRealPart() {
        final DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(this.size);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    float[] tmp;

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            this.tmp = SelectedDenseFComplexMatrix1D.this.getQuick(i);
                            denseFloatMatrix1D.setQuick(i, this.tmp[0]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                float[] fArray = this.getQuick(i);
                denseFloatMatrix1D.setQuick(i, fArray[0]);
            }
        }
        return denseFloatMatrix1D;
    }

    public FloatMatrix1D getImaginaryPart() {
        final DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(this.size);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    float[] tmp;

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            this.tmp = SelectedDenseFComplexMatrix1D.this.getQuick(i);
                            denseFloatMatrix1D.setQuick(i, this.tmp[1]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                float[] fArray = this.getQuick(i);
                denseFloatMatrix1D.setQuick(i, fArray[1]);
            }
        }
        return denseFloatMatrix1D;
    }

    public float[] elements() {
        throw new IllegalAccessError("getElements() is not supported for SelectedDenseComplexMatrix1D.");
    }

    protected boolean haveSharedCellsRaw(FComplexMatrix1D fComplexMatrix1D) {
        if (fComplexMatrix1D instanceof SelectedDenseFComplexMatrix1D) {
            SelectedDenseFComplexMatrix1D selectedDenseFComplexMatrix1D = (SelectedDenseFComplexMatrix1D)fComplexMatrix1D;
            return this.elements == selectedDenseFComplexMatrix1D.elements;
        }
        if (fComplexMatrix1D instanceof DenseFComplexMatrix1D) {
            DenseFComplexMatrix1D denseFComplexMatrix1D = (DenseFComplexMatrix1D)fComplexMatrix1D;
            return this.elements == denseFComplexMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    public FComplexMatrix1D like(int n) {
        return new DenseFComplexMatrix1D(n);
    }

    public FComplexMatrix2D like2D(int n, int n2) {
        return new DenseFComplexMatrix2D(n, n2);
    }

    public FComplexMatrix2D reshape(int n, int n2) {
        throw new IllegalAccessError("reshape is not supported.");
    }

    public FComplexMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalAccessError("reshape is not supported");
    }

    public void setQuick(int n, float[] fArray) {
        int n2 = this.zero + n * this.stride;
        this.elements[this.offset + this.offsets[n2]] = fArray[0];
        this.elements[this.offset + this.offsets[n2] + 1] = fArray[1];
    }

    public void setQuick(int n, float f, float f2) {
        int n2 = this.zero + n * this.stride;
        this.elements[this.offset + this.offsets[n2]] = f;
        this.elements[this.offset + this.offsets[n2] + 1] = f2;
    }

    protected void setUp(int n) {
        super.setUp(n, 0, 1);
        this.offset = 0;
    }

    protected FComplexMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseFComplexMatrix1D(this.elements, nArray);
    }
}

