/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SelectedDenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

class SelectedDenseFComplexMatrix2D
extends FComplexMatrix2D {
    private static final long serialVersionUID = -6212926540247811567L;
    protected float[] elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseFComplexMatrix2D(float[] fArray, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, fArray, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected SelectedDenseFComplexMatrix2D(int n, int n2, float[] fArray, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = fArray;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    public float[] getQuick(int n, int n2) {
        int n3 = this.rowZero + n * this.rowStride;
        int n4 = this.columnZero + n2 * this.columnStride;
        return new float[]{this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4]], this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4] + 1]};
    }

    public float[] elements() {
        throw new IllegalAccessError("getElements() is not supported for SelectedDenseComplexMatrix2D.");
    }

    protected boolean haveSharedCellsRaw(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D instanceof SelectedDenseFComplexMatrix2D) {
            SelectedDenseFComplexMatrix2D selectedDenseFComplexMatrix2D = (SelectedDenseFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == selectedDenseFComplexMatrix2D.elements;
        }
        if (fComplexMatrix2D instanceof DenseFComplexMatrix2D) {
            DenseFComplexMatrix2D denseFComplexMatrix2D = (DenseFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == denseFComplexMatrix2D.elements;
        }
        return false;
    }

    public long index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public FComplexMatrix2D like(int n, int n2) {
        return new DenseFComplexMatrix2D(n, n2);
    }

    public FComplexMatrix1D like1D(int n) {
        return new DenseFComplexMatrix1D(n);
    }

    protected FComplexMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    public void setQuick(int n, int n2, float[] fArray) {
        int n3 = this.rowZero + n * this.rowStride;
        int n4 = this.columnZero + n2 * this.columnStride;
        this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4]] = fArray[0];
        this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4] + 1] = fArray[1];
    }

    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                denseFComplexMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return denseFComplexMatrix1D;
    }

    public void setQuick(int n, int n2, float f, float f2) {
        int n3 = this.rowZero + n * this.rowStride;
        int n4 = this.columnZero + n2 * this.columnStride;
        this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4]] = f;
        this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4] + 1] = f2;
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 2;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    public FComplexMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedDenseFComplexMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public FComplexMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedDenseFComplexMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected FComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseFComplexMatrix2D(this.elements, nArray, nArray2, this.offset);
    }

    public FloatMatrix2D getRealPart() {
        final DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SelectedDenseFComplexMatrix2D.this.columns; ++j) {
                                float[] fArray = SelectedDenseFComplexMatrix2D.this.getQuick(i, j);
                                denseFloatMatrix2D.setQuick(i, j, fArray[0]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float[] fArray = this.getQuick(i, j);
                    denseFloatMatrix2D.setQuick(i, j, fArray[0]);
                }
            }
        }
        return denseFloatMatrix2D;
    }

    public FloatMatrix2D getImaginaryPart() {
        final DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SelectedDenseFComplexMatrix2D.this.columns; ++j) {
                                float[] fArray = SelectedDenseFComplexMatrix2D.this.getQuick(i, j);
                                denseFloatMatrix2D.setQuick(i, j, fArray[1]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    float[] fArray = this.getQuick(i, j);
                    denseFloatMatrix2D.setQuick(i, j, fArray[1]);
                }
            }
        }
        return denseFloatMatrix2D;
    }
}

