/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SelectedSparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = -7792866167410993582L;
    protected ConcurrentHashMap<Integer, float[]> elements;

    public SparseFComplexMatrix1D(float[] fArray) {
        this(fArray.length);
        this.assign(fArray);
    }

    public SparseFComplexMatrix1D(int n) {
        this.setUp(n);
        this.elements = new ConcurrentHashMap(n / 1000);
    }

    protected SparseFComplexMatrix1D(int n, ConcurrentHashMap<Integer, float[]> concurrentHashMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = concurrentHashMap;
        this.isNoView = false;
    }

    @Override
    public FComplexMatrix1D assign(float[] fArray) {
        if (this.isNoView && fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(fArray);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public float[] getQuick(int n) {
        float[] fArray = this.elements.get(this.zero + n * this.stride);
        if (fArray != null) {
            return new float[]{fArray[0], fArray[1]};
        }
        return new float[2];
    }

    @Override
    public ConcurrentHashMap<Integer, float[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix1D fComplexMatrix1D) {
        if (fComplexMatrix1D instanceof SelectedSparseFComplexMatrix1D) {
            SelectedSparseFComplexMatrix1D selectedSparseFComplexMatrix1D = (SelectedSparseFComplexMatrix1D)fComplexMatrix1D;
            return this.elements == selectedSparseFComplexMatrix1D.elements;
        }
        if (fComplexMatrix1D instanceof SparseFComplexMatrix1D) {
            SparseFComplexMatrix1D sparseFComplexMatrix1D = (SparseFComplexMatrix1D)fComplexMatrix1D;
            return this.elements == sparseFComplexMatrix1D.elements;
        }
        return false;
    }

    @Override
    public long index(int n) {
        return this.zero + n * this.stride;
    }

    @Override
    public FComplexMatrix1D like(int n) {
        return new SparseFComplexMatrix1D(n);
    }

    @Override
    public FComplexMatrix2D like2D(int n, int n2) {
        return new SparseFComplexMatrix2D(n, n2);
    }

    @Override
    public FComplexMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*cols != size");
        }
        SparseFComplexMatrix2D sparseFComplexMatrix2D = new SparseFComplexMatrix2D(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                float[] fArray;
                if ((fArray = this.getQuick(n3++))[0] == 0.0f && fArray[1] == 0.0f) continue;
                ((FComplexMatrix2D)sparseFComplexMatrix2D).setQuick(j, i, fArray);
            }
        }
        return sparseFComplexMatrix2D;
    }

    @Override
    public FComplexMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*cols != size");
        }
        SparseFComplexMatrix3D sparseFComplexMatrix3D = new SparseFComplexMatrix3D(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    float[] fArray;
                    if ((fArray = this.getQuick(n4++))[0] == 0.0f && fArray[1] == 0.0f) continue;
                    ((FComplexMatrix3D)sparseFComplexMatrix3D).setQuick(i, k, j, fArray);
                }
            }
        }
        return sparseFComplexMatrix3D;
    }

    @Override
    public void setQuick(int n, float[] fArray) {
        int n2 = this.zero + n * this.stride;
        if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.remove(n2);
        } else {
            this.elements.put(n2, fArray);
        }
    }

    @Override
    public void setQuick(int n, float f, float f2) {
        int n2 = this.zero + n * this.stride;
        if (f == 0.0f && f2 == 0.0f) {
            this.elements.remove(n2);
        } else {
            this.elements.put(n2, new float[]{f, f2});
        }
    }

    @Override
    protected FComplexMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseFComplexMatrix1D(this.elements, nArray);
    }

    @Override
    public FloatMatrix1D getImaginaryPart() {
        int n = this.size();
        SparseFloatMatrix1D sparseFloatMatrix1D = new SparseFloatMatrix1D(n);
        float[] fArray = new float[2];
        for (int i = 0; i < n; ++i) {
            fArray = this.getQuick(i);
            ((FloatMatrix1D)sparseFloatMatrix1D).setQuick(i, fArray[1]);
        }
        return sparseFloatMatrix1D;
    }

    @Override
    public FloatMatrix1D getRealPart() {
        int n = this.size();
        SparseFloatMatrix1D sparseFloatMatrix1D = new SparseFloatMatrix1D(n);
        float[] fArray = new float[2];
        for (int i = 0; i < n; ++i) {
            fArray = this.getQuick(i);
            ((FloatMatrix1D)sparseFloatMatrix1D).setQuick(i, fArray[0]);
        }
        return sparseFloatMatrix1D;
    }
}

