/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.PersistentObject;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.RCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class FloatFactory2D
extends PersistentObject {
    public static final FloatFactory2D dense = new FloatFactory2D();
    public static final FloatFactory2D sparse = new FloatFactory2D();
    public static final FloatFactory2D rowCompressed = new FloatFactory2D();

    protected FloatFactory2D() {
    }

    public FloatMatrix2D appendColumns(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        if (floatMatrix2D2.rows() > floatMatrix2D.rows()) {
            floatMatrix2D2 = floatMatrix2D2.viewPart(0, 0, floatMatrix2D.rows(), floatMatrix2D2.columns());
        } else if (floatMatrix2D2.rows() < floatMatrix2D.rows()) {
            floatMatrix2D = floatMatrix2D.viewPart(0, 0, floatMatrix2D2.rows(), floatMatrix2D.columns());
        }
        int n = floatMatrix2D.columns();
        int n2 = floatMatrix2D2.columns();
        int n3 = floatMatrix2D.rows();
        FloatMatrix2D floatMatrix2D3 = this.make(n3, n + n2);
        floatMatrix2D3.viewPart(0, 0, n3, n).assign(floatMatrix2D);
        floatMatrix2D3.viewPart(0, n, n3, n2).assign(floatMatrix2D2);
        return floatMatrix2D3;
    }

    public FloatMatrix2D appendColumn(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D.size() > floatMatrix2D.rows()) {
            floatMatrix1D = floatMatrix1D.viewPart(0, floatMatrix2D.rows());
        } else if (floatMatrix1D.size() < floatMatrix2D.rows()) {
            floatMatrix2D = floatMatrix2D.viewPart(0, 0, floatMatrix1D.size(), floatMatrix2D.columns());
        }
        int n = floatMatrix2D.columns();
        int n2 = 1;
        int n3 = floatMatrix2D.rows();
        FloatMatrix2D floatMatrix2D2 = this.make(n3, n + n2);
        floatMatrix2D2.viewPart(0, 0, n3, n).assign(floatMatrix2D);
        floatMatrix2D2.viewColumn(n).assign(floatMatrix1D);
        return floatMatrix2D2;
    }

    public FloatMatrix2D appendRows(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        if (floatMatrix2D2.columns() > floatMatrix2D.columns()) {
            floatMatrix2D2 = floatMatrix2D2.viewPart(0, 0, floatMatrix2D2.rows(), floatMatrix2D.columns());
        } else if (floatMatrix2D2.columns() < floatMatrix2D.columns()) {
            floatMatrix2D = floatMatrix2D.viewPart(0, 0, floatMatrix2D.rows(), floatMatrix2D2.columns());
        }
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D2.rows();
        int n3 = floatMatrix2D.columns();
        FloatMatrix2D floatMatrix2D3 = this.make(n + n2, n3);
        floatMatrix2D3.viewPart(0, 0, n, n3).assign(floatMatrix2D);
        floatMatrix2D3.viewPart(n, 0, n2, n3).assign(floatMatrix2D2);
        return floatMatrix2D3;
    }

    public FloatMatrix2D appendRow(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D.size() > floatMatrix2D.columns()) {
            floatMatrix1D = floatMatrix1D.viewPart(0, floatMatrix2D.columns());
        } else if (floatMatrix1D.size() < floatMatrix2D.columns()) {
            floatMatrix2D = floatMatrix2D.viewPart(0, 0, floatMatrix2D.rows(), floatMatrix1D.size());
        }
        int n = floatMatrix2D.rows();
        int n2 = 1;
        int n3 = floatMatrix2D.columns();
        FloatMatrix2D floatMatrix2D2 = this.make(n + n2, n3);
        floatMatrix2D2.viewPart(0, 0, n, n3).assign(floatMatrix2D);
        floatMatrix2D2.viewRow(n).assign(floatMatrix1D);
        return floatMatrix2D2;
    }

    public FloatMatrix2D ascending(int n, int n2) {
        FloatFunctions floatFunctions = FloatFunctions.functions;
        return this.descending(n, n2).assign(FloatFunctions.chain(FloatFunctions.neg, FloatFunctions.minus(n2 * n)));
    }

    protected static void checkRectangularShape(float[][] fArray) {
        int n = -1;
        int n2 = fArray.length;
        while (--n2 >= 0) {
            if (fArray[n2] == null) continue;
            if (n == -1) {
                n = fArray[n2].length;
            }
            if (fArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(FloatMatrix2D[][] floatMatrix2DArray) {
        int n = -1;
        int n2 = floatMatrix2DArray.length;
        while (--n2 >= 0) {
            if (floatMatrix2DArray[n2] == null) continue;
            if (n == -1) {
                n = floatMatrix2DArray[n2].length;
            }
            if (floatMatrix2DArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public FloatMatrix2D reshape(FloatMatrix1D floatMatrix1D, int n, int n2) {
        if (floatMatrix1D.size() != n * n2) {
            throw new IllegalArgumentException("a.size() != rows*columns");
        }
        FloatMatrix2D floatMatrix2D = this == sparse ? new SparseFloatMatrix2D(n, n2) : new DenseFloatMatrix2D(n, n2);
        for (int i = 0; i < n2; ++i) {
            floatMatrix2D.viewColumn(i).assign(floatMatrix1D.viewPart(i * n, n));
        }
        return floatMatrix2D;
    }

    public FloatMatrix2D compose(FloatMatrix2D[][] floatMatrix2DArray) {
        int n;
        int n2;
        int n3;
        FloatFactory2D.checkRectangularShape(floatMatrix2DArray);
        int n4 = floatMatrix2DArray.length;
        int n5 = 0;
        if (floatMatrix2DArray.length > 0) {
            n5 = floatMatrix2DArray[0].length;
        }
        FloatMatrix2D floatMatrix2D = this.make(0, 0);
        if (n4 == 0 || n5 == 0) {
            return floatMatrix2D;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            n3 = 0;
            n2 = n4;
            while (--n2 >= 0) {
                FloatMatrix2D floatMatrix2D2 = floatMatrix2DArray[n2][n6];
                if (floatMatrix2D2 == null) continue;
                int n7 = floatMatrix2D2.columns();
                if (n3 > 0 && n7 > 0 && n7 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n7);
            }
            nArray[n6] = n3;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            n2 = 0;
            int n8 = n5;
            while (--n8 >= 0) {
                FloatMatrix2D floatMatrix2D3 = floatMatrix2DArray[n3][n8];
                if (floatMatrix2D3 == null) continue;
                n = floatMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        int n9 = n5;
        while (--n9 >= 0) {
            n2 += nArray[n9];
        }
        FloatMatrix2D floatMatrix2D4 = this.make(n3, n2);
        int n10 = 0;
        for (n = 0; n < n4; ++n) {
            int n11 = 0;
            for (int i = 0; i < n5; ++i) {
                FloatMatrix2D floatMatrix2D5 = floatMatrix2DArray[n][i];
                if (floatMatrix2D5 != null) {
                    floatMatrix2D4.viewPart(n10, n11, floatMatrix2D5.rows(), floatMatrix2D5.columns()).assign(floatMatrix2D5);
                }
                n11 += nArray[i];
            }
            n10 += nArray2[n];
        }
        return floatMatrix2D4;
    }

    public FloatMatrix2D composeDiagonal(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        int n3 = floatMatrix2D2.rows();
        int n4 = floatMatrix2D2.columns();
        FloatMatrix2D floatMatrix2D3 = this.make(n + n3, n2 + n4);
        floatMatrix2D3.viewPart(0, 0, n, n2).assign(floatMatrix2D);
        floatMatrix2D3.viewPart(n, n2, n3, n4).assign(floatMatrix2D2);
        return floatMatrix2D3;
    }

    public FloatMatrix2D composeDiagonal(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, FloatMatrix2D floatMatrix2D3) {
        FloatMatrix2D floatMatrix2D4 = this.make(floatMatrix2D.rows() + floatMatrix2D2.rows() + floatMatrix2D3.rows(), floatMatrix2D.columns() + floatMatrix2D2.columns() + floatMatrix2D3.columns());
        floatMatrix2D4.viewPart(0, 0, floatMatrix2D.rows(), floatMatrix2D.columns()).assign(floatMatrix2D);
        floatMatrix2D4.viewPart(floatMatrix2D.rows(), floatMatrix2D.columns(), floatMatrix2D2.rows(), floatMatrix2D2.columns()).assign(floatMatrix2D2);
        floatMatrix2D4.viewPart(floatMatrix2D.rows() + floatMatrix2D2.rows(), floatMatrix2D.columns() + floatMatrix2D2.columns(), floatMatrix2D3.rows(), floatMatrix2D3.columns()).assign(floatMatrix2D3);
        return floatMatrix2D4;
    }

    public FloatMatrix2D composeBidiagonal(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        int n3 = floatMatrix2D2.rows();
        int n4 = floatMatrix2D2.columns();
        FloatMatrix2D floatMatrix2D3 = this.make(n + n3 - 1, n2 + n4);
        floatMatrix2D3.viewPart(0, 0, n, n2).assign(floatMatrix2D);
        floatMatrix2D3.viewPart(n - 1, n2, n3, n4).assign(floatMatrix2D2);
        return floatMatrix2D3;
    }

    public void decompose(FloatMatrix2D[][] floatMatrix2DArray, FloatMatrix2D floatMatrix2D) {
        int n;
        int n2;
        int n3;
        FloatFactory2D.checkRectangularShape(floatMatrix2DArray);
        int n4 = floatMatrix2DArray.length;
        int n5 = 0;
        if (floatMatrix2DArray.length > 0) {
            n5 = floatMatrix2DArray[0].length;
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            n3 = 0;
            n2 = n4;
            while (--n2 >= 0) {
                FloatMatrix2D floatMatrix2D2 = floatMatrix2DArray[n2][n6];
                if (floatMatrix2D2 == null) continue;
                int n7 = floatMatrix2D2.columns();
                if (n3 > 0 && n7 > 0 && n7 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n7);
            }
            nArray[n6] = n3;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            n2 = 0;
            int n8 = n5;
            while (--n8 >= 0) {
                FloatMatrix2D floatMatrix2D3 = floatMatrix2DArray[n3][n8];
                if (floatMatrix2D3 == null) continue;
                n = floatMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        int n9 = n5;
        while (--n9 >= 0) {
            n2 += nArray[n9];
        }
        if (floatMatrix2D.rows() < n3 || floatMatrix2D.columns() < n2) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        n9 = 0;
        for (int i = 0; i < n4; ++i) {
            n = 0;
            for (int j = 0; j < n5; ++j) {
                FloatMatrix2D floatMatrix2D4 = floatMatrix2DArray[i][j];
                if (floatMatrix2D4 != null) {
                    floatMatrix2D4.assign(floatMatrix2D.viewPart(n9, n, floatMatrix2D4.rows(), floatMatrix2D4.columns()));
                }
                n += nArray[j];
            }
            n9 += nArray2[i];
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        FloatMatrix2D[][] floatMatrix2DArray = new FloatMatrix2D[][]{{null, this.make(2, 2, 1.0f), null}, {this.make(4, 4, 2.0f), null, this.make(4, 3, 3.0f)}, {null, this.make(2, 2, 4.0f), null}};
        System.out.println("\n" + this.compose(floatMatrix2DArray));
        FloatMatrix2D[][] floatMatrix2DArray2 = new FloatMatrix2D[][]{{this.identity(3), null}, {null, this.identity(3).viewColumnFlip()}, {this.identity(3).viewRowFlip(), null}};
        System.out.println("\n" + this.compose(floatMatrix2DArray2));
        FloatMatrix2D floatMatrix2D = this.ascending(2, 2);
        FloatMatrix2D floatMatrix2D2 = this.descending(2, 2);
        Object var5_5 = null;
        FloatMatrix2D[][] floatMatrix2DArray3 = new FloatMatrix2D[][]{{floatMatrix2D, var5_5, floatMatrix2D, var5_5}, {var5_5, floatMatrix2D, var5_5, floatMatrix2D2}};
        System.out.println("\n" + this.compose(floatMatrix2DArray3));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object var9_1 = null;
        FloatMatrix2D floatMatrix2D = this.make(2, 2, 1.0f);
        FloatMatrix2D floatMatrix2D2 = this.make(4, 4, 2.0f);
        FloatMatrix2D floatMatrix2D3 = this.make(4, 3, 3.0f);
        FloatMatrix2D floatMatrix2D4 = this.make(2, 2, 4.0f);
        FloatMatrix2D[][] floatMatrix2DArray = new FloatMatrix2D[][]{{var9_1, floatMatrix2D, var9_1}, {floatMatrix2D2, var9_1, floatMatrix2D3}, {var9_1, floatMatrix2D4, var9_1}};
        FloatMatrix2D floatMatrix2D5 = this.compose(floatMatrix2DArray);
        System.out.println("\n" + floatMatrix2D5);
        floatMatrix2D.assign(9.0f);
        floatMatrix2D2.assign(9.0f);
        floatMatrix2D3.assign(9.0f);
        floatMatrix2D4.assign(9.0f);
        this.decompose(floatMatrix2DArray, floatMatrix2D5);
        System.out.println(floatMatrix2D);
        System.out.println(floatMatrix2D2);
        System.out.println(floatMatrix2D3);
        System.out.println(floatMatrix2D4);
    }

    public FloatMatrix2D descending(int n, int n2) {
        FloatMatrix2D floatMatrix2D = this.make(n, n2);
        int n3 = 0;
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                floatMatrix2D.setQuick(n4, n5, n3++);
            }
        }
        return floatMatrix2D;
    }

    public FloatMatrix2D diagonal(FloatMatrix1D floatMatrix1D) {
        int n = floatMatrix1D.size();
        FloatMatrix2D floatMatrix2D = this.make(n, n);
        int n2 = n;
        while (--n2 >= 0) {
            floatMatrix2D.setQuick(n2, n2, floatMatrix1D.getQuick(n2));
        }
        return floatMatrix2D;
    }

    public FloatMatrix2D diagonal(float[] fArray) {
        int n = fArray.length;
        FloatMatrix2D floatMatrix2D = this.make(n, n);
        for (int i = 0; i < n; ++i) {
            floatMatrix2D.setQuick(i, i, fArray[i]);
        }
        return floatMatrix2D;
    }

    public FloatMatrix1D diagonal(FloatMatrix2D floatMatrix2D) {
        int n = Math.min(floatMatrix2D.rows(), floatMatrix2D.columns());
        FloatMatrix1D floatMatrix1D = this.make1D(n);
        int n2 = n;
        while (--n2 >= 0) {
            floatMatrix1D.setQuick(n2, floatMatrix2D.getQuick(n2, n2));
        }
        return floatMatrix1D;
    }

    public FloatMatrix2D identity(int n) {
        FloatMatrix2D floatMatrix2D = this.make(n, n);
        int n2 = n;
        while (--n2 >= 0) {
            floatMatrix2D.setQuick(n2, n2, 1.0f);
        }
        return floatMatrix2D;
    }

    public FloatMatrix2D make(float[][] fArray) {
        if (this == sparse) {
            return new SparseFloatMatrix2D(fArray);
        }
        return new DenseFloatMatrix2D(fArray);
    }

    public FloatMatrix2D make(float[] fArray, int n) {
        int n2;
        int n3 = n2 = n != 0 ? fArray.length / n : 0;
        if (n * n2 != fArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        FloatMatrix2D floatMatrix2D = this.make(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2D.setQuick(i, j, fArray[i + j * n]);
            }
        }
        return floatMatrix2D;
    }

    public FloatMatrix2D make(int n, int n2) {
        if (this == sparse) {
            return new SparseFloatMatrix2D(n, n2);
        }
        if (this == rowCompressed) {
            return new RCFloatMatrix2D(n, n2);
        }
        return new DenseFloatMatrix2D(n, n2);
    }

    public FloatMatrix2D make(int n, int n2, float f) {
        if (f == 0.0f) {
            return this.make(n, n2);
        }
        return this.make(n, n2).assign(f);
    }

    protected FloatMatrix1D make1D(int n) {
        return this.make(0, 0).like1D(n);
    }

    public FloatMatrix2D random(int n, int n2) {
        return this.make(n, n2).assign(FloatFunctions.random());
    }

    public FloatMatrix2D repeat(FloatMatrix2D floatMatrix2D, int n, int n2) {
        int n3 = floatMatrix2D.rows();
        int n4 = floatMatrix2D.columns();
        FloatMatrix2D floatMatrix2D2 = this.make(n3 * n, n4 * n2);
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = n2;
            while (--n6 >= 0) {
                floatMatrix2D2.viewPart(n3 * n5, n4 * n6, n3, n4).assign(floatMatrix2D);
            }
        }
        return floatMatrix2D2;
    }

    public FloatMatrix2D sample(int n, int n2, float f, float f2) {
        FloatMatrix2D floatMatrix2D = this.make(n, n2);
        this.sample(floatMatrix2D, f, f2);
        return floatMatrix2D;
    }

    public FloatMatrix2D sample(FloatMatrix2D floatMatrix2D, float f, float f2) {
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        float f3 = 1.0E-8f;
        if (f2 < 0.0f - f3 || f2 > 1.0f + f3) {
            throw new IllegalArgumentException();
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        floatMatrix2D.assign(0.0f);
        int n3 = n * n2;
        int n4 = Math.round((float)n3 * f2);
        if (n4 == 0) {
            return floatMatrix2D;
        }
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = new DoubleRandomSamplingAssistant(n4, n3, new DoubleMersenneTwister());
        for (int i = 0; i < n3; ++i) {
            if (!doubleRandomSamplingAssistant.sampleNextElement()) continue;
            int n5 = i / n2;
            int n6 = i % n2;
            floatMatrix2D.set(n5, n6, f);
        }
        return floatMatrix2D;
    }
}

