/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Sorting;
import cern.colt.Swapper;
import cern.colt.Timer;
import cern.colt.function.tfloat.FloatComparator;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatFactory3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.FloatFormatter;
import cern.colt.matrix.tfloat.algo.FloatMatrix1DComparator;
import cern.colt.matrix.tfloat.algo.FloatMatrix2DComparator;
import cern.colt.matrix.tfloat.algo.FloatStatistic;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.random.tfloat.engine.FRand;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import hep.aida.tfloat.bin.FloatBinFunction1D;
import hep.aida.tfloat.bin.FloatBinFunctions1D;

public class FloatSorting
extends PersistentObject {
    public static final FloatSorting quickSort = new FloatSorting();
    public static final FloatSorting mergeSort = new FloatSorting(){

        protected void runSort(int[] nArray, int n, int n2, IntComparator intComparator) {
            Sorting.mergeSort(nArray, n, n2, intComparator);
        }

        protected void runSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
            GenericSorting.mergeSort(n, n2, intComparator, swapper);
        }
    };

    protected FloatSorting() {
    }

    private static final int compareNaN(float f, float f2) {
        if (f != f) {
            if (f2 != f2) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    protected void runSort(int[] nArray, int n, int n2, IntComparator intComparator) {
        Sorting.parallelQuickSort(nArray, n, n2, intComparator);
    }

    protected void runSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
        GenericSorting.quickSort(n, n2, intComparator, swapper);
    }

    public FloatMatrix1D sort(final FloatMatrix1D floatMatrix1D) {
        int[] nArray = new int[floatMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        if (floatMatrix1D instanceof DenseFloatMatrix1D) {
            final float[] fArray = (float[])floatMatrix1D.elements();
            final int n2 = (int)floatMatrix1D.index(0);
            final int n3 = floatMatrix1D.stride();
            IntComparator intComparator = new IntComparator(){

                public int compare(int n, int n22) {
                    int n32 = n2 + n * n3;
                    int n4 = n2 + n22 * n3;
                    float f = fArray[n32];
                    float f2 = fArray[n4];
                    if (f != f || f2 != f2) {
                        return FloatSorting.compareNaN(f, f2);
                    }
                    return f < f2 ? -1 : (f == f2 ? 0 : 1);
                }
            };
            this.runSort(nArray, 0, nArray.length, intComparator);
            return floatMatrix1D.viewSelection(nArray);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                float f = floatMatrix1D.getQuick(n);
                float f2 = floatMatrix1D.getQuick(n2);
                if (f != f || f2 != f2) {
                    return FloatSorting.compareNaN(f, f2);
                }
                return f < f2 ? -1 : (f == f2 ? 0 : 1);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return floatMatrix1D.viewSelection(nArray);
    }

    public int[] sortIndex(FloatMatrix1D floatMatrix1D) {
        int[] nArray = new int[floatMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final float[] fArray = (float[])floatMatrix1D.elements();
        final int n2 = (int)floatMatrix1D.index(0);
        final int n3 = floatMatrix1D.stride();
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n22) {
                int n32 = n2 + n * n3;
                int n4 = n2 + n22 * n3;
                float f = fArray[n32];
                float f2 = fArray[n4];
                if (f != f || f2 != f2) {
                    return FloatSorting.compareNaN(f, f2);
                }
                return f < f2 ? -1 : (f == f2 ? 0 : 1);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return nArray;
    }

    public int[] sortIndex(FloatMatrix1D floatMatrix1D, IntComparator intComparator) {
        int[] nArray = new int[floatMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        this.runSort(nArray, 0, nArray.length, intComparator);
        return nArray;
    }

    public FloatMatrix1D sort(FloatMatrix1D floatMatrix1D, final FloatComparator floatComparator) {
        int[] nArray = new int[floatMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final float[] fArray = (float[])floatMatrix1D.elements();
        final int n2 = (int)floatMatrix1D.index(0);
        final int n3 = floatMatrix1D.stride();
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n22) {
                int n32 = n2 + n * n3;
                int n4 = n2 + n22 * n3;
                return floatComparator.compare(fArray[n32], fArray[n4]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return floatMatrix1D.viewSelection(nArray);
    }

    public int[] sortIndex(FloatMatrix1D floatMatrix1D, final FloatComparator floatComparator) {
        int[] nArray = new int[floatMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final float[] fArray = (float[])floatMatrix1D.elements();
        final int n2 = (int)floatMatrix1D.index(0);
        final int n3 = floatMatrix1D.stride();
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n22) {
                int n32 = n2 + n * n3;
                int n4 = n2 + n22 * n3;
                return floatComparator.compare(fArray[n32], fArray[n4]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return nArray;
    }

    public FloatMatrix2D sort(FloatMatrix2D floatMatrix2D, final float[] fArray) {
        int n = floatMatrix2D.rows();
        if (fArray.length != n) {
            throw new IndexOutOfBoundsException("aggregates.length != matrix.rows()");
        }
        final int[] nArray = new int[n];
        int n2 = n;
        while (--n2 >= 0) {
            nArray[n2] = n2;
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                float f = fArray[n];
                float f2 = fArray[n2];
                if (f != f || f2 != f2) {
                    return FloatSorting.compareNaN(f, f2);
                }
                return f < f2 ? -1 : (f == f2 ? 0 : 1);
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                float f = fArray[n];
                fArray[n] = fArray[n2];
                fArray[n2] = f;
            }
        };
        this.runSort(0, n, intComparator, swapper);
        return floatMatrix2D.viewSelection(nArray, null);
    }

    public FloatMatrix2D sort(FloatMatrix2D floatMatrix2D, int n) {
        if (n < 0 || n >= floatMatrix2D.columns()) {
            throw new IndexOutOfBoundsException("column=" + n + ", matrix=" + FloatFormatter.shape(floatMatrix2D));
        }
        int[] nArray = new int[floatMatrix2D.rows()];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray[n2] = n2;
        }
        final FloatMatrix1D floatMatrix1D = floatMatrix2D.viewColumn(n);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                float f = floatMatrix1D.getQuick(n);
                float f2 = floatMatrix1D.getQuick(n2);
                if (f != f || f2 != f2) {
                    return FloatSorting.compareNaN(f, f2);
                }
                return f < f2 ? -1 : (f == f2 ? 0 : 1);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return floatMatrix2D.viewSelection(nArray, null);
    }

    public FloatMatrix2D sort(FloatMatrix2D floatMatrix2D, final FloatMatrix1DComparator floatMatrix1DComparator) {
        int[] nArray = new int[floatMatrix2D.rows()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[floatMatrix2D.rows()];
        int n2 = floatMatrix1DArray.length;
        while (--n2 >= 0) {
            floatMatrix1DArray[n2] = floatMatrix2D.viewRow(n2);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return floatMatrix1DComparator.compare(floatMatrix1DArray[n], floatMatrix1DArray[n2]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return floatMatrix2D.viewSelection(nArray, null);
    }

    public FloatMatrix2D sort(FloatMatrix2D floatMatrix2D, FloatBinFunction1D floatBinFunction1D) {
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.like(1, floatMatrix2D.rows());
        FloatBinFunction1D[] floatBinFunction1DArray = new FloatBinFunction1D[]{floatBinFunction1D};
        FloatStatistic.aggregate(floatMatrix2D.viewDice(), floatBinFunction1DArray, floatMatrix2D2);
        float[] fArray = floatMatrix2D2.viewRow(0).toArray();
        return this.sort(floatMatrix2D, fArray);
    }

    public FloatMatrix3D sort(FloatMatrix3D floatMatrix3D, int n, int n2) {
        if (n < 0 || n >= floatMatrix3D.rows()) {
            throw new IndexOutOfBoundsException("row=" + n + ", matrix=" + FloatFormatter.shape(floatMatrix3D));
        }
        if (n2 < 0 || n2 >= floatMatrix3D.columns()) {
            throw new IndexOutOfBoundsException("column=" + n2 + ", matrix=" + FloatFormatter.shape(floatMatrix3D));
        }
        int[] nArray = new int[floatMatrix3D.slices()];
        int n3 = nArray.length;
        while (--n3 >= 0) {
            nArray[n3] = n3;
        }
        final FloatMatrix1D floatMatrix1D = floatMatrix3D.viewRow(n).viewColumn(n2);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                float f = floatMatrix1D.getQuick(n);
                float f2 = floatMatrix1D.getQuick(n2);
                if (f != f || f2 != f2) {
                    return FloatSorting.compareNaN(f, f2);
                }
                return f < f2 ? -1 : (f == f2 ? 0 : 1);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return floatMatrix3D.viewSelection(nArray, null, null);
    }

    public FloatMatrix3D sort(FloatMatrix3D floatMatrix3D, final FloatMatrix2DComparator floatMatrix2DComparator) {
        int[] nArray = new int[floatMatrix3D.slices()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final FloatMatrix2D[] floatMatrix2DArray = new FloatMatrix2D[floatMatrix3D.slices()];
        int n2 = floatMatrix2DArray.length;
        while (--n2 >= 0) {
            floatMatrix2DArray[n2] = floatMatrix3D.viewSlice(n2);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return floatMatrix2DComparator.compare(floatMatrix2DArray[n], floatMatrix2DArray[n2]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return floatMatrix3D.viewSelection(nArray, null, null);
    }

    public static void zdemo1() {
        FloatSorting floatSorting = quickSort;
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.descending(4, 3);
        FloatMatrix1DComparator floatMatrix1DComparator = new FloatMatrix1DComparator(){

            public int compare(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
                float f;
                float f2 = floatMatrix1D.zSum();
                return f2 < (f = floatMatrix1D2.zSum()) ? -1 : (f2 == f ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + floatMatrix2D);
        System.out.println("sorted  :" + floatSorting.sort(floatMatrix2D, floatMatrix1DComparator));
    }

    public static void zdemo2() {
        FloatSorting floatSorting = quickSort;
        FloatMatrix3D floatMatrix3D = FloatFactory3D.dense.descending(4, 3, 2);
        FloatMatrix2DComparator floatMatrix2DComparator = new FloatMatrix2DComparator(){

            public int compare(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2) {
                float f;
                float f2 = floatMatrix2D.zSum();
                return f2 < (f = floatMatrix2D2.zSum()) ? -1 : (f2 == f ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + floatMatrix3D);
        System.out.println("sorted  :" + floatSorting.sort(floatMatrix3D, floatMatrix2DComparator));
    }

    public static void zdemo3() {
        FloatSorting floatSorting = quickSort;
        float[] fArray = new float[]{0.5f, 1.5f, 2.5f, 3.5f};
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(fArray);
        FloatComparator floatComparator = new FloatComparator(){

            public int compare(float f, float f2) {
                float f3;
                float f4 = (float)Math.sin(f);
                return f4 < (f3 = (float)Math.sin(f2)) ? -1 : (f4 == f3 ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + denseFloatMatrix1D);
        FloatMatrix1D floatMatrix1D = floatSorting.sort(denseFloatMatrix1D, floatComparator);
        System.out.println("sorted  :" + floatMatrix1D);
        floatMatrix1D.assign(FloatFunctions.sin);
        System.out.println("sined  :" + floatMatrix1D);
    }

    protected static void zdemo4() {
        float[] fArray = new float[]{0.0f, 1.0f, 2.0f, 3.0f};
        float[] fArray2 = new float[]{0.0f, 2.0f, 4.0f, 6.0f};
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(fArray);
        DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(fArray2);
        System.out.println("m1:" + denseFloatMatrix1D);
        System.out.println("m2:" + denseFloatMatrix1D2);
        ((FloatMatrix1D)denseFloatMatrix1D).assign(denseFloatMatrix1D2, FloatFunctions.pow);
        System.out.println("applied:" + denseFloatMatrix1D);
    }

    public static void zdemo5(int n, int n2, boolean bl) {
        FloatSorting floatSorting = quickSort;
        System.out.println("\n\n");
        System.out.print("now initializing... ");
        Timer timer = new Timer().start();
        FloatFunctions floatFunctions = FloatFunctions.functions;
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.make(n, n2);
        floatMatrix2D.assign(new FRand());
        timer.stop().display();
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.like();
        timer.reset().start();
        System.out.print("now copying... ");
        floatMatrix2D2.assign(floatMatrix2D);
        timer.stop().display();
        timer.reset().start();
        System.out.print("now copying subrange... ");
        floatMatrix2D2.viewPart(0, 0, n, n2).assign(floatMatrix2D.viewPart(0, 0, n, n2));
        timer.stop().display();
        timer.reset().start();
        System.out.print("now copying selected... ");
        floatMatrix2D2.viewSelection(null, null).assign(floatMatrix2D.viewSelection(null, null));
        timer.stop().display();
        System.out.print("now sorting - quick version with precomputation... ");
        timer.reset().start();
        floatMatrix2D = floatSorting.sort(floatMatrix2D, FloatBinFunctions1D.median);
        timer.stop().display();
        if (bl) {
            int n3 = Math.min(n, 5);
            FloatBinFunction1D[] floatBinFunction1DArray = new FloatBinFunction1D[]{FloatBinFunctions1D.median, FloatBinFunctions1D.sumLog, FloatBinFunctions1D.geometricMean};
            String[] stringArray = new String[n3];
            String[] stringArray2 = new String[n2];
            int n4 = n2;
            while (--n4 >= 0) {
                stringArray2[n4] = Integer.toString(n4);
            }
            n4 = n3;
            while (--n4 >= 0) {
                stringArray[n4] = Integer.toString(n4);
            }
            System.out.println("first part of sorted result = \n" + new FloatFormatter("%G").toTitleString(floatMatrix2D.viewPart(0, 0, n3, n2), stringArray, stringArray2, null, null, null, floatBinFunction1DArray));
        }
        System.out.print("now sorting - slow version... ");
        floatMatrix2D = floatMatrix2D2;
        FloatMatrix1DComparator floatMatrix1DComparator = new FloatMatrix1DComparator(){

            public int compare(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
                float f;
                float f2 = FloatStatistic.bin(floatMatrix1D).median();
                return f2 < (f = FloatStatistic.bin(floatMatrix1D2).median()) ? -1 : (f2 == f ? 0 : 1);
            }
        };
        timer.reset().start();
        floatMatrix2D = floatSorting.sort(floatMatrix2D, floatMatrix1DComparator);
        timer.stop().display();
    }

    public static void zdemo6() {
        FloatSorting floatSorting = quickSort;
        float[][] fArrayArray = new float[][]{{3.0f, 7.0f, 0.0f}, {2.0f, 1.0f, 0.0f}, {2.0f, 2.0f, 0.0f}, {1.0f, 8.0f, 0.0f}, {2.0f, 5.0f, 0.0f}, {7.0f, 0.0f, 0.0f}, {2.0f, 3.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {4.0f, 0.0f, 0.0f}, {2.0f, 0.0f, 0.0f}};
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.make(fArrayArray);
        System.out.println("\n\nunsorted:" + floatMatrix2D);
        FloatMatrix2D floatMatrix2D2 = quickSort.sort(floatMatrix2D, 1);
        FloatMatrix2D floatMatrix2D3 = quickSort.sort(floatMatrix2D2, 0);
        System.out.println("quick sorted  :" + floatMatrix2D3);
        floatMatrix2D2 = mergeSort.sort(floatMatrix2D, 1);
        floatMatrix2D3 = mergeSort.sort(floatMatrix2D2, 0);
        System.out.println("merge sorted  :" + floatMatrix2D3);
    }

    public static void zdemo7(int n, int n2, boolean bl) {
        System.out.println("\n\n");
        System.out.println("now initializing... ");
        FloatFunctions floatFunctions = FloatFunctions.functions;
        FloatMatrix2D floatMatrix2D = FloatFactory2D.dense.make(n, n2);
        floatMatrix2D.assign(new FRand());
        FloatMatrix2D floatMatrix2D2 = floatMatrix2D.copy();
        float[] fArray = floatMatrix2D.viewColumn(0).toArray();
        float[] fArray2 = floatMatrix2D.viewColumn(0).toArray();
        System.out.print("now quick sorting... ");
        Timer timer = new Timer().start();
        quickSort.sort(floatMatrix2D, 0);
        timer.stop().display();
        System.out.print("now merge sorting... ");
        timer.reset().start();
        mergeSort.sort(floatMatrix2D, 0);
        timer.stop().display();
        System.out.print("now quick sorting with simple aggregation... ");
        timer.reset().start();
        quickSort.sort(floatMatrix2D, fArray);
        timer.stop().display();
        System.out.print("now merge sorting with simple aggregation... ");
        timer.reset().start();
        mergeSort.sort(floatMatrix2D, fArray2);
        timer.stop().display();
    }

    public static void zdemo8(int n) {
        System.out.println("\n\n");
        System.out.println("now initializing... ");
        FloatFunctions floatFunctions = FloatFunctions.functions;
        FloatMatrix1D floatMatrix1D = FloatFactory1D.dense.random(n);
        System.out.print("now quick sorting... ");
        Timer timer = new Timer().start();
        quickSort.sort(floatMatrix1D);
        timer.stop().display();
        System.out.print("now merge sorting... ");
        timer.reset().start();
        mergeSort.sort(floatMatrix1D);
        timer.stop().display();
    }

    public static void main(String[] stringArray) {
        ConcurrencyUtils.setNumberOfThreads(2);
        FloatSorting.zdemo8(10000000);
        System.exit(0);
    }
}

