/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import java.io.Serializable;

public class FloatEigenvalueDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private int n;
    private boolean issymmetric;
    private float[] d;
    private float[] e;
    private float[][] V;
    private float[][] H;
    private float[] ort;
    private transient float cdivr;
    private transient float cdivi;

    public FloatEigenvalueDecomposition(FloatMatrix2D floatMatrix2D) {
        FloatProperty.DEFAULT.checkSquare(floatMatrix2D);
        this.n = floatMatrix2D.columns();
        this.V = new float[this.n][this.n];
        this.d = new float[this.n];
        this.e = new float[this.n];
        this.issymmetric = FloatProperty.DEFAULT.isSymmetric(floatMatrix2D);
        if (this.issymmetric) {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    this.V[i][j] = floatMatrix2D.getQuick(i, j);
                }
            }
            this.tred2();
            this.tql2();
        } else {
            this.H = new float[this.n][this.n];
            this.ort = new float[this.n];
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    this.H[j][i] = floatMatrix2D.getQuick(j, i);
                }
            }
            this.orthes();
            this.hqr2();
        }
    }

    private void cdiv(float f, float f2, float f3, float f4) {
        if (Math.abs(f3) > Math.abs(f4)) {
            float f5 = f4 / f3;
            float f6 = f3 + f5 * f4;
            this.cdivr = (f + f5 * f2) / f6;
            this.cdivi = (f2 - f5 * f) / f6;
        } else {
            float f7 = f3 / f4;
            float f8 = f4 + f7 * f3;
            this.cdivr = (f7 * f + f2) / f8;
            this.cdivi = (f7 * f2 - f) / f8;
        }
    }

    public FloatMatrix2D getD() {
        float[][] fArray = new float[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                fArray[i][j] = 0.0f;
            }
            fArray[i][i] = this.d[i];
            if (this.e[i] > 0.0f) {
                fArray[i][i + 1] = this.e[i];
                continue;
            }
            if (!(this.e[i] < 0.0f)) continue;
            fArray[i][i - 1] = this.e[i];
        }
        return FloatFactory2D.dense.make(fArray);
    }

    public FloatMatrix1D getImagEigenvalues() {
        return FloatFactory1D.dense.make(this.e);
    }

    public FloatMatrix1D getRealEigenvalues() {
        return FloatFactory1D.dense.make(this.d);
    }

    public FloatMatrix2D getV() {
        return FloatFactory2D.dense.make(this.V);
    }

    private void hqr2() {
        float f;
        int n;
        float f2;
        float f3;
        int n2;
        int n3;
        int n4 = this.n;
        int n5 = n4 - 1;
        int n6 = 0;
        int n7 = n4 - 1;
        float f4 = (float)Math.pow(2.0, -23.0);
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        for (n3 = 0; n3 < n4; ++n3) {
            if (n3 < n6 | n3 > n7) {
                this.d[n3] = this.H[n3][n3];
                this.e[n3] = 0.0f;
            }
            for (n2 = Math.max(n3 - 1, 0); n2 < n4; ++n2) {
                f11 += Math.abs(this.H[n3][n2]);
            }
        }
        n3 = 0;
        block2: while (n5 >= n6) {
            int n8;
            for (n2 = n5; n2 > n6; --n2) {
                f9 = Math.abs(this.H[n2 - 1][n2 - 1]) + Math.abs(this.H[n2][n2]);
                if ((double)f9 == 0.0) {
                    f9 = f11;
                }
                if (Math.abs(this.H[n2][n2 - 1]) < f4 * f9) break;
            }
            if (n2 == n5) {
                this.H[n5][n5] = this.H[n5][n5] + f5;
                this.d[n5] = this.H[n5][n5];
                this.e[n5] = 0.0f;
                --n5;
                n3 = 0;
                continue;
            }
            if (n2 == n5 - 1) {
                f3 = this.H[n5][n5 - 1] * this.H[n5 - 1][n5];
                f6 = (float)((double)(this.H[n5 - 1][n5 - 1] - this.H[n5][n5]) / 2.0);
                f7 = f6 * f6 + f3;
                f10 = (float)Math.sqrt(Math.abs(f7));
                this.H[n5][n5] = this.H[n5][n5] + f5;
                this.H[n5 - 1][n5 - 1] = this.H[n5 - 1][n5 - 1] + f5;
                f2 = this.H[n5][n5];
                if (f7 >= 0.0f) {
                    f10 = f6 >= 0.0f ? f6 + f10 : f6 - f10;
                    this.d[n5 - 1] = f2 + f10;
                    this.d[n5] = this.d[n5 - 1];
                    if ((double)f10 != 0.0) {
                        this.d[n5] = f2 - f3 / f10;
                    }
                    this.e[n5 - 1] = 0.0f;
                    this.e[n5] = 0.0f;
                    f2 = this.H[n5][n5 - 1];
                    f9 = Math.abs(f2) + Math.abs(f10);
                    f6 = f2 / f9;
                    f7 = f10 / f9;
                    f8 = (float)Math.sqrt(f6 * f6 + f7 * f7);
                    f6 /= f8;
                    f7 /= f8;
                    for (n = n5 - 1; n < n4; ++n) {
                        f10 = this.H[n5 - 1][n];
                        this.H[n5 - 1][n] = f7 * f10 + f6 * this.H[n5][n];
                        this.H[n5][n] = f7 * this.H[n5][n] - f6 * f10;
                    }
                    for (n = 0; n <= n5; ++n) {
                        f10 = this.H[n][n5 - 1];
                        this.H[n][n5 - 1] = f7 * f10 + f6 * this.H[n][n5];
                        this.H[n][n5] = f7 * this.H[n][n5] - f6 * f10;
                    }
                    for (n = n6; n <= n7; ++n) {
                        f10 = this.V[n][n5 - 1];
                        this.V[n][n5 - 1] = f7 * f10 + f6 * this.V[n][n5];
                        this.V[n][n5] = f7 * this.V[n][n5] - f6 * f10;
                    }
                } else {
                    this.d[n5 - 1] = f2 + f6;
                    this.d[n5] = f2 + f6;
                    this.e[n5 - 1] = f10;
                    this.e[n5] = -f10;
                }
                n5 -= 2;
                n3 = 0;
                continue;
            }
            f2 = this.H[n5][n5];
            f = 0.0f;
            f3 = 0.0f;
            if (n2 < n5) {
                f = this.H[n5 - 1][n5 - 1];
                f3 = this.H[n5][n5 - 1] * this.H[n5 - 1][n5];
            }
            if (n3 == 10) {
                f5 += f2;
                n = n6;
                while (n <= n5) {
                    float[] fArray = this.H[n];
                    int n9 = n++;
                    fArray[n9] = fArray[n9] - f2;
                }
                f9 = Math.abs(this.H[n5][n5 - 1]) + Math.abs(this.H[n5 - 1][n5 - 2]);
                f2 = f = (float)(0.75 * (double)f9);
                f3 = (float)(-0.4375 * (double)f9 * (double)f9);
            }
            if (n3 == 30) {
                f9 = (float)((double)(f - f2) / 2.0);
                if ((f9 = f9 * f9 + f3) > 0.0f) {
                    f9 = (float)Math.sqrt(f9);
                    if (f < f2) {
                        f9 = -f9;
                    }
                    f9 = (float)((double)f2 - (double)f3 / ((double)(f - f2) / 2.0 + (double)f9));
                    n = n6;
                    while (n <= n5) {
                        float[] fArray = this.H[n];
                        int n10 = n++;
                        fArray[n10] = fArray[n10] - f9;
                    }
                    f5 += f9;
                    f3 = 0.964f;
                    f = 0.964f;
                    f2 = 0.964f;
                }
            }
            ++n3;
            for (n = n5 - 2; n >= n2; --n) {
                f10 = this.H[n][n];
                f8 = f2 - f10;
                f9 = f - f10;
                f6 = (f8 * f9 - f3) / this.H[n + 1][n] + this.H[n][n + 1];
                f7 = this.H[n + 1][n + 1] - f10 - f8 - f9;
                f8 = this.H[n + 2][n + 1];
                f9 = Math.abs(f6) + Math.abs(f7) + Math.abs(f8);
                if (n == n2 || Math.abs(this.H[n][n - 1]) * (Math.abs(f7 /= f9) + Math.abs(f8 /= f9)) < f4 * (Math.abs(f6 /= f9) * (Math.abs(this.H[n - 1][n - 1]) + Math.abs(f10) + Math.abs(this.H[n + 1][n + 1])))) break;
            }
            for (n8 = n + 2; n8 <= n5; ++n8) {
                this.H[n8][n8 - 2] = 0.0f;
                if (n8 <= n + 2) continue;
                this.H[n8][n8 - 3] = 0.0f;
            }
            for (n8 = n; n8 <= n5 - 1; ++n8) {
                int n11;
                boolean bl;
                boolean bl2 = bl = n8 != n5 - 1;
                if (n8 != n) {
                    f6 = this.H[n8][n8 - 1];
                    f7 = this.H[n8 + 1][n8 - 1];
                    f8 = bl ? this.H[n8 + 2][n8 - 1] : 0.0f;
                    f2 = Math.abs(f6) + Math.abs(f7) + Math.abs(f8);
                    if ((double)f2 != 0.0) {
                        f6 /= f2;
                        f7 /= f2;
                        f8 /= f2;
                    }
                }
                if ((double)f2 == 0.0) continue block2;
                f9 = (float)Math.sqrt(f6 * f6 + f7 * f7 + f8 * f8);
                if (f6 < 0.0f) {
                    f9 = -f9;
                }
                if (f9 == 0.0f) continue;
                if (n8 != n) {
                    this.H[n8][n8 - 1] = -f9 * f2;
                } else if (n2 != n) {
                    this.H[n8][n8 - 1] = -this.H[n8][n8 - 1];
                }
                f2 = (f6 += f9) / f9;
                f = f7 / f9;
                f10 = f8 / f9;
                f7 /= f6;
                f8 /= f6;
                for (n11 = n8; n11 < n4; ++n11) {
                    f6 = this.H[n8][n11] + f7 * this.H[n8 + 1][n11];
                    if (bl) {
                        this.H[n8 + 2][n11] = this.H[n8 + 2][n11] - (f6 += f8 * this.H[n8 + 2][n11]) * f10;
                    }
                    this.H[n8][n11] = this.H[n8][n11] - f6 * f2;
                    this.H[n8 + 1][n11] = this.H[n8 + 1][n11] - f6 * f;
                }
                for (n11 = 0; n11 <= Math.min(n5, n8 + 3); ++n11) {
                    f6 = f2 * this.H[n11][n8] + f * this.H[n11][n8 + 1];
                    if (bl) {
                        this.H[n11][n8 + 2] = this.H[n11][n8 + 2] - (f6 += f10 * this.H[n11][n8 + 2]) * f8;
                    }
                    this.H[n11][n8] = this.H[n11][n8] - f6;
                    this.H[n11][n8 + 1] = this.H[n11][n8 + 1] - f6 * f7;
                }
                for (n11 = n6; n11 <= n7; ++n11) {
                    f6 = f2 * this.V[n11][n8] + f * this.V[n11][n8 + 1];
                    if (bl) {
                        this.V[n11][n8 + 2] = this.V[n11][n8 + 2] - (f6 += f10 * this.V[n11][n8 + 2]) * f8;
                    }
                    this.V[n11][n8] = this.V[n11][n8] - f6;
                    this.V[n11][n8 + 1] = this.V[n11][n8 + 1] - f6 * f7;
                }
            }
        }
        if ((double)f11 == 0.0) {
            return;
        }
        for (n5 = n4 - 1; n5 >= 0; --n5) {
            float f12;
            f6 = this.d[n5];
            f7 = this.e[n5];
            if (f7 == 0.0f) {
                n2 = n5;
                this.H[n5][n5] = 1.0f;
                for (n = n5 - 1; n >= 0; --n) {
                    int n12;
                    f3 = this.H[n][n] - f6;
                    f8 = 0.0f;
                    for (n12 = n2; n12 <= n5; ++n12) {
                        f8 += this.H[n][n12] * this.H[n12][n5];
                    }
                    if ((double)this.e[n] < 0.0) {
                        f10 = f3;
                        f9 = f8;
                        continue;
                    }
                    n2 = n;
                    if ((double)this.e[n] == 0.0) {
                        this.H[n][n5] = (double)f3 != 0.0 ? -f8 / f3 : -f8 / (f4 * f11);
                    } else {
                        f2 = this.H[n][n + 1];
                        f = this.H[n + 1][n];
                        f7 = (this.d[n] - f6) * (this.d[n] - f6) + this.e[n] * this.e[n];
                        this.H[n][n5] = f12 = (f2 * f9 - f10 * f8) / f7;
                        this.H[n + 1][n5] = Math.abs(f2) > Math.abs(f10) ? (-f8 - f3 * f12) / f2 : (-f9 - f * f12) / f10;
                    }
                    f12 = Math.abs(this.H[n][n5]);
                    if (!(f4 * f12 * f12 > 1.0f)) continue;
                    for (n12 = n; n12 <= n5; ++n12) {
                        this.H[n12][n5] = this.H[n12][n5] / f12;
                    }
                }
                continue;
            }
            if (!(f7 < 0.0f)) continue;
            n2 = n5 - 1;
            if (Math.abs(this.H[n5][n5 - 1]) > Math.abs(this.H[n5 - 1][n5])) {
                this.H[n5 - 1][n5 - 1] = f7 / this.H[n5][n5 - 1];
                this.H[n5 - 1][n5] = -(this.H[n5][n5] - f6) / this.H[n5][n5 - 1];
            } else {
                this.cdiv(0.0f, -this.H[n5 - 1][n5], this.H[n5 - 1][n5 - 1] - f6, f7);
                this.H[n5 - 1][n5 - 1] = this.cdivr;
                this.H[n5 - 1][n5] = this.cdivi;
            }
            this.H[n5][n5 - 1] = 0.0f;
            this.H[n5][n5] = 1.0f;
            for (n = n5 - 2; n >= 0; --n) {
                int n13;
                float f13 = 0.0f;
                float f14 = 0.0f;
                for (n13 = n2; n13 <= n5; ++n13) {
                    f13 += this.H[n][n13] * this.H[n13][n5 - 1];
                    f14 += this.H[n][n13] * this.H[n13][n5];
                }
                f3 = this.H[n][n] - f6;
                if ((double)this.e[n] < 0.0) {
                    f10 = f3;
                    f8 = f13;
                    f9 = f14;
                    continue;
                }
                n2 = n;
                if (this.e[n] == 0.0f) {
                    this.cdiv(-f13, -f14, f3, f7);
                    this.H[n][n5 - 1] = this.cdivr;
                    this.H[n][n5] = this.cdivi;
                } else {
                    float f15;
                    f2 = this.H[n][n + 1];
                    f = this.H[n + 1][n];
                    float f16 = (this.d[n] - f6) * (this.d[n] - f6) + this.e[n] * this.e[n] - f7 * f7;
                    if ((double)f16 == 0.0 & (double)(f15 = (this.d[n] - f6) * 2.0f * f7) == 0.0) {
                        f16 = f4 * f11 * (Math.abs(f3) + Math.abs(f7) + Math.abs(f2) + Math.abs(f) + Math.abs(f10));
                    }
                    this.cdiv(f2 * f8 - f10 * f13 + f7 * f14, f2 * f9 - f10 * f14 - f7 * f13, f16, f15);
                    this.H[n][n5 - 1] = this.cdivr;
                    this.H[n][n5] = this.cdivi;
                    if (Math.abs(f2) > Math.abs(f10) + Math.abs(f7)) {
                        this.H[n + 1][n5 - 1] = (-f13 - f3 * this.H[n][n5 - 1] + f7 * this.H[n][n5]) / f2;
                        this.H[n + 1][n5] = (-f14 - f3 * this.H[n][n5] - f7 * this.H[n][n5 - 1]) / f2;
                    } else {
                        this.cdiv(-f8 - f * this.H[n][n5 - 1], -f9 - f * this.H[n][n5], f10, f7);
                        this.H[n + 1][n5 - 1] = this.cdivr;
                        this.H[n + 1][n5] = this.cdivi;
                    }
                }
                f12 = Math.max(Math.abs(this.H[n][n5 - 1]), Math.abs(this.H[n][n5]));
                if (!(f4 * f12 * f12 > 1.0f)) continue;
                for (n13 = n; n13 <= n5; ++n13) {
                    this.H[n13][n5 - 1] = this.H[n13][n5 - 1] / f12;
                    this.H[n13][n5] = this.H[n13][n5] / f12;
                }
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (!(n2 < n6 | n2 > n7)) continue;
            for (n = n2; n < n4; ++n) {
                this.V[n2][n] = this.H[n2][n];
            }
        }
        for (n2 = n4 - 1; n2 >= n6; --n2) {
            for (n = n6; n <= n7; ++n) {
                f10 = 0.0f;
                for (int i = n6; i <= Math.min(n2, n7); ++i) {
                    f10 += this.V[n][i] * this.H[i][n2];
                }
                this.V[n][n2] = f10;
            }
        }
    }

    private void orthes() {
        int n;
        int n2 = 0;
        int n3 = this.n - 1;
        for (n = n2 + 1; n <= n3 - 1; ++n) {
            int n4;
            float f;
            int n5;
            float f2 = 0.0f;
            for (int i = n; i <= n3; ++i) {
                f2 += Math.abs(this.H[i][n - 1]);
            }
            if ((double)f2 == 0.0) continue;
            float f3 = 0.0f;
            for (int i = n3; i >= n; --i) {
                this.ort[i] = this.H[i][n - 1] / f2;
                f3 += this.ort[i] * this.ort[i];
            }
            float f4 = (float)Math.sqrt(f3);
            if (this.ort[n] > 0.0f) {
                f4 = -f4;
            }
            f3 -= this.ort[n] * f4;
            this.ort[n] = this.ort[n] - f4;
            for (n5 = n; n5 < this.n; ++n5) {
                f = 0.0f;
                for (n4 = n3; n4 >= n; --n4) {
                    f += this.ort[n4] * this.H[n4][n5];
                }
                f /= f3;
                for (n4 = n; n4 <= n3; ++n4) {
                    float[] fArray = this.H[n4];
                    int n6 = n5;
                    fArray[n6] = fArray[n6] - f * this.ort[n4];
                }
            }
            for (n5 = 0; n5 <= n3; ++n5) {
                f = 0.0f;
                for (n4 = n3; n4 >= n; --n4) {
                    f += this.ort[n4] * this.H[n5][n4];
                }
                f /= f3;
                for (n4 = n; n4 <= n3; ++n4) {
                    float[] fArray = this.H[n5];
                    int n7 = n4;
                    fArray[n7] = fArray[n7] - f * this.ort[n4];
                }
            }
            this.ort[n] = f2 * this.ort[n];
            this.H[n][n - 1] = f2 * f4;
        }
        for (n = 0; n < this.n; ++n) {
            for (int i = 0; i < this.n; ++i) {
                this.V[n][i] = n == i ? 1.0f : 0.0f;
            }
        }
        for (n = n3 - 1; n >= n2 + 1; --n) {
            int n8;
            if ((double)this.H[n][n - 1] == 0.0) continue;
            for (n8 = n + 1; n8 <= n3; ++n8) {
                this.ort[n8] = this.H[n8][n - 1];
            }
            for (n8 = n; n8 <= n3; ++n8) {
                int n9;
                float f = 0.0f;
                for (n9 = n; n9 <= n3; ++n9) {
                    f += this.ort[n9] * this.V[n9][n8];
                }
                f = f / this.ort[n] / this.H[n][n - 1];
                for (n9 = n; n9 <= n3; ++n9) {
                    float[] fArray = this.V[n9];
                    int n10 = n8;
                    fArray[n10] = fArray[n10] + f * this.ort[n9];
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("EigenvalueDecomposition(A) --> D, V, realEigenvalues, imagEigenvalues\n");
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("realEigenvalues = ");
        try {
            stringBuffer.append(String.valueOf(this.getRealEigenvalues()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nimagEigenvalues = ");
        try {
            stringBuffer.append(String.valueOf(this.getImagEigenvalues()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nD = ");
        try {
            stringBuffer.append(String.valueOf(this.getD()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nV = ");
        try {
            stringBuffer.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }

    private void tql2() {
        int n;
        int n2;
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = 0.0f;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = (float)Math.pow(2.0, -23.0);
        for (n2 = 0; n2 < this.n; ++n2) {
            f2 = Math.max(f2, Math.abs(this.d[n2]) + Math.abs(this.e[n2]));
            for (n = n2; n < this.n && !(Math.abs(this.e[n]) <= f3 * f2); ++n) {
            }
            if (n > n2) {
                int n3 = 0;
                do {
                    float f4;
                    ++n3;
                    float f5 = this.d[n2];
                    float f6 = (float)((double)(this.d[n2 + 1] - f5) / (2.0 * (double)this.e[n2]));
                    float f7 = FloatAlgebra.hypot(f6, 1.0f);
                    if (f6 < 0.0f) {
                        f7 = -f7;
                    }
                    this.d[n2] = this.e[n2] / (f6 + f7);
                    this.d[n2 + 1] = this.e[n2] * (f6 + f7);
                    float f8 = this.d[n2 + 1];
                    float f9 = f5 - this.d[n2];
                    int n4 = n2 + 2;
                    while (n4 < this.n) {
                        int n5 = n4++;
                        this.d[n5] = this.d[n5] - f9;
                    }
                    f += f9;
                    f6 = this.d[n];
                    float f10 = f4 = 1.0f;
                    float f11 = f4;
                    float f12 = this.e[n2 + 1];
                    float f13 = 0.0f;
                    float f14 = 0.0f;
                    for (int i = n - 1; i >= n2; --i) {
                        f11 = f10;
                        f10 = f4;
                        f14 = f13;
                        f5 = f4 * this.e[i];
                        f9 = f4 * f6;
                        f7 = FloatAlgebra.hypot(f6, this.e[i]);
                        this.e[i + 1] = f13 * f7;
                        f13 = this.e[i] / f7;
                        f4 = f6 / f7;
                        f6 = f4 * this.d[i] - f13 * f5;
                        this.d[i + 1] = f9 + f13 * (f4 * f5 + f13 * this.d[i]);
                        for (int j = 0; j < this.n; ++j) {
                            f9 = this.V[j][i + 1];
                            this.V[j][i + 1] = f13 * this.V[j][i] + f4 * f9;
                            this.V[j][i] = f4 * this.V[j][i] - f13 * f9;
                        }
                    }
                    f6 = -f13 * f14 * f11 * f12 * this.e[n2] / f8;
                    this.e[n2] = f13 * f6;
                    this.d[n2] = f4 * f6;
                } while (Math.abs(this.e[n2]) > f3 * f2);
            }
            this.d[n2] = this.d[n2] + f;
            this.e[n2] = 0.0f;
        }
        for (n2 = 0; n2 < this.n - 1; ++n2) {
            int n6;
            n = n2;
            float f15 = this.d[n2];
            for (n6 = n2 + 1; n6 < this.n; ++n6) {
                if (!(this.d[n6] < f15)) continue;
                n = n6;
                f15 = this.d[n6];
            }
            if (n == n2) continue;
            this.d[n] = this.d[n2];
            this.d[n2] = f15;
            for (n6 = 0; n6 < this.n; ++n6) {
                f15 = this.V[n6][n2];
                this.V[n6][n2] = this.V[n6][n];
                this.V[n6][n] = f15;
            }
        }
    }

    private void tred2() {
        float f;
        int n;
        for (n = 0; n < this.n; ++n) {
            this.d[n] = this.V[this.n - 1][n];
        }
        for (n = this.n - 1; n > 0; --n) {
            int n2;
            f = 0.0f;
            float f2 = 0.0f;
            for (n2 = 0; n2 < n; ++n2) {
                f += Math.abs(this.d[n2]);
            }
            if ((double)f == 0.0) {
                this.e[n] = this.d[n - 1];
                for (n2 = 0; n2 < n; ++n2) {
                    this.d[n2] = this.V[n - 1][n2];
                    this.V[n][n2] = 0.0f;
                    this.V[n2][n] = 0.0f;
                }
            } else {
                int n3;
                int n4;
                for (n2 = 0; n2 < n; ++n2) {
                    int n5 = n2;
                    this.d[n5] = this.d[n5] / f;
                    f2 += this.d[n2] * this.d[n2];
                }
                float f3 = this.d[n - 1];
                float f4 = (float)Math.sqrt(f2);
                if (f3 > 0.0f) {
                    f4 = -f4;
                }
                this.e[n] = f * f4;
                f2 -= f3 * f4;
                this.d[n - 1] = f3 - f4;
                for (n4 = 0; n4 < n; ++n4) {
                    this.e[n4] = 0.0f;
                }
                for (n4 = 0; n4 < n; ++n4) {
                    this.V[n4][n] = f3 = this.d[n4];
                    f4 = this.e[n4] + this.V[n4][n4] * f3;
                    for (n3 = n4 + 1; n3 <= n - 1; ++n3) {
                        f4 += this.V[n3][n4] * this.d[n3];
                        int n6 = n3;
                        this.e[n6] = this.e[n6] + this.V[n3][n4] * f3;
                    }
                    this.e[n4] = f4;
                }
                f3 = 0.0f;
                for (n4 = 0; n4 < n; ++n4) {
                    int n7 = n4;
                    this.e[n7] = this.e[n7] / f2;
                    f3 += this.e[n4] * this.d[n4];
                }
                float f5 = f3 / (f2 + f2);
                for (n3 = 0; n3 < n; ++n3) {
                    int n8 = n3;
                    this.e[n8] = this.e[n8] - f5 * this.d[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    f3 = this.d[n3];
                    f4 = this.e[n3];
                    for (int i = n3; i <= n - 1; ++i) {
                        float[] fArray = this.V[i];
                        int n9 = n3;
                        fArray[n9] = fArray[n9] - (f3 * this.e[i] + f4 * this.d[i]);
                    }
                    this.d[n3] = this.V[n - 1][n3];
                    this.V[n][n3] = 0.0f;
                }
            }
            this.d[n] = f2;
        }
        for (n = 0; n < this.n - 1; ++n) {
            int n10;
            this.V[this.n - 1][n] = this.V[n][n];
            this.V[n][n] = 1.0f;
            f = this.d[n + 1];
            if ((double)f != 0.0) {
                for (n10 = 0; n10 <= n; ++n10) {
                    this.d[n10] = this.V[n10][n + 1] / f;
                }
                for (n10 = 0; n10 <= n; ++n10) {
                    int n11;
                    float f6 = 0.0f;
                    for (n11 = 0; n11 <= n; ++n11) {
                        f6 += this.V[n11][n + 1] * this.V[n11][n10];
                    }
                    for (n11 = 0; n11 <= n; ++n11) {
                        float[] fArray = this.V[n11];
                        int n12 = n10;
                        fArray[n12] = fArray[n12] - f6 * this.d[n11];
                    }
                }
            }
            for (n10 = 0; n10 <= n; ++n10) {
                this.V[n10][n + 1] = 0.0f;
            }
        }
        for (n = 0; n < this.n; ++n) {
            this.d[n] = this.V[this.n - 1][n];
            this.V[this.n - 1][n] = 0.0f;
        }
        this.V[this.n - 1][this.n - 1] = 1.0f;
        this.e[0] = 0.0f;
    }
}

