/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import java.io.Serializable;

public class FloatSingularValueDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private float[][] U;
    private float[][] V;
    private float[] s;
    private int m;
    private int n;

    public FloatSingularValueDecomposition(FloatMatrix2D floatMatrix2D) {
        int n;
        int n2;
        int n3;
        FloatProperty.DEFAULT.checkRectangular(floatMatrix2D);
        float[][] fArray = floatMatrix2D.toArray();
        this.m = floatMatrix2D.rows();
        this.n = floatMatrix2D.columns();
        int n4 = Math.min(this.m, this.n);
        this.s = new float[Math.min(this.m + 1, this.n)];
        this.U = new float[this.m][n4];
        this.V = new float[this.n][this.n];
        float[] fArray2 = new float[this.n];
        float[] fArray3 = new float[this.m];
        boolean bl = true;
        boolean bl2 = true;
        int n5 = Math.min(this.m - 1, this.n);
        int n6 = Math.max(0, Math.min(this.n - 2, this.m));
        int n7 = Math.max(n5, n6);
        for (n3 = 0; n3 < n7; ++n3) {
            int n8;
            if (n3 < n5) {
                this.s[n3] = 0.0f;
                for (n2 = n3; n2 < this.m; ++n2) {
                    this.s[n3] = FloatAlgebra.hypot(this.s[n3], fArray[n2][n3]);
                }
                if ((double)this.s[n3] != 0.0) {
                    if ((double)fArray[n3][n3] < 0.0) {
                        this.s[n3] = -this.s[n3];
                    }
                    for (n2 = n3; n2 < this.m; ++n2) {
                        float[] fArray4 = fArray[n2];
                        int n9 = n3;
                        fArray4[n9] = fArray4[n9] / this.s[n3];
                    }
                    float[] fArray5 = fArray[n3];
                    int n10 = n3;
                    fArray5[n10] = (float)((double)fArray5[n10] + 1.0);
                }
                this.s[n3] = -this.s[n3];
            }
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                if (n3 < n5 & (double)this.s[n3] != 0.0) {
                    float f = 0.0f;
                    for (n8 = n3; n8 < this.m; ++n8) {
                        f += fArray[n8][n3] * fArray[n8][n2];
                    }
                    f = -f / fArray[n3][n3];
                    for (n8 = n3; n8 < this.m; ++n8) {
                        float[] fArray6 = fArray[n8];
                        int n11 = n2;
                        fArray6[n11] = fArray6[n11] + f * fArray[n8][n3];
                    }
                }
                fArray2[n2] = fArray[n3][n2];
            }
            if (bl & n3 < n5) {
                for (n2 = n3; n2 < this.m; ++n2) {
                    this.U[n2][n3] = fArray[n2][n3];
                }
            }
            if (n3 >= n6) continue;
            fArray2[n3] = 0.0f;
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                fArray2[n3] = FloatAlgebra.hypot(fArray2[n3], fArray2[n2]);
            }
            if ((double)fArray2[n3] != 0.0) {
                if ((double)fArray2[n3 + 1] < 0.0) {
                    fArray2[n3] = -fArray2[n3];
                }
                n2 = n3 + 1;
                while (n2 < this.n) {
                    int n12 = n2++;
                    fArray2[n12] = fArray2[n12] / fArray2[n3];
                }
                int n13 = n3 + 1;
                fArray2[n13] = (float)((double)fArray2[n13] + 1.0);
            }
            fArray2[n3] = -fArray2[n3];
            if (n3 + 1 < this.m & (double)fArray2[n3] != 0.0) {
                for (n2 = n3 + 1; n2 < this.m; ++n2) {
                    fArray3[n2] = 0.0f;
                }
                for (n2 = n3 + 1; n2 < this.n; ++n2) {
                    for (int i = n3 + 1; i < this.m; ++i) {
                        int n14 = i;
                        fArray3[n14] = fArray3[n14] + fArray2[n2] * fArray[i][n2];
                    }
                }
                for (n2 = n3 + 1; n2 < this.n; ++n2) {
                    float f = -fArray2[n2] / fArray2[n3 + 1];
                    for (n8 = n3 + 1; n8 < this.m; ++n8) {
                        float[] fArray7 = fArray[n8];
                        int n15 = n2;
                        fArray7[n15] = fArray7[n15] + f * fArray3[n8];
                    }
                }
            }
            if (!bl2) continue;
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                this.V[n2][n3] = fArray2[n2];
            }
        }
        n3 = Math.min(this.n, this.m + 1);
        if (n5 < this.n) {
            this.s[n5] = fArray[n5][n5];
        }
        if (this.m < n3) {
            this.s[n3 - 1] = 0.0f;
        }
        if (n6 + 1 < n3) {
            fArray2[n6] = fArray[n6][n3 - 1];
        }
        fArray2[n3 - 1] = 0.0f;
        if (bl) {
            for (n2 = n5; n2 < n4; ++n2) {
                for (int i = 0; i < this.m; ++i) {
                    this.U[i][n2] = 0.0f;
                }
                this.U[n2][n2] = 1.0f;
            }
            for (n2 = n5 - 1; n2 >= 0; --n2) {
                int n16;
                if ((double)this.s[n2] != 0.0) {
                    for (n16 = n2 + 1; n16 < n4; ++n16) {
                        float f = 0.0f;
                        for (n = n2; n < this.m; ++n) {
                            f += this.U[n][n2] * this.U[n][n16];
                        }
                        f = -f / this.U[n2][n2];
                        for (n = n2; n < this.m; ++n) {
                            float[] fArray8 = this.U[n];
                            int n17 = n16;
                            fArray8[n17] = fArray8[n17] + f * this.U[n][n2];
                        }
                    }
                    for (n16 = n2; n16 < this.m; ++n16) {
                        this.U[n16][n2] = -this.U[n16][n2];
                    }
                    this.U[n2][n2] = 1.0f + this.U[n2][n2];
                    for (n16 = 0; n16 < n2 - 1; ++n16) {
                        this.U[n16][n2] = 0.0f;
                    }
                    continue;
                }
                for (n16 = 0; n16 < this.m; ++n16) {
                    this.U[n16][n2] = 0.0f;
                }
                this.U[n2][n2] = 1.0f;
            }
        }
        if (bl2) {
            for (n2 = this.n - 1; n2 >= 0; --n2) {
                int n18;
                if (n2 < n6 & (double)fArray2[n2] != 0.0) {
                    for (n18 = n2 + 1; n18 < n4; ++n18) {
                        float f = 0.0f;
                        for (n = n2 + 1; n < this.n; ++n) {
                            f += this.V[n][n2] * this.V[n][n18];
                        }
                        f = -f / this.V[n2 + 1][n2];
                        for (n = n2 + 1; n < this.n; ++n) {
                            float[] fArray9 = this.V[n];
                            int n19 = n18;
                            fArray9[n19] = fArray9[n19] + f * this.V[n][n2];
                        }
                    }
                }
                for (n18 = 0; n18 < this.n; ++n18) {
                    this.V[n18][n2] = 0.0f;
                }
                this.V[n2][n2] = 1.0f;
            }
        }
        n2 = n3 - 1;
        int n20 = 0;
        float f = (float)Math.pow(2.0, -23.0);
        block35: while (n3 > 0) {
            float f2;
            int n21;
            int n22;
            for (n = n3 - 2; n >= -1 && n != -1; --n) {
                if (!(Math.abs(fArray2[n]) <= f * (Math.abs(this.s[n]) + Math.abs(this.s[n + 1])))) continue;
                fArray2[n] = 0.0f;
                break;
            }
            if (n == n3 - 2) {
                n22 = 4;
            } else {
                for (n21 = n3 - 1; n21 >= n && n21 != n; --n21) {
                    f2 = (float)((n21 != n3 ? (double)Math.abs(fArray2[n21]) : 0.0) + (n21 != n + 1 ? (double)Math.abs(fArray2[n21 - 1]) : 0.0));
                    if (!(Math.abs(this.s[n21]) <= f * f2)) continue;
                    this.s[n21] = 0.0f;
                    break;
                }
                if (n21 == n) {
                    n22 = 3;
                } else if (n21 == n3 - 1) {
                    n22 = 1;
                } else {
                    n22 = 2;
                    n = n21;
                }
            }
            ++n;
            switch (n22) {
                case 1: {
                    float f3;
                    float f4;
                    float f5;
                    float f6 = fArray2[n3 - 2];
                    fArray2[n3 - 2] = 0.0f;
                    for (int i = n3 - 2; i >= n; --i) {
                        f5 = FloatAlgebra.hypot(this.s[i], f6);
                        f4 = this.s[i] / f5;
                        f3 = f6 / f5;
                        this.s[i] = f5;
                        if (i != n) {
                            f6 = -f3 * fArray2[i - 1];
                            fArray2[i - 1] = f4 * fArray2[i - 1];
                        }
                        if (!bl2) continue;
                        for (int j = 0; j < this.n; ++j) {
                            f5 = f4 * this.V[j][i] + f3 * this.V[j][n3 - 1];
                            this.V[j][n3 - 1] = -f3 * this.V[j][i] + f4 * this.V[j][n3 - 1];
                            this.V[j][i] = f5;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    float f3;
                    float f4;
                    float f5;
                    float f7 = fArray2[n - 1];
                    fArray2[n - 1] = 0.0f;
                    for (int i = n; i < n3; ++i) {
                        f5 = FloatAlgebra.hypot(this.s[i], f7);
                        f4 = this.s[i] / f5;
                        f3 = f7 / f5;
                        this.s[i] = f5;
                        f7 = -f3 * fArray2[i];
                        fArray2[i] = f4 * fArray2[i];
                        if (!bl) continue;
                        for (int j = 0; j < this.m; ++j) {
                            f5 = f4 * this.U[j][i] + f3 * this.U[j][n - 1];
                            this.U[j][n - 1] = -f3 * this.U[j][i] + f4 * this.U[j][n - 1];
                            this.U[j][i] = f5;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    float f8 = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[n3 - 1]), Math.abs(this.s[n3 - 2])), Math.abs(fArray2[n3 - 2])), Math.abs(this.s[n])), Math.abs(fArray2[n]));
                    f2 = this.s[n3 - 1] / f8;
                    float f5 = this.s[n3 - 2] / f8;
                    float f4 = fArray2[n3 - 2] / f8;
                    float f3 = this.s[n] / f8;
                    float f9 = fArray2[n] / f8;
                    float f10 = (float)((double)((f5 + f2) * (f5 - f2) + f4 * f4) / 2.0);
                    float f11 = f2 * f4 * (f2 * f4);
                    float f12 = 0.0f;
                    if ((double)f10 != 0.0 | (double)f11 != 0.0) {
                        f12 = (float)Math.sqrt(f10 * f10 + f11);
                        if ((double)f10 < 0.0) {
                            f12 = -f12;
                        }
                        f12 = f11 / (f10 + f12);
                    }
                    float f13 = (f3 + f2) * (f3 - f2) + f12;
                    float f14 = f3 * f9;
                    for (int i = n; i < n3 - 1; ++i) {
                        int n23;
                        float f15 = FloatAlgebra.hypot(f13, f14);
                        float f16 = f13 / f15;
                        float f17 = f14 / f15;
                        if (i != n) {
                            fArray2[i - 1] = f15;
                        }
                        f13 = f16 * this.s[i] + f17 * fArray2[i];
                        fArray2[i] = f16 * fArray2[i] - f17 * this.s[i];
                        f14 = f17 * this.s[i + 1];
                        this.s[i + 1] = f16 * this.s[i + 1];
                        if (bl2) {
                            for (n23 = 0; n23 < this.n; ++n23) {
                                f15 = f16 * this.V[n23][i] + f17 * this.V[n23][i + 1];
                                this.V[n23][i + 1] = -f17 * this.V[n23][i] + f16 * this.V[n23][i + 1];
                                this.V[n23][i] = f15;
                            }
                        }
                        f15 = FloatAlgebra.hypot(f13, f14);
                        f16 = f13 / f15;
                        f17 = f14 / f15;
                        this.s[i] = f15;
                        f13 = f16 * fArray2[i] + f17 * this.s[i + 1];
                        this.s[i + 1] = -f17 * fArray2[i] + f16 * this.s[i + 1];
                        f14 = f17 * fArray2[i + 1];
                        fArray2[i + 1] = f16 * fArray2[i + 1];
                        if (!bl || i >= this.m - 1) continue;
                        for (n23 = 0; n23 < this.m; ++n23) {
                            f15 = f16 * this.U[n23][i] + f17 * this.U[n23][i + 1];
                            this.U[n23][i + 1] = -f17 * this.U[n23][i] + f16 * this.U[n23][i + 1];
                            this.U[n23][i] = f15;
                        }
                    }
                    fArray2[n3 - 2] = f13;
                    ++n20;
                    break;
                }
                case 4: {
                    if ((double)this.s[n] <= 0.0) {
                        float f18 = this.s[n] = this.s[n] < 0.0f ? -this.s[n] : 0.0f;
                        if (bl2) {
                            for (n21 = 0; n21 <= n2; ++n21) {
                                this.V[n21][n] = -this.V[n21][n];
                            }
                        }
                    }
                    while (n < n2 && !(this.s[n] >= this.s[n + 1])) {
                        float f19 = this.s[n];
                        this.s[n] = this.s[n + 1];
                        this.s[n + 1] = f19;
                        if (bl2 && n < this.n - 1) {
                            for (int i = 0; i < this.n; ++i) {
                                f19 = this.V[i][n + 1];
                                this.V[i][n + 1] = this.V[i][n];
                                this.V[i][n] = f19;
                            }
                        }
                        if (bl && n < this.m - 1) {
                            for (int i = 0; i < this.m; ++i) {
                                f19 = this.U[i][n + 1];
                                this.U[i][n + 1] = this.U[i][n];
                                this.U[i][n] = f19;
                            }
                        }
                        ++n;
                    }
                    n20 = 0;
                    --n3;
                }
            }
        }
    }

    public float cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public FloatMatrix2D getS() {
        float[][] fArray = new float[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                fArray[i][j] = 0.0f;
            }
            fArray[i][i] = this.s[i];
        }
        return FloatFactory2D.dense.make(fArray);
    }

    public float[] getSingularValues() {
        return this.s;
    }

    public FloatMatrix2D getU() {
        return FloatFactory2D.dense.make(this.U).viewPart(0, 0, this.m, Math.min(this.m + 1, this.n));
    }

    public FloatMatrix2D getV() {
        return FloatFactory2D.dense.make(this.V);
    }

    public float norm2() {
        return this.s[0];
    }

    public int rank() {
        float f = (float)Math.pow(2.0, -23.0);
        float f2 = (float)Math.max(this.m, this.n) * this.s[0] * f;
        int n = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > f2)) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("SingularValueDecomposition(A) --> cond(A), rank(A), norm2(A), U, S, V\n");
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("cond = ");
        try {
            stringBuffer.append(String.valueOf(this.cond()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nrank = ");
        try {
            stringBuffer.append(String.valueOf(this.rank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nnorm2 = ");
        try {
            stringBuffer.append(String.valueOf(this.norm2()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nU = ");
        try {
            stringBuffer.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nS = ");
        try {
            stringBuffer.append(String.valueOf(this.getS()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nV = ");
        try {
            stringBuffer.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

