/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import org.netlib.lapack.Sgesdd;
import org.netlib.util.intW;

public class FloatSingularValueDecompositionDC {
    private float[] Ut;
    private float[] V;
    private float[] s;
    private intW info;
    private int m;
    private int n;
    private int minmn;
    private boolean wantWholeUV;
    private boolean wantUV;

    public FloatSingularValueDecompositionDC(FloatMatrix2D floatMatrix2D, boolean bl, boolean bl2) {
        this.wantUV = bl;
        this.wantWholeUV = bl2;
        this.m = floatMatrix2D.rows();
        this.n = floatMatrix2D.columns();
        float[] fArray = (float[])floatMatrix2D.viewDice().copy().elements();
        this.minmn = Math.min(this.m, this.n);
        int n = Math.max(this.m, this.n);
        this.info = new intW(2);
        int[] nArray = new int[8 * this.minmn];
        this.s = new float[this.minmn];
        bl = true;
        if (true) {
            if (bl2) {
                this.Ut = new float[this.m * this.m];
                this.V = new float[this.n * this.n];
                int n2 = 3 * this.minmn * this.minmn + Math.max(n, 4 * this.minmn * this.minmn + 4 * this.minmn) + n;
                float[] fArray2 = new float[n2];
                Sgesdd.sgesdd((String)"A", (int)this.m, (int)this.n, (float[])fArray, (int)0, (int)this.m, (float[])this.s, (int)0, (float[])this.Ut, (int)0, (int)this.m, (float[])this.V, (int)0, (int)this.n, (float[])fArray2, (int)0, (int)n2, (int[])nArray, (int)0, (intW)this.info);
            } else {
                this.Ut = new float[this.m * this.minmn];
                this.V = new float[this.minmn * this.n];
                int n3 = 3 * this.minmn * this.minmn + Math.max(n, 4 * this.minmn * this.minmn + 4 * this.minmn) + n;
                float[] fArray3 = new float[n3];
                Sgesdd.sgesdd((String)"S", (int)this.m, (int)this.n, (float[])fArray, (int)0, (int)this.m, (float[])this.s, (int)0, (float[])this.Ut, (int)0, (int)this.m, (float[])this.V, (int)0, (int)this.minmn, (float[])fArray3, (int)0, (int)n3, (int[])nArray, (int)0, (intW)this.info);
            }
        } else {
            int n4 = 3 * this.minmn + Math.max(n, 6 * this.minmn) + n;
            float[] fArray4 = new float[n4];
            Sgesdd.sgesdd((String)"N", (int)this.m, (int)this.n, (float[])fArray, (int)0, (int)this.m, (float[])this.s, (int)0, null, (int)0, (int)this.m, null, (int)0, (int)this.n, (float[])fArray4, (int)0, (int)n4, (int[])nArray, (int)0, (intW)this.info);
        }
    }

    public float cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public FloatMatrix2D getS() {
        DenseFloatMatrix2D denseFloatMatrix2D = !this.wantWholeUV ? new DenseFloatMatrix2D(this.minmn, this.minmn) : new DenseFloatMatrix2D(this.m, this.n);
        for (int i = 0; i < this.s.length; ++i) {
            ((FloatMatrix2D)denseFloatMatrix2D).setQuick(i, i, this.s[i]);
        }
        return denseFloatMatrix2D;
    }

    public float[] getSingularValues() {
        return this.s;
    }

    public FloatMatrix2D getU() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix U was not computed");
        }
        if (!this.wantWholeUV) {
            return new DenseFloatMatrix2D(this.minmn, this.m).assign(this.Ut).viewDice().copy();
        }
        return new DenseFloatMatrix2D(this.m, this.m).assign(this.Ut).viewDice().copy();
    }

    public FloatMatrix2D getUt() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix Ut was not computed");
        }
        if (!this.wantWholeUV) {
            return new DenseFloatMatrix2D(this.m, this.minmn).assign(this.Ut);
        }
        return new DenseFloatMatrix2D(this.m, this.m).assign(this.Ut);
    }

    public FloatMatrix2D getVt() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix Vt was not computed");
        }
        if (!this.wantWholeUV) {
            return new DenseFloatMatrix2D(this.minmn, this.n).assign(this.V).viewDice().copy();
        }
        return new DenseFloatMatrix2D(this.n, this.n).assign(this.V).viewDice().copy();
    }

    public FloatMatrix2D getV() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix V was not computed");
        }
        if (!this.wantWholeUV) {
            return new DenseFloatMatrix2D(this.n, this.minmn).assign(this.V);
        }
        return new DenseFloatMatrix2D(this.n, this.n).assign(this.V);
    }

    public intW getInfo() {
        return this.info;
    }

    public float norm2() {
        return this.s[0];
    }

    public int rank() {
        float f = (float)Math.pow(2.0, -23.0);
        float f2 = (float)Math.max(this.m, this.n) * this.s[0] * f;
        int n = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > f2)) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("SingularValueDecomposition(A) --> cond(A), rank(A), norm2(A), U, S, V\n");
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("cond = ");
        try {
            stringBuffer.append(String.valueOf(this.cond()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nrank = ");
        try {
            stringBuffer.append(String.valueOf(this.rank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nnorm2 = ");
        try {
            stringBuffer.append(String.valueOf(this.norm2()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nU = ");
        try {
            stringBuffer.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nS = ");
        try {
            stringBuffer.append(String.valueOf(this.getS()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nV = ");
        try {
            stringBuffer.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

