/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.FloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.FloatIterationReporter;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.NoFloatIterationReporter;

public abstract class AbstractFloatIterationMonitor
implements FloatIterationMonitor {
    protected int iter;
    protected Norm normType = Norm.Two;
    protected FloatIterationReporter reporter = new NoFloatIterationReporter();
    protected float residual;

    public void setFirst() {
        this.iter = 0;
    }

    public boolean isFirst() {
        return this.iter == 0;
    }

    public void next() {
        ++this.iter;
    }

    public int iterations() {
        return this.iter;
    }

    public boolean converged(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        return this.converged(FloatAlgebra.DEFAULT.norm(floatMatrix1D, this.normType), floatMatrix1D2);
    }

    public boolean converged(float f, FloatMatrix1D floatMatrix1D) throws IterativeSolverFloatNotConvergedException {
        this.reporter.monitor(f, floatMatrix1D, this.iter);
        this.residual = f;
        return this.convergedI(f, floatMatrix1D);
    }

    public boolean converged(float f) throws IterativeSolverFloatNotConvergedException {
        this.reporter.monitor(f, this.iter);
        this.residual = f;
        return this.convergedI(f);
    }

    protected abstract boolean convergedI(float var1, FloatMatrix1D var2) throws IterativeSolverFloatNotConvergedException;

    protected abstract boolean convergedI(float var1) throws IterativeSolverFloatNotConvergedException;

    public boolean converged(FloatMatrix1D floatMatrix1D) throws IterativeSolverFloatNotConvergedException {
        return this.converged(FloatAlgebra.DEFAULT.norm(floatMatrix1D, this.normType));
    }

    public Norm getNormType() {
        return this.normType;
    }

    public void setNormType(Norm norm) {
        this.normType = norm;
    }

    public FloatIterationReporter getIterationReporter() {
        return this.reporter;
    }

    public void setIterationReporter(FloatIterationReporter floatIterationReporter) {
        this.reporter = floatIterationReporter;
    }

    public float residual() {
        return this.residual;
    }
}

