/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;

public class DefaultFloatIterationMonitor
extends AbstractFloatIterationMonitor {
    float initR;
    float rtol;
    float atol;
    float dtol;
    int maxIter;

    public DefaultFloatIterationMonitor(int n, float f, float f2, float f3) {
        this.maxIter = n;
        this.rtol = f;
        this.atol = f2;
        this.dtol = f3;
    }

    public DefaultFloatIterationMonitor() {
        this.maxIter = 100000;
        this.rtol = 1.0E-5f;
        this.atol = 1.0E-25f;
        this.dtol = 100000.0f;
    }

    public void setMaxIterations(int n) {
        this.maxIter = n;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setRelativeTolerance(float f) {
        this.rtol = f;
    }

    public float getRelativeTolerance() {
        return this.rtol;
    }

    public void setAbsoluteTolerance(float f) {
        this.atol = f;
    }

    public float getAbsoluteTolerance() {
        return this.atol;
    }

    public void setDivergenceTolerance(float f) {
        this.dtol = f;
    }

    public float getDivergenceTolerance() {
        return this.dtol;
    }

    protected boolean convergedI(float f) throws IterativeSolverFloatNotConvergedException {
        if (this.isFirst()) {
            this.initR = f;
        }
        if (f < Math.max(this.rtol * this.initR, this.atol)) {
            return true;
        }
        if (f > this.dtol * this.initR) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Iterations, this);
        }
        if (Float.isNaN(f)) {
            throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    protected boolean convergedI(float f, FloatMatrix1D floatMatrix1D) throws IterativeSolverFloatNotConvergedException {
        return this.convergedI(f);
    }
}

