/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatChebyshev
extends AbstractFloatIterativeSolver {
    private float eigmin;
    private float eigmax;
    private FloatMatrix1D p;
    private FloatMatrix1D z;
    private FloatMatrix1D r;
    private FloatMatrix1D q;

    public FloatChebyshev(FloatMatrix1D floatMatrix1D, float f, float f2) {
        this.p = floatMatrix1D.copy();
        this.z = floatMatrix1D.copy();
        this.r = floatMatrix1D.copy();
        this.q = floatMatrix1D.copy();
        this.setEigenvalues(f, f2);
    }

    public void setEigenvalues(float f, float f2) {
        this.eigmin = f;
        this.eigmax = f2;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("eigmin <= 0");
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("eigmax <= 0");
        }
        if (f > f2) {
            throw new IllegalArgumentException("eigmin > eigmax");
        }
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(floatMatrix2D, floatMatrix1D, floatMatrix1D2);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        floatMatrix2D.zMult(floatMatrix1D2, this.r.assign(floatMatrix1D), -1.0f, 1.0f, false);
        f3 = (this.eigmax - this.eigmin) / 2.0f;
        f4 = (this.eigmax + this.eigmin) / 2.0f;
        this.iter.setFirst();
        while (!this.iter.converged(this.r, floatMatrix1D2)) {
            this.M.apply(this.r, this.z);
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
                f = (float)(2.0 / (double)f4);
            } else {
                f2 = (float)((double)(f * f3) / 2.0);
                f2 *= f2;
                f = (float)(1.0 / (double)(f4 - f2));
                this.p.assign(this.z, FloatFunctions.plusMultFirst(f2));
            }
            floatMatrix2D.zMult(this.p, this.q);
            floatMatrix1D2.assign(this.p, FloatFunctions.plusMultSecond(f));
            this.r.assign(this.q, FloatFunctions.plusMultSecond(-f));
            this.iter.next();
        }
        return floatMatrix1D2;
    }
}

