/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.matrix.tdouble.algo.solver.HyBRInnerSolver;
import cern.colt.matrix.tdouble.algo.solver.HyBRRegularizationMethod;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.decomposition.FloatSingularValueDecompositionDC;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.HyBRFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatIdentity;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseColFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.stat.tfloat.FloatDescriptive;
import optimization.FloatFmin;
import optimization.FloatFmin_methods;

public class FloatHyBR
extends AbstractFloatIterativeSolver {
    private HyBRInnerSolver innerSolver;
    private HyBRRegularizationMethod regMethod;
    private float regPar;
    private float omega;
    private boolean reorth;
    private int begReg;
    private float flatTol;
    private boolean computeRnrm;
    private static final FloatAlgebra alg = FloatAlgebra.DEFAULT;
    private static final float FMIN_TOL = 1.0E-4f;

    public FloatHyBR() {
        this(HyBRInnerSolver.TIKHONOV, HyBRRegularizationMethod.ADAPTWGCV, 0.0f, 0.0f, false, 2, 1.0E-6f, false);
    }

    public FloatHyBR(HyBRInnerSolver hyBRInnerSolver, HyBRRegularizationMethod hyBRRegularizationMethod, float f, float f2, boolean bl, int n, float f3, boolean bl2) {
        this.innerSolver = hyBRInnerSolver;
        this.regMethod = hyBRRegularizationMethod;
        if ((double)f < 0.0 || (double)f > 1.0) {
            throw new IllegalArgumentException("regularizationParameter must be a number between 0 and 1.");
        }
        this.regPar = f;
        if ((double)f2 < 0.0) {
            throw new IllegalArgumentException("omega must be a nonnegative number.");
        }
        this.omega = f2;
        this.reorth = bl;
        if (n < 2) {
            throw new IllegalArgumentException("beginRegularization must be greater or equal 2");
        }
        this.begReg = n;
        if ((double)f3 < 0.0) {
            throw new IllegalArgumentException("flatTolerance must be a nonnegative number.");
        }
        this.flatTol = f3;
        this.computeRnrm = bl2;
        this.iter = new HyBRFloatIterationMonitor();
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        FloatLBD floatLBD;
        float f;
        FloatMatrix1D floatMatrix1D3;
        if (!(this.iter instanceof HyBRFloatIterationMonitor)) {
            this.iter = new HyBRFloatIterationMonitor();
        }
        this.checkSizes(floatMatrix2D, floatMatrix1D, floatMatrix1D2);
        int n = floatMatrix2D.columns();
        boolean bl = false;
        boolean bl2 = false;
        float f2 = -1.0f;
        int n2 = 0;
        HyBRInnerSolver hyBRInnerSolver = HyBRInnerSolver.NONE;
        FloatMatrix1D floatMatrix1D4 = null;
        DenseFloatMatrix1D denseFloatMatrix1D = null;
        FloatArrayList floatArrayList = new FloatArrayList(new float[this.begReg - 2]);
        FloatArrayList floatArrayList2 = new FloatArrayList(new float[this.begReg - 2]);
        FloatMatrix2D floatMatrix2D2 = new DenseFloatMatrix2D(1, floatMatrix1D.size());
        FloatMatrix2D floatMatrix2D3 = null;
        FloatMatrix2D floatMatrix2D4 = null;
        if (this.computeRnrm) {
            floatMatrix1D3 = floatMatrix1D.copy();
            floatMatrix2D.zMult(floatMatrix1D2, floatMatrix1D3, -1.0f, 1.0f, false);
            f2 = alg.norm2(floatMatrix1D3);
        }
        if (this.M instanceof FloatIdentity) {
            f = alg.norm2(floatMatrix1D);
            floatMatrix2D2.viewRow(0).assign(floatMatrix1D, FloatFunctions.multSecond((float)(1.0 / (double)f)));
            floatLBD = new FloatSimpleLBD(floatMatrix2D, floatMatrix2D2, this.reorth);
        } else {
            floatMatrix1D3 = new DenseFloatMatrix1D(floatMatrix1D.size());
            floatMatrix1D3 = this.M.apply(floatMatrix1D, floatMatrix1D3);
            f = alg.norm2(floatMatrix1D3);
            floatMatrix2D2.viewRow(0).assign(floatMatrix1D3, FloatFunctions.multSecond((float)(1.0 / (double)f)));
            floatLBD = new FloatPLBD(this.M, floatMatrix2D, floatMatrix2D2, this.reorth);
        }
        this.iter.setFirst();
        while (!this.iter.converged(f2, floatMatrix1D2)) {
            floatLBD.apply();
            floatMatrix2D2 = floatLBD.getU();
            floatMatrix2D3 = floatLBD.getB();
            floatMatrix2D4 = floatLBD.getV();
            DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(floatMatrix2D2.rows());
            ((FloatMatrix1D)denseFloatMatrix1D2).setQuick(0, f);
            int n3 = this.iter.iterations();
            if (n3 >= 1) {
                if (n3 >= this.begReg - 1) {
                    hyBRInnerSolver = this.innerSolver;
                }
                switch (hyBRInnerSolver) {
                    case TIKHONOV: {
                        FloatSingularValueDecompositionDC floatSingularValueDecompositionDC = alg.svdDC(floatMatrix2D3);
                        FloatMatrix2D floatMatrix2D5 = floatSingularValueDecompositionDC.getU();
                        float[] fArray = floatSingularValueDecompositionDC.getSingularValues();
                        FloatMatrix2D floatMatrix2D6 = floatSingularValueDecompositionDC.getV();
                        if (this.regMethod == HyBRRegularizationMethod.ADAPTWGCV) {
                            floatMatrix1D3 = new DenseFloatMatrix1D(floatMatrix2D5.rows());
                            floatMatrix2D5.zMult(denseFloatMatrix1D2, floatMatrix1D3, 1.0f, 0.0f, true);
                            floatArrayList.add(Math.min(1.0f, this.findOmega(floatMatrix1D3, fArray)));
                            this.omega = FloatDescriptive.mean(floatArrayList);
                        }
                        floatMatrix1D4 = new DenseFloatMatrix1D(floatMatrix2D6.rows());
                        float f3 = this.tikhonovSolver(floatMatrix2D5, fArray, floatMatrix2D6, denseFloatMatrix1D2, floatMatrix1D4);
                        floatArrayList2.add(this.GCVstopfun(f3, floatMatrix2D5.viewRow(0), fArray, f, n));
                        if (n3 <= 1) break;
                        if (Math.abs(floatArrayList2.getQuick(n3 - 1) - floatArrayList2.getQuick(n3 - 2)) / floatArrayList2.get(this.begReg - 2) < this.flatTol) {
                            floatMatrix2D4.zMult(floatMatrix1D4, floatMatrix1D2);
                            ((HyBRFloatIterationMonitor)this.iter).setStoppingCondition(HyBRFloatIterationMonitor.HyBRStoppingCondition.FLAT_GCV_CURVE);
                            if (this.computeRnrm) {
                                floatMatrix1D3 = floatMatrix1D.copy();
                                floatMatrix2D.zMult(floatMatrix1D2, floatMatrix1D3, -1.0f, 1.0f, false);
                                ((HyBRFloatIterationMonitor)this.iter).residual = alg.norm2(floatMatrix1D3);
                            }
                            return floatMatrix1D2;
                        }
                        if (bl2 && floatArrayList2.size() > n2 + 3) {
                            for (int i = n2; i < floatArrayList2.size(); ++i) {
                                if (!(floatArrayList2.getQuick(n2 - 1) > floatArrayList2.get(i))) continue;
                                bl = true;
                            }
                            if (!bl) {
                                floatMatrix1D2.assign(denseFloatMatrix1D);
                                ((HyBRFloatIterationMonitor)this.iter).setStoppingCondition(HyBRFloatIterationMonitor.HyBRStoppingCondition.MIN_OF_GCV_CURVE_WITHIN_WINDOW_OF_4_ITERATIONS);
                                ((HyBRFloatIterationMonitor)this.iter).iter = n2;
                                if (this.computeRnrm) {
                                    floatMatrix1D3 = floatMatrix1D.copy();
                                    floatMatrix2D.zMult(floatMatrix1D2, floatMatrix1D3, -1.0f, 1.0f, false);
                                    ((HyBRFloatIterationMonitor)this.iter).residual = alg.norm2(floatMatrix1D3);
                                }
                                return floatMatrix1D2;
                            }
                            bl = false;
                            bl2 = false;
                            n2 = this.iter.getMaxIterations();
                            break;
                        }
                        if (bl2 || !(floatArrayList2.get(n3 - 2) < floatArrayList2.get(n3 - 1))) break;
                        bl2 = true;
                        denseFloatMatrix1D = new DenseFloatMatrix1D(floatMatrix2D4.rows());
                        floatMatrix2D4.zMult(floatMatrix1D4, denseFloatMatrix1D);
                        n2 = n3;
                        break;
                    }
                    case NONE: {
                        floatMatrix1D4 = alg.solve(floatMatrix2D3, denseFloatMatrix1D2);
                    }
                }
                floatMatrix2D4.zMult(floatMatrix1D4, floatMatrix1D2);
                if (this.computeRnrm) {
                    floatMatrix1D3 = floatMatrix1D.copy();
                    floatMatrix2D.zMult(floatMatrix1D2, floatMatrix1D3, -1.0f, 1.0f, false);
                    f2 = alg.norm2(floatMatrix1D3);
                }
            }
            this.iter.next();
        }
        return floatMatrix1D2;
    }

    private float findOmega(FloatMatrix1D floatMatrix1D, float[] fArray) {
        int n = floatMatrix1D.size();
        int n2 = fArray.length;
        float f = fArray[n2 - 1];
        float f2 = floatMatrix1D.viewPart(n2, n - n2).aggregate(FloatFunctions.plus, FloatFunctions.square);
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(fArray);
        ((FloatMatrix1D)denseFloatMatrix1D).assign(FloatFunctions.square);
        float f3 = f * f;
        FloatMatrix1D floatMatrix1D2 = denseFloatMatrix1D.copy();
        floatMatrix1D2.assign(FloatFunctions.plus(f3));
        floatMatrix1D2.assign(FloatFunctions.inv);
        float f4 = ((FloatMatrix1D)denseFloatMatrix1D).aggregate(floatMatrix1D2, FloatFunctions.plus, FloatFunctions.mult);
        denseFloatMatrix1D = new DenseFloatMatrix1D(fArray);
        ((FloatMatrix1D)denseFloatMatrix1D).assign(FloatFunctions.mult(f));
        ((FloatMatrix1D)denseFloatMatrix1D).assign(floatMatrix1D.viewPart(0, n2), FloatFunctions.mult);
        ((FloatMatrix1D)denseFloatMatrix1D).assign(FloatFunctions.square);
        FloatMatrix1D floatMatrix1D3 = floatMatrix1D2.copy();
        floatMatrix1D3.assign(FloatFunctions.pow(3.0f));
        floatMatrix1D3.assign(FloatFunctions.abs);
        float f5 = floatMatrix1D3.aggregate(denseFloatMatrix1D, FloatFunctions.plus, FloatFunctions.mult);
        floatMatrix1D3 = new DenseFloatMatrix1D(fArray);
        floatMatrix1D3.assign(floatMatrix1D2, FloatFunctions.mult);
        float f6 = floatMatrix1D3.aggregate(FloatFunctions.plus, FloatFunctions.square);
        floatMatrix1D3 = floatMatrix1D2.copy();
        floatMatrix1D3.assign(floatMatrix1D.viewPart(0, n2), FloatFunctions.mult);
        floatMatrix1D3.assign(FloatFunctions.mult(f3));
        float f7 = floatMatrix1D3.aggregate(FloatFunctions.plus, FloatFunctions.square);
        denseFloatMatrix1D = new DenseFloatMatrix1D(fArray);
        ((FloatMatrix1D)denseFloatMatrix1D).assign(floatMatrix1D.viewPart(0, n2), FloatFunctions.mult);
        ((FloatMatrix1D)denseFloatMatrix1D).assign(FloatFunctions.square);
        floatMatrix1D2.assign(FloatFunctions.pow(3.0f));
        floatMatrix1D2.assign(FloatFunctions.abs);
        float f8 = floatMatrix1D2.aggregate(denseFloatMatrix1D, FloatFunctions.plus, FloatFunctions.mult);
        return (float)n * f3 * f8 / (f4 * f5 + f6 * (f7 + f2));
    }

    private float tikhonovSolver(FloatMatrix2D floatMatrix2D, float[] fArray, FloatMatrix2D floatMatrix2D2, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        FloatMatrix1D floatMatrix1D3 = new DenseFloatMatrix1D(floatMatrix2D.rows());
        floatMatrix2D.zMult(floatMatrix1D, floatMatrix1D3, 1.0f, 0.0f, true);
        float f = 0.0f;
        switch (this.regMethod) {
            case GCV: {
                TikFmin_2D tikFmin_2D = new TikFmin_2D(floatMatrix1D3, fArray, 1.0f);
                f = FloatFmin.fmin(0.0f, 1.0f, tikFmin_2D, 1.0E-4f);
                break;
            }
            case WGCV: {
                TikFmin_2D tikFmin_2D = new TikFmin_2D(floatMatrix1D3, fArray, this.omega);
                f = FloatFmin.fmin(0.0f, 1.0f, tikFmin_2D, 1.0E-4f);
                break;
            }
            case ADAPTWGCV: {
                TikFmin_2D tikFmin_2D = new TikFmin_2D(floatMatrix1D3, fArray, this.omega);
                f = FloatFmin.fmin(0.0f, 1.0f, tikFmin_2D, 1.0E-4f);
                break;
            }
            case NONE: {
                f = this.regPar;
            }
        }
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(fArray);
        ((FloatMatrix1D)denseFloatMatrix1D).assign(FloatFunctions.square);
        ((FloatMatrix1D)denseFloatMatrix1D).assign(FloatFunctions.plus(f * f));
        floatMatrix1D3 = floatMatrix1D3.viewPart(0, fArray.length);
        DenseFloatMatrix1D denseFloatMatrix1D2 = new DenseFloatMatrix1D(fArray);
        floatMatrix1D3.assign(denseFloatMatrix1D2, FloatFunctions.mult);
        floatMatrix1D3.assign(denseFloatMatrix1D, FloatFunctions.div);
        floatMatrix2D2.zMult(floatMatrix1D3, floatMatrix1D2);
        return f;
    }

    private float GCVstopfun(float f, FloatMatrix1D floatMatrix1D, float[] fArray, float f2, int n) {
        int n2 = fArray.length;
        float f3 = f2 * f2;
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(fArray);
        ((FloatMatrix1D)denseFloatMatrix1D).assign(FloatFunctions.square);
        float f4 = f * f;
        FloatMatrix1D floatMatrix1D2 = denseFloatMatrix1D.copy();
        floatMatrix1D2.assign(FloatFunctions.plus(f4));
        floatMatrix1D2.assign(FloatFunctions.inv);
        FloatMatrix1D floatMatrix1D3 = floatMatrix1D2.copy();
        floatMatrix1D3.assign(floatMatrix1D.viewPart(0, n2), FloatFunctions.mult);
        floatMatrix1D3.assign(FloatFunctions.mult(f4));
        float f5 = (float)((double)f3 * ((double)floatMatrix1D3.aggregate(FloatFunctions.plus, FloatFunctions.square) + Math.pow(Math.abs(floatMatrix1D.getQuick(n2)), 2.0)) / (double)n);
        float f6 = ((float)n - floatMatrix1D2.aggregate(denseFloatMatrix1D, FloatFunctions.plus, FloatFunctions.mult)) / (float)n;
        f6 *= f6;
        return f5 / f6;
    }

    private class FloatPLBD
    implements FloatLBD {
        private final FloatAlgebra alg = FloatAlgebra.DEFAULT;
        private final FloatFactory2D factory = FloatFactory2D.dense;
        private final FloatMatrix2D alphaBeta = new DenseFloatMatrix2D(2, 1);
        private final FloatPreconditioner M;
        private final FloatMatrix2D A;
        private FloatMatrix2D B;
        private FloatMatrix2D U;
        private FloatMatrix2D V;
        private boolean reorth;

        public FloatPLBD(FloatPreconditioner floatPreconditioner, FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, boolean bl) {
            this.M = floatPreconditioner;
            this.A = floatMatrix2D;
            this.reorth = bl;
            this.U = floatMatrix2D2;
            this.V = null;
            this.B = null;
        }

        public void apply() {
            int n = this.U.rows();
            FloatMatrix1D floatMatrix1D = null;
            FloatMatrix1D floatMatrix1D2 = null;
            FloatMatrix1D floatMatrix1D3 = null;
            if (n == 1) {
                floatMatrix1D3 = this.U.viewRow(n - 1).copy();
                floatMatrix1D3 = this.M.transApply(floatMatrix1D3, floatMatrix1D3);
                floatMatrix1D2 = this.A.zMult(floatMatrix1D3, floatMatrix1D2, 1.0f, 0.0f, true);
            } else {
                floatMatrix1D3 = this.U.viewRow(n - 1).copy();
                floatMatrix1D3 = this.M.transApply(floatMatrix1D3, floatMatrix1D3);
                floatMatrix1D2 = this.A.zMult(floatMatrix1D3, floatMatrix1D2, 1.0f, 0.0f, true);
                floatMatrix1D3 = this.V.viewColumn(n - 2).copy();
                floatMatrix1D2.assign(floatMatrix1D3.assign(FloatFunctions.mult(this.B.getQuick(n - 1, n - 2))), FloatFunctions.minus);
                if (this.reorth) {
                    for (int i = 0; i < n - 1; ++i) {
                        floatMatrix1D3 = this.V.viewColumn(i).copy();
                        floatMatrix1D2.assign(floatMatrix1D3.assign(FloatFunctions.mult(floatMatrix1D3.zDotProduct(floatMatrix1D2))), FloatFunctions.minus);
                    }
                }
            }
            float f = this.alg.norm2(floatMatrix1D2);
            floatMatrix1D2.assign(FloatFunctions.div(f));
            floatMatrix1D3 = this.A.zMult(floatMatrix1D2, floatMatrix1D3);
            floatMatrix1D = this.M.apply(floatMatrix1D3, floatMatrix1D);
            floatMatrix1D3 = this.U.viewRow(n - 1).copy();
            floatMatrix1D.assign(floatMatrix1D3.assign(FloatFunctions.mult(f)), FloatFunctions.minus);
            if (this.reorth) {
                for (int i = 0; i < n; ++i) {
                    floatMatrix1D3 = this.U.viewRow(i).copy();
                    floatMatrix1D.assign(floatMatrix1D3.assign(FloatFunctions.mult(floatMatrix1D3.zDotProduct(floatMatrix1D))), FloatFunctions.minus);
                }
            }
            float f2 = this.alg.norm2(floatMatrix1D);
            this.alphaBeta.setQuick(0, 0, f);
            this.alphaBeta.setQuick(1, 0, f2);
            floatMatrix1D.assign(FloatFunctions.div(f2));
            this.U = this.factory.appendRow(this.U, floatMatrix1D);
            if (this.V == null) {
                this.V = new DenseColFloatMatrix2D(floatMatrix1D2.size(), 1);
                this.V.assign((float[])floatMatrix1D2.elements());
            } else {
                this.V = this.factory.appendColumn(this.V, floatMatrix1D2);
            }
            if (this.B == null) {
                this.B = new DenseFloatMatrix2D(2, 1);
                this.B.assign(this.alphaBeta);
            } else {
                this.B = this.factory.composeBidiagonal(this.B, this.alphaBeta);
            }
        }

        public FloatMatrix2D getB() {
            return this.B;
        }

        public FloatMatrix2D getU() {
            return this.U;
        }

        public FloatMatrix2D getV() {
            return this.V;
        }
    }

    private class FloatSimpleLBD
    implements FloatLBD {
        private final FloatAlgebra alg = FloatAlgebra.DEFAULT;
        private final FloatFactory2D factory = FloatFactory2D.dense;
        private final FloatMatrix2D alphaBeta = new DenseFloatMatrix2D(2, 1);
        private final FloatMatrix2D A;
        private FloatMatrix2D B;
        private FloatMatrix2D U;
        private FloatMatrix2D V;
        private boolean reorth;

        public FloatSimpleLBD(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, boolean bl) {
            this.A = floatMatrix2D;
            this.reorth = bl;
            this.U = floatMatrix2D2;
            this.V = null;
            this.B = null;
        }

        public void apply() {
            int n = this.U.rows();
            FloatMatrix1D floatMatrix1D = null;
            FloatMatrix1D floatMatrix1D2 = null;
            FloatMatrix1D floatMatrix1D3 = null;
            if (n == 1) {
                floatMatrix1D2 = this.A.zMult(this.U.viewRow(n - 1), floatMatrix1D2, 1.0f, 0.0f, true);
            } else {
                floatMatrix1D2 = this.A.zMult(this.U.viewRow(n - 1), floatMatrix1D2, 1.0f, 0.0f, true);
                floatMatrix1D3 = this.V.viewColumn(n - 2).copy();
                floatMatrix1D2.assign(floatMatrix1D3.assign(FloatFunctions.mult(this.B.getQuick(n - 1, n - 2))), FloatFunctions.minus);
                if (this.reorth) {
                    for (int i = 0; i < n - 1; ++i) {
                        floatMatrix1D3 = this.V.viewColumn(i).copy();
                        floatMatrix1D2.assign(floatMatrix1D3.assign(FloatFunctions.mult(floatMatrix1D3.zDotProduct(floatMatrix1D2))), FloatFunctions.minus);
                    }
                }
            }
            float f = this.alg.norm2(floatMatrix1D2);
            floatMatrix1D2.assign(FloatFunctions.div(f));
            floatMatrix1D = this.A.zMult(floatMatrix1D2, floatMatrix1D);
            floatMatrix1D3 = this.U.viewRow(n - 1).copy();
            floatMatrix1D.assign(floatMatrix1D3.assign(FloatFunctions.mult(f)), FloatFunctions.minus);
            if (this.reorth) {
                for (int i = 0; i < n; ++i) {
                    floatMatrix1D3 = this.U.viewRow(i).copy();
                    floatMatrix1D.assign(floatMatrix1D3.assign(FloatFunctions.mult(floatMatrix1D3.zDotProduct(floatMatrix1D))), FloatFunctions.minus);
                }
            }
            float f2 = this.alg.norm2(floatMatrix1D);
            this.alphaBeta.setQuick(0, 0, f);
            this.alphaBeta.setQuick(1, 0, f2);
            floatMatrix1D.assign(FloatFunctions.div(f2));
            this.U = this.factory.appendRow(this.U, floatMatrix1D);
            if (this.V == null) {
                this.V = new DenseColFloatMatrix2D(floatMatrix1D2.size(), 1);
                this.V.assign((float[])floatMatrix1D2.elements());
            } else {
                this.V = this.factory.appendColumn(this.V, floatMatrix1D2);
            }
            if (this.B == null) {
                this.B = new DenseFloatMatrix2D(2, 1);
                this.B.assign(this.alphaBeta);
            } else {
                this.B = this.factory.composeBidiagonal(this.B, this.alphaBeta);
            }
        }

        public FloatMatrix2D getB() {
            return this.B;
        }

        public FloatMatrix2D getU() {
            return this.U;
        }

        public FloatMatrix2D getV() {
            return this.V;
        }
    }

    private static interface FloatLBD {
        public void apply();

        public FloatMatrix2D getB();

        public FloatMatrix2D getU();

        public FloatMatrix2D getV();
    }

    private static class TikFmin_2D
    implements FloatFmin_methods {
        FloatMatrix1D bhat;
        float[] s;
        float omega;

        public TikFmin_2D(FloatMatrix1D floatMatrix1D, float[] fArray, float f) {
            this.bhat = floatMatrix1D;
            this.s = fArray;
            this.omega = f;
        }

        public float f_to_minimize(float f) {
            int n = this.bhat.size();
            int n2 = this.s.length;
            float f2 = this.bhat.viewPart(n2, n - n2).aggregate(FloatFunctions.plus, FloatFunctions.square);
            DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(this.s);
            ((FloatMatrix1D)denseFloatMatrix1D).assign(FloatFunctions.square);
            float f3 = f * f;
            FloatMatrix1D floatMatrix1D = denseFloatMatrix1D.copy();
            floatMatrix1D.assign(FloatFunctions.plus(f3));
            floatMatrix1D.assign(FloatFunctions.inv);
            FloatMatrix1D floatMatrix1D2 = floatMatrix1D.copy();
            floatMatrix1D2.assign(FloatFunctions.mult(f3));
            FloatMatrix1D floatMatrix1D3 = floatMatrix1D2.copy();
            floatMatrix1D3.assign(this.bhat.viewPart(0, n2), FloatFunctions.mult);
            FloatMatrix1D floatMatrix1D4 = floatMatrix1D.copy();
            floatMatrix1D4.assign(denseFloatMatrix1D, FloatFunctions.mult);
            floatMatrix1D4.assign(FloatFunctions.mult(1.0f - this.omega));
            float f4 = floatMatrix1D4.aggregate(floatMatrix1D2, FloatFunctions.plus, FloatFunctions.plus) + (float)n - (float)n2;
            return (float)n2 * (floatMatrix1D3.aggregate(FloatFunctions.plus, FloatFunctions.square) + f2) / (f4 * f4);
        }
    }
}

