/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.MRNSDFloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatIdentity;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatMRNSD
extends AbstractFloatIterativeSolver {
    private static final FloatAlgebra alg = FloatAlgebra.DEFAULT;
    public static final float sqrteps = (float)Math.sqrt(Math.pow(2.0, -23.0));

    public FloatMRNSD() {
        this.iter = new MRNSDFloatIterationMonitor();
        ((MRNSDFloatIterationMonitor)this.iter).setRelativeTolerance(-1.0f);
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        float f;
        float f2;
        float f3;
        if (!(this.iter instanceof MRNSDFloatIterationMonitor)) {
            this.iter = new MRNSDFloatIterationMonitor();
            ((MRNSDFloatIterationMonitor)this.iter).setRelativeTolerance(-1.0f);
        }
        float f4 = f3 = sqrteps;
        float[] fArray = floatMatrix1D2.getMinLocation();
        float f5 = fArray[0];
        if (f5 < 0.0f) {
            floatMatrix1D2.assign(FloatFunctions.plus(-f5 + f4));
        }
        if ((double)((MRNSDFloatIterationMonitor)this.iter).getRelativeTolerance() == -1.0) {
            ((MRNSDFloatIterationMonitor)this.iter).setRelativeTolerance(sqrteps * alg.norm2(floatMatrix2D.zMult(floatMatrix1D, null, 1.0f, 0.0f, true)));
        }
        FloatMatrix1D floatMatrix1D3 = floatMatrix2D.zMult(floatMatrix1D2, null);
        floatMatrix1D3.assign(floatMatrix1D, FloatFunctions.plusMultFirst(-1.0f));
        if (!(this.M instanceof FloatIdentity)) {
            floatMatrix1D3 = this.M.apply(floatMatrix1D3, null);
            floatMatrix1D3 = this.M.transApply(floatMatrix1D3, null);
            floatMatrix1D3 = floatMatrix2D.zMult(floatMatrix1D3, null, 1.0f, 0.0f, true);
            floatMatrix1D3.assign(FloatFunctions.neg);
            f2 = floatMatrix1D2.aggregate(floatMatrix1D3, FloatFunctions.plus, FloatFunctions.multSquare);
            f = alg.norm2(floatMatrix1D3);
        } else {
            floatMatrix1D3 = floatMatrix2D.zMult(floatMatrix1D3, null, 1.0f, 0.0f, true);
            floatMatrix1D3.assign(FloatFunctions.neg);
            f2 = floatMatrix1D2.aggregate(floatMatrix1D3, FloatFunctions.plus, FloatFunctions.multSquare);
            f = (float)Math.sqrt(f2);
        }
        IntArrayList intArrayList = new IntArrayList(floatMatrix1D.size());
        this.iter.setFirst();
        while (!this.iter.converged(f, floatMatrix1D2)) {
            FloatMatrix1D floatMatrix1D4 = floatMatrix1D2.copy();
            floatMatrix1D4.assign(floatMatrix1D3, FloatFunctions.multNeg);
            FloatMatrix1D floatMatrix1D5 = floatMatrix2D.zMult(floatMatrix1D4, null);
            if (!(this.M instanceof FloatIdentity)) {
                floatMatrix1D5 = this.M.apply(floatMatrix1D5, null);
            }
            float f6 = f2 / floatMatrix1D5.aggregate(FloatFunctions.plus, FloatFunctions.square);
            floatMatrix1D4.getNegativeValues(intArrayList, null);
            FloatMatrix1D floatMatrix1D6 = floatMatrix1D2.copy();
            floatMatrix1D6.assign(floatMatrix1D4, FloatFunctions.divNeg, intArrayList);
            float f7 = Math.min(f6, floatMatrix1D6.aggregate(FloatFunctions.min, FloatFunctions.identity, intArrayList));
            floatMatrix1D2.assign(floatMatrix1D4, FloatFunctions.plusMultSecond(f7));
            if (!(this.M instanceof FloatIdentity)) {
                floatMatrix1D6 = this.M.transApply(floatMatrix1D5, null);
                floatMatrix1D6 = floatMatrix2D.zMult(floatMatrix1D5, null, 1.0f, 0.0f, true);
                floatMatrix1D3.assign(floatMatrix1D6, FloatFunctions.plusMultSecond(f7));
                f2 = floatMatrix1D2.aggregate(floatMatrix1D3, FloatFunctions.plus, FloatFunctions.multSquare);
                f = alg.norm2(floatMatrix1D3);
            } else {
                floatMatrix1D6 = floatMatrix2D.zMult(floatMatrix1D5, null, 1.0f, 0.0f, true);
                floatMatrix1D3.assign(floatMatrix1D6, FloatFunctions.plusMultSecond(f7));
                f2 = floatMatrix1D2.aggregate(floatMatrix1D3, FloatFunctions.plus, FloatFunctions.multSquare);
                f = (float)Math.sqrt(f2);
            }
            this.iter.next();
        }
        return floatMatrix1D2;
    }
}

