/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatQMR
extends AbstractFloatIterativeSolver {
    private FloatPreconditioner M1;
    private FloatPreconditioner M2;
    private FloatMatrix1D r;
    private FloatMatrix1D y;
    private FloatMatrix1D z;
    private FloatMatrix1D v;
    private FloatMatrix1D w;
    private FloatMatrix1D p;
    private FloatMatrix1D q;
    private FloatMatrix1D d;
    private FloatMatrix1D s;
    private FloatMatrix1D v_tld;
    private FloatMatrix1D w_tld;
    private FloatMatrix1D y_tld;
    private FloatMatrix1D z_tld;
    private FloatMatrix1D p_tld;

    public FloatQMR(FloatMatrix1D floatMatrix1D) {
        this.M1 = this.M;
        this.M2 = this.M;
        this.r = floatMatrix1D.copy();
        this.y = floatMatrix1D.copy();
        this.z = floatMatrix1D.copy();
        this.v = floatMatrix1D.copy();
        this.w = floatMatrix1D.copy();
        this.p = floatMatrix1D.copy();
        this.q = floatMatrix1D.copy();
        this.d = floatMatrix1D.copy();
        this.s = floatMatrix1D.copy();
        this.v_tld = floatMatrix1D.copy();
        this.w_tld = floatMatrix1D.copy();
        this.y_tld = floatMatrix1D.copy();
        this.z_tld = floatMatrix1D.copy();
        this.p_tld = floatMatrix1D.copy();
    }

    public FloatQMR(FloatMatrix1D floatMatrix1D, FloatPreconditioner floatPreconditioner, FloatPreconditioner floatPreconditioner2) {
        this.M1 = floatPreconditioner;
        this.M2 = floatPreconditioner2;
        this.r = floatMatrix1D.copy();
        this.y = floatMatrix1D.copy();
        this.z = floatMatrix1D.copy();
        this.v = floatMatrix1D.copy();
        this.w = floatMatrix1D.copy();
        this.p = floatMatrix1D.copy();
        this.q = floatMatrix1D.copy();
        this.d = floatMatrix1D.copy();
        this.s = floatMatrix1D.copy();
        this.v_tld = floatMatrix1D.copy();
        this.w_tld = floatMatrix1D.copy();
        this.y_tld = floatMatrix1D.copy();
        this.z_tld = floatMatrix1D.copy();
        this.p_tld = floatMatrix1D.copy();
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(floatMatrix2D, floatMatrix1D, floatMatrix1D2);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = -1.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        floatMatrix2D.zMult(floatMatrix1D2, this.r.assign(floatMatrix1D), -1.0f, 1.0f, false);
        this.v_tld.assign(this.r);
        this.M1.apply(this.v_tld, this.y);
        f = FloatAlgebra.DEFAULT.norm(this.y, Norm.Two);
        this.w_tld.assign(this.r);
        this.M2.transApply(this.w_tld, this.z);
        f3 = FloatAlgebra.DEFAULT.norm(this.z, Norm.Two);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, floatMatrix1D2)) {
            if (f == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (f3 == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "xi", this.iter);
            }
            this.v.assign(this.v_tld, FloatFunctions.multSecond(1.0f / f));
            this.y.assign(FloatFunctions.mult(1.0f / f));
            this.w.assign(this.w_tld, FloatFunctions.multSecond(1.0f / f3));
            this.z.assign(FloatFunctions.mult(1.0f / f3));
            f9 = this.z.zDotProduct(this.y);
            if (f9 == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "delta", this.iter);
            }
            this.M2.apply(this.y, this.y_tld);
            this.M1.transApply(this.z, this.z_tld);
            if (this.iter.isFirst()) {
                this.p.assign(this.y_tld);
                this.q.assign(this.z_tld);
            } else {
                this.p.assign(this.y_tld, FloatFunctions.plusMultFirst(-f3 * f9 / f10));
                this.q.assign(this.z_tld, FloatFunctions.plusMultFirst(-f * f9 / f10));
            }
            floatMatrix2D.zMult(this.p, this.p_tld);
            f10 = this.q.zDotProduct(this.p_tld);
            if (f10 == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "ep", this.iter);
            }
            f11 = f10 / f9;
            if (f11 == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "beta", this.iter);
            }
            this.v_tld.assign(this.v, FloatFunctions.multSecond(-f11)).assign(this.p_tld, FloatFunctions.plus);
            this.M1.apply(this.v_tld, this.y);
            f2 = f;
            f = FloatAlgebra.DEFAULT.norm(this.y, Norm.Two);
            floatMatrix2D.zMult(this.q, this.w_tld.assign(this.w, FloatFunctions.multSecond(-f11)), 1.0f, 1.0f, true);
            this.M2.transApply(this.w_tld, this.z);
            f3 = FloatAlgebra.DEFAULT.norm(this.z, Norm.Two);
            f5 = f4;
            f7 = f6;
            f6 = f / (f5 * f11);
            f4 = (float)(1.0 / Math.sqrt(1.0f + f6 * f6));
            if (f4 == 0.0f) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "gamma", this.iter);
            }
            f8 = -f8 * f2 * f4 * f4 / (f11 * f5 * f5);
            if (this.iter.isFirst()) {
                this.d.assign(this.p, FloatFunctions.multSecond(f8));
                this.s.assign(this.p_tld, FloatFunctions.multSecond(f8));
            } else {
                float f12 = f7 * f7 * f4 * f4;
                this.d.assign(FloatFunctions.mult(f12)).assign(this.p, FloatFunctions.plusMultSecond(f8));
                this.s.assign(FloatFunctions.mult(f12)).assign(this.p_tld, FloatFunctions.plusMultSecond(f8));
            }
            floatMatrix1D2.assign(this.d, FloatFunctions.plus);
            this.r.assign(this.s, FloatFunctions.minus);
            this.iter.next();
        }
        return floatMatrix1D2;
    }

    public void setPreconditioner(FloatPreconditioner floatPreconditioner) {
        super.setPreconditioner(floatPreconditioner);
        this.M1 = floatPreconditioner;
        this.M2 = floatPreconditioner;
    }
}

