/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.RCFloatMatrix2D;
import java.util.Arrays;

public class FloatICC
implements FloatPreconditioner {
    private final RCFloatMatrix2D R;
    private final FloatMatrix1D y;
    private int[] diagind;

    public FloatICC(RCFloatMatrix2D rCFloatMatrix2D) {
        if (rCFloatMatrix2D.rows() != rCFloatMatrix2D.columns()) {
            throw new IllegalArgumentException("ICC only applies to square matrices");
        }
        this.R = rCFloatMatrix2D;
        int n = rCFloatMatrix2D.rows();
        this.y = new DenseFloatMatrix1D(n);
    }

    public FloatMatrix1D apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        this.upperTransSolve(floatMatrix1D, this.y);
        return this.upperSolve(this.y, floatMatrix1D2);
    }

    public FloatMatrix1D transApply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        return this.apply(floatMatrix1D, floatMatrix1D2);
    }

    public void setMatrix(FloatMatrix2D floatMatrix2D) {
        this.R.assign(floatMatrix2D);
        this.factor();
    }

    private void factor() {
        int n = this.R.rows();
        int[] nArray = this.R.getColumnindexes().elements();
        int[] nArray2 = this.R.getRowPointers();
        float[] fArray = this.R.getValues().elements();
        float[] fArray2 = new float[n];
        this.diagind = this.findDiagonalindexes(n, nArray, nArray2);
        for (int i = 0; i < n; ++i) {
            int n2;
            Arrays.fill(fArray2, 0.0f);
            for (n2 = nArray2[i]; n2 < nArray2[i + 1]; ++n2) {
                fArray2[nArray[n2]] = fArray[n2];
            }
            for (n2 = 0; n2 < i; ++n2) {
                float f = fArray[this.diagind[n2]];
                if (f == 0.0f) {
                    throw new RuntimeException("Zero pivot encountered on row " + (n2 + 1) + " during ICC process");
                }
                float f2 = fArray2[n2] / f;
                if (f2 == 0.0f) continue;
                for (int j = this.diagind[n2] + 1; j < nArray2[n2 + 1]; ++j) {
                    int n3 = nArray[j];
                    fArray2[n3] = fArray2[n3] - f2 * fArray[j];
                }
            }
            if (fArray2[i] == 0.0f) {
                throw new RuntimeException("Zero diagonal entry encountered on row " + (i + 1) + " during ICC process");
            }
            float f = (float)Math.sqrt(fArray2[i]);
            for (int j = this.diagind[i]; j < nArray2[i + 1]; ++j) {
                fArray[j] = fArray2[nArray[j]] / f;
            }
        }
    }

    private int[] findDiagonalindexes(int n, int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = Sorting.binarySearchFromTo(nArray, i, nArray2[i], nArray2[i + 1] - 1);
            if (nArray3[i] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (i + 1));
        }
        return nArray3;
    }

    private FloatMatrix1D upperSolve(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D).elements();
        float[] fArray2 = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        int[] nArray = this.R.getColumnindexes().elements();
        int[] nArray2 = this.R.getRowPointers();
        float[] fArray3 = this.R.getValues().elements();
        int n = this.R.rows();
        for (int i = n - 1; i >= 0; --i) {
            float f = 0.0f;
            for (int j = this.diagind[i] + 1; j < nArray2[i + 1]; ++j) {
                f += fArray3[j] * fArray2[nArray[j]];
            }
            fArray2[i] = (fArray[i] - f) / fArray3[this.diagind[i]];
        }
        return floatMatrix1D2;
    }

    private FloatMatrix1D upperTransSolve(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        floatMatrix1D2.assign(floatMatrix1D);
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        int[] nArray = this.R.getColumnindexes().elements();
        int[] nArray2 = this.R.getRowPointers();
        float[] fArray2 = this.R.getValues().elements();
        int n = this.R.rows();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            fArray[n2] = fArray[n2] / fArray2[this.diagind[i]];
            for (int j = this.diagind[i] + 1; j < nArray2[i + 1]; ++j) {
                int n3 = nArray[j];
                fArray[n3] = fArray[n3] - fArray2[j] * fArray[i];
            }
        }
        return floatMatrix1D2;
    }
}

