/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.RCFloatMatrix2D;

public class FloatSSOR
implements FloatPreconditioner {
    private float omegaF;
    private float omegaR;
    private final RCFloatMatrix2D F;
    private final int[] diagind;
    private final float[] xx;
    private final boolean reverse;

    public FloatSSOR(RCFloatMatrix2D rCFloatMatrix2D, boolean bl, float f, float f2) {
        if (rCFloatMatrix2D.rows() != rCFloatMatrix2D.columns()) {
            throw new IllegalArgumentException("SSOR only applies to square matrices");
        }
        this.F = rCFloatMatrix2D;
        this.reverse = bl;
        this.setOmega(f, f2);
        int n = rCFloatMatrix2D.rows();
        this.diagind = new int[n];
        this.xx = new float[n];
    }

    public FloatSSOR(RCFloatMatrix2D rCFloatMatrix2D) {
        this(rCFloatMatrix2D, true, 1.0f, 1.0f);
    }

    public void setOmega(float f, float f2) {
        if (f < 0.0f || f > 2.0f) {
            throw new IllegalArgumentException("omegaF must be between 0 and 2");
        }
        if (f2 < 0.0f || f2 > 2.0f) {
            throw new IllegalArgumentException("omegaR must be between 0 and 2");
        }
        this.omegaF = f;
        this.omegaR = f2;
    }

    public void setMatrix(FloatMatrix2D floatMatrix2D) {
        this.F.assign(floatMatrix2D);
        int n = this.F.rows();
        int[] nArray = this.F.getRowPointers();
        int[] nArray2 = this.F.getColumnindexes().elements();
        for (int i = 0; i < n; ++i) {
            this.diagind[i] = Sorting.binarySearchFromTo(nArray2, i, nArray[i], nArray[i + 1] - 1);
            if (this.diagind[i] >= 0) continue;
            throw new RuntimeException("Missing diagonal on row " + (i + 1));
        }
    }

    public FloatMatrix1D apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        int n;
        float f;
        int n2;
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D) || !(floatMatrix1D2 instanceof DenseFloatMatrix1D)) {
            throw new IllegalArgumentException("b and x must be a DenseFloatMatrix1D");
        }
        int[] nArray = this.F.getRowPointers();
        int[] nArray2 = this.F.getColumnindexes().elements();
        float[] fArray = this.F.getValues().elements();
        float[] fArray2 = ((DenseFloatMatrix1D)floatMatrix1D).elements();
        float[] fArray3 = new float[floatMatrix1D2.size()];
        int n3 = this.F.rows();
        System.arraycopy(fArray3, 0, this.xx, 0, n3);
        for (n2 = 0; n2 < n3; ++n2) {
            f = 0.0f;
            for (n = nArray[n2]; n < this.diagind[n2]; ++n) {
                f += fArray[n] * this.xx[nArray2[n]];
            }
            for (n = this.diagind[n2] + 1; n < nArray[n2 + 1]; ++n) {
                f += fArray[n] * fArray3[nArray2[n]];
            }
            f = (fArray2[n2] - f) / fArray[this.diagind[n2]];
            this.xx[n2] = fArray3[n2] + this.omegaF * (f - fArray3[n2]);
        }
        if (!this.reverse) {
            System.arraycopy(this.xx, 0, fArray3, 0, n3);
            floatMatrix1D2.assign(fArray3);
            return floatMatrix1D2;
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            f = 0.0f;
            for (n = nArray[n2]; n < this.diagind[n2]; ++n) {
                f += fArray[n] * this.xx[nArray2[n]];
            }
            for (n = this.diagind[n2] + 1; n < nArray[n2 + 1]; ++n) {
                f += fArray[n] * fArray3[nArray2[n]];
            }
            f = (fArray2[n2] - f) / fArray[this.diagind[n2]];
            fArray3[n2] = this.xx[n2] + this.omegaR * (f - this.xx[n2]);
        }
        floatMatrix1D2.assign(fArray3);
        return floatMatrix1D2;
    }

    public FloatMatrix1D transApply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        return this.apply(floatMatrix1D, floatMatrix1D2);
    }
}

