/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class CCFloatMatrix2D
extends WrapperFloatMatrix2D {
    protected IntArrayList rowIndexes;
    protected FloatArrayList values;
    protected int[] columnPointers;

    public CCFloatMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length);
        this.assign(fArray);
    }

    public CCFloatMatrix2D(int n, int n2, int[] nArray, IntArrayList intArrayList, FloatArrayList floatArrayList) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnPointers = nArray;
        this.rowIndexes = intArrayList;
        this.values = floatArrayList;
    }

    public CCFloatMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowIndexes = new IntArrayList();
        this.values = new FloatArrayList();
        this.columnPointers = new int[n2 + 1];
    }

    public CCFloatMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowIndexes = new IntArrayList(n3);
        this.values = new FloatArrayList(n3);
        this.columnPointers = new int[n2 + 1];
    }

    public CCFloatMatrix2D(int n, int n2, IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        int n3;
        block4: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block4;
                throw illegalArgumentException;
            }
        }
        int n4 = intArrayList.size();
        int[] nArray = intArrayList.elements();
        int[] nArray2 = intArrayList2.elements();
        float[] fArray = floatArrayList.elements();
        int[] nArray3 = new int[n4];
        float[] fArray2 = new float[n4];
        int[] nArray4 = new int[n2 + 1];
        int[] nArray5 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray5[n5] = nArray5[n5] + 1;
        }
        this.cumsum(nArray4, nArray5, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray5[n6] = nArray5[n6] + 1;
            nArray3[var14_16] = nArray[n3];
            fArray2[var14_16] = fArray[n3];
        }
        this.columnPointers = nArray4;
        this.rowIndexes = new IntArrayList(nArray3);
        this.values = new FloatArrayList(fArray2);
    }

    public CCFloatMatrix2D(int n, int n2, IntArrayList intArrayList, IntArrayList intArrayList2, float f) {
        int n3;
        block4: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block4;
                throw illegalArgumentException;
            }
        }
        int n4 = intArrayList.size();
        int[] nArray = intArrayList.elements();
        int[] nArray2 = intArrayList2.elements();
        int[] nArray3 = new int[n4];
        float[] fArray = new float[n4];
        int[] nArray4 = new int[n2 + 1];
        int[] nArray5 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray5[n5] = nArray5[n5] + 1;
        }
        this.cumsum(nArray4, nArray5, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray5[n6] = nArray5[n6] + 1;
            nArray3[var13_15] = nArray[n3];
            fArray[var13_15] = f;
        }
        this.columnPointers = nArray4;
        this.rowIndexes = new IntArrayList(nArray3);
        this.values = new FloatArrayList(fArray);
    }

    private float cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            f += (float)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return f;
    }

    public FloatMatrix2D assign(float f) {
        if (f == 0.0f) {
            this.rowIndexes.clear();
            this.values.clear();
            this.columnPointers = new int[this.columns + 1];
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values.setQuick(i, f);
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatFunction floatFunction) {
        if (floatFunction instanceof FloatMult) {
            final float f = ((FloatMult)floatFunction).multiplicator;
            if (f == 1.0f) {
                return this;
            }
            if (f == 0.0f) {
                return this.assign(0.0f);
            }
            if (f != f) {
                return this.assign(f);
            }
            final float[] fArray = this.values.elements();
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = fArray.length / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? fArray.length : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n3;
                            while (n < n4) {
                                int n2 = n++;
                                fArray[n2] = fArray[n2] * f;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = this.values.size();
                while (--n5 >= 0) {
                    int n6 = n5;
                    fArray[n6] = fArray[n6] * f;
                }
            }
        } else {
            this.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f) {
                    return floatFunction.apply(f);
                }
            });
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D == this) {
            return this;
        }
        this.checkShape(floatMatrix2D);
        if (!(floatMatrix2D instanceof CCFloatMatrix2D)) {
            this.assign(0.0f);
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f) {
                    CCFloatMatrix2D.this.setQuick(n, n2, f);
                    return f;
                }
            });
            return this;
        }
        CCFloatMatrix2D cCFloatMatrix2D = (CCFloatMatrix2D)floatMatrix2D;
        System.arraycopy(cCFloatMatrix2D.columnPointers, 0, this.columnPointers, 0, this.columnPointers.length);
        int n = cCFloatMatrix2D.rowIndexes.size();
        this.rowIndexes.setSize(n);
        this.values.setSize(n);
        this.rowIndexes.replaceFromToWithFrom(0, n - 1, cCFloatMatrix2D.rowIndexes, 0);
        this.values.replaceFromToWithFrom(0, n - 1, cCFloatMatrix2D.values, 0);
        return this;
    }

    public FloatMatrix2D assign(final FloatMatrix2D floatMatrix2D, FloatFloatFunction floatFloatFunction) {
        this.checkShape(floatMatrix2D);
        if (floatFloatFunction instanceof FloatPlusMultSecond) {
            final float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
            if (f == 0.0f) {
                return this;
            }
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f2) {
                    CCFloatMatrix2D.this.setQuick(n, n2, CCFloatMatrix2D.this.getQuick(n, n2) + f * f2);
                    return f2;
                }
            });
            return this;
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (floatFloatFunction == FloatFunctions.mult) {
            final int[] nArray = this.rowIndexes.elements();
            final float[] fArray = this.values.elements();
            if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = (this.columnPointers.length - 1) / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.columnPointers.length - 1 : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n3; i < n4; ++i) {
                                int n = CCFloatMatrix2D.this.columnPointers[i + 1];
                                for (int j = CCFloatMatrix2D.this.columnPointers[i]; j < n; ++j) {
                                    int n2 = nArray[j];
                                    int n32 = j;
                                    fArray[n32] = fArray[n32] * floatMatrix2D.getQuick(n2, i);
                                    if (fArray[j] != 0.0f) continue;
                                    CCFloatMatrix2D.this.remove(n2, i);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = this.columnPointers.length - 1;
                while (--n5 >= 0) {
                    int n6 = this.columnPointers[n5];
                    int n7 = this.columnPointers[n5 + 1];
                    while (--n7 >= n6) {
                        int n8 = nArray[n7];
                        int n9 = n7;
                        fArray[n9] = fArray[n9] * floatMatrix2D.getQuick(n8, n5);
                        if (fArray[n7] != 0.0f) continue;
                        this.remove(n8, n5);
                    }
                }
            }
            return this;
        }
        if (floatFloatFunction == FloatFunctions.div) {
            final int[] nArray = this.rowIndexes.elements();
            final float[] fArray = this.values.elements();
            if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n10 = (this.columnPointers.length - 1) / n;
                for (int i = 0; i < n; ++i) {
                    final int n11 = i * n10;
                    final int n12 = i == n - 1 ? this.columnPointers.length - 1 : n11 + n10;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n11; i < n12; ++i) {
                                int n = CCFloatMatrix2D.this.columnPointers[i + 1];
                                for (int j = CCFloatMatrix2D.this.columnPointers[i]; j < n; ++j) {
                                    int n2 = nArray[j];
                                    int n3 = j;
                                    fArray[n3] = fArray[n3] / floatMatrix2D.getQuick(n2, i);
                                    if (fArray[j] != 0.0f) continue;
                                    CCFloatMatrix2D.this.remove(n2, i);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n13 = this.columnPointers.length - 1;
                while (--n13 >= 0) {
                    int n14 = this.columnPointers[n13];
                    int n15 = this.columnPointers[n13 + 1];
                    while (--n15 >= n14) {
                        int n16 = nArray[n15];
                        int n17 = n15;
                        fArray[n17] = fArray[n17] / floatMatrix2D.getQuick(n16, n13);
                        if (fArray[n15] != 0.0f) continue;
                        this.remove(n16, n13);
                    }
                }
            }
            return this;
        }
        return super.assign(floatMatrix2D, floatFloatFunction);
    }

    public FloatMatrix2D forEachNonZero(final IntIntFloatFunction intIntFloatFunction) {
        final int[] nArray = this.rowIndexes.elements();
        final float[] fArray = this.values.elements();
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = (this.columnPointers.length - 1) / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columnPointers.length - 1 : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int n = CCFloatMatrix2D.this.columnPointers[i + 1];
                            for (int j = CCFloatMatrix2D.this.columnPointers[i]; j < n; ++j) {
                                int n2 = nArray[j];
                                float f = fArray[j];
                                float f2 = intIntFloatFunction.apply(n2, i, f);
                                if (f2 == f) continue;
                                fArray[j] = f2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.columnPointers.length - 1;
            while (--n5 >= 0) {
                int n6 = this.columnPointers[n5];
                int n7 = this.columnPointers[n5 + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    float f = fArray[n7];
                    float f2 = intIntFloatFunction.apply(n8, n5, f);
                    if (f2 == f) continue;
                    fArray[n7] = f2;
                }
            }
        }
        return this;
    }

    protected FloatMatrix2D getContent() {
        return this;
    }

    public IntArrayList getRowindexes() {
        return this.rowIndexes;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public FloatArrayList getValues() {
        return this.values;
    }

    public float getQuick(int n, int n2) {
        int n3 = this.rowIndexes.binarySearchFromTo(n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        float f = 0.0f;
        if (n3 >= 0) {
            f = this.values.getQuick(n3);
        }
        return f;
    }

    protected synchronized void insert(int n, int n2, int n3, float f) {
        this.rowIndexes.beforeInsert(n3, n);
        this.values.beforeInsert(n3, f);
        int n4 = this.columnPointers.length;
        while (--n4 > n2) {
            int n5 = n4;
            this.columnPointers[n5] = this.columnPointers[n5] + 1;
        }
    }

    public FloatMatrix2D like(int n, int n2) {
        return new CCFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new SparseFloatMatrix1D(n);
    }

    protected void remove(int n, int n2) {
        this.rowIndexes.remove(n2);
        this.values.remove(n2);
        int n3 = this.columnPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.columnPointers[n4] = this.columnPointers[n4] - 1;
        }
    }

    public int cardinality() {
        return this.rowIndexes.size();
    }

    public synchronized void setQuick(int n, int n2, float f) {
        int n3 = this.rowIndexes.binarySearchFromTo(n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        if (n3 >= 0) {
            if (f == 0.0f) {
                this.remove(n2, n3);
            } else {
                this.values.setQuick(n3, f);
            }
            return;
        }
        if (f != 0.0f) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, f);
        }
    }

    public DenseFloatMatrix2D getFull() {
        final DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntFloatFunction(){

            public float apply(int n, int n2, float f) {
                denseFloatMatrix2D.setQuick(n, n2, CCFloatMatrix2D.this.getQuick(n, n2));
                return f;
            }
        });
        return denseFloatMatrix2D;
    }

    public void trimToSize() {
        this.rowIndexes.trimToSize();
        this.values.trimToSize();
    }

    public FloatMatrix1D zMult(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, final float f, final float f2, boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = floatMatrix1D2 == null || bl;
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = new DenseFloatMatrix1D(n);
        }
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D) || !(floatMatrix1D2 instanceof DenseFloatMatrix1D)) {
            return super.zMult(floatMatrix1D, floatMatrix1D2, f, f2, bl);
        }
        if (n2 != floatMatrix1D.size() || n > floatMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + floatMatrix1D.toStringShort() + ", " + floatMatrix1D2.toStringShort());
        }
        DenseFloatMatrix1D denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D2;
        final float[] fArray = denseFloatMatrix1D.elements;
        final int n3 = denseFloatMatrix1D.stride();
        final int n4 = (int)denseFloatMatrix1D.index(0);
        DenseFloatMatrix1D denseFloatMatrix1D2 = (DenseFloatMatrix1D)floatMatrix1D;
        final float[] fArray2 = denseFloatMatrix1D2.elements;
        final int n5 = denseFloatMatrix1D2.stride();
        final int n6 = (int)denseFloatMatrix1D2.index(0);
        final int[] nArray = this.rowIndexes.elements();
        final float[] fArray3 = this.values.elements();
        int n7 = n4;
        if (!bl) {
            if (!bl2 && (double)(f2 / f) != 1.0) {
                floatMatrix1D2.assign(FloatFunctions.mult(f2 / f));
            }
            for (int i = 0; i < this.columns; ++i) {
                int n8 = this.columnPointers[i + 1];
                float f3 = fArray2[n6 + n5 * i];
                for (int j = this.columnPointers[i]; j < n8; ++j) {
                    int n9 = nArray[j];
                    int n10 = n4 + n3 * n9;
                    fArray[n10] = fArray[n10] + fArray3[j] * f3;
                }
            }
            if ((double)f != 1.0) {
                floatMatrix1D2.assign(FloatFunctions.mult(f));
            }
        } else {
            int n11 = ConcurrencyUtils.getNumberOfThreads();
            if (n11 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n11];
                int n12 = this.columns / n11;
                for (int i = 0; i < n11; ++i) {
                    final int n13 = i * n12;
                    final int n14 = i == n11 - 1 ? this.columns : n13 + n12;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 + n13 * n3;
                            for (int i = n13; i < n14; ++i) {
                                int n2 = CCFloatMatrix2D.this.columnPointers[i + 1];
                                float f3 = 0.0f;
                                for (int j = CCFloatMatrix2D.this.columnPointers[i]; j < n2; ++j) {
                                    int n32 = nArray[j];
                                    f3 += fArray3[j] * fArray2[n6 + n5 * n32];
                                }
                                fArray[n] = f * f3 + fArray[n] * f2;
                                n += n3;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n15 = this.columnPointers[i + 1];
                    float f4 = 0.0f;
                    for (int j = this.columnPointers[i]; j < n15; ++j) {
                        int n16 = nArray[j];
                        f4 += fArray3[j] * fArray2[n6 + n5 * n16];
                    }
                    fArray[n7] = f * f4 + fArray[n7] * f2;
                    n7 += n3;
                }
            }
        }
        return floatMatrix1D2;
    }

    public FloatMatrix2D zMult(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, float f, float f2, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl2) {
            floatMatrix2D = floatMatrix2D.viewDice();
        }
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = floatMatrix2D.columns();
        boolean bl4 = bl3 = floatMatrix2D2 == null;
        if (floatMatrix2D2 == null) {
            floatMatrix2D2 = new DenseFloatMatrix2D(n, n3);
        }
        if (floatMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? floatMatrix2D.viewDice() : floatMatrix2D).toStringShort());
        }
        if (floatMatrix2D2.rows() != n || floatMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? floatMatrix2D.viewDice() : floatMatrix2D).toStringShort() + ", " + floatMatrix2D2.toStringShort());
        }
        if (this == floatMatrix2D2 || floatMatrix2D == floatMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            floatMatrix2D2.assign(FloatFunctions.mult(f2));
        }
        FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            floatMatrix1DArray[n4] = floatMatrix2D.viewRow(n4);
        }
        FloatMatrix1D[] floatMatrix1DArray2 = new FloatMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            floatMatrix1DArray2[n5] = floatMatrix2D2.viewRow(n5);
        }
        FloatPlusMultSecond floatPlusMultSecond = FloatPlusMultSecond.plusMult(0.0f);
        int[] nArray = this.rowIndexes.elements();
        float[] fArray = this.values.elements();
        int n6 = this.columns;
        while (--n6 >= 0) {
            int n7 = this.columnPointers[n6];
            int n8 = this.columnPointers[n6 + 1];
            while (--n8 >= n7) {
                int n9 = nArray[n8];
                floatPlusMultSecond.multiplicator = fArray[n8] * f;
                if (!bl) {
                    floatMatrix1DArray2[n9].assign(floatMatrix1DArray[n6], floatPlusMultSecond);
                    continue;
                }
                floatMatrix1DArray2[n6].assign(floatMatrix1DArray[n9], floatPlusMultSecond);
            }
        }
        return floatMatrix2D2;
    }
}

