/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2DTest;
import cern.colt.matrix.tfloat.impl.DenseColFloatMatrix2D;

public class DenseColFloatMatrix2DTest
extends FloatMatrix2DTest {
    public DenseColFloatMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseColFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new DenseColFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new DenseColFloatMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testAssignFloatArray() {
        int n;
        float[] fArray = new float[this.NROWS * this.NCOLUMNS];
        for (n = 0; n < this.NROWS * this.NCOLUMNS; ++n) {
            fArray[n] = (float)Math.random();
        }
        this.A.assign(fArray);
        n = 0;
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)fArray[n++], (float)this.A.getQuick(j, i), (float)this.TOL);
            }
        }
    }

    public void testDct2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColFloatMatrix2D)this.A).dct2(true);
        ((DenseColFloatMatrix2D)this.A).idct2(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDctColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColFloatMatrix2D)this.A).dctColumns(true);
        ((DenseColFloatMatrix2D)this.A).idctColumns(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDctRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColFloatMatrix2D)this.A).dctRows(true);
        ((DenseColFloatMatrix2D)this.A).idctRows(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDht2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColFloatMatrix2D)this.A).dht2();
        ((DenseColFloatMatrix2D)this.A).idht2(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDhtColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColFloatMatrix2D)this.A).dhtColumns();
        ((DenseColFloatMatrix2D)this.A).idhtColumns(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDhtRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColFloatMatrix2D)this.A).dhtRows();
        ((DenseColFloatMatrix2D)this.A).idhtRows(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDst2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColFloatMatrix2D)this.A).dst2(true);
        ((DenseColFloatMatrix2D)this.A).idst2(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDstColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColFloatMatrix2D)this.A).dstColumns(true);
        ((DenseColFloatMatrix2D)this.A).idstColumns(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testDstRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        ((DenseColFloatMatrix2D)this.A).dstRows(true);
        ((DenseColFloatMatrix2D)this.A).idstRows(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)Math.abs(floatMatrix2D.getQuick(i, j) - this.A.getQuick(i, j)), (float)this.TOL);
            }
        }
    }

    public void testFft2() {
        int n = 64;
        int n2 = 128;
        DenseColFloatMatrix2D denseColFloatMatrix2D = new DenseColFloatMatrix2D(n, n2);
        FloatMatrix2D floatMatrix2D = denseColFloatMatrix2D.copy();
        denseColFloatMatrix2D.fft2();
        denseColFloatMatrix2D.ifft2(true);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                DenseColFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)((FloatMatrix2D)denseColFloatMatrix2D).getQuick(i, j), (float)this.TOL);
            }
        }
    }

    public void testGetFft2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        FComplexMatrix2D fComplexMatrix2D = ((DenseColFloatMatrix2D)this.A).getFft2();
        ((DenseFComplexMatrix2D)fComplexMatrix2D).ifft2(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                float[] fArray = fComplexMatrix2D.getQuick(i, j);
                DenseColFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetIfft2() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        FComplexMatrix2D fComplexMatrix2D = ((DenseColFloatMatrix2D)this.A).getIfft2(true);
        ((DenseFComplexMatrix2D)fComplexMatrix2D).fft2();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                float[] fArray = fComplexMatrix2D.getQuick(i, j);
                DenseColFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetFftColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        FComplexMatrix2D fComplexMatrix2D = ((DenseColFloatMatrix2D)this.A).getFftColumns();
        ((DenseFComplexMatrix2D)fComplexMatrix2D).ifftColumns(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                float[] fArray = fComplexMatrix2D.getQuick(i, j);
                DenseColFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetIfftColumns() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        FComplexMatrix2D fComplexMatrix2D = ((DenseColFloatMatrix2D)this.A).getIfftColumns(true);
        ((DenseFComplexMatrix2D)fComplexMatrix2D).fftColumns();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                float[] fArray = fComplexMatrix2D.getQuick(i, j);
                DenseColFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetFftRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        FComplexMatrix2D fComplexMatrix2D = ((DenseColFloatMatrix2D)this.A).getFftRows();
        ((DenseFComplexMatrix2D)fComplexMatrix2D).ifftRows(true);
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                float[] fArray = fComplexMatrix2D.getQuick(i, j);
                DenseColFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }

    public void testGetIfftRows() {
        FloatMatrix2D floatMatrix2D = this.A.copy();
        FComplexMatrix2D fComplexMatrix2D = ((DenseColFloatMatrix2D)this.A).getIfftRows(true);
        ((DenseFComplexMatrix2D)fComplexMatrix2D).fftRows();
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                float[] fArray = fComplexMatrix2D.getQuick(i, j);
                DenseColFloatMatrix2DTest.assertEquals((float)floatMatrix2D.getQuick(i, j), (float)fArray[0], (float)this.TOL);
                DenseColFloatMatrix2DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
            }
        }
    }
}

