/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1DTest;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;

public class DenseFloatMatrix1DTest
extends FloatMatrix1DTest {
    public DenseFloatMatrix1DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseFloatMatrix1D(this.SIZE);
        this.B = new DenseFloatMatrix1D(this.SIZE);
    }

    public void testDct() {
        FloatMatrix1D floatMatrix1D = this.A.copy();
        ((DenseFloatMatrix1D)this.A).dct(true);
        ((DenseFloatMatrix1D)this.A).idct(true);
        for (int i = 0; i < this.SIZE; ++i) {
            DenseFloatMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testDst() {
        FloatMatrix1D floatMatrix1D = this.A.copy();
        ((DenseFloatMatrix1D)this.A).dst(true);
        ((DenseFloatMatrix1D)this.A).idst(true);
        for (int i = 0; i < this.SIZE; ++i) {
            DenseFloatMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testDht() {
        FloatMatrix1D floatMatrix1D = this.A.copy();
        ((DenseFloatMatrix1D)this.A).dht();
        ((DenseFloatMatrix1D)this.A).idht(true);
        for (int i = 0; i < this.SIZE; ++i) {
            DenseFloatMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testFft() {
        FloatMatrix1D floatMatrix1D = this.A.copy();
        ((DenseFloatMatrix1D)this.A).fft();
        ((DenseFloatMatrix1D)this.A).ifft(true);
        for (int i = 0; i < this.SIZE; ++i) {
            DenseFloatMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testGetFft() {
        FloatMatrix1D floatMatrix1D = this.A.copy();
        DenseFComplexMatrix1D denseFComplexMatrix1D = ((DenseFloatMatrix1D)this.A).getFft();
        denseFComplexMatrix1D.ifft(true);
        for (int i = 0; i < this.SIZE; ++i) {
            float[] fArray = ((FComplexMatrix1D)denseFComplexMatrix1D).getQuick(i);
            DenseFloatMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)fArray[0], (float)this.TOL);
            DenseFloatMatrix1DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
        }
    }

    public void testGetIfft() {
        FloatMatrix1D floatMatrix1D = this.A.copy();
        DenseFComplexMatrix1D denseFComplexMatrix1D = ((DenseFloatMatrix1D)this.A).getIfft(true);
        denseFComplexMatrix1D.fft();
        for (int i = 0; i < this.SIZE; ++i) {
            float[] fArray = ((FComplexMatrix1D)denseFComplexMatrix1D).getQuick(i);
            DenseFloatMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)fArray[0], (float)this.TOL);
            DenseFloatMatrix1DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
        }
    }
}

