/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalFloatMatrix2D
extends WrapperFloatMatrix2D {
    protected float[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalFloatMatrix2D(float[][] fArray, int n) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length, n);
        this.assign(fArray);
    }

    public DiagonalFloatMatrix2D(int n, int n2, int n3) {
        int n4;
        int n5;
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (n3 < -n + 1 || n3 > n2 - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = n3;
        this.dlength = n3 == 0 ? Math.min(n, n2) : (n3 > 0 ? (n >= n2 ? n2 - n3 : (n3 <= (n5 = n2 - n) ? n : n - (n3 - n5))) : (n >= n2 ? (-n3 <= (n4 = n - n2) ? n2 : n2 + n3 + n4) : n + n3));
        this.elements = new float[this.dlength];
    }

    public FloatMatrix2D assign(FloatFunction floatFunction) {
        if (floatFunction instanceof FloatMult) {
            float f = ((FloatMult)floatFunction).multiplicator;
            if (f == 1.0f) {
                return this;
            }
            if (f == 0.0f) {
                return this.assign(0.0f);
            }
            if (f != f) {
                return this.assign(f);
            }
            int n = this.dlength;
            while (--n >= 0) {
                int n2 = n;
                this.elements[n2] = this.elements[n2] * f;
            }
        } else {
            int n = this.dlength;
            while (--n >= 0) {
                this.elements[n] = floatFunction.apply(this.elements[n]);
            }
        }
        return this;
    }

    public FloatMatrix2D assign(float f) {
        int n = this.dlength;
        while (--n >= 0) {
            this.elements[n] = f;
        }
        return this;
    }

    public FloatMatrix2D assign(final float[] fArray) {
        if (fArray.length != this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + " dlength=" + this.dlength);
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.dlength / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DiagonalFloatMatrix2D.this.elements[i] = fArray[i];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.dlength;
            while (--n5 >= 0) {
                this.elements[n5] = fArray[n5];
            }
        }
        return this;
    }

    public FloatMatrix2D assign(float[][] fArray) {
        int n;
        int n2;
        if (fArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + fArray.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            n2 = 0;
            n = this.dindex;
        } else {
            n2 = -this.dindex;
            n = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (fArray[i].length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray[n2].length + "columns()=" + this.columns());
            }
            this.elements[i] = fArray[n2++][n++];
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D == this) {
            return this;
        }
        this.checkShape(floatMatrix2D);
        if (floatMatrix2D instanceof DiagonalFloatMatrix2D) {
            DiagonalFloatMatrix2D diagonalFloatMatrix2D = (DiagonalFloatMatrix2D)floatMatrix2D;
            if (this.dindex != diagonalFloatMatrix2D.dindex || this.dlength != diagonalFloatMatrix2D.dlength) {
                throw new IllegalArgumentException("source is DiagonalFloatMatrix2D with different diagonal stored.");
            }
            System.arraycopy(diagonalFloatMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(floatMatrix2D);
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D, final FloatFloatFunction floatFloatFunction) {
        this.checkShape(floatMatrix2D);
        if (floatMatrix2D instanceof DiagonalFloatMatrix2D) {
            float f;
            DiagonalFloatMatrix2D diagonalFloatMatrix2D = (DiagonalFloatMatrix2D)floatMatrix2D;
            if (this.dindex != diagonalFloatMatrix2D.dindex || this.dlength != diagonalFloatMatrix2D.dlength) {
                throw new IllegalArgumentException("y is DiagonalFloatMatrix2D with different diagonal stored.");
            }
            if (floatFloatFunction instanceof FloatPlusMultSecond && (f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator) == 0.0f) {
                return this;
            }
            final float[] fArray = diagonalFloatMatrix2D.elements;
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.dlength / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.dlength : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (floatFloatFunction instanceof FloatPlusMultSecond) {
                                float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
                                if (f == 1.0f) {
                                    for (int i = n3; i < n4; ++i) {
                                        int n = i;
                                        DiagonalFloatMatrix2D.this.elements[n] = DiagonalFloatMatrix2D.this.elements[n] + fArray[i];
                                    }
                                } else {
                                    for (int i = n3; i < n4; ++i) {
                                        DiagonalFloatMatrix2D.this.elements[i] = DiagonalFloatMatrix2D.this.elements[i] + f * fArray[i];
                                    }
                                }
                            } else if (floatFloatFunction == FloatFunctions.mult) {
                                for (int i = n3; i < n4; ++i) {
                                    DiagonalFloatMatrix2D.this.elements[i] = DiagonalFloatMatrix2D.this.elements[i] * fArray[i];
                                }
                            } else if (floatFloatFunction == FloatFunctions.div) {
                                for (int i = n3; i < n4; ++i) {
                                    DiagonalFloatMatrix2D.this.elements[i] = DiagonalFloatMatrix2D.this.elements[i] / fArray[i];
                                }
                            } else {
                                for (int i = n3; i < n4; ++i) {
                                    DiagonalFloatMatrix2D.this.elements[i] = floatFloatFunction.apply(DiagonalFloatMatrix2D.this.elements[i], fArray[i]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else if (floatFloatFunction instanceof FloatPlusMultSecond) {
                float f2 = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
                if (f2 == 1.0f) {
                    int n5 = this.dlength;
                    while (--n5 >= 0) {
                        int n6 = n5;
                        this.elements[n6] = this.elements[n6] + fArray[n5];
                    }
                } else {
                    int n7 = this.dlength;
                    while (--n7 >= 0) {
                        this.elements[n7] = this.elements[n7] + f2 * fArray[n7];
                    }
                }
            } else if (floatFloatFunction == FloatFunctions.mult) {
                int n8 = this.dlength;
                while (--n8 >= 0) {
                    this.elements[n8] = this.elements[n8] * fArray[n8];
                }
            } else if (floatFloatFunction == FloatFunctions.div) {
                int n9 = this.dlength;
                while (--n9 >= 0) {
                    this.elements[n9] = this.elements[n9] / fArray[n9];
                }
            } else {
                int n10 = this.dlength;
                while (--n10 >= 0) {
                    this.elements[n10] = floatFloatFunction.apply(this.elements[n10], fArray[n10]);
                }
            }
            return this;
        }
        return super.assign(floatMatrix2D, floatFloatFunction);
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.dlength / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.dlength : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (DiagonalFloatMatrix2D.this.elements[i] == 0.0f) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.dlength; ++i) {
                if (this.elements[i] == 0.0f) continue;
                ++n;
            }
        }
        return n;
    }

    public float[] elements() {
        return this.elements;
    }

    public boolean equals(float f) {
        float f2 = FloatProperty.DEFAULT.tolerance();
        for (int i = 0; i < this.dlength; ++i) {
            float f3 = this.elements[i];
            float f4 = Math.abs(f - f3);
            if (f4 != f4 && (f != f && f3 != f3 || f == f3)) {
                f4 = 0.0f;
            }
            if (f4 <= f2) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof DiagonalFloatMatrix2D) {
            DiagonalFloatMatrix2D diagonalFloatMatrix2D = (DiagonalFloatMatrix2D)object;
            float f = FloatProperty.DEFAULT.tolerance();
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            int n = this.rows();
            int n2 = this.columns();
            if (n2 != diagonalFloatMatrix2D.columns() || n != diagonalFloatMatrix2D.rows()) {
                return false;
            }
            if (this.dindex != diagonalFloatMatrix2D.dindex || this.dlength != diagonalFloatMatrix2D.dlength) {
                return false;
            }
            float[] fArray = diagonalFloatMatrix2D.elements;
            for (int i = 0; i < this.dlength; ++i) {
                float f2 = fArray[i];
                float f3 = this.elements[i];
                float f4 = Math.abs(f2 - f3);
                if (f4 != f4 && (f2 != f2 && f3 != f3 || f2 == f3)) {
                    f4 = 0.0f;
                }
                if (f4 <= f) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public FloatMatrix2D forEachNonZero(IntIntFloatFunction intIntFloatFunction) {
        int n = this.dlength;
        while (--n >= 0) {
            float f = this.elements[n];
            if (f == 0.0f) continue;
            this.elements[n] = intIntFloatFunction.apply(n, n, f);
        }
        return this;
    }

    public int dlength() {
        return this.dlength;
    }

    public int dindex() {
        return this.dindex;
    }

    public float[] getMaxLocation() {
        int n;
        int n2;
        int n3 = 0;
        float f = 0.0f;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            Future[] futureArray = new Future[n4];
            float[][] fArray = new float[n4][2];
            int n6 = this.dlength / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.dlength : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = n7;
                        float f = DiagonalFloatMatrix2D.this.elements[n];
                        for (int i = n7 + 1; i < n8; ++i) {
                            float f2 = DiagonalFloatMatrix2D.this.elements[i];
                            if (!(f < f2)) continue;
                            f = f2;
                            n = i;
                        }
                        return new float[]{f, n, n};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    fArray[n5] = (float[])futureArray[n5].get();
                }
                f = fArray[0][0];
                n3 = (int)fArray[0][1];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(f < fArray[n5][0])) continue;
                    f = fArray[n5][0];
                    n3 = (int)fArray[n5][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.elements[0];
            for (int i = 1; i < this.dlength; ++i) {
                float f2 = this.elements[i];
                if (!(f < f2)) continue;
                f = f2;
                n3 = i;
            }
        }
        if (this.dindex > 0) {
            n2 = n3;
            n = n3 + this.dindex;
        } else if (this.dindex < 0) {
            n2 = n3 - this.dindex;
            n = n3;
        } else {
            n2 = n3;
            n = n3;
        }
        return new float[]{f, n2, n};
    }

    public float[] getMinLocation() {
        int n;
        int n2;
        int n3 = 0;
        float f = 0.0f;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            Future[] futureArray = new Future[n4];
            float[][] fArray = new float[n4][2];
            int n6 = this.dlength / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.dlength : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = n7;
                        float f = DiagonalFloatMatrix2D.this.elements[n];
                        for (int i = n7 + 1; i < n8; ++i) {
                            float f2 = DiagonalFloatMatrix2D.this.elements[i];
                            if (!(f > f2)) continue;
                            f = f2;
                            n = i;
                        }
                        return new float[]{f, n, n};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    fArray[n5] = (float[])futureArray[n5].get();
                }
                f = fArray[0][0];
                n3 = (int)fArray[0][1];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(f > fArray[n5][0])) continue;
                    f = fArray[n5][0];
                    n3 = (int)fArray[n5][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.elements[0];
            for (int i = 1; i < this.dlength; ++i) {
                float f2 = this.elements[i];
                if (!(f > f2)) continue;
                f = f2;
                n3 = i;
            }
        }
        if (this.dindex > 0) {
            n2 = n3;
            n = n3 + this.dindex;
        } else if (this.dindex < 0) {
            n2 = n3 - this.dindex;
            n = n3;
        } else {
            n2 = n3;
            n = n3;
        }
        return new float[]{f, n2, n};
    }

    public float getQuick(int n, int n2) {
        if (this.dindex >= 0) {
            if (n2 < this.dindex) {
                return 0.0f;
            }
            if (n < this.dlength && n + this.dindex == n2) {
                return this.elements[n];
            }
            return 0.0f;
        }
        if (n < -this.dindex) {
            return 0.0f;
        }
        if (n2 < this.dlength && n + this.dindex == n2) {
            return this.elements[n2];
        }
        return 0.0f;
    }

    public FloatMatrix2D like(int n, int n2) {
        return new SparseFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new SparseFloatMatrix1D(n);
    }

    public void setQuick(int n, int n2, float f) {
        if (this.dindex >= 0) {
            if (n2 >= this.dindex && n < this.dlength && n + this.dindex == n2) {
                this.elements[n] = f;
            }
        } else if (n >= -this.dindex && n2 < this.dlength && n + this.dindex == n2) {
            this.elements[n2] = f;
        }
    }

    public FloatMatrix1D zMult(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, float f, float f2, boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = floatMatrix1D2 == null;
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = new DenseFloatMatrix1D(n);
        }
        if (!(this.isNoView && floatMatrix1D instanceof DenseFloatMatrix1D && floatMatrix1D2 instanceof DenseFloatMatrix1D)) {
            return super.zMult(floatMatrix1D, floatMatrix1D2, f, f2, bl);
        }
        if (n2 != floatMatrix1D.size() || n > floatMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + floatMatrix1D.toStringShort() + ", " + floatMatrix1D2.toStringShort());
        }
        if (!bl2 && f2 / f != 1.0f) {
            floatMatrix1D2.assign(FloatFunctions.mult(f2 / f));
        }
        DenseFloatMatrix1D denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D2;
        float[] fArray = denseFloatMatrix1D.elements;
        int n3 = denseFloatMatrix1D.stride();
        int n4 = (int)floatMatrix1D2.index(0);
        DenseFloatMatrix1D denseFloatMatrix1D2 = (DenseFloatMatrix1D)floatMatrix1D;
        float[] fArray2 = denseFloatMatrix1D2.elements;
        int n5 = denseFloatMatrix1D2.stride();
        int n6 = (int)floatMatrix1D.index(0);
        if (fArray2 == null || fArray == null) {
            throw new InternalError();
        }
        if (!bl) {
            if (this.dindex >= 0) {
                int n7 = this.dlength;
                while (--n7 >= 0) {
                    int n8 = n4 + n3 * n7;
                    fArray[n8] = fArray[n8] + this.elements[n7] * fArray2[this.dindex + n6 + n5 * n7];
                }
            } else {
                int n9 = this.dlength;
                while (--n9 >= 0) {
                    int n10 = -this.dindex + n4 + n3 * n9;
                    fArray[n10] = fArray[n10] + this.elements[n9] * fArray2[n6 + n5 * n9];
                }
            }
        } else if (this.dindex >= 0) {
            int n11 = this.dlength;
            while (--n11 >= 0) {
                int n12 = this.dindex + n4 + n3 * n11;
                fArray[n12] = fArray[n12] + this.elements[n11] * fArray2[n6 + n5 * n11];
            }
        } else {
            int n13 = this.dlength;
            while (--n13 >= 0) {
                int n14 = n4 + n3 * n13;
                fArray[n14] = fArray[n14] + this.elements[n13] * fArray2[-this.dindex + n6 + n5 * n13];
            }
        }
        if (f != 1.0f) {
            floatMatrix1D2.assign(FloatFunctions.mult(f));
        }
        return floatMatrix1D2;
    }

    protected FloatMatrix2D getContent() {
        return this;
    }
}

