/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultFirst;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class RCFloatMatrix2D
extends WrapperFloatMatrix2D {
    protected IntArrayList columnIndexes;
    protected FloatArrayList values;
    protected int[] rowPointers;

    public RCFloatMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length);
        this.assign(fArray);
    }

    public RCFloatMatrix2D(int n, int n2, int[] nArray, IntArrayList intArrayList, FloatArrayList floatArrayList) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowPointers = nArray;
        this.columnIndexes = intArrayList;
        this.values = floatArrayList;
    }

    public RCFloatMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new IntArrayList();
        this.values = new FloatArrayList();
        this.rowPointers = new int[n + 1];
    }

    public RCFloatMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new IntArrayList(n3);
        this.values = new FloatArrayList(n3);
        this.rowPointers = new int[n + 1];
    }

    public RCFloatMatrix2D(int n, int n2, IntArrayList intArrayList, IntArrayList intArrayList2, float f) {
        int n3;
        block4: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block4;
                throw illegalArgumentException;
            }
        }
        int n4 = intArrayList.size();
        int[] nArray = intArrayList.elements();
        int[] nArray2 = intArrayList2.elements();
        int[] nArray3 = new int[n4];
        float[] fArray = new float[n4];
        int[] nArray4 = new int[n + 1];
        int[] nArray5 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray5[n5] = nArray5[n5] + 1;
        }
        this.cumsum(nArray4, nArray5, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray5[n6] = nArray5[n6] + 1;
            nArray3[var13_15] = nArray2[n3];
            fArray[var13_15] = f;
        }
        this.rowPointers = nArray4;
        this.columnIndexes = new IntArrayList(nArray3);
        this.values = new FloatArrayList(fArray);
    }

    public RCFloatMatrix2D(int n, int n2, IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        int n3;
        block4: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block4;
                throw illegalArgumentException;
            }
        }
        int n4 = intArrayList.size();
        int[] nArray = intArrayList.elements();
        int[] nArray2 = intArrayList2.elements();
        float[] fArray = floatArrayList.elements();
        int[] nArray3 = new int[n4];
        float[] fArray2 = new float[n4];
        int[] nArray4 = new int[n + 1];
        int[] nArray5 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray5[n5] = nArray5[n5] + 1;
        }
        this.cumsum(nArray4, nArray5, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray5[n6] = nArray5[n6] + 1;
            nArray3[var14_16] = nArray2[n3];
            fArray2[var14_16] = fArray[n3];
        }
        this.rowPointers = nArray4;
        this.columnIndexes = new IntArrayList(nArray3);
        this.values = new FloatArrayList(fArray2);
    }

    private float cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            f += (float)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return f;
    }

    public FloatMatrix2D assign(float f) {
        if (f == 0.0f) {
            this.columnIndexes.clear();
            this.values.clear();
            this.rowPointers = new int[this.rows + 1];
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values.setQuick(i, f);
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatFunction floatFunction) {
        if (floatFunction instanceof FloatMult) {
            final float f = ((FloatMult)floatFunction).multiplicator;
            if (f == 1.0f) {
                return this;
            }
            if (f == 0.0f) {
                return this.assign(0.0f);
            }
            if (f != f) {
                return this.assign(f);
            }
            final float[] fArray = this.values.elements();
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                Future[] futureArray = new Future[n];
                int n2 = fArray.length / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? fArray.length : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n3;
                            while (n < n4) {
                                int n2 = n++;
                                fArray[n2] = fArray[n2] * f;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = this.values.size();
                while (--n5 >= 0) {
                    int n6 = n5;
                    fArray[n6] = fArray[n6] * f;
                }
            }
        } else {
            this.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f) {
                    return floatFunction.apply(f);
                }
            });
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D == this) {
            return this;
        }
        this.checkShape(floatMatrix2D);
        if (!(floatMatrix2D instanceof RCFloatMatrix2D)) {
            this.assign(0.0f);
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f) {
                    RCFloatMatrix2D.this.setQuick(n, n2, f);
                    return f;
                }
            });
            return this;
        }
        RCFloatMatrix2D rCFloatMatrix2D = (RCFloatMatrix2D)floatMatrix2D;
        System.arraycopy(rCFloatMatrix2D.rowPointers, 0, this.rowPointers, 0, this.rowPointers.length);
        int n = rCFloatMatrix2D.columnIndexes.size();
        this.columnIndexes.setSize(n);
        this.values.setSize(n);
        this.columnIndexes.replaceFromToWithFrom(0, n - 1, rCFloatMatrix2D.columnIndexes, 0);
        this.values.replaceFromToWithFrom(0, n - 1, rCFloatMatrix2D.values, 0);
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D, FloatFloatFunction floatFloatFunction) {
        Object[] objectArray;
        Object object;
        this.checkShape(floatMatrix2D);
        if (floatMatrix2D instanceof RCFloatMatrix2D && floatFloatFunction == FloatFunctions.plus) {
            object = (RCFloatMatrix2D)floatMatrix2D;
            objectArray = this.rowPointers;
            int[] nArray = this.columnIndexes.elements();
            float[] fArray = this.values.elements();
            int[] nArray2 = ((RCFloatMatrix2D)object).rowPointers;
            int[] nArray3 = ((RCFloatMatrix2D)object).columnIndexes.elements();
            float[] fArray2 = ((RCFloatMatrix2D)object).values.elements();
            int[] nArray4 = new int[objectArray.length];
            int[] nArray5 = new int[nArray.length];
            float[] fArray3 = new float[fArray.length];
            int n = this.rows;
            int n2 = this.columns;
            int n3 = fArray.length;
            int n4 = this.cardinality();
            if (floatFloatFunction == FloatFunctions.plus) {
                int n5;
                nArray4[0] = n5 = 0;
                for (int i = 0; i < n; ++i) {
                    int n6 = objectArray[i];
                    int n7 = nArray2[i];
                    int n8 = objectArray[i + 1] - 1;
                    int n9 = nArray2[i + 1] - 1;
                    while (n6 <= n8 || n7 <= n9) {
                        int n10;
                        int n11 = n6 <= n8 ? nArray[n6] : n2 + 1;
                        if (n11 == (n10 = n7 <= n9 ? nArray3[n7] : n2 + 1)) {
                            fArray3[n5] = fArray[n6] + fArray2[n7];
                            nArray5[n5] = n11;
                            ++n6;
                            ++n7;
                            ++n5;
                        } else if (n11 < n10) {
                            nArray5[n5] = n11;
                            fArray3[n5] = fArray[n6];
                            ++n6;
                            ++n5;
                        } else if (n11 > n10) {
                            nArray5[n5] = n10;
                            fArray3[n5] = fArray2[n7];
                            ++n7;
                            ++n5;
                            ++n4;
                        }
                        if (n5 < n3) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    nArray4[i + 1] = n5;
                }
                this.rowPointers = nArray4;
                this.columnIndexes = new IntArrayList(nArray5);
                this.columnIndexes.setSizeRaw(n4);
                this.values = new FloatArrayList(fArray3);
                this.values.setSizeRaw(n4);
                return this;
            }
        }
        if (floatFloatFunction instanceof FloatPlusMultSecond) {
            final float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
            if (f == 0.0f) {
                return this;
            }
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f2) {
                    RCFloatMatrix2D.this.setQuick(n, n2, RCFloatMatrix2D.this.getQuick(n, n2) + f * f2);
                    return f2;
                }
            });
            return this;
        }
        if (floatFloatFunction instanceof FloatPlusMultFirst) {
            final float f = ((FloatPlusMultFirst)floatFloatFunction).multiplicator;
            if (f == 0.0f) {
                return this.assign(floatMatrix2D);
            }
            floatMatrix2D.forEachNonZero(new IntIntFloatFunction(){

                public float apply(int n, int n2, float f2) {
                    RCFloatMatrix2D.this.setQuick(n, n2, f * RCFloatMatrix2D.this.getQuick(n, n2) + f2);
                    return f2;
                }
            });
            return this;
        }
        if (floatFloatFunction == FloatFunctions.mult) {
            object = this.columnIndexes.elements();
            objectArray = this.values.elements();
            int n = this.rowPointers.length - 1;
            while (--n >= 0) {
                int n12 = this.rowPointers[n];
                int n13 = this.rowPointers[n + 1];
                while (--n13 >= n12) {
                    Object object2 = object[n13];
                    int n14 = n13;
                    objectArray[n14] = objectArray[n14] * floatMatrix2D.getQuick(n, (int)object2);
                    if (objectArray[n13] != 0.0f) continue;
                    this.remove(n, (int)object2);
                }
            }
            return this;
        }
        if (floatFloatFunction == FloatFunctions.div) {
            object = this.columnIndexes.elements();
            objectArray = this.values.elements();
            int n = this.rowPointers.length - 1;
            while (--n >= 0) {
                int n15 = this.rowPointers[n];
                int n16 = this.rowPointers[n + 1];
                while (--n16 >= n15) {
                    Object object3 = object[n16];
                    int n17 = n16;
                    objectArray[n17] = objectArray[n17] / floatMatrix2D.getQuick(n, (int)object3);
                    if (objectArray[n16] != 0.0f) continue;
                    this.remove(n, (int)object3);
                }
            }
            return this;
        }
        return super.assign(floatMatrix2D, floatFloatFunction);
    }

    public FloatMatrix2D forEachNonZero(final IntIntFloatFunction intIntFloatFunction) {
        final int[] nArray = this.columnIndexes.elements();
        final float[] fArray = this.values.elements();
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = (this.rowPointers.length - 1) / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rowPointers.length - 1 : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int n = RCFloatMatrix2D.this.rowPointers[i + 1];
                            for (int j = RCFloatMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                int n2 = nArray[j];
                                float f = fArray[j];
                                float f2 = intIntFloatFunction.apply(i, n2, f);
                                if (f2 == f) continue;
                                fArray[j] = f2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.rowPointers.length - 1;
            while (--n5 >= 0) {
                int n6 = this.rowPointers[n5];
                int n7 = this.rowPointers[n5 + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    float f = fArray[n7];
                    float f2 = intIntFloatFunction.apply(n5, n8, f);
                    if (f2 == f) continue;
                    fArray[n7] = f2;
                }
            }
        }
        return this;
    }

    protected FloatMatrix2D getContent() {
        return this;
    }

    public IntArrayList getColumnindexes() {
        return this.columnIndexes;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public FloatArrayList getValues() {
        return this.values;
    }

    public float getQuick(int n, int n2) {
        int n3 = this.columnIndexes.binarySearchFromTo(n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        float f = 0.0f;
        if (n3 >= 0) {
            f = this.values.getQuick(n3);
        }
        return f;
    }

    protected synchronized void insert(int n, int n2, int n3, float f) {
        this.columnIndexes.beforeInsert(n3, n2);
        this.values.beforeInsert(n3, f);
        int n4 = this.rowPointers.length;
        while (--n4 > n) {
            int n5 = n4;
            this.rowPointers[n5] = this.rowPointers[n5] + 1;
        }
    }

    public FloatMatrix2D like(int n, int n2) {
        return new RCFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new SparseFloatMatrix1D(n);
    }

    protected void remove(int n, int n2) {
        this.columnIndexes.remove(n2);
        this.values.remove(n2);
        int n3 = this.rowPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.rowPointers[n4] = this.rowPointers[n4] - 1;
        }
    }

    public int cardinality() {
        return this.columnIndexes.size();
    }

    public synchronized void setQuick(int n, int n2, float f) {
        int n3 = this.columnIndexes.binarySearchFromTo(n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n3 >= 0) {
            if (f == 0.0f) {
                this.remove(n, n3);
            } else {
                this.values.setQuick(n3, f);
            }
            return;
        }
        if (f != 0.0f) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, f);
        }
    }

    public float[][] toArray() {
        float[][] fArray = new float[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                fArray[i][j] = this.getQuick(i, j);
            }
        }
        return fArray;
    }

    public void trimToSize() {
        this.columnIndexes.trimToSize();
        this.values.trimToSize();
    }

    public FloatMatrix1D zMult(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, final float f, final float f2, boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = floatMatrix1D2 == null || !bl;
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = new DenseFloatMatrix1D(n);
        }
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D) || !(floatMatrix1D2 instanceof DenseFloatMatrix1D)) {
            return super.zMult(floatMatrix1D, floatMatrix1D2, f, f2, bl);
        }
        if (n2 != floatMatrix1D.size() || n > floatMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + floatMatrix1D.toStringShort() + ", " + floatMatrix1D2.toStringShort());
        }
        DenseFloatMatrix1D denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D2;
        final float[] fArray = denseFloatMatrix1D.elements;
        final int n3 = denseFloatMatrix1D.stride();
        final int n4 = (int)floatMatrix1D2.index(0);
        DenseFloatMatrix1D denseFloatMatrix1D2 = (DenseFloatMatrix1D)floatMatrix1D;
        final float[] fArray2 = denseFloatMatrix1D2.elements;
        final int n5 = denseFloatMatrix1D2.stride();
        final int n6 = (int)floatMatrix1D.index(0);
        final int[] nArray = this.columnIndexes.elements();
        final float[] fArray3 = this.values.elements();
        if (bl) {
            if (!bl2 && (double)f2 != 1.0) {
                floatMatrix1D2.assign(FloatFunctions.mult(f2));
            }
            for (int i = 0; i < this.rows; ++i) {
                int n7 = this.rowPointers[i + 1];
                float f3 = f * fArray2[n6 + n5 * i];
                for (int j = this.rowPointers[i]; j < n7; ++j) {
                    int n8 = nArray[j];
                    int n9 = n4 + n3 * n8;
                    fArray[n9] = fArray[n9] + fArray3[j] * f3;
                }
            }
            return floatMatrix1D2;
        }
        int n10 = ConcurrencyUtils.getNumberOfThreads();
        if (n10 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n10];
            int n11 = this.rows / n10;
            for (int i = 0; i < n10; ++i) {
                final int n12 = i * n11;
                final int n13 = i == n10 - 1 ? this.rows : n12 + n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n12 * n3;
                        int n2 = RCFloatMatrix2D.this.rowPointers[n12];
                        if ((double)f2 == 0.0) {
                            for (int i = n12; i < n13; ++i) {
                                float f3 = 0.0f;
                                int n32 = RCFloatMatrix2D.this.rowPointers[i + 1];
                                while (n2 + 10 < n32) {
                                    int n42 = n2 + 9;
                                    f3 += fArray3[n42] * fArray2[n6 + n5 * nArray[n42--]] + fArray3[n42] * fArray2[n6 + n5 * nArray[n42--]] + fArray3[n42] * fArray2[n6 + n5 * nArray[n42--]] + fArray3[n42] * fArray2[n6 + n5 * nArray[n42--]] + fArray3[n42] * fArray2[n6 + n5 * nArray[n42--]] + fArray3[n42] * fArray2[n6 + n5 * nArray[n42--]] + fArray3[n42] * fArray2[n6 + n5 * nArray[n42--]] + fArray3[n42] * fArray2[n6 + n5 * nArray[n42--]] + fArray3[n42] * fArray2[n6 + n5 * nArray[n42--]] + fArray3[n42] * fArray2[n6 + n5 * nArray[n42--]];
                                    n2 += 10;
                                }
                                while (n2 < n32) {
                                    f3 += fArray3[n2] * fArray2[nArray[n2]];
                                    ++n2;
                                }
                                fArray[n] = f * f3;
                                n += n3;
                            }
                        } else {
                            for (int i = n12; i < n13; ++i) {
                                float f4 = 0.0f;
                                int n52 = RCFloatMatrix2D.this.rowPointers[i + 1];
                                while (n2 + 10 < n52) {
                                    int n62 = n2 + 9;
                                    f4 += fArray3[n62] * fArray2[n6 + n5 * nArray[n62--]] + fArray3[n62] * fArray2[n6 + n5 * nArray[n62--]] + fArray3[n62] * fArray2[n6 + n5 * nArray[n62--]] + fArray3[n62] * fArray2[n6 + n5 * nArray[n62--]] + fArray3[n62] * fArray2[n6 + n5 * nArray[n62--]] + fArray3[n62] * fArray2[n6 + n5 * nArray[n62--]] + fArray3[n62] * fArray2[n6 + n5 * nArray[n62--]] + fArray3[n62] * fArray2[n6 + n5 * nArray[n62--]] + fArray3[n62] * fArray2[n6 + n5 * nArray[n62--]] + fArray3[n62] * fArray2[n6 + n5 * nArray[n62--]];
                                    n2 += 10;
                                }
                                while (n2 < n52) {
                                    f4 += fArray3[n2] * fArray2[nArray[n2]];
                                    ++n2;
                                }
                                fArray[n] = f * f4 + f2 * fArray[n];
                                n += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n14 = n4;
            int n15 = this.rowPointers[0];
            if ((double)f2 == 0.0) {
                for (int i = 0; i < this.rows; ++i) {
                    float f4 = 0.0f;
                    int n16 = this.rowPointers[i + 1];
                    while (n15 + 10 < n16) {
                        int n17 = n15 + 9;
                        f4 += fArray3[n17] * fArray2[n6 + n5 * nArray[n17--]] + fArray3[n17] * fArray2[n6 + n5 * nArray[n17--]] + fArray3[n17] * fArray2[n6 + n5 * nArray[n17--]] + fArray3[n17] * fArray2[n6 + n5 * nArray[n17--]] + fArray3[n17] * fArray2[n6 + n5 * nArray[n17--]] + fArray3[n17] * fArray2[n6 + n5 * nArray[n17--]] + fArray3[n17] * fArray2[n6 + n5 * nArray[n17--]] + fArray3[n17] * fArray2[n6 + n5 * nArray[n17--]] + fArray3[n17] * fArray2[n6 + n5 * nArray[n17--]] + fArray3[n17] * fArray2[n6 + n5 * nArray[n17--]];
                        n15 += 10;
                    }
                    while (n15 < n16) {
                        f4 += fArray3[n15] * fArray2[nArray[n15]];
                        ++n15;
                    }
                    fArray[n14] = f * f4;
                    n14 += n3;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    float f5 = 0.0f;
                    int n18 = this.rowPointers[i + 1];
                    while (n15 + 10 < n18) {
                        int n19 = n15 + 9;
                        f5 += fArray3[n19] * fArray2[n6 + n5 * nArray[n19--]] + fArray3[n19] * fArray2[n6 + n5 * nArray[n19--]] + fArray3[n19] * fArray2[n6 + n5 * nArray[n19--]] + fArray3[n19] * fArray2[n6 + n5 * nArray[n19--]] + fArray3[n19] * fArray2[n6 + n5 * nArray[n19--]] + fArray3[n19] * fArray2[n6 + n5 * nArray[n19--]] + fArray3[n19] * fArray2[n6 + n5 * nArray[n19--]] + fArray3[n19] * fArray2[n6 + n5 * nArray[n19--]] + fArray3[n19] * fArray2[n6 + n5 * nArray[n19--]] + fArray3[n19] * fArray2[n6 + n5 * nArray[n19--]];
                        n15 += 10;
                    }
                    while (n15 < n18) {
                        f5 += fArray3[n15] * fArray2[nArray[n15]];
                        ++n15;
                    }
                    fArray[n14] = f * f5 + f2 * fArray[n14];
                    n14 += n3;
                }
            }
        }
        return floatMatrix1D2;
    }

    public FloatMatrix2D zMult(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, float f, float f2, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl2) {
            floatMatrix2D = floatMatrix2D.viewDice();
        }
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = floatMatrix2D.columns();
        boolean bl4 = bl3 = floatMatrix2D2 == null;
        if (floatMatrix2D2 == null) {
            floatMatrix2D2 = new DenseFloatMatrix2D(n, n3);
        }
        if (floatMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? floatMatrix2D.viewDice() : floatMatrix2D).toStringShort());
        }
        if (floatMatrix2D2.rows() != n || floatMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? floatMatrix2D.viewDice() : floatMatrix2D).toStringShort() + ", " + floatMatrix2D2.toStringShort());
        }
        if (this == floatMatrix2D2 || floatMatrix2D == floatMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            floatMatrix2D2.assign(FloatFunctions.mult(f2));
        }
        FloatMatrix1D[] floatMatrix1DArray = new FloatMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            floatMatrix1DArray[n4] = floatMatrix2D.viewRow(n4);
        }
        FloatMatrix1D[] floatMatrix1DArray2 = new FloatMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            floatMatrix1DArray2[n5] = floatMatrix2D2.viewRow(n5);
        }
        FloatPlusMultSecond floatPlusMultSecond = FloatPlusMultSecond.plusMult(0.0f);
        int[] nArray = this.columnIndexes.elements();
        float[] fArray = this.values.elements();
        int n6 = this.rowPointers.length - 1;
        while (--n6 >= 0) {
            int n7 = this.rowPointers[n6];
            int n8 = this.rowPointers[n6 + 1];
            while (--n8 >= n7) {
                int n9 = nArray[n8];
                floatPlusMultSecond.multiplicator = fArray[n8] * f;
                if (!bl) {
                    floatMatrix1DArray2[n6].assign(floatMatrix1DArray[n9], floatPlusMultSecond);
                    continue;
                }
                floatMatrix1DArray2[n9].assign(floatMatrix1DArray[n6], floatPlusMultSecond);
            }
        }
        return floatMatrix2D2;
    }
}

