/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;

class SelectedDenseFloatMatrix1D
extends FloatMatrix1D {
    protected float[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseFloatMatrix1D(float[] fArray, int[] nArray) {
        this(nArray.length, fArray, 0, 1, nArray, 0);
    }

    protected SelectedDenseFloatMatrix1D(int n, float[] fArray, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = fArray;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    public float[] elements() {
        return this.elements;
    }

    public float getQuick(int n) {
        return this.elements[this.offset + this.offsets[this.zero + n * this.stride]];
    }

    public long index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    public FloatMatrix1D like(int n) {
        return new DenseFloatMatrix1D(n);
    }

    public FloatMatrix2D like2D(int n, int n2) {
        return new DenseFloatMatrix2D(n, n2);
    }

    public FloatMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*cols != size");
        }
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(n, n2);
        float[] fArray = (float[])((FloatMatrix2D)denseFloatMatrix2D).elements();
        int n3 = (int)((AbstractMatrix2D)denseFloatMatrix2D).index(0, 0);
        int n4 = denseFloatMatrix2D.rowStride();
        int n5 = denseFloatMatrix2D.columnStride();
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7 = n3 + i * n5;
            for (int j = 0; j < n; ++j) {
                fArray[n7] = this.getQuick(n6++);
                n7 += n4;
            }
        }
        return denseFloatMatrix2D;
    }

    public FloatMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*cols != size");
        }
        DenseFloatMatrix3D denseFloatMatrix3D = new DenseFloatMatrix3D(n, n2, n3);
        float[] fArray = (float[])((FloatMatrix3D)denseFloatMatrix3D).elements();
        int n4 = (int)((AbstractMatrix3D)denseFloatMatrix3D).index(0, 0, 0);
        int n5 = denseFloatMatrix3D.sliceStride();
        int n6 = denseFloatMatrix3D.rowStride();
        int n7 = denseFloatMatrix3D.columnStride();
        int n8 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n9 = n4 + i * n5 + j * n7;
                for (int k = 0; k < n2; ++k) {
                    fArray[n9] = this.getQuick(n8++);
                    n9 += n6;
                }
            }
        }
        return denseFloatMatrix3D;
    }

    public void setQuick(int n, float f) {
        this.elements[this.offset + this.offsets[this.zero + n * this.stride]] = f;
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    protected boolean haveSharedCellsRaw(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D instanceof SelectedDenseFloatMatrix1D) {
            SelectedDenseFloatMatrix1D selectedDenseFloatMatrix1D = (SelectedDenseFloatMatrix1D)floatMatrix1D;
            return this.elements == selectedDenseFloatMatrix1D.elements;
        }
        if (floatMatrix1D instanceof DenseFloatMatrix1D) {
            DenseFloatMatrix1D denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D;
            return this.elements == denseFloatMatrix1D.elements;
        }
        return false;
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected FloatMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseFloatMatrix1D(this.elements, nArray);
    }
}

