/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.map.tfloat.AbstractLongFloatMap;
import cern.colt.map.tfloat.OpenLongFloatHashMap;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SelectedSparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix3D;

public class SparseFloatMatrix1D
extends FloatMatrix1D {
    protected AbstractLongFloatMap elements;

    public SparseFloatMatrix1D(float[] fArray) {
        this(fArray.length);
        this.assign(fArray);
    }

    public SparseFloatMatrix1D(int n) {
        this(n, n / 1000, 0.2f, 0.5f);
    }

    public SparseFloatMatrix1D(int n, int n2, float f, float f2) {
        this.setUp(n);
        this.elements = new OpenLongFloatHashMap(n2, f, f2);
    }

    protected SparseFloatMatrix1D(int n, AbstractLongFloatMap abstractLongFloatMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = abstractLongFloatMap;
        this.isNoView = false;
    }

    public FloatMatrix1D assign(float f) {
        if (this.isNoView && f == 0.0f) {
            this.elements.clear();
        } else {
            super.assign(f);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongFloatMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public float getQuick(int n) {
        return this.elements.get(this.zero + n * this.stride);
    }

    public long index(int n) {
        return this.zero + n * this.stride;
    }

    public FloatMatrix1D like(int n) {
        return new SparseFloatMatrix1D(n);
    }

    public FloatMatrix2D like2D(int n, int n2) {
        return new SparseFloatMatrix2D(n, n2);
    }

    public FloatMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*cols != size");
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                float f;
                if ((f = this.getQuick(n3++)) == 0.0f) continue;
                ((FloatMatrix2D)sparseFloatMatrix2D).setQuick(j, i, f);
            }
        }
        return sparseFloatMatrix2D;
    }

    public FloatMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*cols != size");
        }
        SparseFloatMatrix3D sparseFloatMatrix3D = new SparseFloatMatrix3D(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    float f;
                    if ((f = this.getQuick(n4++)) == 0.0f) continue;
                    ((FloatMatrix3D)sparseFloatMatrix3D).setQuick(i, k, j, f);
                }
            }
        }
        return sparseFloatMatrix3D;
    }

    public synchronized void setQuick(int n, float f) {
        int n2 = this.zero + n * this.stride;
        if (f == 0.0f) {
            this.elements.removeKey(n2);
        } else {
            this.elements.put(n2, f);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected boolean haveSharedCellsRaw(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D instanceof SelectedSparseFloatMatrix1D) {
            SelectedSparseFloatMatrix1D selectedSparseFloatMatrix1D = (SelectedSparseFloatMatrix1D)floatMatrix1D;
            return this.elements == selectedSparseFloatMatrix1D.elements;
        }
        if (floatMatrix1D instanceof SparseFloatMatrix1D) {
            SparseFloatMatrix1D sparseFloatMatrix1D = (SparseFloatMatrix1D)floatMatrix1D;
            return this.elements == sparseFloatMatrix1D.elements;
        }
        return false;
    }

    protected FloatMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseFloatMatrix1D(this.elements, nArray);
    }
}

