/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;

public class WrapperFloatMatrix1D
extends FloatMatrix1D {
    protected FloatMatrix1D content;

    public WrapperFloatMatrix1D(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D != null) {
            this.setUp(floatMatrix1D.size());
        }
        this.content = floatMatrix1D;
    }

    protected FloatMatrix1D getContent() {
        return this.content;
    }

    public float getQuick(int n) {
        return this.content.getQuick(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    public FloatMatrix1D like(int n) {
        return this.content.like(n);
    }

    public FloatMatrix2D like2D(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public FloatMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FloatMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void setQuick(int n, float f) {
        this.content.setQuick(n, f);
    }

    public FloatMatrix1D viewFlip() {
        WrapperFloatMatrix1D wrapperFloatMatrix1D = new WrapperFloatMatrix1D(this){

            public float getQuick(int n) {
                return this.content.getQuick(this.size - 1 - n);
            }

            public void setQuick(int n, float f) {
                this.content.setQuick(this.size - 1 - n, f);
            }

            public float get(int n) {
                return this.content.get(this.size - 1 - n);
            }

            public void set(int n, float f) {
                this.content.set(this.size - 1 - n, f);
            }
        };
        return wrapperFloatMatrix1D;
    }

    public FloatMatrix1D viewPart(final int n, int n2) {
        this.checkRange(n, n2);
        WrapperFloatMatrix1D wrapperFloatMatrix1D = new WrapperFloatMatrix1D(this){

            public float getQuick(int n2) {
                return this.content.getQuick(n + n2);
            }

            public void setQuick(int n2, float f) {
                this.content.setQuick(n + n2, f);
            }

            public float get(int n2) {
                return this.content.get(n + n2);
            }

            public void set(int n2, float f) {
                this.content.set(n + n2, f);
            }
        };
        wrapperFloatMatrix1D.setSize(n2);
        return wrapperFloatMatrix1D;
    }

    public FloatMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        final int[] nArray2 = nArray;
        WrapperFloatMatrix1D wrapperFloatMatrix1D = new WrapperFloatMatrix1D(this){

            public float getQuick(int n) {
                return this.content.getQuick(nArray2[n]);
            }

            public void setQuick(int n, float f) {
                this.content.setQuick(nArray2[n], f);
            }

            public float get(int n) {
                return this.content.get(nArray2[n]);
            }

            public void set(int n, float f) {
                this.content.set(nArray2[n], f);
            }
        };
        wrapperFloatMatrix1D.setSize(nArray.length);
        return wrapperFloatMatrix1D;
    }

    protected FloatMatrix1D viewSelectionLike(int[] nArray) {
        throw new InternalError();
    }

    public FloatMatrix1D viewStrides(final int n) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperFloatMatrix1D wrapperFloatMatrix1D = new WrapperFloatMatrix1D(this){

            public float getQuick(int n2) {
                return this.content.getQuick(n2 * n);
            }

            public void setQuick(int n2, float f) {
                this.content.setQuick(n2 * n, f);
            }

            public float get(int n2) {
                return this.content.get(n2 * n);
            }

            public void set(int n2, float f) {
                this.content.set(n2 * n, f);
            }
        };
        wrapperFloatMatrix1D.setSize(this.size);
        if (this.size != 0) {
            wrapperFloatMatrix1D.setSize((this.size - 1) / n + 1);
        }
        return wrapperFloatMatrix1D;
    }
}

