/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix1DProcedure;
import cern.colt.matrix.tint.algo.IntFormatter;
import cern.colt.matrix.tint.algo.IntProperty;
import cern.colt.matrix.tint.algo.IntSorting;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntMatrix2D
extends AbstractMatrix2D {
    protected IntMatrix2D() {
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intFunction.apply(IntMatrix2D.this.getQuick(n4, 0));
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < IntMatrix2D.this.columns; ++j) {
                                n = intIntFunction.apply(n, intFunction.apply(IntMatrix2D.this.getQuick(i, j)));
                            }
                            n2 = 0;
                        }
                        return n;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n = intFunction.apply(this.getQuick(0, 0));
            int n6 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n6; j < this.columns; ++j) {
                    n = intIntFunction.apply(n, intFunction.apply(this.getQuick(i, j)));
                }
                n6 = 0;
            }
        }
        return n;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, final IntProcedure intProcedure) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = IntMatrix2D.this.getQuick(n4, 0);
                        int n2 = 0;
                        if (intProcedure.apply(n)) {
                            n2 = intIntFunction.apply(n2, intFunction.apply(n));
                        }
                        int n3 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n3; j < IntMatrix2D.this.columns; ++j) {
                                n = IntMatrix2D.this.getQuick(i, j);
                                if (!intProcedure.apply(n)) continue;
                                n2 = intIntFunction.apply(n2, intFunction.apply(n));
                            }
                            n3 = 0;
                        }
                        return n2;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            int n6 = this.getQuick(0, 0);
            if (intProcedure.apply(n6)) {
                n = intIntFunction.apply(n, intFunction.apply(n6));
            }
            int n7 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n7; j < this.columns; ++j) {
                    n6 = this.getQuick(i, j);
                    if (!intProcedure.apply(n6)) continue;
                    n = intIntFunction.apply(n, intFunction.apply(n6));
                }
                n7 = 0;
            }
        }
        return n;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n3];
            Integer[] integerArray = new Integer[n3];
            int n4 = n / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intFunction.apply(IntMatrix2D.this.getQuick(nArray[n5], nArray2[n5]));
                        for (int i = n5 + 1; i < n6; ++i) {
                            int n2 = IntMatrix2D.this.getQuick(nArray[i], nArray2[i]);
                            n = intIntFunction.apply(n, intFunction.apply(n2));
                        }
                        return n;
                    }
                });
            }
            n2 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n2 = intFunction.apply(this.getQuick(nArray[0], nArray2[0]));
            for (int i = 1; i < n; ++i) {
                int n7 = this.getQuick(nArray[i], nArray2[i]);
                n2 = intIntFunction.apply(n2, intFunction.apply(n7));
            }
        }
        return n2;
    }

    public int aggregate(final IntMatrix2D intMatrix2D, final IntIntFunction intIntFunction, final IntIntFunction intIntFunction2) {
        this.checkShape(intMatrix2D);
        if (this.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intIntFunction2.apply(IntMatrix2D.this.getQuick(n4, 0), intMatrix2D.getQuick(n4, 0));
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < IntMatrix2D.this.columns; ++j) {
                                n = intIntFunction.apply(n, intIntFunction2.apply(IntMatrix2D.this.getQuick(i, j), intMatrix2D.getQuick(i, j)));
                            }
                            n2 = 0;
                        }
                        return n;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n = intIntFunction2.apply(this.getQuick(0, 0), intMatrix2D.getQuick(0, 0));
            int n6 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n6; j < this.columns; ++j) {
                    n = intIntFunction.apply(n, intIntFunction2.apply(this.getQuick(i, j), intMatrix2D.getQuick(i, j)));
                }
                n6 = 0;
            }
        }
        return n;
    }

    public IntMatrix2D assign(final IntFunction intFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                IntMatrix2D.this.setQuick(i, j, intFunction.apply(IntMatrix2D.this.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, intFunction.apply(this.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntProcedure intProcedure, final IntFunction intFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                int n = IntMatrix2D.this.getQuick(i, j);
                                if (!intProcedure.apply(n)) continue;
                                IntMatrix2D.this.setQuick(i, j, intFunction.apply(n));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    int n5 = this.getQuick(i, j);
                    if (!intProcedure.apply(n5)) continue;
                    this.setQuick(i, j, intFunction.apply(n5));
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntProcedure intProcedure, final int n) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                int n2 = IntMatrix2D.this.getQuick(i, j);
                                if (!intProcedure.apply(n2)) continue;
                                IntMatrix2D.this.setQuick(i, j, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    int n6 = this.getQuick(i, j);
                    if (!intProcedure.apply(n6)) continue;
                    this.setQuick(i, j, n);
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int n) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                IntMatrix2D.this.setQuick(i, j, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, n);
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int[] nArray) {
        if (nArray.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + nArray.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i * n2 * this.columns;
                final int n5 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        for (int i = n3; i < n5; ++i) {
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                IntMatrix2D.this.setQuick(i, j, nArray[n++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, nArray[n6++]);
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final int[][] nArray) {
        if (nArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + nArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int[] nArray2 = nArray[i];
                            if (nArray2.length != IntMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray2.length + "columns()=" + IntMatrix2D.this.columns());
                            }
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                IntMatrix2D.this.setQuick(i, j, nArray2[j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                int[] nArray2 = nArray[i];
                if (nArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray2.length + "columns()=" + this.columns());
                }
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, nArray2[j]);
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D) {
        if (intMatrix2D == this) {
            return this;
        }
        this.checkShape(intMatrix2D);
        final IntMatrix2D intMatrix2D2 = this.haveSharedCells(intMatrix2D) ? intMatrix2D.copy() : intMatrix2D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                IntMatrix2D.this.setQuick(i, j, intMatrix2D2.getQuick(i, j));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, intMatrix2D2.getQuick(i, j));
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntMatrix2D intMatrix2D, final IntIntFunction intIntFunction) {
        this.checkShape(intMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                IntMatrix2D.this.setQuick(i, j, intIntFunction.apply(IntMatrix2D.this.getQuick(i, j), intMatrix2D.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, intIntFunction.apply(this.getQuick(i, j), intMatrix2D.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public IntMatrix2D assign(final IntMatrix2D intMatrix2D, final IntIntFunction intIntFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(intMatrix2D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            IntMatrix2D.this.setQuick(nArray[i], nArray2[i], intIntFunction.apply(IntMatrix2D.this.getQuick(nArray[i], nArray2[i]), intMatrix2D.getQuick(nArray[i], nArray2[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(nArray[i], nArray2[i], intIntFunction.apply(this.getQuick(nArray[i], nArray2[i]), intMatrix2D.getQuick(nArray[i], nArray2[i])));
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.rows / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.rows : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                if (IntMatrix2D.this.getQuick(i, j) == 0) continue;
                                ++n;
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    if (this.getQuick(i, j) == 0) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public IntMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(int n) {
        return IntProperty.DEFAULT.equals(this, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof IntMatrix2D)) {
            return false;
        }
        return IntProperty.DEFAULT.equals(this, (IntMatrix2D)object);
    }

    public IntMatrix2D forEachNonZero(final IntIntIntFunction intIntIntFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                int n;
                                int n2 = IntMatrix2D.this.getQuick(i, j);
                                if (n2 == 0 || (n = intIntIntFunction.apply(i, j, n2)) == n2) continue;
                                IntMatrix2D.this.setQuick(i, j, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    int n5;
                    int n6 = this.getQuick(i, j);
                    if (n6 == 0 || (n5 = intIntIntFunction.apply(i, j, n6)) == n6) continue;
                    this.setQuick(i, j, n5);
                }
            }
        }
        return this;
    }

    public int get(int n, int n2) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        return this.getQuick(n, n2);
    }

    protected IntMatrix2D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                int n = this.getQuick(i, j);
                if (n >= 0) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                intArrayList3.add(n);
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                int n = this.getQuick(i, j);
                if (n == 0) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                intArrayList3.add(n);
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                int n = this.getQuick(i, j);
                if (n <= 0) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                intArrayList3.add(n);
            }
        }
    }

    public abstract int getQuick(int var1, int var2);

    protected boolean haveSharedCells(IntMatrix2D intMatrix2D) {
        if (intMatrix2D == null) {
            return false;
        }
        if (this == intMatrix2D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(intMatrix2D.getContent());
    }

    protected boolean haveSharedCellsRaw(IntMatrix2D intMatrix2D) {
        return false;
    }

    public IntMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract IntMatrix2D like(int var1, int var2);

    public abstract IntMatrix1D like1D(int var1);

    protected abstract IntMatrix1D like1D(int var1, int var2, int var3);

    public int[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            Future[] futureArray = new Future[n4];
            int[][] nArray = new int[n4][2];
            int n6 = this.rows / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.rows : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        int n3 = IntMatrix2D.this.getQuick(n, 0);
                        int n4 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n4; j < IntMatrix2D.this.columns; ++j) {
                                int n5 = IntMatrix2D.this.getQuick(i, j);
                                if (n3 >= n5) continue;
                                n3 = n5;
                                n = i;
                                n2 = j;
                            }
                            n4 = 0;
                        }
                        return new int[]{n3, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    nArray[n5] = (int[])futureArray[n5].get();
                }
                n3 = nArray[0][0];
                n = nArray[0][1];
                n2 = nArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (n3 >= nArray[n5][0]) continue;
                    n3 = nArray[n5][0];
                    n = nArray[n5][1];
                    n2 = nArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n3 = this.getQuick(0, 0);
            int n9 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    int n10 = this.getQuick(i, j);
                    if (n3 >= n10) continue;
                    n3 = n10;
                    n = i;
                    n2 = j;
                }
                n9 = 0;
            }
        }
        return new int[]{n3, n, n2};
    }

    public int[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            Future[] futureArray = new Future[n4];
            int[][] nArray = new int[n4][2];
            int n6 = this.rows / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.rows : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        int n3 = IntMatrix2D.this.getQuick(n, 0);
                        int n4 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n4; j < IntMatrix2D.this.columns; ++j) {
                                int n5 = IntMatrix2D.this.getQuick(i, j);
                                if (n3 <= n5) continue;
                                n3 = n5;
                                n = i;
                                n2 = j;
                            }
                            n4 = 0;
                        }
                        return new int[]{n3, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    nArray[n5] = (int[])futureArray[n5].get();
                }
                n3 = nArray[0][0];
                n = nArray[0][1];
                n2 = nArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (n3 <= nArray[n5][0]) continue;
                    n3 = nArray[n5][0];
                    n = nArray[n5][1];
                    n2 = nArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n3 = this.getQuick(0, 0);
            int n9 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    int n10 = this.getQuick(i, j);
                    if (n3 <= n10) continue;
                    n3 = n10;
                    n = i;
                    n2 = j;
                }
                n9 = 0;
            }
        }
        return new int[]{n3, n, n2};
    }

    public void set(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        this.setQuick(n, n2, n3);
    }

    public abstract void setQuick(int var1, int var2, int var3);

    public int[][] toArray() {
        final int[][] nArray = new int[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int[] nArray2 = nArray[i];
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                nArray2[j] = IntMatrix2D.this.getQuick(i, j);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                int[] nArray2 = nArray[i];
                for (int j = 0; j < this.columns; ++j) {
                    nArray2[j] = this.getQuick(i, j);
                }
            }
        }
        return nArray;
    }

    public String toString() {
        return new IntFormatter().toString(this);
    }

    public abstract IntMatrix1D vectorize();

    protected IntMatrix2D view() {
        return (IntMatrix2D)this.clone();
    }

    public IntMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = (int)this.index(0, n);
        int n4 = this.rowStride;
        return this.like1D(n2, n3, n4);
    }

    public IntMatrix2D viewColumnFlip() {
        return (IntMatrix2D)this.view().vColumnFlip();
    }

    public IntMatrix2D viewDice() {
        return (IntMatrix2D)this.view().vDice();
    }

    public IntMatrix2D viewPart(int n, int n2, int n3, int n4) {
        return (IntMatrix2D)this.view().vPart(n, n2, n3, n4);
    }

    public IntMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = (int)this.index(n, 0);
        int n4 = this.columnStride;
        return this.like1D(n2, n3, n4);
    }

    public IntMatrix2D viewRowFlip() {
        return (IntMatrix2D)this.view().vRowFlip();
    }

    public IntMatrix2D viewSelection(IntMatrix1DProcedure intMatrix1DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!intMatrix1DProcedure.apply(this.viewRow(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null);
    }

    public IntMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.rows];
            for (n2 = 0; n2 < this.rows; ++n2) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            for (n2 = 0; n2 < this.columns; ++n2) {
                nArray2[n2] = n2;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = this._rowOffset(this._rowRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray4[n] = this._columnOffset(this._columnRank(nArray2[n]));
        }
        return this.viewSelectionLike(nArray3, nArray4);
    }

    public IntMatrix2D viewSelection(Set<int[]> set) {
        int n;
        int[] nArray4;
        int n2 = set.size();
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (int[] nArray4 : set) {
            nArray2[n3] = nArray4[0];
            nArray3[n3] = nArray4[1];
            ++n3;
        }
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        Object object = new int[nArray2.length];
        nArray4 = new int[nArray3.length];
        for (n = 0; n < nArray2.length; ++n) {
            object[n] = this._rowOffset(this._rowRank(nArray2[n]));
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray4[n] = this._columnOffset(this._columnRank(nArray3[n]));
        }
        return this.viewSelectionLike((int[])object, nArray4);
    }

    protected abstract IntMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public IntMatrix2D viewSorted(int n) {
        return IntSorting.mergeSort.sort(this, n);
    }

    public IntMatrix2D viewStrides(int n, int n2) {
        return (IntMatrix2D)this.view().vStrides(n, n2);
    }

    public IntMatrix1D zMult(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2) {
        return this.zMult(intMatrix1D, intMatrix1D2, 1, intMatrix1D2 == null ? 1 : 0, false);
    }

    public IntMatrix1D zMult(final IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2, final int n, final int n2, boolean bl) {
        if (bl) {
            return this.viewDice().zMult(intMatrix1D, intMatrix1D2, n, n2, false);
        }
        final IntMatrix1D intMatrix1D3 = intMatrix1D2 == null ? new DenseIntMatrix1D(this.rows) : intMatrix1D2;
        if (this.columns != intMatrix1D.size() || this.rows > intMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D3.toStringShort());
        }
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.rows / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.rows : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){
                    int[] s = new int[2];

                    public void run() {
                        for (int i = n5; i < n6; ++i) {
                            int n3 = 0;
                            for (int j = 0; j < IntMatrix2D.this.columns; ++j) {
                                n3 += IntMatrix2D.this.getQuick(i, j) * intMatrix1D.getQuick(j);
                            }
                            intMatrix1D3.setQuick(i, n * n3 + n2 * intMatrix1D3.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                int n7 = 0;
                for (int j = 0; j < this.columns; ++j) {
                    n7 += this.getQuick(i, j) * intMatrix1D.getQuick(j);
                }
                intMatrix1D3.setQuick(i, n * n7 + n2 * intMatrix1D3.getQuick(i));
            }
        }
        intMatrix1D2 = intMatrix1D3;
        return intMatrix1D2;
    }

    public IntMatrix2D zMult(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2) {
        return this.zMult(intMatrix2D, intMatrix2D2, 1, intMatrix2D2 == null ? 1 : 0, false, false);
    }

    public IntMatrix2D zMult(final IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2, final int n, final int n2, boolean bl, boolean bl2) {
        if (bl) {
            return this.viewDice().zMult(intMatrix2D, intMatrix2D2, n, n2, false, bl2);
        }
        if (bl2) {
            return this.zMult(intMatrix2D.viewDice(), intMatrix2D2, n, n2, bl, false);
        }
        final int n3 = this.rows;
        final int n4 = this.columns;
        int n5 = intMatrix2D.columns;
        final IntMatrix2D intMatrix2D3 = intMatrix2D2 == null ? new DenseIntMatrix2D(n3, n5) : intMatrix2D2;
        if (intMatrix2D.rows != n4) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + intMatrix2D.toStringShort());
        }
        if (intMatrix2D3.rows != n3 || intMatrix2D3.columns != n5) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + intMatrix2D.toStringShort() + ", " + intMatrix2D3.toStringShort());
        }
        if (this == intMatrix2D3 || intMatrix2D == intMatrix2D3) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n6];
            int n7 = n5 / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n5 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n5 = 0;
                                for (int k = 0; k < n4; ++k) {
                                    n5 += IntMatrix2D.this.getQuick(j, k) * intMatrix2D.getQuick(k, i);
                                }
                                intMatrix2D3.setQuick(j, i, n * n5 + n2 * intMatrix2D3.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n10 = 0;
                    for (int k = 0; k < n4; ++k) {
                        n10 += this.getQuick(j, k) * intMatrix2D.getQuick(k, i);
                    }
                    intMatrix2D3.setQuick(j, i, n * n10 + n2 * intMatrix2D3.getQuick(j, i));
                }
            }
        }
        intMatrix2D2 = intMatrix2D3;
        return intMatrix2D2;
    }

    public int zSum() {
        if (this.size() == 0) {
            return 0;
        }
        return this.aggregate(IntFunctions.plus, IntFunctions.identity);
    }
}

