/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedDenseIntMatrix1D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultFirst;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseIntMatrix1D
extends IntMatrix1D {
    private static final long serialVersionUID = -706456704651139684L;
    protected int[] elements;

    public DenseIntMatrix1D(int[] nArray) {
        this(nArray.length);
        this.assign(nArray);
    }

    public DenseIntMatrix1D(int n) {
        this.setUp(n);
        this.elements = new int[n];
    }

    public DenseIntMatrix1D(int n, int[] nArray, int n2, int n3, boolean bl) {
        this.setUp(n, n2, n3);
        this.elements = nArray;
        this.isNoView = !bl;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction) {
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n3 = this.size / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.size : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = DenseIntMatrix1D.this.zero + n4 * DenseIntMatrix1D.this.stride;
                        int n2 = intFunction.apply(DenseIntMatrix1D.this.elements[n]);
                        for (int i = n4 + 1; i < n5; ++i) {
                            n2 = intIntFunction.apply(n2, intFunction.apply(DenseIntMatrix1D.this.elements[n += DenseIntMatrix1D.this.stride]));
                        }
                        return n2;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n = intFunction.apply(this.elements[this.zero]);
            int n6 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                n = intIntFunction.apply(n, intFunction.apply(this.elements[n6 += this.stride]));
            }
        }
        return n;
    }

    public int aggregate(IntMatrix1D intMatrix1D, final IntIntFunction intIntFunction, final IntIntFunction intIntFunction2) {
        if (!(intMatrix1D instanceof DenseIntMatrix1D)) {
            return super.aggregate(intMatrix1D, intIntFunction, intIntFunction2);
        }
        this.checkSize(intMatrix1D);
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)intMatrix1D.index(0);
        final int n2 = intMatrix1D.stride();
        final int[] nArray = (int[])intMatrix1D.elements();
        int n3 = 0;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n4];
            Integer[] integerArray = new Integer[n4];
            int n5 = this.size / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? this.size : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n4 = DenseIntMatrix1D.this.zero + n6 * DenseIntMatrix1D.this.stride;
                        int n22 = n + n6 * n2;
                        int n3 = intIntFunction2.apply(DenseIntMatrix1D.this.elements[n4], nArray[n22]);
                        for (int i = n6 + 1; i < n7; ++i) {
                            n3 = intIntFunction.apply(n3, intIntFunction2.apply(DenseIntMatrix1D.this.elements[n4 += DenseIntMatrix1D.this.stride], nArray[n22 += n2]));
                        }
                        return n3;
                    }
                });
            }
            n3 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n3 = intIntFunction2.apply(this.elements[this.zero], nArray[n]);
            int n8 = this.zero;
            int n9 = n;
            for (int i = 1; i < this.size; ++i) {
                n3 = intIntFunction.apply(n3, intIntFunction2.apply(this.elements[n8 += this.stride], nArray[n9 += n2]));
            }
        }
        return n3;
    }

    public IntMatrix1D assign(final IntFunction intFunction) {
        int n;
        int n2;
        if (intFunction instanceof IntMult) {
            n2 = ((IntMult)intFunction).multiplicator;
            if (n2 == 1) {
                return this;
            }
        } else {
            n2 = 0;
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n3 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.size : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseIntMatrix1D.this.zero + n4 * DenseIntMatrix1D.this.stride;
                        if (intFunction instanceof IntMult) {
                            for (int i = n4; i < n5; ++i) {
                                int n22 = n;
                                DenseIntMatrix1D.this.elements[n22] = DenseIntMatrix1D.this.elements[n22] * n2;
                                n += DenseIntMatrix1D.this.stride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                DenseIntMatrix1D.this.elements[n] = intFunction.apply(DenseIntMatrix1D.this.elements[n]);
                                n += DenseIntMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = this.zero - this.stride;
            if (intFunction instanceof IntMult) {
                int n7 = this.size;
                while (--n7 >= 0) {
                    this.elements[n6 += this.stride] = this.elements[n6] * n2;
                }
            } else {
                int n8 = this.size;
                while (--n8 >= 0) {
                    this.elements[n6 += this.stride] = intFunction.apply(this.elements[n6]);
                }
            }
        }
        return this;
    }

    public IntMatrix1D assign(final IntProcedure intProcedure, final IntFunction intFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseIntMatrix1D.this.zero + n3 * DenseIntMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            if (intProcedure.apply(DenseIntMatrix1D.this.elements[n])) {
                                DenseIntMatrix1D.this.elements[n] = intFunction.apply(DenseIntMatrix1D.this.elements[n]);
                            }
                            n += DenseIntMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (intProcedure.apply(this.elements[n5])) {
                    this.elements[n5] = intFunction.apply(this.elements[n5]);
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    public IntMatrix1D assign(final IntProcedure intProcedure, final int n) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.size / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.size : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n2 = DenseIntMatrix1D.this.zero + n4 * DenseIntMatrix1D.this.stride;
                        for (int i = n4; i < n5; ++i) {
                            if (intProcedure.apply(DenseIntMatrix1D.this.elements[n2])) {
                                DenseIntMatrix1D.this.elements[n2] = n;
                            }
                            n2 += DenseIntMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (intProcedure.apply(this.elements[n6])) {
                    this.elements[n6] = n;
                }
                n6 += this.stride;
            }
        }
        return this;
    }

    public IntMatrix1D assign(final int n) {
        final int[] nArray = this.elements;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.size / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.size : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n2 = DenseIntMatrix1D.this.zero + n4 * DenseIntMatrix1D.this.stride;
                        for (int i = n4; i < n5; ++i) {
                            nArray[n2] = n;
                            n2 += DenseIntMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                nArray[n6] = n;
                n6 += this.stride;
            }
        }
        return this;
    }

    public IntMatrix1D assign(final int[] nArray) {
        if (nArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + nArray.length + "size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
                Future[] futureArray = new Future[n];
                int n2 = this.size / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.size - n3 : n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            System.arraycopy(nArray, n3, DenseIntMatrix1D.this.elements, n3, n4);
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                System.arraycopy(nArray, 0, this.elements, 0, nArray.length);
            }
        } else if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n];
            int n5 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n - 1 ? this.size : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseIntMatrix1D.this.zero + n6 * DenseIntMatrix1D.this.stride;
                        for (int i = n6; i < n7; ++i) {
                            DenseIntMatrix1D.this.elements[n] = nArray[i];
                            n += DenseIntMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n8 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n8] = nArray[i];
                n8 += this.stride;
            }
        }
        return this;
    }

    public IntMatrix1D assign(IntMatrix1D intMatrix1D) {
        Object object;
        if (!(intMatrix1D instanceof DenseIntMatrix1D)) {
            super.assign(intMatrix1D);
            return this;
        }
        DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D;
        if (denseIntMatrix1D == this) {
            return this;
        }
        this.checkSize(denseIntMatrix1D);
        if (this.isNoView && denseIntMatrix1D.isNoView) {
            System.arraycopy(denseIntMatrix1D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseIntMatrix1D)) {
            object = denseIntMatrix1D.copy();
            if (!(object instanceof DenseIntMatrix1D)) {
                super.assign(intMatrix1D);
                return this;
            }
            denseIntMatrix1D = (DenseIntMatrix1D)object;
        }
        object = denseIntMatrix1D.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n = (int)denseIntMatrix1D.index(0);
        final int n2 = denseIntMatrix1D.stride;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((int[])object){
                    final /* synthetic */ int[] val$elemsOther;
                    {
                        this.val$elemsOther = nArray;
                    }

                    public void run() {
                        int n3 = DenseIntMatrix1D.this.zero + n5 * DenseIntMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseIntMatrix1D.this.elements[n3] = this.val$elemsOther[n22];
                            n3 += DenseIntMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = (int)object[n8];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    public IntMatrix1D assign(IntMatrix1D intMatrix1D, final IntIntFunction intIntFunction) {
        if (!(intMatrix1D instanceof DenseIntMatrix1D)) {
            super.assign(intMatrix1D, intIntFunction);
            return this;
        }
        this.checkSize(intMatrix1D);
        final int n = (int)intMatrix1D.index(0);
        final int n2 = intMatrix1D.stride();
        final int[] nArray = (int[])intMatrix1D.elements();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n11 = DenseIntMatrix1D.this.zero + n5 * DenseIntMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        if (intIntFunction == IntFunctions.mult) {
                            for (int i = n5; i < n6; ++i) {
                                int n3 = n11;
                                DenseIntMatrix1D.this.elements[n3] = DenseIntMatrix1D.this.elements[n3] * nArray[n22];
                                n11 += DenseIntMatrix1D.this.stride;
                                n22 += n2;
                            }
                        } else if (intIntFunction == IntFunctions.div) {
                            for (int i = n5; i < n6; ++i) {
                                int n4 = n11;
                                DenseIntMatrix1D.this.elements[n4] = DenseIntMatrix1D.this.elements[n4] / nArray[n22];
                                n11 += DenseIntMatrix1D.this.stride;
                                n22 += n2;
                            }
                        } else if (intIntFunction instanceof IntPlusMultFirst) {
                            int n52 = ((IntPlusMultFirst)intIntFunction).multiplicator;
                            if (n52 == 0) {
                                for (int i = n5; i < n6; ++i) {
                                    DenseIntMatrix1D.this.elements[n11] = nArray[n22];
                                    n11 += DenseIntMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (n52 == 1) {
                                for (int i = n5; i < n6; ++i) {
                                    int n62 = n11;
                                    DenseIntMatrix1D.this.elements[n62] = DenseIntMatrix1D.this.elements[n62] + nArray[n22];
                                    n11 += DenseIntMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (n52 == -1) {
                                for (int i = n5; i < n6; ++i) {
                                    DenseIntMatrix1D.this.elements[n11] = nArray[n22] - DenseIntMatrix1D.this.elements[n11];
                                    n11 += DenseIntMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else {
                                for (int i = n5; i < n6; ++i) {
                                    DenseIntMatrix1D.this.elements[n11] = n52 * DenseIntMatrix1D.this.elements[n11] + nArray[n22];
                                    n11 += DenseIntMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            }
                        } else if (intIntFunction instanceof IntPlusMultSecond) {
                            int n7 = ((IntPlusMultSecond)intIntFunction).multiplicator;
                            if (n7 == 0) {
                                return;
                            }
                            if (n7 == 1) {
                                for (int i = n5; i < n6; ++i) {
                                    int n8 = n11;
                                    DenseIntMatrix1D.this.elements[n8] = DenseIntMatrix1D.this.elements[n8] + nArray[n22];
                                    n11 += DenseIntMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (n7 == -1) {
                                for (int i = n5; i < n6; ++i) {
                                    int n9 = n11;
                                    DenseIntMatrix1D.this.elements[n9] = DenseIntMatrix1D.this.elements[n9] - nArray[n22];
                                    n11 += DenseIntMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else {
                                for (int i = n5; i < n6; ++i) {
                                    int n10 = n11;
                                    DenseIntMatrix1D.this.elements[n10] = DenseIntMatrix1D.this.elements[n10] + n7 * nArray[n22];
                                    n11 += DenseIntMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            }
                        } else {
                            for (int i = n5; i < n6; ++i) {
                                DenseIntMatrix1D.this.elements[n11] = intIntFunction.apply(DenseIntMatrix1D.this.elements[n11], nArray[n22]);
                                n11 += DenseIntMatrix1D.this.stride;
                                n22 += n2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            if (intIntFunction == IntFunctions.mult) {
                for (int i = 0; i < this.size; ++i) {
                    int n9 = n7;
                    this.elements[n9] = this.elements[n9] * nArray[n8];
                    n7 += this.stride;
                    n8 += n2;
                }
            } else if (intIntFunction == IntFunctions.div) {
                for (int i = 0; i < this.size; ++i) {
                    int n10 = n7;
                    this.elements[n10] = this.elements[n10] / nArray[n8];
                    n7 += this.stride;
                    n8 += n2;
                }
            } else if (intIntFunction instanceof IntPlusMultSecond) {
                int n11 = ((IntPlusMultSecond)intIntFunction).multiplicator;
                if (n11 == 0) {
                    return this;
                }
                if (n11 == 1) {
                    for (int i = 0; i < this.size; ++i) {
                        int n12 = n7;
                        this.elements[n12] = this.elements[n12] + nArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                } else if (n11 == -1) {
                    for (int i = 0; i < this.size; ++i) {
                        int n13 = n7;
                        this.elements[n13] = this.elements[n13] - nArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                } else {
                    for (int i = 0; i < this.size; ++i) {
                        int n14 = n7;
                        this.elements[n14] = this.elements[n14] + n11 * nArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                }
            } else {
                for (int i = 0; i < this.size; ++i) {
                    this.elements[n7] = intIntFunction.apply(this.elements[n7], nArray[n8]);
                    n7 += this.stride;
                    n8 += n2;
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = DenseIntMatrix1D.this.zero + n5 * DenseIntMatrix1D.this.stride;
                        for (int i = n5; i < n6; ++i) {
                            if (DenseIntMatrix1D.this.elements[n2] != 0) {
                                ++n;
                            }
                            n2 += DenseIntMatrix1D.this.stride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[n7] != 0) {
                    ++n;
                }
                n7 += this.stride;
            }
        }
        return n;
    }

    public int[] elements() {
        return this.elements;
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2) {
        int n;
        intArrayList.clear();
        intArrayList2.clear();
        int n2 = this.zero;
        int n3 = this.size % 2;
        if (n3 == 1) {
            n = this.elements[n2];
            if (n != 0) {
                intArrayList.add(0);
                intArrayList2.add(n);
            }
            n2 += this.stride;
        }
        for (n = n3; n < this.size; n += 2) {
            int n4 = this.elements[n2];
            if (n4 != 0) {
                intArrayList.add(n);
                intArrayList2.add(n4);
            }
            if ((n4 = this.elements[n2 += this.stride]) != 0) {
                intArrayList.add(n + 1);
                intArrayList2.add(n4);
            }
            n2 += this.stride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2) {
        int n;
        intArrayList.clear();
        intArrayList2.clear();
        int n2 = this.zero;
        int n3 = this.size % 2;
        if (n3 == 1) {
            n = this.elements[n2];
            if (n > 0) {
                intArrayList.add(0);
                intArrayList2.add(n);
            }
            n2 += this.stride;
        }
        for (n = n3; n < this.size; n += 2) {
            int n4 = this.elements[n2];
            if (n4 > 0) {
                intArrayList.add(n);
                intArrayList2.add(n4);
            }
            if ((n4 = this.elements[n2 += this.stride]) > 0) {
                intArrayList.add(n + 1);
                intArrayList2.add(n4);
            }
            n2 += this.stride;
        }
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2) {
        int n;
        intArrayList.clear();
        intArrayList2.clear();
        int n2 = this.zero;
        int n3 = this.size % 2;
        if (n3 == 1) {
            n = this.elements[n2];
            if (n < 0) {
                intArrayList.add(0);
                intArrayList2.add(n);
            }
            n2 += this.stride;
        }
        for (n = n3; n < this.size; n += 2) {
            int n4 = this.elements[n2];
            if (n4 < 0) {
                intArrayList.add(n);
                intArrayList2.add(n4);
            }
            if ((n4 = this.elements[n2 += this.stride]) < 0) {
                intArrayList.add(n + 1);
                intArrayList2.add(n4);
            }
            n2 += this.stride;
        }
    }

    public int[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            int[][] nArray = new int[n3][2];
            int n5 = this.size / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.size : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = DenseIntMatrix1D.this.zero + n6 * DenseIntMatrix1D.this.stride;
                        int n2 = DenseIntMatrix1D.this.elements[n];
                        int n3 = (n - DenseIntMatrix1D.this.zero) / DenseIntMatrix1D.this.stride;
                        for (int i = n6 + 1; i < n7; ++i) {
                            if (n2 >= DenseIntMatrix1D.this.elements[n += DenseIntMatrix1D.this.stride]) continue;
                            n2 = DenseIntMatrix1D.this.elements[n];
                            n3 = (n - DenseIntMatrix1D.this.zero) / DenseIntMatrix1D.this.stride;
                        }
                        return new int[]{n2, n3};
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    nArray[n4] = (int[])futureArray[n4].get();
                }
                n2 = nArray[0][0];
                n = nArray[0][1];
                for (n4 = 1; n4 < n3; ++n4) {
                    if (n2 >= nArray[n4][0]) continue;
                    n2 = nArray[n4][0];
                    n = nArray[n4][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n2 = this.elements[this.zero];
            n = 0;
            int n8 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                if (n2 >= this.elements[n8 += this.stride]) continue;
                n2 = this.elements[n8];
                n = (n8 - this.zero) / this.stride;
            }
        }
        return new int[]{n2, n};
    }

    public int[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n4;
            Future[] futureArray = new Future[n3];
            int[][] nArray = new int[n3][2];
            int n5 = this.size / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.size : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = DenseIntMatrix1D.this.zero + n6 * DenseIntMatrix1D.this.stride;
                        int n2 = DenseIntMatrix1D.this.elements[n];
                        int n3 = (n - DenseIntMatrix1D.this.zero) / DenseIntMatrix1D.this.stride;
                        for (int i = n6 + 1; i < n7; ++i) {
                            if (n2 <= DenseIntMatrix1D.this.elements[n += DenseIntMatrix1D.this.stride]) continue;
                            n2 = DenseIntMatrix1D.this.elements[n];
                            n3 = (n - DenseIntMatrix1D.this.zero) / DenseIntMatrix1D.this.stride;
                        }
                        return new int[]{n2, n3};
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    nArray[n4] = (int[])futureArray[n4].get();
                }
                n2 = nArray[0][0];
                n = nArray[0][1];
                for (n4 = 1; n4 < n3; ++n4) {
                    if (n2 <= nArray[n4][0]) continue;
                    n2 = nArray[n4][0];
                    n = nArray[n4][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n2 = this.elements[this.zero];
            n = 0;
            int n8 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                if (n2 <= this.elements[n8 += this.stride]) continue;
                n2 = this.elements[n8];
                n = (n8 - this.zero) / this.stride;
            }
        }
        return new int[]{n2, n};
    }

    public int getQuick(int n) {
        return this.elements[this.zero + n * this.stride];
    }

    public IntMatrix1D like(int n) {
        return new DenseIntMatrix1D(n);
    }

    public IntMatrix2D like2D(int n, int n2) {
        return new DenseIntMatrix2D(n, n2);
    }

    public IntMatrix2D reshape(final int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*cols != size");
        }
        DenseIntMatrix2D denseIntMatrix2D = new DenseIntMatrix2D(n, n2);
        final int[] nArray = (int[])((IntMatrix2D)denseIntMatrix2D).elements();
        final int n3 = (int)((AbstractMatrix2D)denseIntMatrix2D).index(0, 0);
        final int n4 = denseIntMatrix2D.rowStride();
        final int n5 = denseIntMatrix2D.columnStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n6];
            int n7 = n2 / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n2 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n6 = n3 + i * n5;
                            int n2 = DenseIntMatrix1D.this.zero + i * n * DenseIntMatrix1D.this.stride;
                            for (int j = 0; j < n; ++j) {
                                nArray[n6] = DenseIntMatrix1D.this.elements[n2];
                                n6 += n4;
                                n2 += DenseIntMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = this.zero;
            for (int i = 0; i < n2; ++i) {
                int n11 = n3 + i * n5;
                for (int j = 0; j < n; ++j) {
                    nArray[n11] = this.elements[n10];
                    n11 += n4;
                    n10 += this.stride;
                }
            }
        }
        return denseIntMatrix2D;
    }

    public IntMatrix3D reshape(int n, final int n2, final int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*cols != size");
        }
        DenseIntMatrix3D denseIntMatrix3D = new DenseIntMatrix3D(n, n2, n3);
        final int[] nArray = (int[])((IntMatrix3D)denseIntMatrix3D).elements();
        final int n4 = (int)((AbstractMatrix3D)denseIntMatrix3D).index(0, 0, 0);
        final int n5 = denseIntMatrix3D.sliceStride();
        final int n6 = denseIntMatrix3D.rowStride();
        final int n7 = denseIntMatrix3D.columnStride();
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n8];
            int n9 = n / n8;
            for (int i = 0; i < n8; ++i) {
                final int n10 = i * n9;
                final int n11 = i == n8 - 1 ? n : n10 + n9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n10; i < n11; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n = n4 + i * n5 + j * n7;
                                int n22 = DenseIntMatrix1D.this.zero + (i * n2 * n3 + j * n2) * DenseIntMatrix1D.this.stride;
                                for (int k = 0; k < n2; ++k) {
                                    nArray[n] = DenseIntMatrix1D.this.elements[n22];
                                    n += n6;
                                    n22 += DenseIntMatrix1D.this.stride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12 = this.zero;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n13 = n4 + i * n5 + j * n7;
                    for (int k = 0; k < n2; ++k) {
                        nArray[n13] = this.elements[n12];
                        n13 += n6;
                        n12 += this.stride;
                    }
                }
            }
        }
        return denseIntMatrix3D;
    }

    public void setQuick(int n, int n2) {
        this.elements[this.zero + n * this.stride] = n2;
    }

    public void swap(IntMatrix1D intMatrix1D) {
        DenseIntMatrix1D denseIntMatrix1D;
        if (!(intMatrix1D instanceof DenseIntMatrix1D)) {
            super.swap(intMatrix1D);
        }
        if ((denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D) == this) {
            return;
        }
        this.checkSize(denseIntMatrix1D);
        final int[] nArray = denseIntMatrix1D.elements;
        if (this.elements == null || nArray == null) {
            throw new InternalError();
        }
        final int n = (int)intMatrix1D.index(0);
        final int n2 = intMatrix1D.stride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = DenseIntMatrix1D.this.zero + n5 * DenseIntMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            int n3 = DenseIntMatrix1D.this.elements[n4];
                            DenseIntMatrix1D.this.elements[n4] = nArray[n22];
                            nArray[n22] = n3;
                            n4 += DenseIntMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                int n9 = this.elements[n7];
                this.elements[n7] = nArray[n8];
                nArray[n8] = n9;
                n7 += this.stride;
                n8 += n2;
            }
        }
    }

    public void toArray(int[] nArray) {
        if (nArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, nArray, 0, this.elements.length);
        } else {
            super.toArray(nArray);
        }
    }

    public int zDotProduct(IntMatrix1D intMatrix1D) {
        if (!(intMatrix1D instanceof DenseIntMatrix1D)) {
            return super.zDotProduct(intMatrix1D);
        }
        DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D;
        final int[] nArray = denseIntMatrix1D.elements;
        int n = (int)this.index(0);
        int n2 = (int)denseIntMatrix1D.index(0);
        int n3 = denseIntMatrix1D.stride;
        if (this.elements == null || nArray == null) {
            throw new InternalError();
        }
        int n4 = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n6;
            final int n7 = n;
            final int n8 = n2;
            final int n9 = n3;
            Future[] futureArray = new Future[n5];
            Integer[] integerArray = new Integer[n5];
            int n10 = this.size / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n11 = n6 * n10;
                final int n12 = n6 == n5 - 1 ? this.size : n11 + n10;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = n7 + n11 * DenseIntMatrix1D.this.stride;
                        int n2 = n8 + n11 * n9;
                        n -= DenseIntMatrix1D.this.stride;
                        n2 -= n9;
                        int n3 = 0;
                        int n4 = n12 - n11;
                        int n5 = n4 / 4;
                        while (--n5 >= 0) {
                            int n6 = n + DenseIntMatrix1D.this.stride;
                            n = n6;
                            int n72 = n2 + n9;
                            n2 = n72;
                            int n82 = n + DenseIntMatrix1D.this.stride;
                            n = n82;
                            int n92 = n2 + n9;
                            n2 = n92;
                            n = n + DenseIntMatrix1D.this.stride;
                            n2 = n2 + n9;
                            n3 += DenseIntMatrix1D.this.elements[n6] * nArray[n72] + DenseIntMatrix1D.this.elements[n82] * nArray[n92] + DenseIntMatrix1D.this.elements[n] * nArray[n2] + DenseIntMatrix1D.this.elements[n += DenseIntMatrix1D.this.stride] * nArray[n2 += n9];
                        }
                        n5 = n4 % 4;
                        while (--n5 >= 0) {
                            n3 += DenseIntMatrix1D.this.elements[n += DenseIntMatrix1D.this.stride] * nArray[n2 += n9];
                        }
                        return n3;
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    integerArray[n6] = (Integer)futureArray[n6].get();
                }
                n4 = integerArray[0];
                for (n6 = 1; n6 < n5; ++n6) {
                    n4 += integerArray[n6].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n -= this.stride;
            n2 -= n3;
            int n13 = this.size / 4;
            while (--n13 >= 0) {
                int n14 = n + this.stride;
                n = n14;
                int n15 = n2 + n3;
                n2 = n15;
                int n16 = n + this.stride;
                n = n16;
                int n17 = n2 + n3;
                n2 = n17;
                n = n + this.stride;
                n2 = n2 + n3;
                n4 += this.elements[n14] * nArray[n15] + this.elements[n16] * nArray[n17] + this.elements[n] * nArray[n2] + this.elements[n += this.stride] * nArray[n2 += n3];
            }
            n13 = this.size % 4;
            while (--n13 >= 0) {
                n4 += this.elements[n += this.stride] * nArray[n2 += n3];
            }
        }
        return n4;
    }

    public int zDotProduct(IntMatrix1D intMatrix1D, int n, int n2) {
        if (!(intMatrix1D instanceof DenseIntMatrix1D)) {
            return super.zDotProduct(intMatrix1D, n, n2);
        }
        DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D;
        int n3 = n + n2;
        if (n < 0 || n2 < 0) {
            return 0;
        }
        if (this.size < n3) {
            n3 = this.size;
        }
        if (intMatrix1D.size() < n3) {
            n3 = intMatrix1D.size();
        }
        final int[] nArray = denseIntMatrix1D.elements;
        int n4 = (int)this.index(n);
        int n5 = (int)denseIntMatrix1D.index(n);
        int n6 = denseIntMatrix1D.stride;
        if (this.elements == null || nArray == null) {
            throw new InternalError();
        }
        int n7 = 0;
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n9;
            final int n10 = n4;
            final int n11 = n5;
            final int n12 = n6;
            Future[] futureArray = new Future[n8];
            Integer[] integerArray = new Integer[n8];
            int n13 = n2 / n8;
            for (n9 = 0; n9 < n8; ++n9) {
                final int n14 = n9 * n13;
                final int n15 = n9 == n8 - 1 ? n2 : n14 + n13;
                futureArray[n9] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = n10 + n14 * DenseIntMatrix1D.this.stride;
                        int n2 = n11 + n14 * n12;
                        n -= DenseIntMatrix1D.this.stride;
                        n2 -= n12;
                        int n3 = 0;
                        int n4 = n15 - n14;
                        int n5 = n4 / 4;
                        while (--n5 >= 0) {
                            int n6 = n + DenseIntMatrix1D.this.stride;
                            n = n6;
                            int n7 = n2 + n12;
                            n2 = n7;
                            int n8 = n + DenseIntMatrix1D.this.stride;
                            n = n8;
                            int n9 = n2 + n12;
                            n2 = n9;
                            n = n + DenseIntMatrix1D.this.stride;
                            n2 = n2 + n12;
                            n3 += DenseIntMatrix1D.this.elements[n6] * nArray[n7] + DenseIntMatrix1D.this.elements[n8] * nArray[n9] + DenseIntMatrix1D.this.elements[n] * nArray[n2] + DenseIntMatrix1D.this.elements[n += DenseIntMatrix1D.this.stride] * nArray[n2 += n12];
                        }
                        n5 = n4 % 4;
                        while (--n5 >= 0) {
                            n3 += DenseIntMatrix1D.this.elements[n += DenseIntMatrix1D.this.stride] * nArray[n2 += n12];
                        }
                        return n3;
                    }
                });
            }
            try {
                for (n9 = 0; n9 < n8; ++n9) {
                    integerArray[n9] = (Integer)futureArray[n9].get();
                }
                n7 = integerArray[0];
                for (n9 = 1; n9 < n8; ++n9) {
                    n7 += integerArray[n9].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 -= this.stride;
            n5 -= n6;
            int n16 = n3 - n;
            int n17 = n16 / 4;
            while (--n17 >= 0) {
                int n18 = n4 + this.stride;
                n4 = n18;
                int n19 = n5 + n6;
                n5 = n19;
                int n20 = n4 + this.stride;
                n4 = n20;
                int n21 = n5 + n6;
                n5 = n21;
                n4 = n4 + this.stride;
                n5 = n5 + n6;
                n7 += this.elements[n18] * nArray[n19] + this.elements[n20] * nArray[n21] + this.elements[n4] * nArray[n5] + this.elements[n4 += this.stride] * nArray[n5 += n6];
            }
            n17 = n16 % 4;
            while (--n17 >= 0) {
                n7 += this.elements[n4 += this.stride] * nArray[n5 += n6];
            }
        }
        return n7;
    }

    public int zSum() {
        int n = 0;
        final int[] nArray = this.elements;
        if (nArray == null) {
            throw new InternalError();
        }
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = DenseIntMatrix1D.this.zero + n5 * DenseIntMatrix1D.this.stride;
                        for (int i = n5; i < n6; ++i) {
                            n += nArray[n2];
                            n2 += DenseIntMatrix1D.this.stride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                n += nArray[n7];
                n7 += this.stride;
            }
        }
        return n;
    }

    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.zero;
        int[] nArray = this.elements;
        int n4 = this.size;
        while (--n4 >= 0 && n2 < n) {
            if (nArray[n3] != 0) {
                ++n2;
            }
            n3 += this.stride;
        }
        return n2;
    }

    protected boolean haveSharedCellsRaw(IntMatrix1D intMatrix1D) {
        if (intMatrix1D instanceof SelectedDenseIntMatrix1D) {
            SelectedDenseIntMatrix1D selectedDenseIntMatrix1D = (SelectedDenseIntMatrix1D)intMatrix1D;
            return this.elements == selectedDenseIntMatrix1D.elements;
        }
        if (intMatrix1D instanceof DenseIntMatrix1D) {
            DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D;
            return this.elements == denseIntMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return this.zero + n * this.stride;
    }

    protected IntMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseIntMatrix1D(this.elements, nArray);
    }
}

