/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;

class SelectedDenseIntMatrix1D
extends IntMatrix1D {
    protected int[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseIntMatrix1D(int[] nArray, int[] nArray2) {
        this(nArray2.length, nArray, 0, 1, nArray2, 0);
    }

    protected SelectedDenseIntMatrix1D(int n, int[] nArray, int n2, int n3, int[] nArray2, int n4) {
        this.setUp(n, n2, n3);
        this.elements = nArray;
        this.offsets = nArray2;
        this.offset = n4;
        this.isNoView = false;
    }

    public int[] elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public int getQuick(int n) {
        return this.elements[this.offset + this.offsets[this.zero + n * this.stride]];
    }

    public long index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    public IntMatrix1D like(int n) {
        return new DenseIntMatrix1D(n);
    }

    public IntMatrix2D like2D(int n, int n2) {
        return new DenseIntMatrix2D(n, n2);
    }

    public IntMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public IntMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void setQuick(int n, int n2) {
        this.elements[this.offset + this.offsets[this.zero + n * this.stride]] = n2;
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    protected boolean haveSharedCellsRaw(IntMatrix1D intMatrix1D) {
        if (intMatrix1D instanceof SelectedDenseIntMatrix1D) {
            SelectedDenseIntMatrix1D selectedDenseIntMatrix1D = (SelectedDenseIntMatrix1D)intMatrix1D;
            return this.elements == selectedDenseIntMatrix1D.elements;
        }
        if (intMatrix1D instanceof DenseIntMatrix1D) {
            DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D;
            return this.elements == denseIntMatrix1D.elements;
        }
        return false;
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected IntMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseIntMatrix1D(this.elements, nArray);
    }
}

