/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedDenseIntMatrix2D;

class SelectedDenseIntMatrix3D
extends IntMatrix3D {
    protected int[] elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseIntMatrix3D(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n) {
        int n2 = nArray2.length;
        int n3 = nArray3.length;
        int n4 = nArray4.length;
        this.setUp(n2, n3, n4);
        this.elements = nArray;
        this.sliceOffsets = nArray2;
        this.rowOffsets = nArray3;
        this.columnOffsets = nArray4;
        this.offset = n;
        this.isNoView = false;
    }

    public int[] elements() {
        throw new IllegalAccessError("getElements() is not supported for SelectedDenseIntMatrix3D.");
    }

    public int getQuick(int n, int n2, int n3) {
        return this.elements[this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride]];
    }

    public long index(int n, int n2, int n3) {
        return this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride];
    }

    public IntMatrix3D like(int n, int n2, int n3) {
        return new DenseIntMatrix3D(n, n2, n3);
    }

    public void setQuick(int n, int n2, int n3, int n4) {
        this.elements[this.offset + this.sliceOffsets[this.sliceZero + n * this.sliceStride] + this.rowOffsets[this.rowZero + n2 * this.rowStride] + this.columnOffsets[this.columnZero + n3 * this.columnStride]] = n4;
    }

    public IntMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public IntMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero;
        int n6 = this.offset + this._columnOffset(this._columnRank(n));
        int n7 = this.sliceStride;
        int n8 = this.rowStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.rowOffsets;
        return new SelectedDenseIntMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public IntMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._rowOffset(this._rowRank(n));
        int n7 = this.sliceStride;
        int n8 = this.columnStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedDenseIntMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    public IntMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._sliceOffset(this._sliceRank(n));
        int n7 = this.rowStride;
        int n8 = this.columnStride;
        int[] nArray = this.rowOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedDenseIntMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected int _sliceOffset(int n) {
        return this.sliceOffsets[n];
    }

    protected boolean haveSharedCellsRaw(IntMatrix3D intMatrix3D) {
        if (intMatrix3D instanceof SelectedDenseIntMatrix3D) {
            SelectedDenseIntMatrix3D selectedDenseIntMatrix3D = (SelectedDenseIntMatrix3D)intMatrix3D;
            return this.elements == selectedDenseIntMatrix3D.elements;
        }
        if (intMatrix3D instanceof DenseIntMatrix3D) {
            DenseIntMatrix3D denseIntMatrix3D = (DenseIntMatrix3D)intMatrix3D;
            return this.elements == denseIntMatrix3D.elements;
        }
        return false;
    }

    protected IntMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2, int n3) {
        super.setUp(n, n2, n3);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix3D vDice(int n, int n2, int n3) {
        super.vDice(n, n2, n3);
        int[][] nArrayArray = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = nArrayArray[n];
        this.rowOffsets = nArrayArray[n2];
        this.columnOffsets = nArrayArray[n3];
        return this;
    }

    protected IntMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseIntMatrix3D(this.elements, nArray, nArray2, nArray3, this.offset);
    }
}

