/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseObjectMatrix2D
extends ObjectMatrix2D {
    protected Object[] elements;

    public DenseObjectMatrix2D(Object[][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length);
        this.assign(objectArray);
    }

    public DenseObjectMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new Object[n * n2];
    }

    protected DenseObjectMatrix2D(int n, int n2, Object[] objectArray, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = objectArray;
        this.isNoView = false;
    }

    public ObjectMatrix2D assign(final Object[][] objectArray) {
        if (objectArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + objectArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n2;
                Future[] futureArray = new Future[n];
                int n3 = this.rows / n;
                for (n2 = 0; n2 < n; ++n2) {
                    final int n4 = n2 * n3;
                    final int n5 = n2 == n - 1 ? this.rows : n4 + n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseObjectMatrix2D.this.rowStride;
                            for (int i = n4; i < n5; ++i) {
                                Object[] objectArray2 = objectArray[i];
                                if (objectArray2.length != DenseObjectMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + DenseObjectMatrix2D.this.columns());
                                }
                                System.arraycopy(objectArray2, 0, DenseObjectMatrix2D.this.elements, n, DenseObjectMatrix2D.this.columns);
                                n += DenseObjectMatrix2D.this.columns;
                            }
                        }
                    });
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        futureArray[n2].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                int n6 = 0;
                for (int i = 0; i < this.rows; ++i) {
                    Object[] objectArray2 = objectArray[i];
                    if (objectArray2.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(objectArray2, 0, this.elements, n6, this.columns);
                    n6 += this.columns;
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n8;
                Future[] futureArray = new Future[n];
                int n9 = this.rows / n;
                for (n8 = 0; n8 < n; ++n8) {
                    final int n10 = n8 * n9;
                    final int n11 = n8 == n - 1 ? this.rows : n10 + n9;
                    futureArray[n8] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n7 + n10 * DenseObjectMatrix2D.this.rowStride;
                            for (int i = n10; i < n11; ++i) {
                                Object[] objectArray2 = objectArray[i];
                                if (objectArray2.length != DenseObjectMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + DenseObjectMatrix2D.this.columns());
                                }
                                int n2 = n;
                                for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                    DenseObjectMatrix2D.this.elements[n2] = objectArray2[j];
                                    n2 += DenseObjectMatrix2D.this.columnStride;
                                }
                                n += DenseObjectMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                try {
                    for (n8 = 0; n8 < n; ++n8) {
                        futureArray[n8].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                int n12 = n7;
                for (int i = 0; i < this.rows; ++i) {
                    Object[] objectArray3 = objectArray[i];
                    if (objectArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray3.length + "columns()=" + this.columns());
                    }
                    int n13 = n12;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n13] = objectArray3[j];
                        n13 += this.columnStride;
                    }
                    n12 += this.rowStride;
                }
            }
            return this;
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectFunction objectFunction) {
        final Object[] objectArray = this.elements;
        if (objectArray == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseObjectMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                objectArray[n2] = objectFunction.apply(objectArray[n2]);
                                n2 += DenseObjectMatrix2D.this.columnStride;
                            }
                            n3 += DenseObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    objectArray[n7] = objectFunction.apply(objectArray[n7]);
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D) {
        Object[] objectArray;
        if (!(objectMatrix2D instanceof DenseObjectMatrix2D)) {
            return super.assign(objectMatrix2D);
        }
        final DenseObjectMatrix2D denseObjectMatrix2D = (DenseObjectMatrix2D)objectMatrix2D;
        if (denseObjectMatrix2D == this) {
            return this;
        }
        this.checkShape(denseObjectMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseObjectMatrix2D.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n2;
                Future[] futureArray = new Future[n];
                int n3 = this.size() / n;
                for (n2 = 0; n2 < n; ++n2) {
                    final int n4 = n2 * n3;
                    final int n5 = n2 == n - 1 ? this.size() - n4 : n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            System.arraycopy(denseObjectMatrix2D.elements, n4, DenseObjectMatrix2D.this.elements, n4, n5);
                        }
                    });
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        futureArray[n2].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                System.arraycopy(denseObjectMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            }
            return this;
        }
        DenseObjectMatrix2D denseObjectMatrix2D2 = (DenseObjectMatrix2D)objectMatrix2D;
        if (this.haveSharedCells(denseObjectMatrix2D2)) {
            objectArray = denseObjectMatrix2D2.copy();
            if (!(objectArray instanceof DenseObjectMatrix2D)) {
                super.assign(denseObjectMatrix2D2);
                return this;
            }
            denseObjectMatrix2D2 = (DenseObjectMatrix2D)objectArray;
        }
        objectArray = denseObjectMatrix2D2.elements;
        if (this.elements == null || objectArray == null) {
            throw new InternalError();
        }
        final int n6 = (int)denseObjectMatrix2D2.index(0, 0);
        final int n7 = (int)this.index(0, 0);
        final int n8 = denseObjectMatrix2D2.columnStride;
        final int n9 = denseObjectMatrix2D2.rowStride;
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n];
            int n10 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n11 = i * n10;
                final int n12 = i == n - 1 ? this.rows : n11 + n10;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n7 + n11 * DenseObjectMatrix2D.this.rowStride;
                        int n2 = n6 + n11 * n9;
                        for (int i = n11; i < n12; ++i) {
                            int n3 = n;
                            int n4 = n2;
                            for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                DenseObjectMatrix2D.this.elements[n3] = objectArray[n4];
                                n3 += DenseObjectMatrix2D.this.columnStride;
                                n4 += n8;
                            }
                            n += DenseObjectMatrix2D.this.rowStride;
                            n2 += n9;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n13 = n7;
            int n14 = n6;
            for (int i = 0; i < this.rows; ++i) {
                int n15 = n13;
                int n16 = n14;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n15] = objectArray[n16];
                    n15 += this.columnStride;
                    n16 += n8;
                }
                n13 += this.rowStride;
                n14 += n9;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D, final ObjectObjectFunction objectObjectFunction) {
        if (!(objectMatrix2D instanceof DenseObjectMatrix2D)) {
            return super.assign(objectMatrix2D, objectObjectFunction);
        }
        DenseObjectMatrix2D denseObjectMatrix2D = (DenseObjectMatrix2D)objectMatrix2D;
        this.checkShape(objectMatrix2D);
        final Object[] objectArray = denseObjectMatrix2D.elements();
        if (this.elements == null || objectArray == null) {
            throw new InternalError();
        }
        final int n = (int)denseObjectMatrix2D.index(0, 0);
        final int n2 = (int)this.index(0, 0);
        final int n3 = denseObjectMatrix2D.columnStride;
        final int n4 = denseObjectMatrix2D.rowStride;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n5 = n2 + n7 * DenseObjectMatrix2D.this.rowStride;
                        int n22 = n + n7 * n4;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n5;
                            int n42 = n22;
                            for (int j = 0; j < DenseObjectMatrix2D.this.columns; ++j) {
                                DenseObjectMatrix2D.this.elements[n32] = objectObjectFunction.apply(DenseObjectMatrix2D.this.elements[n32], objectArray[n42]);
                                n32 += DenseObjectMatrix2D.this.columnStride;
                                n42 += n3;
                            }
                            n5 += DenseObjectMatrix2D.this.rowStride;
                            n22 += n4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n2;
            int n10 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11] = objectObjectFunction.apply(this.elements[n11], objectArray[n12]);
                    n11 += this.columnStride;
                    n12 += n3;
                }
                n9 += this.rowStride;
                n10 += n4;
            }
        }
        return this;
    }

    public Object[] elements() {
        return this.elements;
    }

    public Object getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D instanceof SelectedDenseObjectMatrix2D) {
            SelectedDenseObjectMatrix2D selectedDenseObjectMatrix2D = (SelectedDenseObjectMatrix2D)objectMatrix2D;
            return this.elements == selectedDenseObjectMatrix2D.elements;
        }
        if (objectMatrix2D instanceof DenseObjectMatrix2D) {
            DenseObjectMatrix2D denseObjectMatrix2D = (DenseObjectMatrix2D)objectMatrix2D;
            return this.elements == denseObjectMatrix2D.elements;
        }
        return false;
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new DenseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return new DenseObjectMatrix1D(n);
    }

    protected ObjectMatrix1D like1D(int n, int n2, int n3) {
        return new DenseObjectMatrix1D(n, this.elements, n2, n3);
    }

    public void setQuick(int n, int n2, Object object) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = object;
    }

    protected ObjectMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseObjectMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

