/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseObjectMatrix3D
extends ObjectMatrix3D {
    protected Object[] elements;

    public DenseObjectMatrix3D(Object[][][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length, objectArray.length == 0 ? 0 : (objectArray[0].length == 0 ? 0 : objectArray[0][0].length));
        this.assign(objectArray);
    }

    public DenseObjectMatrix3D(int n, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = new Object[n * n2 * n3];
    }

    protected DenseObjectMatrix3D(int n, int n2, int n3, Object[] objectArray, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.elements = objectArray;
        this.isNoView = false;
    }

    public ObjectMatrix3D assign(final Object[][][] objectArray) {
        if (objectArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + objectArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n2;
                Future[] futureArray = new Future[n];
                int n3 = this.slices / n;
                for (n2 = 0; n2 < n; ++n2) {
                    final int n4 = n2 * n3;
                    final int n5 = n2 == n - 1 ? this.slices : n4 + n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseObjectMatrix3D.this.sliceStride;
                            for (int i = n4; i < n5; ++i) {
                                Object[][] objectArray3 = objectArray[i];
                                if (objectArray3.length != DenseObjectMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray3.length + "rows()=" + DenseObjectMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                    Object[] objectArray2 = objectArray3[j];
                                    if (objectArray2.length != DenseObjectMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + DenseObjectMatrix3D.this.columns());
                                    }
                                    System.arraycopy(objectArray2, 0, DenseObjectMatrix3D.this.elements, n, DenseObjectMatrix3D.this.columns);
                                    n += DenseObjectMatrix3D.this.columns;
                                }
                            }
                        }
                    });
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        futureArray[n2].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                int n6 = 0;
                for (int i = 0; i < this.slices; ++i) {
                    Object[][] objectArray2 = objectArray[i];
                    if (objectArray2.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray2.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        Object[] objectArray3 = objectArray2[j];
                        if (objectArray3.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray3.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(objectArray3, 0, this.elements, n6, this.columns);
                        n6 += this.columns;
                    }
                }
            }
        } else {
            final int n7 = (int)this.index(0, 0, 0);
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n8;
                Future[] futureArray = new Future[n];
                int n9 = this.slices / n;
                for (n8 = 0; n8 < n; ++n8) {
                    final int n10 = n8 * n9;
                    final int n11 = n8 == n - 1 ? this.slices : n10 + n9;
                    futureArray[n8] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n10; i < n11; ++i) {
                                Object[][] objectArray3 = objectArray[i];
                                if (objectArray3.length != DenseObjectMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray3.length + "rows()=" + DenseObjectMatrix3D.this.rows());
                                }
                                for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                    int n = n7 + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride;
                                    Object[] objectArray2 = objectArray3[j];
                                    if (objectArray2.length != DenseObjectMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + DenseObjectMatrix3D.this.columns());
                                    }
                                    for (int k = 0; k < DenseObjectMatrix3D.this.columns; ++k) {
                                        DenseObjectMatrix3D.this.elements[n] = objectArray2[k];
                                        n += DenseObjectMatrix3D.this.columnStride;
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    for (n8 = 0; n8 < n; ++n8) {
                        futureArray[n8].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                for (int i = 0; i < this.slices; ++i) {
                    Object[][] objectArray4 = objectArray[i];
                    if (objectArray4.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + objectArray4.length + "rows()=" + this.rows());
                    }
                    for (int j = 0; j < this.rows; ++j) {
                        int n12 = n7 + i * this.sliceStride + j * this.rowStride;
                        Object[] objectArray5 = objectArray4[j];
                        if (objectArray5.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray5.length + "columns()=" + this.columns());
                        }
                        for (int k = 0; k < this.columns; ++k) {
                            this.elements[n12] = objectArray5[k];
                            n12 += this.columnStride;
                        }
                    }
                }
            }
        }
        return this;
    }

    public ObjectMatrix3D assign(ObjectMatrix3D objectMatrix3D) {
        ObjectMatrix3D objectMatrix3D2;
        if (!(objectMatrix3D instanceof DenseObjectMatrix3D)) {
            return super.assign(objectMatrix3D);
        }
        DenseObjectMatrix3D denseObjectMatrix3D = (DenseObjectMatrix3D)objectMatrix3D;
        if (denseObjectMatrix3D == this) {
            return this;
        }
        this.checkShape(denseObjectMatrix3D);
        if (this.haveSharedCells(denseObjectMatrix3D)) {
            objectMatrix3D2 = denseObjectMatrix3D.copy();
            if (!(objectMatrix3D2 instanceof DenseObjectMatrix3D)) {
                super.assign(objectMatrix3D);
                return this;
            }
            denseObjectMatrix3D = objectMatrix3D2;
        }
        objectMatrix3D2 = denseObjectMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseObjectMatrix3D.isNoView) {
            if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
                int n2;
                Future[] futureArray = new Future[n];
                int n3 = this.size() / n;
                for (n2 = 0; n2 < n; ++n2) {
                    int n4 = n2 * n3;
                    int n5 = n2 == n - 1 ? this.size() - n4 : n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable((DenseObjectMatrix3D)objectMatrix3D2, n4, n5){
                        final /* synthetic */ DenseObjectMatrix3D val$other_final;
                        final /* synthetic */ int val$startidx;
                        final /* synthetic */ int val$length;
                        {
                            this.val$other_final = denseObjectMatrix3D2;
                            this.val$startidx = n;
                            this.val$length = n2;
                        }

                        public void run() {
                            System.arraycopy(this.val$other_final.elements, this.val$startidx, DenseObjectMatrix3D.this.elements, this.val$startidx, this.val$length);
                        }
                    });
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        futureArray[n2].get();
                    }
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                System.arraycopy(((DenseObjectMatrix3D)objectMatrix3D2).elements, 0, this.elements, 0, this.elements.length);
            }
            return this;
        }
        final int n6 = (int)this.index(0, 0, 0);
        final int n7 = (int)((DenseObjectMatrix3D)objectMatrix3D2).index(0, 0, 0);
        final int n8 = ((DenseObjectMatrix3D)objectMatrix3D2).sliceStride;
        final int n9 = ((DenseObjectMatrix3D)objectMatrix3D2).rowStride;
        final int n10 = ((DenseObjectMatrix3D)objectMatrix3D2).columnStride;
        final Object[] objectArray = ((DenseObjectMatrix3D)objectMatrix3D2).elements;
        if (n > 1 && this.size() >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n11;
            Future[] futureArray = new Future[n];
            int n12 = this.slices / n;
            for (n11 = 0; n11 < n; ++n11) {
                final int n13 = n11 * n12;
                final int n14 = n11 == n - 1 ? this.slices : n13 + n12;
                futureArray[n11] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n13; i < n14; ++i) {
                            for (int j = 0; j < DenseObjectMatrix3D.this.rows; ++j) {
                                int n = n6 + i * DenseObjectMatrix3D.this.sliceStride + j * DenseObjectMatrix3D.this.rowStride;
                                int n2 = n7 + i * n8 + j * n9;
                                for (int k = 0; k < DenseObjectMatrix3D.this.columns; ++k) {
                                    DenseObjectMatrix3D.this.elements[n] = objectArray[n2];
                                    n += DenseObjectMatrix3D.this.columnStride;
                                    n2 += n10;
                                }
                            }
                        }
                    }
                });
            }
            try {
                for (n11 = 0; n11 < n; ++n11) {
                    futureArray[n11].get();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n15 = n6 + i * this.sliceStride + j * this.rowStride;
                    int n16 = n7 + i * n8 + j * n9;
                    for (int k = 0; k < this.columns; ++k) {
                        this.elements[n15] = objectArray[n16];
                        n15 += this.columnStride;
                        n16 += n10;
                    }
                }
            }
        }
        return this;
    }

    public Object[] elements() {
        return this.elements;
    }

    public Object getQuick(int n, int n2, int n3) {
        return this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix3D objectMatrix3D) {
        if (objectMatrix3D instanceof SelectedDenseObjectMatrix3D) {
            SelectedDenseObjectMatrix3D selectedDenseObjectMatrix3D = (SelectedDenseObjectMatrix3D)objectMatrix3D;
            return this.elements == selectedDenseObjectMatrix3D.elements;
        }
        if (objectMatrix3D instanceof DenseObjectMatrix3D) {
            DenseObjectMatrix3D denseObjectMatrix3D = (DenseObjectMatrix3D)objectMatrix3D;
            return this.elements == denseObjectMatrix3D.elements;
        }
        return false;
    }

    public long index(int n, int n2, int n3) {
        return this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride;
    }

    public ObjectMatrix3D like(int n, int n2, int n3) {
        return new DenseObjectMatrix3D(n, n2, n3);
    }

    protected ObjectMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new DenseObjectMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    public void setQuick(int n, int n2, int n3, Object object) {
        this.elements[this.sliceZero + n * this.sliceStride + this.rowZero + n2 * this.rowStride + this.columnZero + n3 * this.columnStride] = object;
    }

    protected ObjectMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedDenseObjectMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

