/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tfcomplex;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexRealProcedure;
import cern.colt.function.tfcomplex.FComplexFComplexRealRealFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFComplexFunction;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.function.tfcomplex.RealFComplexFComplexFunction;
import cern.colt.function.tfcomplex.RealFComplexFunction;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexMult;
import cern.jet.math.tfcomplex.FComplexPlusMult;

public class FComplexFunctions {
    public static final FComplexFunctions functions = new FComplexFunctions();
    public static final FComplexRealFunction abs = new FComplexRealFunction(){

        public final float apply(float[] fArray) {
            float f = Math.abs(fArray[0]);
            float f2 = Math.abs(fArray[1]);
            if ((double)f == 0.0 && (double)f2 == 0.0) {
                return 0.0f;
            }
            if (f >= f2) {
                float f3 = fArray[1] / fArray[0];
                return (float)((double)f * Math.sqrt(1.0 + (double)(f3 * f3)));
            }
            float f4 = fArray[0] / fArray[1];
            return (float)((double)f2 * Math.sqrt(1.0 + (double)(f4 * f4)));
        }
    };
    public static final FComplexFComplexFunction acos = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[2];
            float f = (float)(1.0 - (double)(fArray[0] * fArray[0] - fArray[1] * fArray[1]));
            float f2 = -(fArray[0] * fArray[1] + fArray[1] * fArray[0]);
            fArray2[0] = f;
            fArray2[1] = f2;
            fArray2 = FComplex.sqrt(fArray2);
            f = -fArray2[1];
            f2 = fArray2[0];
            fArray2[0] = fArray[0] + f;
            fArray2[1] = fArray[1] + f2;
            f = (float)Math.log(FComplex.abs(fArray2));
            fArray2[0] = f2 = (float)Math.atan2(fArray2[1], fArray2[0]);
            fArray2[1] = -f;
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[2];
            float f3 = (float)(1.0 - (double)(f * f - f2 * f2));
            float f4 = -(f * f2 + f2 * f);
            fArray[0] = f3;
            fArray[1] = f4;
            fArray = FComplex.sqrt(fArray);
            f3 = -fArray[1];
            f4 = fArray[0];
            fArray[0] = f + f3;
            fArray[1] = f2 + f4;
            f3 = (float)Math.log(FComplex.abs(fArray));
            fArray[0] = f4 = (float)Math.atan2(fArray[1], fArray[0]);
            fArray[1] = -f3;
            return fArray;
        }
    };
    public static final FComplexRealFunction arg = new FComplexRealFunction(){

        public final float apply(float[] fArray) {
            return (float)Math.atan2(fArray[1], fArray[0]);
        }
    };
    public static final FComplexFComplexFunction asin = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[2];
            float f = (float)(1.0 - (double)(fArray[0] * fArray[0] - fArray[1] * fArray[1]));
            float f2 = -(fArray[0] * fArray[1] + fArray[1] * fArray[0]);
            fArray2[0] = f;
            fArray2[1] = f2;
            fArray2 = FComplex.sqrt(fArray2);
            f = -fArray2[1];
            f2 = fArray2[0];
            fArray2[0] = fArray2[0] + f;
            fArray2[1] = fArray2[1] + f2;
            f = (float)Math.log(FComplex.abs(fArray2));
            fArray2[0] = f2 = (float)Math.atan2(fArray2[1], fArray2[0]);
            fArray2[1] = -f;
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[2];
            float f3 = (float)(1.0 - (double)(f * f - f2 * f2));
            float f4 = -(f * f2 + f2 * f);
            fArray[0] = f3;
            fArray[1] = f4;
            fArray = FComplex.sqrt(fArray);
            f3 = -fArray[1];
            f4 = fArray[0];
            fArray[0] = fArray[0] + f3;
            fArray[1] = fArray[1] + f4;
            f3 = (float)Math.log(FComplex.abs(fArray));
            fArray[0] = f4 = (float)Math.atan2(fArray[1], fArray[0]);
            fArray[1] = -f3;
            return fArray;
        }
    };
    public static final FComplexFComplexFunction atan = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[]{-fArray[0], 1.0f - fArray[1]};
            float f = fArray[0];
            float f2 = 1.0f + fArray[1];
            fArray2 = FComplex.div(fArray2, f, f2);
            f = (float)Math.log(FComplex.abs(fArray2));
            f2 = (float)Math.atan2(fArray2[1], fArray2[0]);
            fArray2[0] = 0.5f * f2;
            fArray2[1] = -0.5f * f;
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[]{-f, 1.0f - f2};
            float f3 = f;
            float f4 = 1.0f + f2;
            fArray = FComplex.div(fArray, f3, f4);
            f3 = (float)Math.log(FComplex.abs(fArray));
            f4 = (float)Math.atan2(fArray[1], fArray[0]);
            fArray[0] = 0.5f * f4;
            fArray[1] = -0.5f * f3;
            return fArray;
        }
    };
    public static final FComplexFComplexFunction conj = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[]{fArray[0], -fArray[1]};
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[]{f, -f2};
            return fArray;
        }
    };
    public static final FComplexFComplexFunction cos = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[2];
            float f = -fArray[1];
            float f2 = fArray[0];
            float f3 = (float)Math.exp(f);
            float f4 = (float)((double)f3 * Math.cos(f2));
            float f5 = (float)((double)f3 * Math.sin(f2));
            f3 = (float)Math.exp(-f);
            float f6 = (float)((double)f3 * Math.cos(-f2));
            float f7 = (float)((double)f3 * Math.sin(-f2));
            fArray2[0] = 0.5f * (f4 += f6);
            fArray2[1] = 0.5f * (f5 += f7);
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[2];
            float f3 = -f2;
            float f4 = f;
            float f5 = (float)Math.exp(f3);
            float f6 = (float)((double)f5 * Math.cos(f4));
            float f7 = (float)((double)f5 * Math.sin(f4));
            f5 = (float)Math.exp(-f3);
            float f8 = (float)((double)f5 * Math.cos(-f4));
            float f9 = (float)((double)f5 * Math.sin(-f4));
            fArray[0] = 0.5f * (f6 += f8);
            fArray[1] = 0.5f * (f7 += f9);
            return fArray;
        }
    };
    public static final FComplexFComplexFunction exp = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[2];
            float f = (float)Math.exp(fArray[0]);
            fArray2[0] = (float)((double)f * Math.cos(fArray[1]));
            fArray2[1] = (float)((double)f * Math.sin(fArray[1]));
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[2];
            float f3 = (float)Math.exp(f);
            fArray[0] = (float)((double)f3 * Math.cos(f2));
            fArray[1] = (float)((double)f3 * Math.sin(f2));
            return fArray;
        }
    };
    public static final FComplexFComplexFunction identity = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            return fArray;
        }

        public final float[] apply(float f, float f2) {
            return new float[]{f, f2};
        }
    };
    public static final FComplexFComplexFunction inv = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[2];
            if ((double)fArray[1] != 0.0) {
                if (Math.abs(fArray[0]) >= Math.abs(fArray2[1])) {
                    float f;
                    fArray2[0] = f = (float)(1.0 / (double)(fArray[0] + fArray[1] * (fArray[1] / fArray[0])));
                    fArray2[1] = f * (-fArray[1] / fArray[0]);
                } else {
                    float f = (float)(1.0 / (double)(fArray[0] * (fArray[0] / fArray[1]) + fArray[1]));
                    fArray2[0] = f * (fArray[0] / fArray[1]);
                    fArray2[1] = -f;
                }
            } else {
                fArray2[0] = 1.0f / fArray[0];
                fArray2[1] = 0.0f;
            }
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[2];
            if ((double)f2 != 0.0) {
                if (Math.abs(f) >= Math.abs(fArray[1])) {
                    float f3;
                    fArray[0] = f3 = (float)(1.0 / (double)(f + f2 * (f2 / f)));
                    fArray[1] = f3 * (-f2 / f);
                } else {
                    float f4 = (float)(1.0 / (double)(f * (f / f2) + f2));
                    fArray[0] = f4 * (f / f2);
                    fArray[1] = -f4;
                }
            } else {
                fArray[0] = 1.0f / f;
                fArray[1] = 0.0f;
            }
            return fArray;
        }
    };
    public static final FComplexFComplexFunction log = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[]{(float)Math.log(FComplex.abs(fArray)), FComplex.arg(fArray)};
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[]{(float)Math.log(FComplex.abs(f, f2)), FComplex.arg(f, f2)};
            return fArray;
        }
    };
    public static final FComplexFComplexFunction neg = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            return new float[]{-fArray[0], -fArray[1]};
        }

        public final float[] apply(float f, float f2) {
            return new float[]{-f, -f2};
        }
    };
    public static final FComplexFComplexFunction sin = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[2];
            float f = -fArray[1];
            float f2 = fArray[0];
            float f3 = (float)Math.exp(f);
            float f4 = (float)((double)f3 * Math.cos(f2));
            float f5 = (float)((double)f3 * Math.sin(f2));
            f3 = (float)Math.exp(-f);
            float f6 = (float)((double)f3 * Math.cos(-f2));
            float f7 = (float)((double)f3 * Math.sin(-f2));
            fArray2[0] = 0.5f * (f5 -= f7);
            fArray2[1] = -0.5f * (f4 -= f6);
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[2];
            float f3 = -f2;
            float f4 = f;
            float f5 = (float)Math.exp(f3);
            float f6 = (float)((double)f5 * Math.cos(f4));
            float f7 = (float)((double)f5 * Math.sin(f4));
            f5 = (float)Math.exp(-f3);
            float f8 = (float)((double)f5 * Math.cos(-f4));
            float f9 = (float)((double)f5 * Math.sin(-f4));
            fArray[0] = 0.5f * (f7 -= f9);
            fArray[1] = -0.5f * (f6 -= f8);
            return fArray;
        }
    };
    public static final FComplexFComplexFunction sqrt = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[2];
            float f = FComplex.abs(fArray);
            if ((double)f > 0.0) {
                if ((double)fArray[0] > 0.0) {
                    float f2;
                    fArray2[0] = f2 = (float)Math.sqrt(0.5 * (double)(f + fArray[0]));
                    fArray2[1] = 0.5f * (fArray[1] / f2);
                } else {
                    float f3 = (float)Math.sqrt(0.5 * (double)(f - fArray[0]));
                    if ((double)fArray[1] < 0.0) {
                        f3 = -f3;
                    }
                    fArray2[0] = 0.5f * (fArray[1] / f3);
                    fArray2[1] = f3;
                }
            } else {
                fArray2[0] = 0.0f;
                fArray2[1] = 0.0f;
            }
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[2];
            float f3 = FComplex.abs(f, f2);
            if ((double)f3 > 0.0) {
                if ((double)f > 0.0) {
                    float f4;
                    fArray[0] = f4 = (float)Math.sqrt(0.5 * (double)(f3 + f));
                    fArray[1] = 0.5f * (f2 / f4);
                } else {
                    float f5 = (float)Math.sqrt(0.5 * (double)(f3 - f));
                    if ((double)f2 < 0.0) {
                        f5 = -f5;
                    }
                    fArray[0] = 0.5f * (f2 / f5);
                    fArray[1] = f5;
                }
            } else {
                fArray[0] = 0.0f;
                fArray[1] = 0.0f;
            }
            return fArray;
        }
    };
    public static final FComplexFComplexFunction square = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[]{fArray[0] * fArray[0] - fArray[1] * fArray[1], fArray[1] * fArray[0] + fArray[0] * fArray[1]};
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[]{f * f - f2 * f2, f2 * f + f * f2};
            return fArray;
        }
    };
    public static final FComplexFComplexFunction tan = new FComplexFComplexFunction(){

        public final float[] apply(float[] fArray) {
            float[] fArray2 = new float[2];
            float f = -fArray[1];
            float f2 = fArray[0];
            float f3 = (float)Math.exp(f);
            float f4 = (float)((double)f3 * Math.cos(f2));
            float f5 = (float)((double)f3 * Math.sin(f2));
            f3 = (float)Math.exp(-f);
            float f6 = (float)((double)f3 * Math.cos(-f2));
            float f7 = (float)((double)f3 * Math.sin(-f2));
            float f8 = f4 - f6;
            float f9 = f5 - f7;
            fArray2[0] = 0.5f * f9;
            fArray2[1] = -0.5f * f8;
            f8 = f4 + f6;
            f9 = f5 + f7;
            float f10 = 0.5f * f8;
            float f11 = 0.5f * f9;
            fArray2 = FComplex.div(fArray2, f10, f11);
            return fArray2;
        }

        public final float[] apply(float f, float f2) {
            float[] fArray = new float[2];
            float f3 = -f2;
            float f4 = f;
            float f5 = (float)Math.exp(f3);
            float f6 = (float)((double)f5 * Math.cos(f4));
            float f7 = (float)((double)f5 * Math.sin(f4));
            f5 = (float)Math.exp(-f3);
            float f8 = (float)((double)f5 * Math.cos(-f4));
            float f9 = (float)((double)f5 * Math.sin(-f4));
            float f10 = f6 - f8;
            float f11 = f7 - f9;
            fArray[0] = 0.5f * f11;
            fArray[1] = -0.5f * f10;
            f10 = f6 + f8;
            f11 = f7 + f9;
            float f12 = 0.5f * f10;
            float f13 = 0.5f * f11;
            fArray = FComplex.div(fArray, f12, f13);
            return fArray;
        }
    };
    public static final FComplexFComplexFComplexFunction div = new FComplexFComplexFComplexFunction(){

        public final float[] apply(float[] fArray, float[] fArray2) {
            float f = fArray2[0];
            float f2 = fArray2[1];
            float[] fArray3 = new float[2];
            if (Math.abs(f) >= Math.abs(f2)) {
                float f3 = (float)(1.0 / (double)(f + f2 * (f2 / f)));
                fArray3[0] = f3 * (fArray[0] + fArray[1] * (f2 / f));
                fArray3[1] = f3 * (fArray[1] - fArray[0] * (f2 / f));
            } else {
                float f4 = (float)(1.0 / (double)(f * (f / f2) + f2));
                fArray3[0] = f4 * (fArray[0] * (f / f2) + fArray[1]);
                fArray3[1] = f4 * (fArray[1] * (f / f2) - fArray[0]);
            }
            return fArray3;
        }
    };
    public static final FComplexFComplexRealRealFunction equals = new FComplexFComplexRealRealFunction(){

        public final float apply(float[] fArray, float[] fArray2, float f) {
            if (FComplex.abs(fArray[0] - fArray2[0], fArray[1] - fArray2[1]) <= Math.abs(f)) {
                return 1.0f;
            }
            return 0.0f;
        }
    };
    public static final FComplexFComplexRealProcedure isEqual = new FComplexFComplexRealProcedure(){

        public final boolean apply(float[] fArray, float[] fArray2, float f) {
            return FComplex.abs(fArray[0] - fArray2[0], fArray[1] - fArray2[1]) <= Math.abs(f);
        }
    };
    public static final FComplexFComplexFComplexFunction minus = new FComplexFComplexFComplexFunction(){

        public final float[] apply(float[] fArray, float[] fArray2) {
            float[] fArray3 = new float[]{fArray[0] - fArray2[0], fArray[1] - fArray2[1]};
            return fArray3;
        }
    };
    public static final FComplexFComplexFComplexFunction mult = new FComplexFComplexFComplexFunction(){

        public final float[] apply(float[] fArray, float[] fArray2) {
            float[] fArray3 = new float[]{fArray[0] * fArray2[0] - fArray[1] * fArray2[1], fArray[1] * fArray2[0] + fArray[0] * fArray2[1]};
            return fArray3;
        }
    };
    public static final FComplexFComplexFComplexFunction multConjFirst = new FComplexFComplexFComplexFunction(){

        public final float[] apply(float[] fArray, float[] fArray2) {
            float[] fArray3 = new float[]{fArray[0] * fArray2[0] + fArray[1] * fArray2[1], -fArray[1] * fArray2[0] + fArray[0] * fArray2[1]};
            return fArray3;
        }
    };
    public static final FComplexFComplexFComplexFunction multConjSecond = new FComplexFComplexFComplexFunction(){

        public final float[] apply(float[] fArray, float[] fArray2) {
            float[] fArray3 = new float[]{fArray[0] * fArray2[0] + fArray[1] * fArray2[1], fArray[1] * fArray2[0] - fArray[0] * fArray2[1]};
            return fArray3;
        }
    };
    public static final FComplexFComplexFComplexFunction plus = new FComplexFComplexFComplexFunction(){

        public final float[] apply(float[] fArray, float[] fArray2) {
            float[] fArray3 = new float[]{fArray[0] + fArray2[0], fArray[1] + fArray2[1]};
            return fArray3;
        }
    };
    public static final FComplexRealFComplexFunction pow1 = new FComplexRealFComplexFunction(){

        public final float[] apply(float[] fArray, float f) {
            float[] fArray2 = new float[2];
            float f2 = (float)((double)f * Math.log(FComplex.abs(fArray)));
            float f3 = f * FComplex.arg(fArray);
            float f4 = (float)Math.exp(f2);
            fArray2[0] = (float)((double)f4 * Math.cos(f3));
            fArray2[1] = (float)((double)f4 * Math.sin(f3));
            return fArray2;
        }
    };
    public static final RealFComplexFComplexFunction pow2 = new RealFComplexFComplexFunction(){

        public final float[] apply(float f, float[] fArray) {
            float[] fArray2 = new float[2];
            float f2 = (float)Math.log(Math.abs(f));
            float f3 = (float)Math.atan2(0.0, f);
            float f4 = f2 * fArray[0] - f3 * fArray[1];
            float f5 = f2 * fArray[1] + f3 * fArray[0];
            float f6 = (float)Math.exp(f4);
            fArray2[0] = (float)((double)f6 * Math.cos(f5));
            fArray2[1] = (float)((double)f6 * Math.sin(f5));
            return fArray2;
        }
    };
    public static final FComplexFComplexFComplexFunction pow3 = new FComplexFComplexFComplexFunction(){

        public final float[] apply(float[] fArray, float[] fArray2) {
            float[] fArray3 = new float[2];
            float f = (float)Math.log(FComplex.abs(fArray));
            float f2 = FComplex.arg(fArray);
            float f3 = f * fArray2[0] - f2 * fArray2[1];
            float f4 = f * fArray2[1] + f2 * fArray2[0];
            float f5 = (float)Math.exp(f3);
            fArray3[0] = (float)((double)f5 * Math.cos(f4));
            fArray3[1] = (float)((double)f5 * Math.sin(f4));
            return fArray3;
        }
    };

    public static FComplexFComplexFunction bindArg1(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final float[] fArray) {
        return new FComplexFComplexFunction(){

            public final float[] apply(float[] fArray2) {
                return fComplexFComplexFComplexFunction.apply(fArray, fArray2);
            }

            public final float[] apply(float f, float f2) {
                return fComplexFComplexFComplexFunction.apply(fArray, new float[]{f, f2});
            }
        };
    }

    public static FComplexFComplexFunction bindArg2(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final float[] fArray) {
        return new FComplexFComplexFunction(){

            public final float[] apply(float[] fArray2) {
                return fComplexFComplexFComplexFunction.apply(fArray2, fArray);
            }

            public final float[] apply(float f, float f2) {
                return fComplexFComplexFComplexFunction.apply(new float[]{f, f2}, fArray);
            }
        };
    }

    public static FComplexFComplexFComplexFunction chain(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction, final FComplexFComplexFunction fComplexFComplexFunction, final FComplexFComplexFunction fComplexFComplexFunction2) {
        return new FComplexFComplexFComplexFunction(){

            public final float[] apply(float[] fArray, float[] fArray2) {
                return fComplexFComplexFComplexFunction.apply(fComplexFComplexFunction.apply(fArray), fComplexFComplexFunction2.apply(fArray2));
            }
        };
    }

    public static FComplexFComplexFComplexFunction chain(final FComplexFComplexFunction fComplexFComplexFunction, final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        return new FComplexFComplexFComplexFunction(){

            public final float[] apply(float[] fArray, float[] fArray2) {
                return fComplexFComplexFunction.apply(fComplexFComplexFComplexFunction.apply(fArray, fArray2));
            }
        };
    }

    public static FComplexFComplexFunction chain(final FComplexFComplexFunction fComplexFComplexFunction, final FComplexFComplexFunction fComplexFComplexFunction2) {
        return new FComplexFComplexFunction(){

            public final float[] apply(float[] fArray) {
                return fComplexFComplexFunction.apply(fComplexFComplexFunction2.apply(fArray));
            }

            public final float[] apply(float f, float f2) {
                return fComplexFComplexFunction.apply(fComplexFComplexFunction2.apply(new float[]{f, f2}));
            }
        };
    }

    public static FComplexFComplexFunction constant(final float[] fArray) {
        return new FComplexFComplexFunction(){

            public final float[] apply(float[] fArray2) {
                return fArray;
            }

            public final float[] apply(float f, float f2) {
                return new float[]{f, f2};
            }
        };
    }

    public static FComplexFComplexFunction div(float[] fArray) {
        return FComplexFunctions.mult(FComplex.inv(fArray));
    }

    public static FComplexFComplexFunction div(float f) {
        float[] fArray = new float[]{f, 0.0f};
        return FComplexFunctions.mult(FComplex.inv(fArray));
    }

    public static FComplexRealFunction equals(final float[] fArray) {
        return new FComplexRealFunction(){

            public final float apply(float[] fArray2) {
                if (fArray2[0] == fArray[0] && fArray2[1] == fArray[1]) {
                    return 1.0f;
                }
                return 0.0f;
            }
        };
    }

    public static FComplexProcedure isEqual(final float[] fArray) {
        return new FComplexProcedure(){

            public final boolean apply(float[] fArray2) {
                return fArray2[0] == fArray[0] && fArray2[1] == fArray[1];
            }
        };
    }

    public static FComplexFComplexFunction minus(float[] fArray) {
        float[] fArray2 = new float[]{-fArray[0], -fArray[1]};
        return FComplexFunctions.plus(fArray2);
    }

    public static FComplexFComplexFComplexFunction minusMult(float[] fArray) {
        float[] fArray2 = new float[]{-fArray[0], -fArray[1]};
        return FComplexFunctions.plusMult(fArray2);
    }

    public static FComplexFComplexFunction mult(float[] fArray) {
        return new FComplexMult(fArray);
    }

    public static FComplexFComplexFunction mult(float f) {
        return new FComplexMult(new float[]{f, 0.0f});
    }

    public static FComplexFComplexFunction plus(final float[] fArray) {
        return new FComplexFComplexFunction(){

            public final float[] apply(float[] fArray3) {
                float[] fArray2 = new float[]{fArray3[0] + fArray[0], fArray3[1] + fArray[1]};
                return fArray2;
            }

            public final float[] apply(float f, float f2) {
                float[] fArray2 = new float[]{f + fArray[0], f2 + fArray[1]};
                return fArray2;
            }
        };
    }

    public static FComplexFComplexFComplexFunction plusMult(float[] fArray) {
        return new FComplexPlusMult(fArray);
    }

    public static FComplexFComplexFunction pow1(final float f) {
        return new FComplexFComplexFunction(){

            public final float[] apply(float[] fArray) {
                float[] fArray2 = new float[2];
                float f4 = (float)((double)f * Math.log(FComplex.abs(fArray)));
                float f2 = f * FComplex.arg(fArray);
                float f3 = (float)Math.exp(f4);
                fArray2[0] = (float)((double)f3 * Math.cos(f2));
                fArray2[1] = (float)((double)f3 * Math.sin(f2));
                return fArray2;
            }

            public final float[] apply(float f6, float f2) {
                float[] fArray = new float[2];
                float f3 = (float)((double)f * Math.log(FComplex.abs(f6, f2)));
                float f4 = f * FComplex.arg(f6, f2);
                float f5 = (float)Math.exp(f3);
                fArray[0] = (float)((double)f5 * Math.cos(f4));
                fArray[1] = (float)((double)f5 * Math.sin(f4));
                return fArray;
            }
        };
    }

    public static RealFComplexFunction pow2(final float[] fArray) {
        return new RealFComplexFunction(){

            public final float[] apply(float f) {
                float[] fArray2 = new float[2];
                float f2 = (float)Math.log(Math.abs(f));
                float f3 = (float)Math.atan2(0.0, f);
                float f4 = f2 * fArray[0] - f3 * fArray[1];
                float f5 = f2 * fArray[1] + f3 * fArray[0];
                float f6 = (float)Math.exp(f4);
                fArray2[0] = (float)((double)f6 * Math.cos(f5));
                fArray2[1] = (float)((double)f6 * Math.sin(f5));
                return fArray2;
            }
        };
    }

    public static FComplexFComplexFunction pow3(final float[] fArray) {
        return new FComplexFComplexFunction(){

            public final float[] apply(float[] fArray3) {
                float[] fArray2 = new float[2];
                float f = (float)Math.log(FComplex.abs(fArray3));
                float f2 = FComplex.arg(fArray3);
                float f3 = f * fArray[0] - f2 * fArray[1];
                float f4 = f * fArray[1] + f2 * fArray[0];
                float f5 = (float)Math.exp(f3);
                fArray2[0] = (float)((double)f5 * Math.cos(f4));
                fArray2[1] = (float)((double)f5 * Math.sin(f4));
                return fArray2;
            }

            public final float[] apply(float f, float f2) {
                float[] fArray2 = new float[2];
                float f3 = (float)Math.log(FComplex.abs(f, f2));
                float f4 = FComplex.arg(f, f2);
                float f5 = f3 * fArray[0] - f4 * fArray[1];
                float f6 = f3 * fArray[1] + f4 * fArray[0];
                float f7 = (float)Math.exp(f5);
                fArray2[0] = (float)((double)f7 * Math.cos(f6));
                fArray2[1] = (float)((double)f7 * Math.sin(f6));
                return fArray2;
            }
        };
    }

    public static FComplexFComplexFunction random() {
        return new RandomComplexFunction();
    }

    public static FComplexFComplexFComplexFunction swapArgs(final FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        return new FComplexFComplexFComplexFunction(){

            public final float[] apply(float[] fArray, float[] fArray2) {
                return fComplexFComplexFComplexFunction.apply(fArray2, fArray);
            }
        };
    }

    private static class RandomComplexFunction
    implements FComplexFComplexFunction {
        private RandomComplexFunction() {
        }

        public float[] apply(float[] fArray) {
            return new float[]{(float)Math.random(), (float)Math.random()};
        }

        public float[] apply(float f, float f2) {
            return new float[]{(float)Math.random(), (float)Math.random()};
        }
    }
}

