/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.random.tdouble.BreitWigner;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class BreitWignerMeanSquare
extends BreitWigner {
    protected DoubleUniform uniform;
    protected static BreitWigner shared = new BreitWignerMeanSquare(1.0, 0.2, 1.0, BreitWignerMeanSquare.makeDefaultGenerator());

    public BreitWignerMeanSquare(double d, double d2, double d3, DoubleRandomEngine doubleRandomEngine) {
        super(d, d2, d3, doubleRandomEngine);
        this.uniform = new DoubleUniform(doubleRandomEngine);
    }

    public Object clone() {
        BreitWignerMeanSquare breitWignerMeanSquare = (BreitWignerMeanSquare)super.clone();
        if (this.uniform != null) {
            breitWignerMeanSquare.uniform = new DoubleUniform(breitWignerMeanSquare.randomGenerator);
        }
        return breitWignerMeanSquare;
    }

    public double nextDouble(double d, double d2, double d3) {
        if (d2 == 0.0) {
            return d;
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            double d4 = Math.atan(-d / d2);
            double d5 = this.uniform.nextDoubleFromTo(d4, 1.5707963267948966);
            double d6 = d2 * Math.tan(d5);
            return Math.sqrt(d * d + d * d6);
        }
        double d7 = Math.max(0.0, d - d3);
        double d8 = Math.atan((d7 * d7 - d * d) / (d * d2));
        double d9 = Math.atan(((d + d3) * (d + d3) - d * d) / (d * d2));
        double d10 = this.uniform.nextDoubleFromTo(d8, d9);
        double d11 = d2 * Math.tan(d10);
        return Math.sqrt(Math.max(0.0, d * d + d * d11));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d, double d2, double d3) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            return shared.nextDouble(d, d2, d3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(DoubleRandomEngine doubleRandomEngine) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            shared.setRandomGenerator(doubleRandomEngine);
        }
    }
}

