/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.random.tdouble.AbstractContinousDoubleDistribution;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class DoubleUniform
extends AbstractContinousDoubleDistribution {
    protected double min;
    protected double max;
    protected static DoubleUniform shared = new DoubleUniform(DoubleUniform.makeDefaultGenerator());

    public DoubleUniform(double d, double d2, int n) {
        this(d, d2, new DoubleMersenneTwister(n));
    }

    public DoubleUniform(double d, double d2, DoubleRandomEngine doubleRandomEngine) {
        this.setRandomGenerator(doubleRandomEngine);
        this.setState(d, d2);
    }

    public DoubleUniform(DoubleRandomEngine doubleRandomEngine) {
        this(0.0, 1.0, doubleRandomEngine);
    }

    public double cdf(double d) {
        if (d <= this.min) {
            return 0.0;
        }
        if (d >= this.max) {
            return 1.0;
        }
        return (d - this.min) / (this.max - this.min);
    }

    public boolean nextBoolean() {
        return this.randomGenerator.raw() > 0.5;
    }

    public double nextDouble() {
        return this.min + (this.max - this.min) * this.randomGenerator.raw();
    }

    public double nextDoubleFromTo(double d, double d2) {
        return d + (d2 - d) * this.randomGenerator.raw();
    }

    public float nextFloatFromTo(float f, float f2) {
        return (float)this.nextDoubleFromTo(f, f2);
    }

    public int nextInt() {
        return this.nextIntFromTo((int)Math.round(this.min), (int)Math.round(this.max));
    }

    public int nextIntFromTo(int n, int n2) {
        return (int)((long)n + (long)((double)(1L + (long)n2 - (long)n) * this.randomGenerator.raw()));
    }

    public long nextLongFromTo(long l, long l2) {
        long l3;
        if (l >= 0L && l2 < Long.MAX_VALUE) {
            return l + (long)this.nextDoubleFromTo(0.0, l2 - l + 1L);
        }
        double d = (double)l2 - (double)l + 1.0;
        if (d <= 9.223372036854776E18) {
            return l + (long)this.nextDoubleFromTo(0.0, d);
        }
        if (l == Long.MIN_VALUE) {
            if (l2 == Long.MAX_VALUE) {
                int n = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                int n2 = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                return ((long)n & 0xFFFFFFFFL) << 32 | (long)n2 & 0xFFFFFFFFL;
            }
            l3 = Math.round(this.nextDoubleFromTo(l, l2 + 1L));
            if (l3 > l2) {
                l3 = l;
            }
        } else {
            l3 = Math.round(this.nextDoubleFromTo(l - 1L, l2));
            if (l3 < l) {
                l3 = l2;
            }
        }
        return l3;
    }

    public double pdf(double d) {
        if (d <= this.min || d >= this.max) {
            return 0.0;
        }
        return 1.0 / (this.max - this.min);
    }

    public void setState(double d, double d2) {
        if (d2 < d) {
            this.setState(d2, d);
            return;
        }
        this.min = d;
        this.max = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean staticNextBoolean() {
        DoubleUniform doubleUniform = shared;
        synchronized (doubleUniform) {
            return shared.nextBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble() {
        DoubleUniform doubleUniform = shared;
        synchronized (doubleUniform) {
            return shared.nextDouble();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDoubleFromTo(double d, double d2) {
        DoubleUniform doubleUniform = shared;
        synchronized (doubleUniform) {
            return shared.nextDoubleFromTo(d, d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float staticNextFloatFromTo(float f, float f2) {
        DoubleUniform doubleUniform = shared;
        synchronized (doubleUniform) {
            return shared.nextFloatFromTo(f, f2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextIntFromTo(int n, int n2) {
        DoubleUniform doubleUniform = shared;
        synchronized (doubleUniform) {
            return shared.nextIntFromTo(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long staticNextLongFromTo(long l, long l2) {
        DoubleUniform doubleUniform = shared;
        synchronized (doubleUniform) {
            return shared.nextLongFromTo(l, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticSetRandomEngine(DoubleRandomEngine doubleRandomEngine) {
        DoubleUniform doubleUniform = shared;
        synchronized (doubleUniform) {
            shared.setRandomGenerator(doubleRandomEngine);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.min + "," + this.max + ")";
    }
}

