/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.random.tdouble.AbstractDiscreteDistribution;
import cern.jet.random.tdouble.Gamma;
import cern.jet.random.tdouble.Poisson;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.stat.tdouble.Probability;

public class NegativeBinomial
extends AbstractDiscreteDistribution {
    protected int n;
    protected double p;
    protected Gamma gamma;
    protected Poisson poisson;
    protected static NegativeBinomial shared = new NegativeBinomial(1, 0.5, NegativeBinomial.makeDefaultGenerator());

    public NegativeBinomial(int n, double d, DoubleRandomEngine doubleRandomEngine) {
        this.setRandomGenerator(doubleRandomEngine);
        this.setNandP(n, d);
        this.gamma = new Gamma(n, 1.0, doubleRandomEngine);
        this.poisson = new Poisson(0.0, doubleRandomEngine);
    }

    public double cdf(int n) {
        return Probability.negativeBinomial(n, this.n, this.p);
    }

    public Object clone() {
        NegativeBinomial negativeBinomial = (NegativeBinomial)super.clone();
        if (this.poisson != null) {
            negativeBinomial.poisson = (Poisson)this.poisson.clone();
        }
        negativeBinomial.poisson.setRandomGenerator(negativeBinomial.getRandomGenerator());
        if (this.gamma != null) {
            negativeBinomial.gamma = (Gamma)this.gamma.clone();
        }
        negativeBinomial.gamma.setRandomGenerator(negativeBinomial.getRandomGenerator());
        return negativeBinomial;
    }

    public int nextInt() {
        return this.nextInt(this.n, this.p);
    }

    public int nextInt(int n, double d) {
        double d2 = d / (1.0 - d);
        double d3 = d;
        double d4 = d2 * this.gamma.nextDouble(n, 1.0);
        return this.poisson.nextInt(d4);
    }

    public double pdf(int n) {
        if (n > this.n) {
            throw new IllegalArgumentException();
        }
        return DoubleArithmetic.binomial(this.n, (long)n) * Math.pow(this.p, n) * Math.pow(1.0 - this.p, this.n - n);
    }

    public void setNandP(int n, double d) {
        this.n = n;
        this.p = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(int n, double d) {
        NegativeBinomial negativeBinomial = shared;
        synchronized (negativeBinomial) {
            return shared.nextInt(n, d);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.n + "," + this.p + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(DoubleRandomEngine doubleRandomEngine) {
        NegativeBinomial negativeBinomial = shared;
        synchronized (negativeBinomial) {
            shared.setRandomGenerator(doubleRandomEngine);
        }
    }
}

