/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble.sampling;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.jet.random.tdouble.AbstractDoubleDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class DoubleRandomSampler
extends PersistentObject {
    long my_n;
    long my_N;
    long my_low;
    DoubleRandomEngine my_RandomGenerator;

    public DoubleRandomSampler(long l, long l2, long l3, DoubleRandomEngine doubleRandomEngine) {
        if (l < 0L) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        if (l > l2) {
            throw new IllegalArgumentException("n must by <= N");
        }
        this.my_n = l;
        this.my_N = l2;
        this.my_low = l3;
        if (doubleRandomEngine == null) {
            doubleRandomEngine = AbstractDoubleDistribution.makeDefaultGenerator();
        }
        this.my_RandomGenerator = doubleRandomEngine;
    }

    public Object clone() {
        DoubleRandomSampler doubleRandomSampler = (DoubleRandomSampler)super.clone();
        doubleRandomSampler.my_RandomGenerator = (DoubleRandomEngine)this.my_RandomGenerator.clone();
        return doubleRandomSampler;
    }

    public static void main(String[] stringArray) {
        long l = Long.parseLong(stringArray[0]);
        long l2 = Long.parseLong(stringArray[1]);
        long l3 = Long.parseLong(stringArray[2]);
        int n = Integer.parseInt(stringArray[3]);
        int n2 = Integer.parseInt(stringArray[4]);
        DoubleRandomSampler.test(l, l2, l3, n, n2);
    }

    public void nextBlock(int n, long[] lArray, int n2) {
        if ((long)n > this.my_n) {
            throw new IllegalArgumentException("Random sample exhausted.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative count.");
        }
        if (n == 0) {
            return;
        }
        DoubleRandomSampler.sample(this.my_n, this.my_N, n, this.my_low, lArray, n2, this.my_RandomGenerator);
        long l = lArray[n2 + n - 1];
        this.my_n -= (long)n;
        this.my_N = this.my_N - l - 1L + this.my_low;
        this.my_low = l + 1L;
    }

    protected static void rejectMethodD(long l, long l2, int n, long l3, long[] lArray, int n2, DoubleRandomEngine doubleRandomEngine) {
        int n3;
        long l4;
        l = l2 - l;
        long l5 = -1L + l3;
        long l6 = -13L;
        double d = l;
        double d2 = 1.0 / d;
        double d3 = l2;
        double d4 = Math.exp(Math.log(doubleRandomEngine.raw()) * d2);
        long l7 = -l + 1L + l2;
        double d5 = -d + 1.0 + d3;
        while (l > 1L && n > 0) {
            double d6;
            double d7 = 1.0 / (-1.0 + d);
            while (true) {
                long l8;
                double d8;
                double d9;
                if ((l4 = (long)(d9 = d3 * (-d4 + 1.0))) >= l7) {
                    d4 = Math.exp(Math.log(doubleRandomEngine.raw()) * d2);
                    continue;
                }
                double d10 = doubleRandomEngine.raw();
                d6 = -l4;
                double d11 = Math.exp(Math.log(d10 * d3 / d5) * d7);
                d4 = d11 * (-d9 / d3 + 1.0) * (d5 / (d6 + d5));
                if (d4 <= 1.0) break;
                double d12 = 1.0;
                double d13 = -1.0 + d3;
                if (l - 1L > l4) {
                    d8 = -d + d3;
                    l8 = -l4 + l2;
                } else {
                    d8 = -1.0 + d6 + d3;
                    l8 = l7;
                }
                for (long i = l2 - 1L; i >= l8; --i) {
                    d12 = d12 * d13 / d8;
                    d13 -= 1.0;
                    d8 -= 1.0;
                }
                if (d3 / (-d9 + d3) >= d11 * Math.exp(Math.log(d12) * d7)) {
                    d4 = Math.exp(Math.log(doubleRandomEngine.raw()) * d7);
                    break;
                }
                d4 = Math.exp(Math.log(doubleRandomEngine.raw()) * d2);
            }
            n3 = n;
            if (l4 < (long)n3) {
                n3 = (int)l4;
            }
            n -= n3;
            while (--n3 >= 0) {
                lArray[n2++] = ++l5;
            }
            ++l5;
            l2 -= l4 + 1L;
            d3 = d6 + (-1.0 + d3);
            --l;
            d -= 1.0;
            d2 = d7;
            l7 = -l4 + l7;
            d5 = d6 + d5;
        }
        if (n > 0) {
            l4 = (long)((double)l2 * d4);
            n3 = n;
            if (l4 < (long)n3) {
                n3 = (int)l4;
            }
            n -= n3;
            while (--n3 >= 0) {
                lArray[n2++] = ++l5;
            }
            ++l5;
            while (--n >= 0) {
                lArray[n2++] = ++l5;
            }
        }
    }

    public static void sample(long l, long l2, int n, long l3, long[] lArray, int n2, DoubleRandomEngine doubleRandomEngine) {
        if (l <= 0L || n <= 0) {
            return;
        }
        if ((long)n > l) {
            throw new IllegalArgumentException("count must not be greater than n");
        }
        if (doubleRandomEngine == null) {
            doubleRandomEngine = AbstractDoubleDistribution.makeDefaultGenerator();
        }
        if ((long)n == l2) {
            long l4 = l3;
            int n3 = n2 + n;
            int n4 = n2;
            while (n4 < n3) {
                lArray[n4++] = l4++;
            }
            return;
        }
        if ((double)l < (double)l2 * 0.95) {
            DoubleRandomSampler.sampleMethodD(l, l2, n, l3, lArray, n2, doubleRandomEngine);
        } else {
            DoubleRandomSampler.rejectMethodD(l, l2, n, l3, lArray, n2, doubleRandomEngine);
        }
    }

    protected static void sampleMethodA(long l, long l2, int n, long l3, long[] lArray, int n2, DoubleRandomEngine doubleRandomEngine) {
        long l4;
        long l5 = -1L + l3;
        double d = l2 - l;
        double d2 = l2;
        while (l >= 2L && n > 0) {
            double d3 = doubleRandomEngine.raw();
            l4 = 0L;
            double d4 = d / d2;
            while (d4 > d3) {
                ++l4;
                d4 = d4 * (d -= 1.0) / (d2 -= 1.0);
            }
            lArray[n2++] = l5 += l4 + 1L;
            --n;
            d2 -= 1.0;
            --l;
        }
        if (n > 0) {
            l4 = (long)((double)Math.round(d2) * doubleRandomEngine.raw());
            lArray[n2] = l5 += l4 + 1L;
        }
    }

    protected static void sampleMethodD(long l, long l2, int n, long l3, long[] lArray, int n2, DoubleRandomEngine doubleRandomEngine) {
        long l4;
        long l5 = -1L + l3;
        long l6 = -13L;
        double d = l;
        double d2 = 1.0 / d;
        double d3 = l2;
        double d4 = Math.exp(Math.log(doubleRandomEngine.raw()) * d2);
        long l7 = -l + 1L + l2;
        double d5 = -d + 1.0 + d3;
        for (long i = -l6 * l; l > 1L && n > 0 && i < l2; i += l6) {
            double d6;
            double d7 = 1.0 / (-1.0 + d);
            while (true) {
                long l8;
                double d8;
                double d9;
                if ((l4 = (long)(d9 = d3 * (-d4 + 1.0))) >= l7) {
                    d4 = Math.exp(Math.log(doubleRandomEngine.raw()) * d2);
                    continue;
                }
                double d10 = doubleRandomEngine.raw();
                d6 = -l4;
                double d11 = Math.exp(Math.log(d10 * d3 / d5) * d7);
                d4 = d11 * (-d9 / d3 + 1.0) * (d5 / (d6 + d5));
                if (d4 <= 1.0) break;
                double d12 = 1.0;
                double d13 = -1.0 + d3;
                if (l - 1L > l4) {
                    d8 = -d + d3;
                    l8 = -l4 + l2;
                } else {
                    d8 = -1.0 + d6 + d3;
                    l8 = l7;
                }
                for (long j = l2 - 1L; j >= l8; --j) {
                    d12 = d12 * d13 / d8;
                    d13 -= 1.0;
                    d8 -= 1.0;
                }
                if (d3 / (-d9 + d3) >= d11 * Math.exp(Math.log(d12) * d7)) {
                    d4 = Math.exp(Math.log(doubleRandomEngine.raw()) * d7);
                    break;
                }
                d4 = Math.exp(Math.log(doubleRandomEngine.raw()) * d2);
            }
            lArray[n2++] = l5 += l4 + 1L;
            --n;
            l2 -= l4 + 1L;
            d3 = d6 + (-1.0 + d3);
            --l;
            d -= 1.0;
            d2 = d7;
            l7 = -l4 + l7;
            d5 = d6 + d5;
        }
        if (n > 0) {
            if (l > 1L) {
                DoubleRandomSampler.sampleMethodA(l, l2, n, l5 + 1L, lArray, n2, doubleRandomEngine);
            } else {
                l4 = (long)((double)l2 * d4);
                lArray[n2++] = l5 += l4 + 1L;
            }
        }
    }

    public static void test(long l, long l2, long l3, int n, int n2) {
        long[] lArray = new long[n];
        long l4 = l / (long)n;
        Timer timer = new Timer().start();
        long l5 = n2;
        while (--l5 >= 0L) {
            DoubleRandomSampler doubleRandomSampler = new DoubleRandomSampler(l, l2, l3, AbstractDoubleDistribution.makeDefaultGenerator());
            for (long i = 0L; i < l4; ++i) {
                doubleRandomSampler.nextBlock(n, lArray, 0);
            }
            int n3 = (int)(l - (long)n * l4);
            if (n3 <= 0) continue;
            doubleRandomSampler.nextBlock(n3, lArray, 0);
        }
        timer.stop();
        System.out.println("single run took " + timer.elapsedTime() / (double)n2);
        System.out.println("Good bye.\n");
    }

    protected static void testNegAlphaInv(String[] stringArray) {
    }
}

